/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.BoxWidget;
import VASSAL.build.widget.Chart;
import VASSAL.build.widget.HtmlChart;
import VASSAL.build.widget.ListWidget;
import VASSAL.build.widget.MapWidget;
import VASSAL.build.widget.PanelWidget;
import VASSAL.build.widget.TabWidget;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.preferences.PositionOption;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartWindow
extends Widget {
    public static final String DEPRECATED_NAME = "label";
    public static final String NAME = "name";
    public static final String BUTTON_TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    protected LaunchButton launch;
    protected JDialog frame;
    protected Container root = new JPanel();
    protected String tooltip = "";
    protected String id;

    public ChartWindow() {
        ActionListener actionListener = new ActionListener(){
            boolean initialized;

            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.initialized) {
                    String string = PositionOption.key + ChartWindow.this.id;
                    GameModule.getGameModule().getPrefs().addOption(new PositionOption(string, ChartWindow.this.frame));
                    this.initialized = true;
                }
                ChartWindow.this.frame.setVisible(!ChartWindow.this.frame.isVisible());
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.setAttribute(NAME, "Charts");
        this.setAttribute(BUTTON_TEXT, "Charts");
        this.launch.setAttribute(TOOLTIP, "Charts");
    }

    @Override
    public void addTo(Buildable buildable) {
        this.rebuild();
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.frame = new JDialog(GameModule.getGameModule().getFrame());
        GameModule.getGameModule().addKeyStrokeSource(new KeyStrokeSource(this.frame.getRootPane(), 2));
        while (this.root.getComponentCount() > 0) {
            this.frame.add(this.root.getComponent(0));
        }
        this.root = this.frame.getContentPane();
        this.frame.setTitle(this.launch.getAttributeValueString(DEPRECATED_NAME));
        int n = GameModule.getGameModule().getComponentsOf(ChartWindow.class).size();
        this.id = "ChartWindow" + n;
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (DEPRECATED_NAME.equals(string)) {
            this.setAttribute(NAME, object);
            this.setAttribute(BUTTON_TEXT, object);
        } else if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            if (this.tooltip.length() == 0) {
                this.launch.setToolTipText((String)object);
            }
            if (this.frame != null) {
                this.frame.setTitle((String)object);
            }
        } else if (TOOLTIP.equals(string)) {
            this.tooltip = (String)object;
            this.launch.setAttribute(string, object);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public String[] getAttributeNames() {
        String[] stringArray = new String[]{NAME, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY};
        return stringArray;
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (TOOLTIP.equals(string)) {
            return this.tooltip.length() == 0 ? this.launch.getAttributeValueString(string) : this.tooltip;
        }
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public Class[] getAllowableConfigureComponents() {
        return new Class[]{Chart.class, HtmlChart.class, TabWidget.class, PanelWidget.class, BoxWidget.class, ListWidget.class, MapWidget.class};
    }

    @Override
    public void add(Buildable buildable) {
        if (buildable instanceof Widget) {
            this.root.add(((Widget)buildable).getComponent());
        }
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        if (buildable instanceof Widget) {
            this.root.remove(((Widget)buildable).getComponent());
        }
        super.remove(buildable);
    }

    @Override
    public Component getComponent() {
        return this.root;
    }

    public static String getConfigureTypeName() {
        return "Charts";
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Button text:  ", "Tooltip text:  ", "Button icon:  ", "Hotkey:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, KeyStroke.class};
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.htm");
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/chart.gif");
        }
    }
}

