/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.DieRoll;
import VASSAL.build.module.InternetDiceButton;
import VASSAL.build.module.MultiRoll;
import VASSAL.build.module.dice.BonesDiceServer;
import VASSAL.build.module.dice.DieServer;
import VASSAL.build.module.dice.RollSet;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.preferences.Prefs;
import VASSAL.tools.FormattedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DieManager
extends AbstractConfigurable {
    private Map<String, DieServer> servers;
    private List<InternetDiceButton> dieButtons = new ArrayList<InternetDiceButton>();
    private String desc = "Die Manager";
    private boolean useMultiRoll;
    private int defaultNDice = 2;
    private int defaultNSides = 6;
    private DieServer server;
    private String lastServerName = "";
    private MultiRoll myMultiRoll;
    final StringEnumConfigurer semail;
    public static final String USE_INTERNET_DICE = "useinternetdice";
    public static final String DICE_SERVER = "diceserver";
    public static final String SERVER_PW = "serverpw";
    public static final String USE_EMAIL = "useemail";
    public static final String PRIMARY_EMAIL = "primaryemail";
    public static final String SECONDARY_EMAIL = "secondaryemail";
    public static final String ADDRESS_BOOK = "addressbook";
    public static final String MULTI_ROLL = "multiroll";
    public static final String DIE_MANAGER = "Internet Die Roller";
    public static final String DESC = "description";
    public static final String DFLT_NSIDES = "dfltnsides";
    public static final String DFLT_NDICE = "dfltndice";

    public DieManager() {
        this.servers = new HashMap<String, DieServer>();
        BonesDiceServer bonesDiceServer = new BonesDiceServer();
        this.servers.put(bonesDiceServer.getName(), bonesDiceServer);
        this.server = bonesDiceServer;
        StringEnumConfigurer stringEnumConfigurer = new StringEnumConfigurer(DICE_SERVER, "Internet Dice Server", this.getDescriptions());
        stringEnumConfigurer.setValue(this.server.getDescription());
        StringConfigurer stringConfigurer = new StringConfigurer(SERVER_PW, "Dice Server Password");
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(USE_EMAIL, "Email results?");
        StringConfigurer stringConfigurer2 = new StringConfigurer(PRIMARY_EMAIL, "Primary Email");
        StringArrayConfigurer stringArrayConfigurer = new StringArrayConfigurer(ADDRESS_BOOK, "Address Book");
        BooleanConfigurer booleanConfigurer2 = new BooleanConfigurer(MULTI_ROLL, "Put multiple rolls into single email");
        GameModule.getGameModule().getPrefs().addOption(null, stringEnumConfigurer);
        GameModule.getGameModule().getPrefs().addOption(null, stringConfigurer);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, booleanConfigurer);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, stringArrayConfigurer);
        String[] stringArray = (String[])GameModule.getGameModule().getPrefs().getValue(ADDRESS_BOOK);
        this.semail = new StringEnumConfigurer(SECONDARY_EMAIL, "Secondary Email", stringArray);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, stringConfigurer2);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, this.semail);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, booleanConfigurer2);
        this.setSemailValues();
        DefaultListModel defaultListModel = stringArrayConfigurer.getModel();
        ListDataListener listDataListener = new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                DieManager.this.setSemailValues();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                DieManager.this.setSemailValues();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                DieManager.this.setSemailValues();
            }
        };
        defaultListModel.addListDataListener(listDataListener);
    }

    public void setSemailValues() {
        String string = (String)GameModule.getGameModule().getPrefs().getValue(SECONDARY_EMAIL);
        String[] stringArray = (String[])GameModule.getGameModule().getPrefs().getValue(ADDRESS_BOOK);
        this.semail.setValidValues(stringArray);
        this.semail.setValue(string);
    }

    public String[] getNames() {
        if (this.servers == null) {
            return null;
        }
        return this.servers.keySet().toArray(new String[this.servers.size()]);
    }

    public String[] getDescriptions() {
        if (this.servers == null) {
            return null;
        }
        String[] stringArray = new String[this.servers.size()];
        int n = 0;
        for (DieServer dieServer : this.servers.values()) {
            stringArray[n++] = dieServer.getDescription();
        }
        return stringArray;
    }

    public DieServer getServerForName(String string) {
        return this.servers.get(string);
    }

    public DieServer getServerFromDescription(String string) {
        for (DieServer dieServer : this.servers.values()) {
            if (!string.equals(dieServer.getDescription())) continue;
            return dieServer;
        }
        return null;
    }

    public DieServer getServer() {
        this.getPrefs();
        return this.server;
    }

    public String getServerDescription() {
        return this.getServer().getDescription();
    }

    public String getServerName() {
        return this.getServer().getName();
    }

    public int getDfltNDice() {
        return this.defaultNDice;
    }

    public int getDfltNSides() {
        return this.defaultNSides;
    }

    public MultiRoll getMultiRoll(int n, int n2) {
        String string = this.getServer().getName();
        if (this.myMultiRoll == null || !string.equals(this.lastServerName)) {
            this.myMultiRoll = new MultiRoll(this, n, n2);
        }
        this.lastServerName = string;
        return this.myMultiRoll;
    }

    public void roll(int n, int n2, int n3, boolean bl, String string, FormattedString formattedString) {
        Object object;
        RollSet rollSet;
        MultiRoll multiRoll = this.getMultiRoll(n, n2);
        this.getPrefs();
        String string2 = GameModule.getGameModule().getChatter().getInputField().getText();
        if (string2 != null && string2.length() > 0) {
            multiRoll.setDescription(string2);
        }
        if (this.useMultiRoll) {
            multiRoll.setVisible(true);
            if (multiRoll.wasCancelled()) {
                return;
            }
            rollSet = multiRoll.getRollSet();
            string2 = rollSet.getDescription();
        } else {
            object = new DieRoll[]{new DieRoll(string, n, n2, n3, bl)};
            rollSet = new RollSet(string, (DieRoll[])object);
            string2 = "";
        }
        object = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Roll sent to " + this.server.getDescription());
        if (string2 == null || string2.length() == 0) {
            string2 = GameModule.getGameModule().getChatter().getInputField().getText();
        }
        if (this.server.getUseEmail()) {
            if (string2 == null || string2.length() == 0) {
                ((Command)object).append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Emailing " + this.server.getSecondaryEmail() + " (no subject line)"));
                ((Command)object).append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Leave text in the chat input area to provide a subject line"));
            } else {
                ((Command)object).append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Emailing " + this.server.getSecondaryEmail() + " (Subject:  " + string2 + ")"));
            }
        }
        ((Command)object).execute();
        GameModule.getGameModule().sendAndLog((Command)object);
        GameModule.getGameModule().getChatter().getInputField().setText("");
        rollSet.setDescription(string2);
        this.server.roll(rollSet, formattedString);
    }

    private void getPrefs() {
        Prefs prefs = GameModule.getGameModule().getPrefs();
        String string = (String)prefs.getValue(DICE_SERVER);
        this.server = this.getServerFromDescription(string);
        this.server.setPasswd((String)prefs.getValue(SERVER_PW));
        this.server.setUseEmail((Boolean)prefs.getValue(USE_EMAIL));
        this.server.setPrimaryEmail((String)prefs.getValue(PRIMARY_EMAIL));
        this.server.setSecondaryEmail((String)prefs.getValue(SECONDARY_EMAIL));
        this.useMultiRoll = (Boolean)prefs.getValue(MULTI_ROLL);
    }

    public void addDieButton(InternetDiceButton internetDiceButton) {
        this.dieButtons.add(internetDiceButton);
    }

    public void removeDieButton(InternetDiceButton internetDiceButton) {
        this.dieButtons.remove(internetDiceButton);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Description", "Multi-roll Default Ndice", "Multi-roll Default Nsides"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{DESC, DFLT_NDICE, DFLT_NSIDES};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (DESC.equals(string)) {
            this.desc = (String)object;
        } else if (DFLT_NDICE.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.defaultNDice = (Integer)object;
        } else if (DFLT_NSIDES.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.defaultNSides = (Integer)object;
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (DESC.equals(string)) {
            return this.desc;
        }
        if (DFLT_NDICE.equals(string)) {
            return this.defaultNDice + "";
        }
        if (DFLT_NSIDES.equals(string)) {
            return this.defaultNSides + "";
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{InternetDiceButton.class};
    }

    @Override
    public void addTo(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "Die Manager";
    }

    public void setSecondaryEmail(String string) {
        GameModule.getGameModule().getPrefs().setValue(SECONDARY_EMAIL, string);
        this.server.setSecondaryEmail(string);
    }
}

