/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.NullCommand;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.configure.AudioClipConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.ListConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoActionButton
extends AbstractConfigurable
implements RecursionLimiter.Loopable {
    public static final String BUTTON_TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String NAME = "name";
    public static final String HOTKEY = "hotkey";
    public static final String ICON = "icon";
    public static final String DO_REPORT = "doReport";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String DO_SOUND = "doSound";
    public static final String SOUND_CLIP = "soundClip";
    public static final String DO_HOTKEY = "doHotkey";
    public static final String HOTKEYS = "hotkeys";
    protected LaunchButton launch;
    protected boolean doReport = false;
    protected FormattedString reportFormat = new FormattedString(GameModule.getGameModule());
    protected boolean doSound = false;
    protected String soundClip = "";
    protected boolean doHotkey = false;
    protected List<KeyStroke> hotkeys = new ArrayList<KeyStroke>();

    public DoActionButton() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DoActionButton.this.execute();
                }
                catch (RecursionLimitException recursionLimitException) {
                    ErrorDialog.infiniteLoop(recursionLimitException);
                }
            }
        };
        this.launch = new LaunchButton("Do Action", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.setAttribute(NAME, "Do Action");
        this.setAttribute(TOOLTIP, "Do Action");
        this.launch.setAttribute(BUTTON_TEXT, "Do Action");
    }

    public static String getConfigureTypeName() {
        return "Action Button";
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY, DO_REPORT, REPORT_FORMAT, DO_SOUND, SOUND_CLIP, DO_HOTKEY, HOTKEYS};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Description:  ", "Button text:  ", "Button Tooltip text:  ", "Button icon:  ", "Hot key:  ", "Display Message?", "Report Format:  ", "Play a sound?", "Sound Clip:  ", "Send Hotkeys?", "Hot Keys:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, KeyStroke.class, Boolean.class, ReportFormatConfig.class, Boolean.class, SoundConfig.class, Boolean.class, HotkeyConfig.class};
    }

    @Override
    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getToolBar().add(this.getComponent());
    }

    protected Component getComponent() {
        return this.launch;
    }

    @Override
    public void setAttribute(String string, Object list) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)((Object)list));
        } else if (DO_REPORT.equals(string)) {
            if (list instanceof String) {
                list = Boolean.valueOf((String)((Object)list));
            }
            this.doReport = (Boolean)((Object)list);
        } else if (REPORT_FORMAT.equals(string)) {
            this.reportFormat.setFormat((String)((Object)list));
        } else if (DO_SOUND.equals(string)) {
            if (list instanceof String) {
                list = Boolean.valueOf((String)((Object)list));
            }
            this.doSound = (Boolean)((Object)list);
        }
        if (SOUND_CLIP.equals(string)) {
            if (list instanceof File) {
                list = ((File)((Object)list)).getName();
            }
            this.soundClip = (String)((Object)list);
        } else if (DO_HOTKEY.equals(string)) {
            if (list instanceof String) {
                list = Boolean.valueOf((String)((Object)list));
            }
            this.doHotkey = (Boolean)((Object)list);
        } else if (HOTKEYS.equals(string)) {
            if (list instanceof String) {
                list = this.decodeHotkeys((String)((Object)list));
            }
            this.hotkeys = list;
        } else {
            this.launch.setAttribute(string, list);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (DO_REPORT.equals(string)) {
            return String.valueOf(this.doReport);
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.reportFormat.getFormat();
        }
        if (DO_SOUND.equals(string)) {
            return String.valueOf(this.doSound);
        }
        if (SOUND_CLIP.equals(string)) {
            return this.soundClip;
        }
        if (DO_HOTKEY.equals(string)) {
            return String.valueOf(this.doHotkey);
        }
        if (HOTKEYS.equals(string)) {
            return this.encodeHotkeys();
        }
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (REPORT_FORMAT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doReport;
                }
            };
        }
        if (SOUND_CLIP.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doSound;
                }
            };
        }
        if (HOTKEYS.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doHotkey;
                }
            };
        }
        return null;
    }

    protected String encodeHotkeys() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (KeyStroke keyStroke : this.hotkeys) {
            sequenceEncoder.append(HotKeyConfigurer.encode(keyStroke));
        }
        String string = sequenceEncoder.getValue();
        return string == null ? "" : string;
    }

    protected List<KeyStroke> decodeHotkeys(String string) {
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        while (decoder.hasMoreTokens()) {
            KeyStroke keyStroke = HotKeyConfigurer.decode(decoder.nextToken());
            arrayList.add(keyStroke);
        }
        return arrayList;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.getComponent());
        GameModule.getGameModule().getToolBar().revalidate();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MessageButton.htm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws RecursionLimitException {
        try {
            Object object;
            RecursionLimiter.startExecution(this);
            NullCommand nullCommand = new NullCommand();
            if (this.doReport) {
                object = "* " + this.reportFormat.getLocalizedText();
                nullCommand.append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), (String)object));
            }
            if (this.doSound) {
                object = new FormattedString(this.soundClip).getText(GameModule.getGameModule());
                nullCommand.append(new PlayAudioClipCommand((String)object));
            }
            if (this.doHotkey) {
                for (KeyStroke keyStroke : this.hotkeys) {
                    GameModule.getGameModule().fireKeyStroke(keyStroke);
                }
            }
            nullCommand.execute();
            GameModule.getGameModule().sendAndLog(nullCommand);
        }
        finally {
            RecursionLimiter.endExecution();
        }
    }

    @Override
    public String getComponentTypeName() {
        return DoActionButton.getConfigureTypeName();
    }

    @Override
    public String getComponentName() {
        return this.getConfigureName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HotkeyListConfigurer
    extends ListConfigurer {
        public HotkeyListConfigurer(String string, String string2, List<KeyStroke> list) {
            super(string, string2, list);
        }

        @Override
        protected Configurer buildChildConfigurer() {
            return new HotKeyConfigurer(null, "  HotKey:  ");
        }
    }

    public static class HotkeyConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new HotkeyListConfigurer(string, string2, ((DoActionButton)autoConfigurable).hotkeys);
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[0]);
        }
    }

    public static class SoundConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new AudioClipConfigurer(string, string2, GameModule.getGameModule().getArchiveWriter());
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, null);
        }
    }
}

