/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventLog
extends AbstractBuildable
implements CommandEncoder,
GameComponent {
    public static final String EVENT_LIST = "Events";
    private List<Event> myEvents;
    private List<Event> savedEvents;

    @Override
    public void addTo(Buildable buildable) {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.addCommandEncoder(this);
        gameModule.getGameState().addGameComponent(this);
        gameModule.getPrefs().addOption(new StringConfigurer(EVENT_LIST, null));
        this.myEvents = new ArrayList<Event>();
        this.savedEvents = new ArrayList<Event>();
        for (Event event : EventLog.decodedEvents((String)gameModule.getPrefs().getValue(EVENT_LIST))) {
            this.myEvents.add(event);
        }
    }

    public void clearSaved() {
        this.savedEvents.clear();
    }

    public void store(Event event) {
        this.savedEvents.add(event);
    }

    public void log(Event event) {
        this.myEvents.add(event);
        GameModule.getGameModule().getPrefs().getOption(EVENT_LIST).setValue(EventLog.encodedEvents(this.myEvents));
    }

    @Override
    public Command decode(String string) {
        if (string.startsWith(EVENT_LIST)) {
            return new StoreEvents(this, string.substring(EVENT_LIST.length()));
        }
        return null;
    }

    @Override
    public String encode(Command command) {
        if (command instanceof StoreEvents) {
            return EVENT_LIST + ((StoreEvents)command).getEvents();
        }
        return null;
    }

    @Override
    public void setup(boolean bl) {
        if (!bl) {
            this.clearSaved();
        }
    }

    @Override
    public Command getRestoreCommand() {
        return new StoreEvents(this, EventLog.encodedEvents(this.savedEvents));
    }

    public static Iterable<Event> decodedEvents(final String string) {
        return new Iterable<Event>(){

            @Override
            public Iterator<Event> iterator() {
                return new Iterator<Event>(){
                    private final SequenceEncoder.Decoder se;
                    {
                        this.se = new SequenceEncoder.Decoder(string, '|');
                    }

                    @Override
                    public boolean hasNext() {
                        return this.se.hasMoreTokens();
                    }

                    @Override
                    public Event next() {
                        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.se.nextToken(), ',');
                        return new Event(Long.parseLong(decoder.nextToken()), decoder.nextToken(), decoder.nextToken());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Deprecated
    public static Enumeration decodeEvents(String string) {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        while (decoder.hasMoreTokens()) {
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), ',');
            arrayList.add(new Event(Long.parseLong(decoder2.nextToken()), decoder2.nextToken(), decoder2.nextToken()));
        }
        return Collections.enumeration(arrayList);
    }

    public static String encodedEvents(Iterable<Event> iterable) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        for (Event event : iterable) {
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(',');
            sequenceEncoder2.append(event.getTime()).append(event.getUser()).append(event.getAction());
            sequenceEncoder.append(sequenceEncoder2.getValue());
        }
        return sequenceEncoder.getValue();
    }

    @Deprecated
    public static String encodeEvents(Enumeration enumeration) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        while (enumeration.hasMoreElements()) {
            Event event = (Event)enumeration.nextElement();
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(',');
            sequenceEncoder2.append(event.getTime()).append(event.getUser()).append(event.getAction());
            sequenceEncoder.append(sequenceEncoder2.getValue());
        }
        return sequenceEncoder.getValue();
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public String getAttributeValueString(String string) {
        return null;
    }

    public static class StoreEvents
    extends Command {
        private EventLog log;
        private String events;

        public StoreEvents(EventLog eventLog, String string) {
            this.log = eventLog;
            this.events = string;
        }

        public String getEvents() {
            return this.events;
        }

        public void executeCommand() {
            this.log.clearSaved();
            for (Event event : EventLog.decodedEvents(this.events)) {
                this.log.store(event);
            }
        }

        public Command myUndoCommand() {
            return null;
        }
    }

    public static class Event {
        private long time;
        private String user;
        private String action;

        public Event(long l, String string, String string2) {
            this.time = l;
            this.user = string;
            this.action = string2;
        }

        public long getTime() {
            return this.time;
        }

        public String getUser() {
            return this.user;
        }

        public String getAction() {
            return this.action;
        }
    }
}

