/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.command.AddPiece;
import VASSAL.command.AlertCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.CommandFilter;
import VASSAL.command.ConditionalCommand;
import VASSAL.command.Logger;
import VASSAL.command.NullCommand;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.launch.Launcher;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.Deobfuscator;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.Obfuscator;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.LogAndSaveFileFilter;
import VASSAL.tools.io.FastByteArrayOutputStream;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.menu.MenuManager;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameState
implements CommandEncoder {
    protected Map<String, GamePiece> pieces = new HashMap<String, GamePiece>();
    protected List<GameComponent> gameComponents = new ArrayList<GameComponent>();
    protected List<GameSetupStep> setupSteps = new ArrayList<GameSetupStep>();
    protected Action loadGame;
    protected Action saveGame;
    protected Action newGame;
    protected Action closeGame;
    protected String lastSave;
    protected DirectoryConfigurer savedGameDirectoryPreference;
    private boolean gameStarting = false;
    private boolean gameStarted = false;
    private volatile boolean gameUpdating = false;
    public static final String SAVEFILE_ZIP_ENTRY = "savedGame";
    public static final String BEGIN_SAVE = "begin_save";
    public static final String END_SAVE = "end_save";

    public void addTo(GameModule gameModule) {
        this.loadGame = new AbstractAction(Resources.getString("GameState.load_game")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.loadGame();
            }
        };
        this.loadGame.putValue("MnemonicKey", Resources.getString("GameState.load_game.shortcut").charAt(0));
        this.saveGame = new AbstractAction(Resources.getString("GameState.save_game")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.saveGame();
            }
        };
        this.saveGame.putValue("MnemonicKey", Resources.getString("GameState.save_game.shortcut").charAt(0));
        this.newGame = new AbstractAction(Resources.getString("GameState.new_game")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.setup(false);
                GameState.this.setup(true);
            }
        };
        this.newGame.putValue("MnemonicKey", Resources.getString("GameState.new_game.shortcut").charAt(0));
        this.closeGame = new AbstractAction(Resources.getString("GameState.close_game")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.setup(false);
            }
        };
        this.closeGame.putValue("MnemonicKey", Resources.getString("GameState.close_game.shortcut").charAt(0));
        MenuManager menuManager = MenuManager.getInstance();
        menuManager.addAction("GameState.new_game", this.newGame);
        menuManager.addAction("GameState.load_game", this.loadGame);
        menuManager.addAction("GameState.save_game", this.saveGame);
        menuManager.addAction("GameState.close_game", this.closeGame);
        this.saveGame.setEnabled(this.gameStarting);
        this.closeGame.setEnabled(this.gameStarting);
    }

    public boolean isModified() {
        String string = this.saveString();
        return string != null && !string.equals(this.lastSave);
    }

    public void addGameComponent(GameComponent gameComponent) {
        this.gameComponents.add(gameComponent);
    }

    public void removeGameComponent(GameComponent gameComponent) {
        this.gameComponents.remove(gameComponent);
    }

    @Deprecated
    public Enumeration getGameComponentsEnum() {
        return Collections.enumeration(this.gameComponents);
    }

    public Collection<GameComponent> getGameComponents() {
        return Collections.unmodifiableCollection(this.gameComponents);
    }

    public void addGameSetupStep(GameSetupStep gameSetupStep) {
        this.setupSteps.add(gameSetupStep);
    }

    public void removeGameSetupStep(GameSetupStep gameSetupStep) {
        this.setupSteps.remove(gameSetupStep);
    }

    public Iterator<GameSetupStep> getUnfinishedSetupSteps() {
        ArrayList<GameSetupStep> arrayList = new ArrayList<GameSetupStep>();
        for (GameSetupStep gameSetupStep : this.setupSteps) {
            if (gameSetupStep.isFinished()) continue;
            arrayList.add(gameSetupStep);
        }
        return arrayList.iterator();
    }

    public void setup(boolean bl, boolean bl2) {
        this.gameUpdating = bl2;
        this.setup(bl);
    }

    public void updateDone() {
        this.gameUpdating = false;
    }

    public boolean isUpdating() {
        return this.gameUpdating;
    }

    public void setup(boolean bl) {
        if (!bl && this.gameStarted && this.isModified()) {
            switch (JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), Resources.getString("GameState.save_game_query"), Resources.getString("GameState.game_modified"), 1)) {
                case 0: {
                    this.saveGame();
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.gameStarting = bl;
        if (!bl) {
            this.pieces.clear();
        }
        this.newGame.setEnabled(!bl);
        this.saveGame.setEnabled(bl);
        this.closeGame.setEnabled(bl);
        if (bl) {
            this.loadGame.putValue("Name", Resources.getString("GameState.load_continuation"));
            GameModule.getGameModule().getWizardSupport().showGameSetupWizard();
        } else {
            this.loadGame.putValue("Name", Resources.getString("GameState.load_game"));
            GameModule.getGameModule().appendToTitle(null);
        }
        this.gameStarted = this.gameStarted && this.gameStarting;
        for (GameComponent gameComponent : this.gameComponents) {
            gameComponent.setup(this.gameStarting);
        }
        this.gameStarted = this.gameStarted || this.gameStarting;
        this.lastSave = bl ? this.saveString() : null;
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public void loadGame() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.addChoosableFileFilter(new LogAndSaveFileFilter());
        if (fileChooser.showOpenDialog() != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("Unable to locate " + file.getPath());
            }
            AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(file);
            if (abstractMetaData == null || !(abstractMetaData instanceof SaveMetaData)) {
                WarningDialog.show("GameState.invalid_save_file", file.getPath());
                return;
            }
            SaveMetaData saveMetaData = (SaveMetaData)abstractMetaData;
            if (saveMetaData.getModuleData() != null) {
                String string = saveMetaData.getModuleName();
                String string2 = saveMetaData.getModuleVersion();
                String string3 = GameModule.getGameModule().getGameName();
                String string4 = GameModule.getGameModule().getGameVersion();
                String string5 = null;
                if (!string.equals(string3)) {
                    string5 = Resources.getString("GameState.load_module_mismatch", file.getName(), string, string3);
                } else if (!string2.equals(string4)) {
                    string5 = Resources.getString("GameState.load_version_mismatch", file.getName(), string2, string4);
                }
                if (string5 != null && JOptionPane.showConfirmDialog(null, string5, Resources.getString("GameState.load_mismatch"), 0, 3) != 0) {
                    GameModule.getGameModule().warn(Resources.getString("GameState.cancel_load", file.getName()));
                    return;
                }
            }
            if (this.gameStarted) {
                this.loadContinuation(file);
            } else {
                this.loadGameInBackground(file);
            }
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, file);
        }
    }

    protected String saveString() {
        return GameModule.getGameModule().encode(this.getRestoreCommand());
    }

    public void saveGame() {
        GameModule.getGameModule().warn(Resources.getString("GameState.saving_game"));
        File file = this.getSaveFile();
        if (file == null) {
            GameModule.getGameModule().warn(Resources.getString("GameState.save_canceled"));
        } else {
            try {
                this.saveGame(file);
                GameModule.getGameModule().warn(Resources.getString("GameState.game_saved"));
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, file);
            }
        }
    }

    public void setModified(boolean bl) {
        this.lastSave = bl ? null : this.saveString();
    }

    private File getSaveFile() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.selectDotSavFile();
        fileChooser.addChoosableFileFilter(new LogAndSaveFileFilter());
        if (fileChooser.showSaveDialog() != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        if (file.getName().indexOf(46) == -1) {
            file = new File(file.getParent(), file.getName() + ".vsav");
        }
        return file;
    }

    public void addPiece(GamePiece gamePiece) {
        if (gamePiece.getId() == null) {
            gamePiece.setId(this.getNewPieceId());
        }
        this.pieces.put(gamePiece.getId(), gamePiece);
    }

    public GamePiece getPieceForId(String string) {
        return string == null ? null : this.pieces.get(string);
    }

    public void removePiece(String string) {
        if (string != null) {
            this.pieces.remove(string);
        }
    }

    public String getNewPieceId() {
        long l = System.currentTimeMillis();
        String string = new Long(l).toString();
        while (this.pieces.get(string) != null) {
            string = new Long(++l).toString();
        }
        return string;
    }

    public void loadContinuation(File file) throws IOException {
        Command command = this.decodeSavedGame(file);
        CommandFilter commandFilter = new CommandFilter(){

            protected boolean accept(Command command) {
                return command instanceof BasicLogger.LogCommand;
            }
        };
        if ((command = commandFilter.apply(command)) != null) {
            command.execute();
        }
    }

    @Deprecated
    public Enumeration<GamePiece> getPieces() {
        return Collections.enumeration(this.pieces.values());
    }

    public Collection<GamePiece> getAllPieces() {
        return this.pieces.values();
    }

    public Command getRestoreCommand() {
        if (!this.saveGame.isEnabled()) {
            return null;
        }
        SetupCommand setupCommand = new SetupCommand(false);
        setupCommand.append(this.checkVersionCommand());
        setupCommand.append(this.getRestorePiecesCommand());
        for (GameComponent gameComponent : this.gameComponents) {
            setupCommand.append(gameComponent.getRestoreCommand());
        }
        setupCommand.append(new SetupCommand(true));
        return setupCommand;
    }

    private Command checkVersionCommand() {
        String string = GameModule.getGameModule().getAttributeValueString("runningVassalVersion");
        ConditionalCommand.Lt lt = new ConditionalCommand.Lt("runningVassalVersion", string);
        ConditionalCommand conditionalCommand = new ConditionalCommand(new ConditionalCommand.Condition[]{lt}, new AlertCommand(Resources.getString("GameState.version_mismatch", string)));
        String string2 = GameModule.getGameModule().getAttributeValueString("name");
        String string3 = GameModule.getGameModule().getAttributeValueString("version");
        lt = new ConditionalCommand.Lt("version", string3);
        conditionalCommand.append(new ConditionalCommand(new ConditionalCommand.Condition[]{lt}, new AlertCommand(Resources.getString("GameState.version_mismatch2", string2, string3))));
        return conditionalCommand;
    }

    @Override
    public String encode(Command command) {
        if (command instanceof SetupCommand) {
            return ((SetupCommand)command).isGameStarting() ? END_SAVE : BEGIN_SAVE;
        }
        return null;
    }

    @Override
    public Command decode(String string) {
        if (BEGIN_SAVE.equals(string)) {
            return new SetupCommand(false);
        }
        if (END_SAVE.equals(string)) {
            return new SetupCommand(true);
        }
        return null;
    }

    public void saveGame(File file) throws IOException {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        String string = this.saveString();
        new Obfuscator(string.getBytes("UTF-8")).write(fastByteArrayOutputStream);
        this.lastSave = string;
        ArchiveWriter archiveWriter = new ArchiveWriter(file.getPath());
        archiveWriter.addFile(SAVEFILE_ZIP_ENTRY, fastByteArrayOutputStream.toInputStream());
        new SaveMetaData().save(archiveWriter);
        archiveWriter.write();
        Launcher.getInstance().sendSaveCmd(file);
        if (archiveWriter.getArchive() != null) {
            archiveWriter.getArchive().close();
        }
    }

    public void loadGameInBackground(File file) {
        try {
            this.loadGameInBackground(file.getName(), new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, file);
        }
    }

    public void loadGameInBackground(final String string, final InputStream inputStream) {
        GameModule.getGameModule().warn(Resources.getString("GameState.loading", string));
        final JFrame jFrame = GameModule.getGameModule().getFrame();
        jFrame.setCursor(Cursor.getPredefinedCursor(3));
        new SwingWorker<Command, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Command doInBackground() throws Exception {
                try {
                    Command command = GameState.this.decodeSavedGame(inputStream);
                    return command;
                }
                finally {
                    IOUtils.closeQuietly(inputStream);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void done() {
                try {
                    Command command = null;
                    String string2 = null;
                    try {
                        command = (Command)this.get();
                        string2 = command != null ? Resources.getString("GameState.loaded", string) : Resources.getString("GameState.invalid_savefile", string);
                    }
                    catch (InterruptedException interruptedException) {
                        ErrorDialog.bug(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        OutOfMemoryError outOfMemoryError = ThrowableUtils.getAncestor(OutOfMemoryError.class, executionException);
                        if (outOfMemoryError != null) {
                            ErrorDialog.bug(executionException);
                        } else {
                            VASSAL.tools.logging.Logger.log(executionException);
                        }
                        string2 = Resources.getString("GameState.error_loading", string);
                    }
                    if (command != null) {
                        command.execute();
                    }
                    GameModule.getGameModule().warn(string2);
                    Logger logger = GameModule.getGameModule().getLogger();
                    if (logger instanceof BasicLogger) {
                        ((BasicLogger)logger).queryNewLogFile(true);
                    }
                }
                finally {
                    jFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }.execute();
    }

    public Command getRestorePiecesCommand() {
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        for (GamePiece object : this.pieces.values()) {
            int n = 0;
            if (object.getParent() == null) {
                n = arrayList.size();
            }
            arrayList.add(n, object);
        }
        NullCommand nullCommand = new NullCommand();
        for (GamePiece gamePiece : arrayList) {
            nullCommand.append(new AddPiece(gamePiece));
        }
        return nullCommand;
    }

    public Command decodeSavedGame(File file) throws IOException {
        return this.decodeSavedGame(new BufferedInputStream(new FileInputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Command decodeSavedGame(InputStream inputStream) throws IOException {
        Command command;
        ZipInputStream zipInputStream;
        block5: {
            zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(inputStream);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    if (SAVEFILE_ZIP_ENTRY.equals(zipEntry.getName())) {
                        command = GameModule.getGameModule().decode(new Deobfuscator(zipInputStream).getString());
                        break block5;
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
                zipInputStream.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(zipInputStream);
            throw new IOException("Invalid saveFile format");
        }
        IOUtils.closeQuietly(zipInputStream);
        return command;
    }

    public DirectoryConfigurer getSavedGameDirectoryPreference() {
        if (this.savedGameDirectoryPreference == null) {
            this.savedGameDirectoryPreference = new DirectoryConfigurer("savedGameDir", null);
            GameModule.getGameModule().getPrefs().addOption(null, this.savedGameDirectoryPreference);
        }
        return this.savedGameDirectoryPreference;
    }

    public static class SetupCommand
    extends Command {
        private boolean gameStarting;

        public SetupCommand(boolean bl) {
            this.gameStarting = bl;
        }

        public boolean isGameStarting() {
            return this.gameStarting;
        }

        protected void executeCommand() {
            GameModule.getGameModule().getGameState().setup(this.gameStarting);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

