/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.ObscurableOptions;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.StringEnum;
import VASSAL.i18n.Resources;
import VASSAL.preferences.BooleanPreference;
import VASSAL.preferences.DoublePreference;
import VASSAL.preferences.EnumPreference;
import VASSAL.preferences.IntegerPreference;
import VASSAL.preferences.StringPreference;
import VASSAL.preferences.TextPreference;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalOptions
extends AbstractConfigurable {
    public static final String NON_OWNER_UNMASKABLE = "nonOwnerUnmaskable";
    public static final String PROMPT_STRING = "promptString";
    public static final String CENTER_ON_MOVE = "centerOnMove";
    public static final String MARK_MOVED = "markMoved";
    public static final String AUTO_REPORT = "autoReport";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String PROMPT = "Use Preferences Setting";
    public static final String SINGLE_WINDOW = "singleWindow";
    public static final String MAXIMUM_HEAP = "maximumHeap";
    public static final String INITIAL_HEAP = "initialHeap";
    public static final String PLAYER_NAME = "playerName";
    public static final String PLAYER_SIDE = "playerSide";
    public static final String PLAYER_ID = "playerId";
    public static final String PLAYER_ID_FORMAT = "playerIdFormat";
    private String promptString = "Opponents can unmask my pieces";
    private String nonOwnerUnmaskable = "Never";
    private String centerOnMoves = "Always";
    private String autoReport = "Always";
    private String markMoved = "Never";
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static Map<String, Configurer> optionConfigurers = new LinkedHashMap<String, Configurer>();
    private static Properties optionInitialValues = new Properties();
    private FormattedString playerIdFormat = new FormattedString("$playerName$");
    private static GlobalOptions instance = new GlobalOptions();
    private boolean useSingleWindow;

    @Override
    public void addTo(Buildable buildable) {
        instance = this;
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(SINGLE_WINDOW, Resources.getString("GlobalOptions.use_combined"), Boolean.TRUE);
        GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
        this.useSingleWindow = !Boolean.FALSE.equals(booleanConfigurer.getValue());
        IntConfigurer intConfigurer = new IntConfigurer(INITIAL_HEAP, Resources.getString("GlobalOptions.initial_heap"), 256);
        GameModule.getGameModule().getPrefs().addOption(intConfigurer);
        IntConfigurer intConfigurer2 = new IntConfigurer(MAXIMUM_HEAP, Resources.getString("GlobalOptions.maximum_heap"), 512);
        GameModule.getGameModule().getPrefs().addOption(intConfigurer2);
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    public static GlobalOptions getInstance() {
        return instance;
    }

    public boolean isUseSingleWindow() {
        return this.useSingleWindow;
    }

    @Deprecated
    public boolean isAveragedScaling() {
        return true;
    }

    public static String getConfigureTypeName() {
        return "Global Options";
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{StringPreference.class, TextPreference.class, EnumPreference.class, IntegerPreference.class, DoublePreference.class, BooleanPreference.class};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Allow non-owners to unmask pieces:  ", null, "Center on opponent's moves:  ", "Auto-report moves:  ", "Player Id format:  "};
    }

    @Override
    public String[] getAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(NON_OWNER_UNMASKABLE, PROMPT_STRING, CENTER_ON_MOVE, AUTO_REPORT, PLAYER_ID_FORMAT));
        for (String string : this.properties.keySet()) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Prompt.class, null, Prompt.class, Prompt.class, PlayerIdFormatConfig.class};
    }

    public void addOption(Configurer configurer) {
        optionConfigurers.put(configurer.getKey(), configurer);
        Object object = optionInitialValues.get(configurer.getKey());
        if (object instanceof String) {
            configurer.setValue((String)object);
        }
        if (this.config != null) {
            ((Container)this.config.getControls()).add(configurer.getControls());
        }
    }

    @Override
    public void build(Element element) {
        Node node;
        if (element == null) {
            return;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            node = (Attr)namedNodeMap.item(i);
            this.setAttribute(node.getName(), node.getValue());
        }
        for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            if (node2.getNodeType() != 1) continue;
            node = (Element)node2;
            if ("option".equals(node.getTagName())) {
                object = node.getAttribute("name");
                String string = Builder.getText((Element)node);
                optionInitialValues.put(object, string);
                Configurer configurer = optionConfigurers.get(object);
                if (configurer == null) continue;
                configurer.setValue(string);
                continue;
            }
            try {
                object = Builder.create((Element)node);
                object.addTo(this);
                this.add((Buildable)object);
                continue;
            }
            catch (IllegalBuildException illegalBuildException) {
                ErrorDialog.bug(illegalBuildException);
            }
        }
    }

    @Override
    public Element getBuildElement(Document document) {
        Element element = super.getBuildElement(document);
        for (Configurer configurer : optionConfigurers.values()) {
            Element element2 = document.createElement("option");
            element2.setAttribute("name", configurer.getKey());
            element2.appendChild(document.createTextNode(configurer.getValueString()));
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public Configurer getConfigurer() {
        if (this.config == null) {
            Configurer configurer = super.getConfigurer();
            for (Configurer configurer2 : optionConfigurers.values()) {
                ((Container)configurer.getControls()).add(configurer2.getControls());
            }
        }
        return this.config;
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NON_OWNER_UNMASKABLE.equals(string)) {
            return this.nonOwnerUnmaskable;
        }
        if (PROMPT_STRING.equals(string)) {
            return this.promptString;
        }
        if (CENTER_ON_MOVE.equals(string)) {
            return this.centerOnMoves;
        }
        if (AUTO_REPORT.equals(string)) {
            return this.autoReport;
        }
        if (MARK_MOVED.equals(string)) {
            return this.markMoved;
        }
        if (PLAYER_ID_FORMAT.equals(string)) {
            return this.playerIdFormat.getFormat();
        }
        if (!optionConfigurers.containsKey(string)) {
            Object object = this.properties.get(string);
            return object != null ? object.toString() : null;
        }
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalOptions.htm");
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NON_OWNER_UNMASKABLE.equals(string)) {
            this.nonOwnerUnmaskable = (String)object;
            if (ALWAYS.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowAll();
            } else if (NEVER.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowNone();
            } else if (PROMPT.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowSome(this.promptString);
                GameModule.getGameModule().getGameState().addGameComponent(ObscurableOptions.getInstance());
                GameModule.getGameModule().addCommandEncoder(ObscurableOptions.getInstance());
            }
        } else if (PROMPT_STRING.equals(string)) {
            this.promptString = (String)object;
            ObscurableOptions.getInstance().setPrompt(this.promptString);
        } else if (CENTER_ON_MOVE.equals(string)) {
            this.centerOnMoves = (String)object;
            if (PROMPT.equals(this.centerOnMoves)) {
                BooleanConfigurer booleanConfigurer = new BooleanConfigurer(CENTER_ON_MOVE, Resources.getString("GlobalOptions.center_on_move"));
                GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
            }
        } else if (AUTO_REPORT.equals(string)) {
            this.autoReport = (String)object;
            if (PROMPT.equals(this.autoReport)) {
                BooleanConfigurer booleanConfigurer = new BooleanConfigurer(AUTO_REPORT, Resources.getString("GlobalOptions.auto_report"));
                GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
            }
        } else if (MARK_MOVED.equals(string)) {
            this.markMoved = (String)object;
            if (PROMPT.equals(this.markMoved)) {
                BooleanConfigurer booleanConfigurer = new BooleanConfigurer(MARK_MOVED, Resources.getString("GlobalOptions.mark_moved"));
                GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
            }
        } else if (PLAYER_ID_FORMAT.equals(string)) {
            this.playerIdFormat.setFormat((String)object);
        } else if (optionConfigurers.containsKey(string)) {
            optionConfigurers.get(string).setValue(object);
        } else {
            this.properties.put(string, object);
        }
    }

    public boolean autoReportEnabled() {
        return this.isEnabled(this.autoReport, AUTO_REPORT);
    }

    public boolean centerOnOpponentsMove() {
        return this.isEnabled(this.centerOnMoves, CENTER_ON_MOVE);
    }

    public boolean isMarkMoveEnabled() {
        return this.isEnabled(this.markMoved, MARK_MOVED);
    }

    public String getPlayerId() {
        this.playerIdFormat.setProperty(PLAYER_NAME, (String)GameModule.getGameModule().getPrefs().getValue("RealName"));
        this.playerIdFormat.setProperty(PLAYER_SIDE, PlayerRoster.getMyLocalizedSide());
        return this.playerIdFormat.getText();
    }

    private boolean isEnabled(String string, String string2) {
        if (ALWAYS.equals(string)) {
            return true;
        }
        if (NEVER.equals(string)) {
            return false;
        }
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(string2));
    }

    public static class PlayerIdFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{GlobalOptions.PLAYER_NAME, GlobalOptions.PLAYER_SIDE});
        }
    }

    public static class Prompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{GlobalOptions.ALWAYS, GlobalOptions.NEVER, GlobalOptions.PROMPT};
        }
    }
}

