/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.DieManager;
import VASSAL.build.module.DieRoll;
import VASSAL.build.module.dice.RollSet;
import VASSAL.preferences.Prefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class MultiRoll
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton rollButton = new JButton("Roll");
    private JButton canButton = new JButton("Cancel");
    private JButton emailButton = new JButton("Change Email Address");
    private JDialog me;
    private JPanel serverPanel;
    private JLabel serverLabel;
    private JPanel emailPanel;
    private JLabel emailLabel;
    private JPanel descPanel;
    private JTextField descText;
    private JPanel topPanel;
    private JPanel buttonPanel;
    private JPanel detailPanel;
    protected int lastSelectedRow;
    protected int lastSelectedCol;
    private String description = "";
    protected RollRow[] rollRows;
    public static final int COL_IDX = 0;
    public static final int COL_ROLL = 1;
    public static final int COL_DESC = 2;
    public static final int COL_NDICE = 3;
    public static final int COL_NSIDES = 4;
    public static final int COL_ADD = 5;
    public static final int COL_TOTAL = 6;
    public static final int NUMCOLS = 7;
    public static final int MAX_ROLLS = 10;
    public static final int ROW_HEIGHT = 20;
    public static final int COL1_WIDTH = 31;
    public static final int COL2_WIDTH = 30;
    public static final int COL3_WIDTH = 137;
    public static final int COL4_WIDTH = 50;
    public static final int COL5_WIDTH = 50;
    public static final int COL6_WIDTH = 25;
    public static final int COL7_WIDTH = 35;
    protected DieManager dieManager;
    protected DieRoll[] rolls = new DieRoll[10];
    protected boolean[] useDie = new boolean[10];
    protected String verification = "";
    protected boolean rollCancelled = false;
    protected boolean singleRoll;
    private static final String EMAIL_OFF = "Off";

    protected MultiRoll() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MultiRoll.this.rollCancelled = true;
                MultiRoll.this.setVisible(false);
            }
        });
    }

    public MultiRoll(DieManager dieManager, int n, int n2) {
        this();
        this.dieManager = dieManager;
        for (int i = 0; i < 10; ++i) {
            this.rolls[i] = new DieRoll("", n, n2);
        }
        this.initConfig(n, n2);
        this.clearDie();
    }

    private void clearDie() {
        for (int i = 0; i < 10; ++i) {
            this.useDie[i] = false;
        }
    }

    public boolean wasCancelled() {
        return this.rollCancelled;
    }

    public void setDescription(String string) {
        this.description = string;
        this.descText.setText(string);
    }

    public String getDescription() {
        return this.description;
    }

    public RollSet getRollSet() {
        ArrayList<DieRoll> arrayList = new ArrayList<DieRoll>();
        for (int i = 0; i < 10; ++i) {
            if (!this.useDie[i]) continue;
            arrayList.add(this.rolls[i]);
        }
        DieRoll[] dieRollArray = arrayList.toArray(new DieRoll[arrayList.size()]);
        return new RollSet(this.getDescription(), dieRollArray);
    }

    public void setVisible(boolean bl) {
        this.setServerHeader();
        this.setEmailHeader();
        super.setVisible(bl);
    }

    private void initConfig(int n, int n2) {
        this.setModal(true);
        this.setTitle("Multi Roller");
        this.setSize(380, 206);
        this.setBackground(Color.gray);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 3));
        this.serverPanel = new JPanel();
        this.serverLabel = new JLabel();
        this.setServerHeader();
        this.serverPanel.add(this.serverLabel);
        this.topPanel.add(this.serverPanel);
        this.emailPanel = new JPanel();
        this.emailLabel = new JLabel();
        this.setEmailHeader();
        this.emailPanel.add(this.emailLabel);
        this.topPanel.add(this.emailPanel);
        this.descPanel = new JPanel();
        JLabel jLabel = new JLabel("Roll Description");
        this.descText = new JTextField(20);
        this.descText.setText(GameModule.getGameModule().getChatter().getInputField().getText());
        this.descText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                MultiRoll.this.description = MultiRoll.this.descText.getText();
            }
        });
        this.descPanel.add(jLabel);
        this.descPanel.add(this.descText);
        this.topPanel.add(this.descPanel);
        this.detailPanel = new JPanel();
        this.detailPanel.setLayout(new BoxLayout(this.detailPanel, 3));
        this.detailPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.detailPanel.add(new HeaderRow());
        this.rollRows = new RollRow[10];
        for (int i = 0; i < 10; ++i) {
            this.rollRows[i] = new RollRow(i, n, n2);
            this.detailPanel.add(this.rollRows[i]);
        }
        this.topPanel.add(this.detailPanel);
        this.buttonPanel = new JPanel();
        this.rollButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiRoll.this.rollCancelled = false;
                int n = 0;
                for (int i = 0; i < 10; ++i) {
                    n += MultiRoll.this.useDie[i] ? 1 : 0;
                }
                if (n == 0) {
                    JOptionPane.showMessageDialog(MultiRoll.this.me, "No dice selected for Roll.", "Roll Cancelled", 0);
                    return;
                }
                MultiRoll.this.setVisible(false);
            }
        });
        this.canButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiRoll.this.rollCancelled = true;
                MultiRoll.this.setVisible(false);
            }
        });
        this.emailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiRoll.this.updateEmailAddress();
            }
        });
        this.buttonPanel.add(this.rollButton);
        this.buttonPanel.add(this.canButton);
        this.buttonPanel.add(this.emailButton);
        this.add((Component)this.topPanel, "First");
        this.add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    protected void setServerHeader() {
        this.serverLabel.setText("Server: " + this.dieManager.getServer().getName());
    }

    protected void setEmailHeader() {
        Prefs prefs = GameModule.getGameModule().getPrefs();
        String string = (Boolean)prefs.getValue("useemail") != false ? (String)prefs.getValue("secondaryemail") : EMAIL_OFF;
        this.emailLabel.setText("Email: " + string);
    }

    protected void updateEmailAddress() {
        Prefs prefs = GameModule.getGameModule().getPrefs();
        String[] stringArray = (String[])prefs.getValue("addressbook");
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(EMAIL_OFF);
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        for (int i = 0; i < stringArray.length; ++i) {
            jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(this.emailButton, this.emailButton.getX(), this.emailButton.getY());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Prefs prefs = GameModule.getGameModule().getPrefs();
        if (string.equals(EMAIL_OFF)) {
            prefs.setValue("useemail", Boolean.FALSE);
        } else {
            prefs.setValue("secondaryemail", string);
            prefs.setValue("useemail", Boolean.TRUE);
        }
        this.setEmailHeader();
    }

    class StateButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        boolean state;

        StateButton(String string, boolean bl) {
            super(string);
            this.state = false;
            this.setHorizontalAlignment(0);
            this.setState(bl);
        }

        StateButton(String string) {
            this(string, false);
        }

        public void setState(boolean bl) {
            this.state = bl;
            if (this.state) {
                this.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
            }
        }

        public boolean getState() {
            return this.state;
        }

        public void switchState() {
            this.setState(!this.state);
        }
    }

    class RollRow
    extends JPanel {
        private static final long serialVersionUID = 1L;
        int myRow;
        boolean selected;
        String description;
        int nDice;
        int nSides;
        int plus;
        boolean reportTotal;
        Dimension rowDim = new Dimension(40, 20);
        StateButton col1;
        JCheckBox col2;
        JCheckBox col7;
        JComboBox col4;
        JComboBox col5;
        JTextField col3;
        JTextField col6;
        Border blackline = BorderFactory.createLineBorder(Color.black);
        Border raisedetched = BorderFactory.createEtchedBorder(0);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border myBorder = this.raisedbevel;

        public void setEnabled(boolean bl) {
            this.col3.setEnabled(bl);
            this.col4.setEnabled(bl);
            this.col5.setEnabled(bl);
            this.col6.setEnabled(bl);
            this.col7.setEnabled(bl);
        }

        public RollRow(int n, int n2, int n3) {
            this.myRow = n;
            this.col1 = new StateButton(n + 1 + "");
            this.col1.setPreferredSize(new Dimension(31, 20));
            this.col1.setState(MultiRoll.this.useDie[this.myRow]);
            this.col1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RollRow.this.col1.switchState();
                    MultiRoll.this.useDie[RollRow.this.myRow] = RollRow.this.col1.getState();
                    RollRow.this.setEnabled(RollRow.this.col1.getState());
                }
            });
            this.col3 = new JTextField(12);
            this.col3.setBorder(this.myBorder);
            this.col3.setPreferredSize(new Dimension(137, 20));
            this.col3.setText(MultiRoll.this.rolls[this.myRow].getDescription() + "");
            this.col3.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    MultiRoll.this.rolls[RollRow.this.myRow].setDescription(RollRow.this.col3.getText());
                }
            });
            this.col3.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!RollRow.this.col3.hasFocus()) {
                        RollRow.this.col3.selectAll();
                    }
                }
            });
            this.col3.setEnabled(false);
            int[] nArray = MultiRoll.this.dieManager.getServer().getnDiceList();
            String[] stringArray = new String[nArray.length];
            int n4 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = nArray[i] + "";
                if (n2 != nArray[i]) continue;
                n4 = i;
            }
            this.col4 = new JComboBox<String>(stringArray);
            this.col4.setSelectedIndex(n4);
            this.col4.setPreferredSize(new Dimension(50, 20));
            this.col4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    MultiRoll.this.rolls[RollRow.this.myRow].setNumDice(Integer.valueOf((String)jComboBox.getSelectedItem()));
                }
            });
            this.col4.setEnabled(false);
            int[] nArray2 = MultiRoll.this.dieManager.getServer().getnSideList();
            String[] stringArray2 = new String[nArray2.length];
            int n5 = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = nArray2[i] + "";
                if (n3 != nArray2[i]) continue;
                n5 = i;
            }
            this.col5 = new JComboBox<String>(stringArray2);
            this.col5.setSelectedIndex(n5);
            this.col5.setPreferredSize(new Dimension(50, 20));
            this.col5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    MultiRoll.this.rolls[RollRow.this.myRow].setNumSides(Integer.valueOf((String)jComboBox.getSelectedItem()));
                }
            });
            this.col5.setEnabled(false);
            this.col6 = new JTextField(2);
            this.col6.setBorder(this.myBorder);
            this.col6.setPreferredSize(new Dimension(25, 20));
            this.col6.setText(MultiRoll.this.rolls[this.myRow].getPlus() + "");
            this.col6.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    try {
                        MultiRoll.this.rolls[RollRow.this.myRow].setPlus(Integer.valueOf(RollRow.this.col3.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        MultiRoll.this.rolls[RollRow.this.myRow].setPlus(0);
                    }
                }
            });
            this.col6.setEnabled(false);
            this.col7 = new JCheckBox();
            this.col7.setBorder(this.myBorder);
            this.col7.setPreferredSize(new Dimension(35, 20));
            this.col7.setHorizontalAlignment(0);
            this.col7.setSelected(MultiRoll.this.rolls[this.myRow].isReportTotal());
            this.col7.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    MultiRoll.this.rolls[RollRow.this.myRow].setReportTotal(itemEvent.getStateChange() == 1);
                }
            });
            this.col7.setEnabled(false);
            this.add(this.col1);
            this.add(this.col3);
            this.add(this.col4);
            this.add(this.col5);
            this.add(this.col6);
            this.add(this.col7);
        }
    }

    class HeaderRow
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public HeaderRow() {
            Border border;
            Border border2 = border = BorderFactory.createRaisedBevelBorder();
            JLabel jLabel = new JLabel("Roll");
            jLabel.setPreferredSize(new Dimension(31, 20));
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(border2);
            JLabel jLabel2 = new JLabel("Details");
            jLabel2.setPreferredSize(new Dimension(137, 20));
            jLabel2.setBorder(border2);
            JLabel jLabel3 = new JLabel("nDice");
            jLabel3.setBorder(border2);
            jLabel3.setHorizontalAlignment(0);
            jLabel3.setPreferredSize(new Dimension(50, 20));
            JLabel jLabel4 = new JLabel("nSides");
            jLabel4.setBorder(border2);
            jLabel4.setHorizontalAlignment(0);
            jLabel4.setPreferredSize(new Dimension(50, 20));
            JLabel jLabel5 = new JLabel("add");
            jLabel5.setBorder(border2);
            jLabel5.setPreferredSize(new Dimension(25, 20));
            JLabel jLabel6 = new JLabel("Total");
            jLabel6.setBorder(border2);
            jLabel6.setPreferredSize(new Dimension(35, 20));
            this.add(jLabel);
            this.add(jLabel2);
            this.add(jLabel3);
            this.add(jLabel4);
            this.add(jLabel5);
            this.add(jLabel6);
        }
    }
}

