/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.AbstractProxy;
import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.menu.MenuProxy;
import VASSAL.tools.menu.ParentProxy;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedSetup
extends AbstractConfigurable
implements GameComponent {
    public static final String NAME = "name";
    public static final String FILE = "file";
    public static final String USE_FILE = "useFile";
    public static final String IS_MENU = "isMenu";
    protected boolean isMenu;
    protected boolean useFile = true;
    protected String fileName;
    protected MenuItemProxy menuItem;
    protected MenuProxy menu;
    protected VisibilityCondition showFile;
    protected VisibilityCondition showUseFile;
    protected AbstractAction launchAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            PredefinedSetup.this.launch();
        }
    };

    public PredefinedSetup() {
        this.menuItem = new MenuItemProxy(this.launchAction);
        this.menu = new MenuProxy();
        this.showFile = new VisibilityCondition(){

            public boolean shouldBeVisible() {
                return !PredefinedSetup.this.isMenu && PredefinedSetup.this.useFile;
            }
        };
        this.showUseFile = new VisibilityCondition(){

            public boolean shouldBeVisible() {
                return !PredefinedSetup.this.isMenu;
            }
        };
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Parent menu?", "Use pre-defined file?", "Saved Game:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Boolean.class, Boolean.class, File.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, IS_MENU, USE_FILE, FILE};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        if (USE_FILE.equals(string)) {
            return String.valueOf(this.useFile);
        }
        if (IS_MENU.equals(string)) {
            return String.valueOf(this.isMenu);
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            this.menuItem.getAction().putValue("Name", (String)object);
            this.menu.setText((String)object);
        } else if (USE_FILE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.useFile = (Boolean)object;
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
        } else if (IS_MENU.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.setMenu((Boolean)object);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (FILE.equals(string)) {
            return this.showFile;
        }
        if (USE_FILE.equals(string)) {
            return this.showUseFile;
        }
        return super.getAttributeVisibility(string);
    }

    public void launch() {
        if (this.useFile && this.fileName != null) {
            try {
                GameModule.getGameModule().getGameState().loadGameInBackground(this.fileName, this.getSavedGameContents());
            }
            catch (IOException iOException) {
                ErrorDialog.dataError(new BadDataReport(this, Resources.getString("Error.not_found", "Setup"), this.fileName, (Throwable)iOException));
            }
        } else {
            GameModule.getGameModule().getGameState().setup(false);
            GameModule.getGameModule().getGameState().setup(true);
        }
    }

    public InputStream getSavedGameContents() throws IOException {
        return GameModule.getGameModule().getDataArchive().getInputStream(this.fileName);
    }

    private ChildProxy<?> getMenuInUse() {
        return this.isMenu ? this.menu : this.menuItem;
    }

    private void setMenu(boolean bl) {
        if (bl == this.isMenu) {
            return;
        }
        ChildProxy<?> childProxy = this.getMenuInUse();
        ParentProxy parentProxy = childProxy.getParent();
        if (parentProxy != null) {
            AbstractProxy abstractProxy = this.isMenu ? this.menuItem : this.menu;
            parentProxy.insert(abstractProxy, parentProxy.getIndex(childProxy));
            parentProxy.remove(childProxy);
        }
        this.isMenu = bl;
    }

    @Override
    public void addTo(Buildable buildable) {
        if (buildable instanceof GameModule) {
            MenuManager.getInstance().addToSection("PredefinedSetup", this.getMenuInUse());
        } else if (buildable instanceof PredefinedSetup) {
            PredefinedSetup predefinedSetup = (PredefinedSetup)buildable;
            predefinedSetup.menu.add(this.getMenuInUse());
        }
        MenuManager.getInstance().removeAction("GameState.new_game");
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().getWizardSupport().addPredefinedSetup(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        if (buildable instanceof GameModule) {
            MenuManager.getInstance().removeFromSection("PredefinedSetup", this.getMenuInUse());
        } else if (buildable instanceof PredefinedSetup) {
            PredefinedSetup predefinedSetup = (PredefinedSetup)buildable;
            predefinedSetup.menu.remove(this.getMenuInUse());
        }
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().getWizardSupport().removePredefinedSetup(this);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        Class[] classArray;
        if (this.isMenu) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = PredefinedSetup.class;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    public static String getConfigureTypeName() {
        return "Pre-defined setup";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "PredefinedSetup");
    }

    public boolean isMenu() {
        return this.isMenu;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean bl) {
        this.launchAction.setEnabled(!bl);
    }
}

