/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.menu.MenuManager;
import java.awt.Component;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivateMap
extends Map {
    protected String[] owners = new String[0];
    protected boolean visibleToAll;
    protected Map surrogate;
    public static final String VISIBLE = "visible";
    public static final String SIDE = "side";
    public static final String USE_BOARDS = "useBoards";

    @Override
    public String[] getAttributeNames() {
        String[] stringArray = new String[]{SIDE, VISIBLE, USE_BOARDS};
        String[] stringArray2 = super.getAttributeNames();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    @Override
    public String[] getAttributeDescriptions() {
        String[] stringArray = new String[]{"Belongs to side", "Visible to all players?", "Use same boards as this map:  "};
        String[] stringArray2 = super.getAttributeDescriptions();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Class[] classArray = new Class[]{String[].class, Boolean.class, String.class};
        Class<?>[] classArray2 = super.getAttributeTypes();
        Class[] classArray3 = new Class[classArray.length + classArray2.length];
        System.arraycopy(classArray, 0, classArray3, 0, classArray.length);
        System.arraycopy(classArray2, 0, classArray3, classArray.length, classArray2.length);
        return classArray3;
    }

    @Override
    public void setAttribute(String string, Object stringArray) {
        if (VISIBLE.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = Boolean.valueOf((String)stringArray);
            }
            this.visibleToAll = (Boolean)stringArray;
        } else if (SIDE.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = StringArrayConfigurer.stringToArray((String)stringArray);
            }
            this.owners = stringArray;
        } else if (USE_BOARDS.equals(string)) {
            for (Map map : Map.getMapList()) {
                if (!map.getMapName().equals(stringArray)) continue;
                this.surrogate = map;
                break;
            }
        } else {
            super.setAttribute(string, stringArray);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (VISIBLE.equals(string)) {
            return String.valueOf(this.visibleToAll);
        }
        if (SIDE.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.owners);
        }
        if (USE_BOARDS.equals(string)) {
            return this.surrogate == null ? null : this.surrogate.getMapName();
        }
        return super.getAttributeValueString(string);
    }

    @Override
    public JComponent getView() {
        if (this.theMap == null) {
            this.theMap = new View(this);
            this.scroll = new AdjustableSpeedScrollPane(this.theMap, 22, 32);
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
            this.layeredPane.setLayout(new Map.InsetLayout(this.layeredPane, this.scroll));
            this.layeredPane.add((Component)this.scroll, JLayeredPane.DEFAULT_LAYER);
        }
        return this.theMap;
    }

    @Override
    protected Window createParentFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            JDialog jDialog = new JDialog(GameModule.getGameModule().getFrame()){
                private static final long serialVersionUID = 1L;

                public void setVisible(boolean bl) {
                    super.setVisible(bl && (PrivateMap.this.visibleToAll || PrivateMap.this.isAccessibleTo(PlayerRoster.getMySide())));
                }
            };
            jDialog.setDefaultCloseOperation(0);
            jDialog.setTitle(this.getDefaultWindowTitle());
            return jDialog;
        }
        JFrame jFrame = new JFrame(){
            private static final long serialVersionUID = 1L;

            public void setVisible(boolean bl) {
                super.setVisible(bl && (PrivateMap.this.visibleToAll || PrivateMap.this.isAccessibleTo(PlayerRoster.getMySide())));
            }
        };
        jFrame.setDefaultCloseOperation(0);
        jFrame.setTitle(this.getDefaultWindowTitle());
        jFrame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(jFrame));
        return jFrame;
    }

    @Override
    public void sideChanged(String string, String string2) {
        super.sideChanged(string, string2);
        ((View)this.getView()).disableListeners();
        if (this.isAccessibleTo(string2)) {
            ((View)this.getView()).enableListeners();
        }
        this.launchButton.setEnabled(this.isVisibleTo(PlayerRoster.getMySide()));
    }

    @Override
    public boolean shouldDockIntoMainWindow() {
        return false;
    }

    public boolean isAccessibleTo(String string) {
        for (int i = 0; i < this.owners.length; ++i) {
            if (!this.owners[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisibleTo(String string) {
        return this.visibleToAll || this.isAccessibleTo(string);
    }

    @Override
    public void setup(boolean bl) {
        super.setup(bl);
        if (!bl) {
            ((View)this.theMap).disableListeners();
        } else if (this.isAccessibleTo(PlayerRoster.getMySide())) {
            ((View)this.theMap).enableListeners();
        }
        this.launchButton.setEnabled(this.isVisibleTo(PlayerRoster.getMySide()));
    }

    @Override
    public void setBoards(Collection<Board> collection) {
        if (this.surrogate != null) {
            collection = this.surrogate.getBoards();
            this.edgeBuffer = this.surrogate.getEdgeBuffer();
        }
        super.setBoards(collection);
    }

    @Override
    @Deprecated
    public void setBoards(Enumeration enumeration) {
        if (this.surrogate != null) {
            enumeration = this.surrogate.getAllBoards();
            this.edgeBuffer = this.surrogate.getEdgeBuffer();
        }
        super.setBoards(enumeration);
    }

    public static String getConfigureTypeName() {
        return "Private Window";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PrivateWindow.htm");
    }

    @Override
    public void build(Element element) {
        this.validator = new ValidityChecker(){

            public void validate(Buildable buildable, ValidationReport validationReport) {
                if (!PlayerRoster.isActive()) {
                    validationReport.addWarning("Must add " + ConfigureTree.getConfigureName(PlayerRoster.class) + " in order to use " + ConfigureTree.getConfigureName(this.getClass()));
                }
            }
        };
        this.surrogate = null;
        super.build(element);
    }

    public static class View
    extends Map.View {
        private static final long serialVersionUID = 1L;
        private boolean listenersActive;
        private List<KeyListener> keyListeners = new ArrayList<KeyListener>();
        private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
        private List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
        private DropTarget dropTarget;

        public View(PrivateMap privateMap) {
            super(privateMap);
        }

        public synchronized void setDropTarget(DropTarget dropTarget) {
            if (dropTarget != null) {
                this.dropTarget = dropTarget;
            }
        }

        public synchronized void addKeyListener(KeyListener keyListener) {
            if (this.listenersActive) {
                super.addKeyListener(keyListener);
            } else {
                this.keyListeners.add(keyListener);
            }
        }

        public synchronized void addMouseListener(MouseListener mouseListener) {
            if (this.listenersActive) {
                super.addMouseListener(mouseListener);
            } else {
                this.mouseListeners.add(mouseListener);
            }
        }

        public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
            if (this.listenersActive) {
                super.addMouseMotionListener(mouseMotionListener);
            } else {
                this.mouseMotionListeners.add(mouseMotionListener);
            }
        }

        protected void disableListeners() {
            for (KeyListener eventListener : this.keyListeners) {
                this.removeKeyListener(eventListener);
            }
            for (MouseListener mouseListener : this.mouseListeners) {
                this.removeMouseListener(mouseListener);
            }
            for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
                this.removeMouseMotionListener(mouseMotionListener);
            }
            super.setDropTarget(null);
            this.listenersActive = false;
        }

        protected void enableListeners() {
            for (KeyListener eventListener : this.keyListeners) {
                super.addKeyListener(eventListener);
            }
            for (MouseListener mouseListener : this.mouseListeners) {
                super.addMouseListener(mouseListener);
            }
            for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
                super.addMouseMotionListener(mouseMotionListener);
            }
            super.setDropTarget(this.dropTarget);
            this.listenersActive = true;
        }
    }
}

