/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ToolBarComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarMenu
extends AbstractConfigurable
implements ContainerListener,
PropertyChangeListener,
GameComponent {
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_ICON = "icon";
    public static final String BUTTON_HOTKEY = "hotkey";
    public static final String TOOLTIP = "tooltip";
    public static final String MENU_ITEMS = "menuItems";
    public static final String MENU_PROPERTY = "ToolbarMenu.popup";
    protected List<String> menuItems = new ArrayList<String>();
    protected Map<AbstractButton, JMenuItem> buttonsToMenuMap = new HashMap<AbstractButton, JMenuItem>();
    protected LaunchButton launch = new LaunchButton(Resources.getString("General.menu"), "tooltip", "text", "hotkey", "icon", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ToolbarMenu.this.launch();
        }
    });
    protected JToolBar toolbar;
    protected JPopupMenu menu = new JPopupMenu();
    protected Runnable menuBuilder;

    public ToolbarMenu() {
        this.launch.putClientProperty(MENU_PROPERTY, this.menu);
        this.launch.setToolTipText("Display Menu Options");
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public void launch() {
        this.menu.show(this.launch, 0, 0);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.ToolbarMenu.menu_entries")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, Icon.class, KeyStroke.class, String[].class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, BUTTON_ICON, BUTTON_HOTKEY, MENU_ITEMS};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (MENU_ITEMS.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.menuItems.toArray(new String[this.menuItems.size()]));
        }
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public void setAttribute(String string, Object stringArray) {
        if (MENU_ITEMS.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = StringArrayConfigurer.stringToArray((String)stringArray);
            }
            this.menuItems = new ArrayList<String>(Arrays.asList(stringArray));
            if (this.toolbar != null) {
                this.scheduleBuildMenu();
            }
        } else if (BUTTON_TEXT.equals(string)) {
            this.setConfigureName((String)stringArray);
            this.launch.setAttribute(string, stringArray);
        } else {
            this.launch.setAttribute(string, stringArray);
        }
    }

    @Override
    public void addTo(Buildable buildable) {
        if (buildable instanceof ToolBarComponent) {
            this.toolbar = ((ToolBarComponent)((Object)buildable)).getToolBar();
        }
        this.toolbar.add(this.launch);
        this.toolbar.addContainerListener(this);
        this.scheduleBuildMenu();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ToolbarMenu.htm");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ToolbarMenu.component_type");
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.toolbar.remove(this.launch);
        this.toolbar.removeContainerListener(this);
    }

    protected void buildMenu() {
        Object object;
        JButton jButton;
        for (AbstractButton abstractButton : this.buttonsToMenuMap.keySet()) {
            abstractButton.setVisible(true);
            abstractButton.removePropertyChangeListener(this);
        }
        this.buttonsToMenuMap.clear();
        this.menu.removeAll();
        HashMap hashMap = new HashMap();
        if (this.toolbar != null) {
            int n = this.toolbar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!(this.toolbar.getComponentAtIndex(i) instanceof JButton)) continue;
                jButton = (JButton)this.toolbar.getComponentAtIndex(i);
                object = (String)jButton.getClientProperty("unTranslatedText");
                if (object == null) {
                    object = jButton.getText();
                }
                hashMap.put(object, jButton);
            }
        }
        for (String string : this.menuItems) {
            JComponent jComponent;
            jButton = (JButton)hashMap.get(string);
            if (jButton == null) continue;
            object = jButton.getClientProperty(MENU_PROPERTY);
            jButton.addPropertyChangeListener(this);
            jButton.setVisible(false);
            if (object instanceof JPopupMenu) {
                jComponent = (JPopupMenu)object;
                jComponent.addContainerListener(this);
                JMenu jMenu = new JMenu(jButton.getText());
                Component[] componentArray = jComponent.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    final JMenuItem jMenuItem = (JMenuItem)componentArray[i];
                    JMenuItem jMenuItem2 = new JMenuItem(jMenuItem.getText(), jMenuItem.getIcon());
                    jMenuItem2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            jMenuItem.doClick();
                        }
                    });
                    jMenu.add(jMenuItem2);
                    this.buttonsToMenuMap.put(jMenuItem, jMenuItem2);
                }
                this.buttonsToMenuMap.put(jButton, jMenu);
                this.menu.add(jMenu);
                continue;
            }
            jComponent = new JMenuItem(jButton.getText(), jButton.getIcon());
            ((JMenuItem)jComponent).setEnabled(jButton.isEnabled());
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jButton.doClick();
                }
            });
            this.buttonsToMenuMap.put(jButton, (JMenuItem)jComponent);
            this.menu.add((JMenuItem)jComponent);
        }
    }

    protected void scheduleBuildMenu() {
        if (this.menuBuilder == null) {
            this.menuBuilder = new Runnable(){

                public void run() {
                    ToolbarMenu.this.buildMenu();
                    ToolbarMenu.this.menuBuilder = null;
                }
            };
            SwingUtilities.invokeLater(this.menuBuilder);
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.scheduleBuildMenu();
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.scheduleBuildMenu();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JButton jButton = (JButton)propertyChangeEvent.getSource();
        JMenuItem jMenuItem = this.buttonsToMenuMap.get(jButton);
        if (jMenuItem != null) {
            if (BUTTON_TEXT.equals(propertyChangeEvent.getPropertyName())) {
                this.scheduleBuildMenu();
            } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                jMenuItem.setEnabled(jButton.isEnabled());
            } else if (BUTTON_ICON.equals(propertyChangeEvent.getPropertyName())) {
                jMenuItem.setIcon(jButton.getIcon());
            }
        }
    }

    @Override
    public void setup(boolean bl) {
        this.scheduleBuildMenu();
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }
}

