/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.GameState;
import VASSAL.build.module.PredefinedSetup;
import VASSAL.build.module.documentation.Tutorial;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.command.CommandFilter;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.PasswordConfigurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.BasicModule;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SplashScreen;
import VASSAL.tools.UsernameAndPasswordDialog;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.logging.Logger;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.swingworker.SwingWorker;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardBranchController;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class WizardSupport {
    public static final String POST_INITIAL_STEPS_WIZARD = "postInitialStepsWizard";
    public static final String POST_LOAD_GAME_WIZARD = "postLoadGameWizard";
    public static final String POST_PLAY_OFFLINE_WIZARD = "postPlayOfflineWizard";
    public static final String WELCOME_WIZARD_KEY = "welcomeWizard";
    public static final String SETUP_KEY = "setup";
    public static final String ACTION_KEY = "action";
    public static final String LOAD_TUTORIAL_ACTION = "tutorial";
    public static final String PLAY_ONLINE_ACTION = "online";
    public static final String PLAY_OFFLINE_ACTION = "offline";
    public static final String LOAD_GAME_ACTION = "loadGame";
    public static final String WELCOME_WIZARD_ENABLED = "showWelcomeWizard";
    protected Dimension logoSize = new Dimension(200, 200);
    protected List<PredefinedSetup> setups = new ArrayList<PredefinedSetup>();
    protected Tutorial tutorial;

    public void addPredefinedSetup(PredefinedSetup predefinedSetup) {
        this.setups.add(predefinedSetup);
    }

    public void removePredefinedSetup(PredefinedSetup predefinedSetup) {
        this.setups.remove(predefinedSetup);
    }

    public void setTutorial(Tutorial tutorial) {
        this.tutorial = tutorial;
    }

    public void showWelcomeWizard() {
        GameModule gameModule = GameModule.getGameModule();
        Boolean bl = (Boolean)Prefs.getGlobalPrefs().getValue(WELCOME_WIZARD_KEY);
        if (!Boolean.TRUE.equals(bl)) {
            gameModule.getFrame().setVisible(true);
            String string = (String)gameModule.getPrefs().getValue("RealName");
            if (string == null || string.equals("newbie")) {
                new UsernameAndPasswordDialog(gameModule.getFrame()).setVisible(true);
            }
            return;
        }
        BranchingWizard branchingWizard = this.createWelcomeWizard();
        Wizard wizard = branchingWizard.createWizard();
        HashMap<String, Wizard> hashMap = new HashMap<String, Wizard>();
        hashMap.put(WELCOME_WIZARD_KEY, wizard);
        ShowHelpAction showHelpAction = null;
        try {
            showHelpAction = new ShowHelpAction(new URL("http://www.vassalengine.org/wiki/doku.php?id=getting_started:getting_started"), null);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        Object object = WizardDisplayer.showWizard((Wizard)wizard, null, (Action)showHelpAction, hashMap);
        if (object instanceof Map) {
            Map map = (Map)object;
            Object v = map.get(ACTION_KEY);
            if (PLAY_ONLINE_ACTION.equals(v)) {
                final ChatServerControls chatServerControls = ((BasicModule)gameModule).getServerControls();
                gameModule.getFrame().setVisible(true);
                chatServerControls.toggleVisible();
                new SwingWorker<Void, Void>(){

                    protected Void doInBackground() {
                        chatServerControls.getClient().setConnected(true);
                        return null;
                    }
                }.execute();
            } else {
                gameModule.getGameState().setup(true);
                gameModule.getFrame().setVisible(true);
            }
        } else {
            gameModule.getFrame().setVisible(true);
        }
    }

    protected BranchingWizard createWelcomeWizard() {
        InitialWelcomeSteps initialWelcomeSteps = this.createInitialWelcomeSteps();
        initialWelcomeSteps.setTutorial(this.tutorial);
        return new BranchingWizard(initialWelcomeSteps, POST_INITIAL_STEPS_WIZARD);
    }

    public WizardPanelProvider createPlayOfflinePanels() {
        ArrayList<PredefinedSetup> arrayList = new ArrayList<PredefinedSetup>();
        for (PredefinedSetup predefinedSetup : this.setups) {
            if (predefinedSetup.isMenu()) continue;
            arrayList.add(predefinedSetup);
        }
        if (arrayList.isEmpty()) {
            return GameSetupPanels.newInstance();
        }
        return new PlayOfflinePanels(Resources.getString("WizardSupport.WizardSupport.PlayOffline"), Resources.getString("WizardSupport.WizardSupport.SelectSetup"), arrayList);
    }

    public void showGameSetupWizard() {
        GameSetupPanels gameSetupPanels = GameSetupPanels.newInstance();
        if (gameSetupPanels != null) {
            WizardDisplayer.showWizard((Wizard)gameSetupPanels.newWizard(this.logoSize), (Rectangle)new Rectangle(0, 0, this.logoSize.width + 400, this.logoSize.height));
        }
    }

    public InitialWelcomeSteps createInitialWelcomeSteps() {
        Object object = GameModule.getGameModule().getPrefs().getValue("RealName");
        if (object == null || object.equals(Resources.getString("Prefs.newbie"))) {
            return new InitialWelcomeSteps(new String[]{"name", ACTION_KEY}, new String[]{Resources.getString("WizardSupport.WizardSupport.EnterName"), Resources.getString("WizardSupport.WizardSupport.SelectPlayMode")});
        }
        return new InitialWelcomeSteps(new String[]{ACTION_KEY}, new String[]{Resources.getString("WizardSupport.SelectPlayMode")});
    }

    public void setBackgroundImage(Image image) {
        if (image != null) {
            ImageIcon imageIcon = new ImageIcon(image);
            this.logoSize = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(this.logoSize.width, this.logoSize.height);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            imageIcon.paintIcon(null, graphics2D, 0, 0);
            graphics2D.dispose();
            UIManager.put("wizard.sidebar.image", bufferedImage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GameSetupPanels
    extends WizardPanelProvider
    implements WizardPage.WizardResultProducer {
        private WizardPage[] pages;
        private List<GameSetupStep> setupSteps;

        private GameSetupPanels(String[] stringArray, String[] stringArray2, WizardPage[] wizardPageArray, List<GameSetupStep> list) {
            super(stringArray, stringArray2);
            this.pages = wizardPageArray;
            this.setupSteps = list;
        }

        public static GameSetupPanels newInstance() {
            String[] stringArray;
            String[] stringArray2;
            GameSetupPanels gameSetupPanels = null;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ArrayList<GameSetupStep> arrayList2 = new ArrayList<GameSetupStep>();
            WizardPage[] wizardPageArray = GameModule.getGameModule().getGameState().getUnfinishedSetupSteps();
            while (wizardPageArray.hasNext()) {
                stringArray2 = wizardPageArray.next();
                arrayList2.add((GameSetupStep)stringArray2);
                stringArray = new SetupStepPage((GameSetupStep)stringArray2);
                arrayList.add(stringArray);
            }
            if (!arrayList.isEmpty()) {
                wizardPageArray = arrayList.toArray(new WizardPage[arrayList.size()]);
                stringArray2 = new String[arrayList2.size()];
                stringArray = new String[arrayList2.size()];
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = String.valueOf(i);
                    stringArray[i] = arrayList2.get(i).getStepTitle();
                }
                gameSetupPanels = new GameSetupPanels(stringArray2, stringArray, wizardPageArray, arrayList2);
            }
            return gameSetupPanels;
        }

        protected JComponent createPanel(WizardController wizardController, String string, Map map) {
            int n = this.indexOfStep(string);
            wizardController.setForwardNavigationMode(n == this.pages.length - 1 ? 2 : 1);
            return this.pages[n];
        }

        public boolean cancel(Map map) {
            GameModule.getGameModule().getGameState().setup(false);
            return true;
        }

        public Object finish(Map map) throws WizardException {
            for (GameSetupStep gameSetupStep : this.setupSteps) {
                gameSetupStep.finish();
            }
            return map;
        }

        public Wizard newWizard(Dimension dimension) {
            Wizard wizard = this.createWizard();
            return wizard;
        }
    }

    public static class SetupStepPage
    extends WizardPage {
        private static final long serialVersionUID = 1L;

        public SetupStepPage(GameSetupStep gameSetupStep) {
            super(gameSetupStep.getStepTitle());
            this.setLayout(new BorderLayout());
            this.add(gameSetupStep.getControls());
            this.putWizardData(gameSetupStep, gameSetupStep);
        }
    }

    public static class LoadSavedGamePanels
    extends WizardPanelProvider {
        private FileConfigurer fileConfig;

        public LoadSavedGamePanels() {
            super(Resources.getString("WizardSupport.LoadGame"), WizardSupport.LOAD_GAME_ACTION, Resources.getString("WizardSupport.LoadSavedGame"));
        }

        protected JComponent createPanel(final WizardController wizardController, String string, final Map map) {
            if (this.fileConfig == null) {
                this.fileConfig = new FileConfigurer(null, Resources.getString("WizardSupport.SavedGame"), GameModule.getGameModule().getGameState().getSavedGameDirectoryPreference());
                this.fileConfig.addPropertyChangeListener(new PropertyChangeListener(){
                    private Set<File> processing = new HashSet<File>();

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        final File file = (File)propertyChangeEvent.getNewValue();
                        if (file == null || !file.exists()) {
                            wizardController.setProblem(Resources.getString("WizardSupport.NoSuchFile"));
                        } else if (file.isDirectory()) {
                            wizardController.setProblem("");
                        } else if (!this.processing.contains(file)) {
                            this.processing.add(file);
                            try {
                                new SavedGameLoader(wizardController, map, new BufferedInputStream(new FileInputStream(file)), WizardSupport.POST_LOAD_GAME_WIZARD){

                                    public void run() {
                                        super.run();
                                        processing.remove(file);
                                    }
                                }.start();
                            }
                            catch (IOException iOException) {
                                wizardController.setProblem(Resources.getString("WizardSupport.UnableToLoad"));
                            }
                        }
                    }
                });
                wizardController.setProblem(Resources.getString("WizardSupport.SelectSavedGame"));
            }
            return (JComponent)this.fileConfig.getControls();
        }
    }

    public static class TutorialLoader
    extends SavedGameLoader {
        private Tutorial tutorial;

        public TutorialLoader(WizardController wizardController, Map map, InputStream inputStream, String string, Tutorial tutorial) {
            super(wizardController, map, inputStream, string);
            this.tutorial = tutorial;
        }

        protected Command loadSavedGame() throws IOException {
            String string = this.tutorial.getWelcomeMessage();
            Command command = string == null ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
            command = command.append(super.loadSavedGame());
            return command;
        }
    }

    public static class SavedGameLoader
    extends Thread {
        private WizardController controller;
        private Map settings;
        private InputStream in;
        private String wizardKey;

        public SavedGameLoader(WizardController wizardController, Map map, InputStream inputStream, String string) {
            this.controller = wizardController;
            this.settings = map;
            this.in = inputStream;
            this.wizardKey = string;
        }

        public void run() {
            try {
                this.controller.setProblem(Resources.getString("WizardSupport.LoadingGame"));
                Command command = this.loadSavedGame();
                command.execute();
                this.controller.setProblem(null);
                GameSetupPanels gameSetupPanels = GameSetupPanels.newInstance();
                this.settings.put(this.wizardKey, gameSetupPanels);
                this.controller.setForwardNavigationMode(gameSetupPanels == null ? 2 : 1);
            }
            catch (IOException iOException) {
                this.controller.setProblem(Resources.getString("WizardSupport.UnableToLoad"));
            }
        }

        protected Command loadSavedGame() throws IOException {
            Command command = GameModule.getGameModule().getGameState().decodeSavedGame(this.in);
            if (command == null) {
                throw new IOException(Resources.getString("WizardSupport.InvalidSavefile"));
            }
            command = new CommandFilter(){

                protected boolean accept(Command command) {
                    return !(command instanceof GameState.SetupCommand) || !((GameState.SetupCommand)command).isGameStarting();
                }
            }.apply(command);
            return command;
        }
    }

    public static class BranchingWizard
    extends WizardBranchController {
        private String wizardKey;

        public BranchingWizard(WizardPanelProvider wizardPanelProvider, String string) {
            super(wizardPanelProvider);
            this.wizardKey = string;
        }

        protected WizardPanelProvider getPanelProviderForStep(String string, Map map) {
            WizardPanelProvider wizardPanelProvider = (WizardPanelProvider)map.get(this.wizardKey);
            return wizardPanelProvider;
        }

        protected Wizard getWizardForStep(String string, Map map) {
            Wizard wizard = null;
            Object v = map.get(this.wizardKey);
            wizard = v instanceof Wizard ? (Wizard)v : super.getWizardForStep(string, map);
            return wizard;
        }
    }

    public static class PlayOfflinePanels
    extends WizardPanelProvider {
        private List setups;
        private String description;

        protected PlayOfflinePanels(String string, String string2, List list) {
            super(string, WizardSupport.SETUP_KEY, string2);
            this.setups = list;
            this.description = string2;
        }

        protected JComponent createPanel(final WizardController wizardController, String string, final Map map) {
            final JComboBox<Object> jComboBox = new JComboBox<Object>(this.setups.toArray());
            ((DefaultComboBoxModel)jComboBox.getModel()).insertElementAt(this.description, 0);
            jComboBox.setSelectedIndex(0);
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jComboBox.getSelectedItem() instanceof PredefinedSetup) {
                        PredefinedSetup predefinedSetup = (PredefinedSetup)jComboBox.getSelectedItem();
                        if (predefinedSetup.isUseFile() && predefinedSetup.getFileName() != null) {
                            PlayOfflinePanels.this.loadSetup(predefinedSetup, wizardController, map);
                        } else {
                            GameSetupPanels gameSetupPanels = GameSetupPanels.newInstance();
                            map.put(WizardSupport.POST_PLAY_OFFLINE_WIZARD, gameSetupPanels);
                            wizardController.setProblem(null);
                            wizardController.setForwardNavigationMode(gameSetupPanels == null ? 2 : 1);
                        }
                    } else {
                        wizardController.setProblem(PlayOfflinePanels.this.description);
                    }
                }
            });
            jComboBox.setMaximumSize(new Dimension(jComboBox.getMaximumSize().width, jComboBox.getPreferredSize().height));
            jComboBox.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof PredefinedSetup) {
                        PredefinedSetup predefinedSetup = (PredefinedSetup)object;
                        jLabel.setText(predefinedSetup.getConfigureName());
                        if (predefinedSetup.isMenu()) {
                            jLabel.setSize(0, 0);
                        }
                    } else {
                        jLabel.setText(object == null ? "" : object.toString());
                    }
                    return jLabel;
                }
            });
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalGlue());
            box.add(jComboBox);
            box.add(Box.createVerticalGlue());
            wizardController.setProblem(this.description);
            return box;
        }

        protected void loadSetup(PredefinedSetup predefinedSetup, WizardController wizardController, Map map) {
            try {
                new SavedGameLoader(wizardController, map, new BufferedInputStream(predefinedSetup.getSavedGameContents()), WizardSupport.POST_PLAY_OFFLINE_WIZARD).start();
            }
            catch (IOException iOException) {
                wizardController.setProblem(Resources.getString("WizardSupport.UnableToLoad"));
            }
        }
    }

    public class InitialWelcomeSteps
    extends WizardPanelProvider {
        public static final String NAME_STEP = "name";
        protected JComponent nameControls;
        protected JComponent actionControls;
        protected Tutorial tutorial;

        public InitialWelcomeSteps(String[] stringArray, String[] stringArray2) {
            super(Resources.getString("WizardSupport.Welcome"), stringArray, stringArray2);
        }

        protected JComponent createPanel(WizardController wizardController, String string, Map map) {
            JComponent jComponent = null;
            if (NAME_STEP.equals(string)) {
                jComponent = this.getNameControls(wizardController, map);
            } else if (WizardSupport.ACTION_KEY.equals(string)) {
                jComponent = this.getActionControls(wizardController, map);
            } else {
                throw new IllegalArgumentException("Illegal step: " + string);
            }
            SplashScreen.disposeAll();
            return jComponent;
        }

        private JComponent getActionControls(WizardController wizardController, Map map) {
            if (this.actionControls == null) {
                Object object;
                Box box = Box.createVerticalBox();
                ButtonGroup buttonGroup = new ButtonGroup();
                JRadioButton jRadioButton = null;
                if (this.tutorial != null && this.tutorial.isFirstRun()) {
                    jRadioButton = this.createTutorialButton(wizardController, map);
                    this.addButton(jRadioButton, buttonGroup, box);
                    box.add(Box.createVerticalStrut(20));
                }
                JRadioButton jRadioButton2 = this.createPlayOfflineButton(wizardController, map);
                jRadioButton2.doClick();
                this.addButton(jRadioButton2, buttonGroup, box);
                map.put(WizardSupport.ACTION_KEY, WizardSupport.PLAY_OFFLINE_ACTION);
                this.addButton(this.createPlayOnlineButton(wizardController, map), buttonGroup, box);
                this.addButton(this.createLoadSavedGameButton(wizardController, map), buttonGroup, box);
                if (jRadioButton != null) {
                    object = jRadioButton;
                    SwingUtilities.invokeLater(new Runnable((JRadioButton)object){
                        final /* synthetic */ JRadioButton val$clickOnMe;
                        {
                            this.val$clickOnMe = jRadioButton;
                        }

                        public void run() {
                            this.val$clickOnMe.doClick();
                        }
                    });
                    jRadioButton.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent itemEvent) {
                            if (itemEvent.getStateChange() == 2) {
                                InitialWelcomeSteps.this.tutorial.markAsViewed();
                            }
                        }
                    });
                } else if (this.tutorial != null) {
                    this.addButton(this.createTutorialButton(wizardController, map), buttonGroup, box);
                }
                this.actionControls = box;
                box.add(Box.createVerticalGlue());
                object = (BooleanConfigurer)Prefs.getGlobalPrefs().getOption(WizardSupport.WELCOME_WIZARD_KEY);
                JCheckBox jCheckBox = new JCheckBox(((Configurer)object).getName());
                jCheckBox.setSelected(((BooleanConfigurer)object).booleanValue());
                jCheckBox.addActionListener(new ActionListener((BooleanConfigurer)object, jCheckBox){
                    final /* synthetic */ BooleanConfigurer val$wizardConf;
                    final /* synthetic */ JCheckBox val$show;
                    {
                        this.val$wizardConf = booleanConfigurer;
                        this.val$show = jCheckBox;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$wizardConf.setValue(this.val$show.isSelected());
                    }
                });
                box.add(jCheckBox);
            }
            return this.actionControls;
        }

        private JRadioButton createTutorialButton(final WizardController wizardController, final Map map) {
            JRadioButton jRadioButton = new JRadioButton(Resources.getString("WizardSupport.LoadTutorial"));
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    wizardController.setProblem(Resources.getString("WizardSupport.LoadingTutorial"));
                    try {
                        new TutorialLoader(wizardController, map, new BufferedInputStream(InitialWelcomeSteps.this.tutorial.getTutorialContents()), WizardSupport.POST_INITIAL_STEPS_WIZARD, InitialWelcomeSteps.this.tutorial).start();
                    }
                    catch (IOException iOException) {
                        Logger.log(iOException);
                        wizardController.setProblem(Resources.getString("WizardSupport.ErrorLoadingTutorial"));
                    }
                }
            });
            return jRadioButton;
        }

        private JRadioButton createLoadSavedGameButton(final WizardController wizardController, final Map map) {
            JRadioButton jRadioButton = new JRadioButton(Resources.getString("WizardSupport.LoadSavedGame"));
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    map.put(WizardSupport.ACTION_KEY, WizardSupport.LOAD_GAME_ACTION);
                    Wizard wizard = new BranchingWizard(new LoadSavedGamePanels(), WizardSupport.POST_LOAD_GAME_WIZARD).createWizard();
                    map.put(WizardSupport.POST_INITIAL_STEPS_WIZARD, wizard);
                    wizardController.setForwardNavigationMode(1);
                    wizardController.setProblem(null);
                }
            });
            return jRadioButton;
        }

        private JRadioButton createPlayOnlineButton(final WizardController wizardController, final Map map) {
            JRadioButton jRadioButton = new JRadioButton(Resources.getString("WizardSupport.PlayOnline"));
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    map.put(WizardSupport.ACTION_KEY, WizardSupport.PLAY_ONLINE_ACTION);
                    wizardController.setForwardNavigationMode(2);
                    wizardController.setProblem(null);
                }
            });
            return jRadioButton;
        }

        private JRadioButton createPlayOfflineButton(final WizardController wizardController, final Map map) {
            JRadioButton jRadioButton = new JRadioButton(Resources.getString("WizardSupport.PlayOffline"));
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GameModule.getGameModule().getGameState().setup(false);
                    map.put(WizardSupport.ACTION_KEY, WizardSupport.PLAY_OFFLINE_ACTION);
                    WizardPanelProvider wizardPanelProvider = WizardSupport.this.createPlayOfflinePanels();
                    if (wizardPanelProvider == null) {
                        wizardController.setForwardNavigationMode(2);
                    } else {
                        Wizard wizard = new BranchingWizard(wizardPanelProvider, WizardSupport.POST_PLAY_OFFLINE_WIZARD).createWizard();
                        map.put(WizardSupport.POST_INITIAL_STEPS_WIZARD, wizard);
                        wizardController.setForwardNavigationMode(1);
                    }
                }
            });
            return jRadioButton;
        }

        private void addButton(JRadioButton jRadioButton, ButtonGroup buttonGroup, Box box) {
            box.add(jRadioButton);
            buttonGroup.add(jRadioButton);
        }

        protected JComponent getNameControls(final WizardController wizardController, final Map map) {
            if (this.nameControls == null) {
                Box box = Box.createVerticalBox();
                box.add(Box.createVerticalGlue());
                wizardController.setProblem(Resources.getString("WizardSupport.EnterNameAndPassword"));
                final StringConfigurer stringConfigurer = new StringConfigurer(null, Resources.getString("WizardSupport.RealName"));
                final PasswordConfigurer passwordConfigurer = new PasswordConfigurer(null, Resources.getString("WizardSupport.Password"));
                final PasswordConfigurer passwordConfigurer2 = new PasswordConfigurer(null, Resources.getString("WizardSupport.ConfirmPassword"));
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        map.put("RealName", stringConfigurer.getValue());
                        map.put("SecretName", passwordConfigurer.getValue());
                        if (stringConfigurer.getValue() == null || "".equals(stringConfigurer.getValue())) {
                            wizardController.setProblem(Resources.getString("WizardSupport.EnterYourName"));
                        } else if (passwordConfigurer.getValue() == null || "".equals(passwordConfigurer.getValue())) {
                            wizardController.setProblem(Resources.getString("WizardSupport.EnterYourPassword"));
                        } else if (!passwordConfigurer.getValue().equals(passwordConfigurer2.getValue())) {
                            wizardController.setProblem(Resources.getString("WizardSupport.PasswordsDontMatch"));
                        } else {
                            GameModule.getGameModule().getPrefs().getOption("RealName").setValue(stringConfigurer.getValueString());
                            GameModule.getGameModule().getPrefs().getOption("SecretName").setValue(passwordConfigurer.getValueString());
                            try {
                                GameModule.getGameModule().getPrefs().write();
                                wizardController.setProblem(null);
                            }
                            catch (IOException iOException) {
                                String string = iOException.getMessage();
                                if (string == null) {
                                    string = Resources.getString("Prefs.unable_to_save");
                                }
                                wizardController.setProblem(string);
                            }
                        }
                    }
                };
                stringConfigurer.addPropertyChangeListener(propertyChangeListener);
                passwordConfigurer.addPropertyChangeListener(propertyChangeListener);
                passwordConfigurer2.addPropertyChangeListener(propertyChangeListener);
                box.add(stringConfigurer.getControls());
                box.add(passwordConfigurer.getControls());
                box.add(passwordConfigurer2.getControls());
                JLabel jLabel = new JLabel(Resources.getString("WizardSupport.NameAndPasswordDetails"));
                jLabel.setAlignmentX(0.5f);
                box.add(jLabel);
                box.add(Box.createVerticalGlue());
                this.nameControls = box;
            }
            return this.nameControls;
        }

        public void setTutorial(Tutorial tutorial) {
            this.tutorial = tutorial;
        }
    }
}

