/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.URLUtils;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpFile
extends AbstractConfigurable {
    public static final String TITLE = "title";
    public static final String FILE = "fileName";
    public static final String TYPE = "fileType";
    private static final String IMAGE = "image";
    public static final String ARCHIVE_ENTRY = "archive";
    public static final String RESOURCE = "resource";
    public static final String LOCAL_FILE = "file";
    protected HelpWindow frame;
    protected URL contents;
    protected String title;
    protected String fileName;
    protected Action launch;
    protected String fileType = "archive";
    protected MenuItemProxy launchItem;

    public static String getConfigureTypeName() {
        return "Plain Text Help File";
    }

    public HelpFile() {
        this("help", (URL)null);
    }

    public HelpFile(String string, File file, String string2) throws MalformedURLException {
        this(string, new URL(URLUtils.toURL(file), string2));
    }

    public HelpFile(String string, File file) throws MalformedURLException {
        this(string, URLUtils.toURL(file));
    }

    public HelpFile(String string, URL uRL) {
        this.title = string;
        this.contents = uRL;
        this.setConfigureName(string);
        this.launch = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFile.this.showWindow();
            }
        };
        this.launch.putValue("Name", this.getConfigureName());
    }

    public void showWindow() {
        HelpWindow helpWindow = this.getHelpWindow();
        helpWindow.setVisible(true);
        helpWindow.toFront();
    }

    protected HelpWindow getHelpWindow() {
        if (this.frame == null) {
            this.frame = new HelpWindow(this.title, this.getContents());
        }
        return this.frame;
    }

    public URL getContents() {
        if (this.contents != null || this.fileName == null) {
            return this.contents;
        }
        if (ARCHIVE_ENTRY.equals(this.fileType)) {
            try {
                this.contents = GameModule.getGameModule().getDataArchive().getURL(this.fileName);
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, this.fileName);
            }
        } else if (RESOURCE.equals(this.fileType)) {
            this.contents = this.getClass().getResource(this.fileName);
        } else if (LOCAL_FILE.equals(this.fileType)) {
            File file = new File(this.fileName);
            if (this.fileName.startsWith("docs/")) {
                file = new File(Documentation.getDocumentationBaseDir(), this.fileName.substring("docs/".length()));
            }
            try {
                this.contents = URLUtils.toURL(file);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorDialog.bug(malformedURLException);
            }
        }
        return this.contents;
    }

    @Deprecated
    public static URL toURL(File file) throws MalformedURLException {
        return URLUtils.toURL(file);
    }

    @Override
    public HelpFile getHelpFile() {
        File file = Documentation.getDocumentationBaseDir();
        file = new File(file, "ReferenceManual");
        try {
            return new HelpFile(null, new File(file, "HelpMenu.htm"), "#HelpFile");
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
            return null;
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TITLE, FILE, IMAGE, TYPE};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (TITLE.equals(string)) {
            return this.title;
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        if (TYPE.equals(string)) {
            return this.fileType;
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (TITLE.equals(string)) {
            this.title = (String)object;
            this.setConfigureName(this.title);
            this.launch.putValue("Name", this.title);
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
                this.fileType = ARCHIVE_ENTRY;
            }
            this.fileName = (String)object;
            if ("Intro.txt".equals(string)) {
                this.fileType = RESOURCE;
            }
        } else if (TYPE.equals(string)) {
            this.fileType = (String)object;
        }
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Entry:  ", "Text File:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, File.class};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable buildable) {
        this.launchItem = new MenuItemProxy(this.launch);
        MenuManager.getInstance().addToSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(true);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        MenuManager.getInstance().removeFromSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(false);
    }

    public static HelpFile getReferenceManualPage(String string) {
        return HelpFile.getReferenceManualPage(string, null);
    }

    public static HelpFile getReferenceManualPage(String string, String string2) {
        if (string2 != null && !string2.startsWith("#")) {
            string2 = "#" + string2;
        }
        File file = Documentation.getDocumentationBaseDir();
        file = new File(file, "ReferenceManual");
        try {
            return string2 == null ? new HelpFile(null, new File(file, string)) : new HelpFile(null, new File(file, string), string2);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
            return null;
        }
    }
}

