/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.ShapeItemInstance;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeItem
extends Item {
    public static final String TYPE = "Box";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String SHAPE = "shape";
    protected static final String BEVEL = "bevel";
    protected static final String RECT = "Rectangle";
    protected static final String RRECT = "Rounded Rectangle";
    protected static final String OVAL = "Oval";
    protected int height = 30;
    protected int width = 40;
    protected int bevel = 5;
    protected String shape = "Rectangle";
    private VisibilityCondition falseCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return false;
        }
    };
    private VisibilityCondition bevelCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return ShapeItem.this.shape.equals(ShapeItem.RRECT);
        }
    };

    public ShapeItem() {
    }

    public ShapeItem(GamePieceLayout gamePieceLayout) {
        super(gamePieceLayout);
    }

    public ShapeItem(GamePieceLayout gamePieceLayout, String string) {
        this(gamePieceLayout);
        this.setConfigureName(string);
    }

    @Override
    public String[] getAttributeDescriptions() {
        String[] stringArray = new String[]{"Width:  ", "Height:  ", "Shape:  ", "Bevel:  "};
        String[] stringArray2 = super.getAttributeDescriptions();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, 2);
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        System.arraycopy(stringArray2, 2, stringArray3, stringArray.length + 2, stringArray2.length - 2);
        return stringArray3;
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Class[] classArray = new Class[]{Integer.class, Integer.class, ShapeConfig.class, Integer.class};
        Class<?>[] classArray2 = super.getAttributeTypes();
        Class[] classArray3 = new Class[classArray.length + classArray2.length];
        System.arraycopy(classArray2, 0, classArray3, 0, 2);
        System.arraycopy(classArray, 0, classArray3, 2, classArray.length);
        System.arraycopy(classArray2, 2, classArray3, classArray.length + 2, classArray2.length - 2);
        return classArray3;
    }

    @Override
    public String[] getAttributeNames() {
        String[] stringArray = new String[]{WIDTH, HEIGHT, SHAPE, BEVEL};
        String[] stringArray2 = super.getAttributeNames();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, 2);
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        System.arraycopy(stringArray2, 2, stringArray3, stringArray.length + 2, stringArray2.length - 2);
        return stringArray3;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.width = (Integer)object;
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.height = (Integer)object;
        } else if (SHAPE.equals(string)) {
            this.shape = (String)object;
        } else if (BEVEL.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.bevel = (Integer)object;
        } else {
            super.setAttribute(string, object);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (WIDTH.equals(string)) {
            return this.width + "";
        }
        if (HEIGHT.equals(string)) {
            return this.height + "";
        }
        if (SHAPE.equals(string)) {
            return this.shape;
        }
        if (BEVEL.equals(string)) {
            return this.bevel + "";
        }
        return super.getAttributeValueString(string);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if ("rotation".equals(string)) {
            return this.falseCond;
        }
        if (BEVEL.equals(string)) {
            return this.bevelCond;
        }
        return super.getAttributeVisibility(string);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(Graphics graphics, GamePieceImage gamePieceImage) {
        ItemInstance itemInstance = null;
        if (gamePieceImage != null) {
            itemInstance = gamePieceImage.getShapeInstance(this.getConfigureName());
        }
        if (itemInstance == null) {
            itemInstance = new ShapeItemInstance();
        }
        Color color = itemInstance.getFgColor().getColor();
        Color color2 = ((ShapeItemInstance)itemInstance).getBorderColor().getColor();
        Point point = this.layout.getPosition(this);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.getWidth(), this.getHeight());
        if (this.isAntialias()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (color != null) {
            graphics.setColor(color);
            if (this.shape.equals(RECT)) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else if (this.shape.equals(RRECT)) {
                graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.bevel * 2, this.bevel * 2);
            } else if (this.shape.equals(OVAL)) {
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (color2 != null) {
            graphics.setColor(color2);
            if (this.shape.equals(RECT)) {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else if (this.shape.equals(RRECT)) {
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.bevel * 2, this.bevel * 2);
            } else if (this.shape.equals(OVAL)) {
                graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getDisplayName() {
        return "Shape";
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public static Item decode(GamePieceLayout gamePieceLayout, String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        ShapeItem shapeItem = new ShapeItem(gamePieceLayout);
        decoder.nextToken();
        shapeItem.width = decoder.nextInt(30);
        shapeItem.height = decoder.nextInt(40);
        shapeItem.shape = decoder.nextToken(RECT);
        shapeItem.bevel = decoder.nextInt(5);
        return shapeItem;
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(TYPE, ';');
        sequenceEncoder.append(this.width);
        sequenceEncoder.append(this.height);
        sequenceEncoder.append(this.shape);
        sequenceEncoder.append(this.bevel);
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(sequenceEncoder.getValue(), '|');
        sequenceEncoder2.append(super.encode());
        return sequenceEncoder2.getValue();
    }

    public static class ShapeConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{ShapeItem.RECT, ShapeItem.RRECT, ShapeItem.OVAL};
        }
    }
}

