/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.gamepieceimage.TextItemInstance;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextItem
extends Item {
    public static final String TYPE = "Text";
    protected static final String FONT = "font";
    protected static final String SOURCE = "source";
    protected static final String TEXT = "text";
    protected static final String LEFT = "left";
    protected static final String CENTER = "center";
    protected static final String RIGHT = "right";
    protected static final String TOP = "top";
    protected static final String BOTTOM = "bottom";
    public static final String SRC_VARIABLE = "Specified in individual images";
    public static final String SRC_FIXED = "Fixed for this layout";
    protected static final String PIECE_NAME = "pieceName";
    protected static final String LABEL = "label";
    protected static final String DEFAULT_FORMAT = "$pieceName$";
    public static final int AL_CENTER = 0;
    public static final int AL_RIGHT = 1;
    public static final int AL_LEFT = 2;
    public static final int AL_TOP = 3;
    public static final int AL_BOTTOM = 4;
    protected String fontStyleName = "Default";
    protected String textSource = "Specified in individual images";
    protected String text = "";
    protected String changeCmd = "";
    protected KeyStroke changeKey;
    protected boolean lockable = false;
    protected String lockCmd = "";
    protected KeyStroke lockKey;
    private VisibilityCondition fixedCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return TextItem.this.textSource.equals(TextItem.SRC_FIXED);
        }
    };

    public TextItem() {
    }

    public TextItem(GamePieceLayout gamePieceLayout) {
        super(gamePieceLayout);
    }

    public TextItem(GamePieceLayout gamePieceLayout, String string) {
        this(gamePieceLayout);
        this.setConfigureName(string);
    }

    @Override
    public String[] getAttributeDescriptions() {
        String[] stringArray = new String[]{"Font style:  ", "Text is:  ", "Text:  "};
        String[] stringArray2 = super.getAttributeDescriptions();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, 2);
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        System.arraycopy(stringArray2, 2, stringArray3, stringArray.length + 2, stringArray2.length - 2);
        return stringArray3;
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Class[] classArray = new Class[]{FontStyleConfig.class, TextSource.class, String.class};
        Class<?>[] classArray2 = super.getAttributeTypes();
        Class[] classArray3 = new Class[classArray.length + classArray2.length];
        System.arraycopy(classArray2, 0, classArray3, 0, 2);
        System.arraycopy(classArray, 0, classArray3, 2, classArray.length);
        System.arraycopy(classArray2, 2, classArray3, classArray.length + 2, classArray2.length - 2);
        return classArray3;
    }

    @Override
    public String[] getAttributeNames() {
        String[] stringArray = new String[]{FONT, SOURCE, TEXT};
        String[] stringArray2 = super.getAttributeNames();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, 2);
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        System.arraycopy(stringArray2, 2, stringArray3, stringArray.length + 2, stringArray2.length - 2);
        return stringArray3;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (FONT.equals(string)) {
            this.fontStyleName = (String)object;
        } else if (SOURCE.equals(string)) {
            this.textSource = (String)object;
        } else if (TEXT.equals(string)) {
            this.text = (String)object;
        } else {
            super.setAttribute(string, object);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (FONT.equals(string)) {
            return this.fontStyleName;
        }
        if (SOURCE.equals(string)) {
            return this.textSource + "";
        }
        if (TEXT.equals(string)) {
            return this.text;
        }
        return super.getAttributeValueString(string);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (TEXT.equals(string)) {
            return this.fixedCond;
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void draw(Graphics graphics, GamePieceImage gamePieceImage) {
        TextItemInstance textItemInstance = null;
        FontStyle fontStyle = FontManager.getFontManager().getFontStyle(this.fontStyleName);
        OutlineFont outlineFont = fontStyle.getFont();
        if (gamePieceImage != null) {
            textItemInstance = gamePieceImage.getTextInstance(this.name);
        } else {
            gamePieceImage = new GamePieceImage(this.getLayout());
            textItemInstance = gamePieceImage.getTextInstance(this.name);
        }
        if (textItemInstance == null) {
            textItemInstance = new TextItemInstance();
        }
        Color color = textItemInstance.getFgColor().getColor();
        Color color2 = textItemInstance.getBgColor().getColor();
        if (color == null && color2 == null) {
            return;
        }
        boolean bl = textItemInstance.isOutline();
        Color color3 = textItemInstance.getOutlineColor().getColor();
        String string = GamePieceLayout.getCompassPoint(this.getLocation());
        int n = 0;
        switch (string.charAt(string.length() - 1)) {
            case 'W': {
                n = 2;
                break;
            }
            case 'E': {
                n = 1;
            }
        }
        int n2 = 0;
        switch (string.charAt(0)) {
            case 'N': {
                n2 = 3;
                break;
            }
            case 'S': {
                n2 = 4;
            }
        }
        Point point = this.layout.getPosition(this);
        String string2 = null;
        if (this.textSource.equals(SRC_FIXED)) {
            string2 = this.text;
        } else if (gamePieceImage != null && textItemInstance != null) {
            string2 = textItemInstance.getValue();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntialias()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        AffineTransform affineTransform = null;
        if (this.getRotation() != 0) {
            affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), this.getLayout().getVisualizerWidth() / 2, this.getLayout().getVisualizerHeight() / 2);
            graphics2D.transform(affineTransform2);
        }
        TextItem.drawLabel(graphics, string2, point.x, point.y, outlineFont, n, n2, color, color2, null, bl, color3);
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getDisplayName() {
        return "Label";
    }

    @Override
    public Dimension getSize() {
        return new Dimension(0, 0);
    }

    public static Item decode(GamePieceLayout gamePieceLayout, String string) {
        TextItem textItem = new TextItem(gamePieceLayout);
        TextItem.decode(textItem, string);
        return textItem;
    }

    public static void decode(TextItem textItem, String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        textItem.fontStyleName = decoder.nextToken("Default");
        if (textItem.fontStyleName.length() == 0) {
            textItem.fontStyleName = "Default";
        }
        textItem.textSource = decoder.nextToken(SRC_VARIABLE);
        textItem.text = decoder.nextToken("");
        textItem.changeCmd = decoder.nextToken("");
        textItem.changeKey = decoder.nextKeyStroke(null);
        textItem.lockCmd = decoder.nextToken("");
        textItem.lockKey = decoder.nextKeyStroke(null);
        textItem.lockable = decoder.nextBoolean(false);
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(TYPE, ';');
        sequenceEncoder.append(this.fontStyleName == null ? "" : this.fontStyleName);
        sequenceEncoder.append(this.textSource);
        sequenceEncoder.append(this.text);
        sequenceEncoder.append(this.changeCmd);
        sequenceEncoder.append(this.changeKey);
        sequenceEncoder.append(this.lockCmd);
        sequenceEncoder.append(this.lockKey);
        sequenceEncoder.append(this.lockable);
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(sequenceEncoder.getValue(), '|');
        sequenceEncoder2.append(super.encode());
        return sequenceEncoder2.getValue();
    }

    public boolean isOutline() {
        return FontManager.getFontManager().getFontStyle(this.fontStyleName).isOutline();
    }

    public boolean isFixed() {
        return this.textSource.equals(SRC_FIXED);
    }

    public static void drawLabel(Graphics graphics, String string, int n, int n2, Font font, int n3, int n4, Color color, Color color2, Color color3, boolean bl, Color color4) {
        graphics.setFont(font);
        int n5 = graphics.getFontMetrics().getLeading();
        int n6 = graphics.getFontMetrics().stringWidth(string) + 2 * n5;
        int n7 = graphics.getFontMetrics().getHeight();
        int n8 = n;
        int n9 = n2;
        switch (n3) {
            case 0: {
                n8 = n - n6 / 2;
                break;
            }
            case 1: {
                n8 = n - n6;
            }
        }
        switch (n4) {
            case 0: {
                n9 = n2 - n7 / 2;
                break;
            }
            case 4: {
                n9 = n2 - n7;
            }
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(n8, n9, n6, n7);
        }
        if (color3 != null) {
            graphics.setColor(color3);
            graphics.drawRect(n8, n9, n6, n7);
        }
        int n10 = n9 + graphics.getFontMetrics().getHeight() - graphics.getFontMetrics().getDescent();
        int n11 = n8 + n5;
        if (bl && color4 != null) {
            graphics.setColor(color4);
            graphics.drawString(string, n11 - 1, n10 - 1);
            graphics.drawString(string, n11 - 1, n10 + 1);
            graphics.drawString(string, n11 + 1, n10 - 1);
            graphics.drawString(string, n11 + 1, n10 + 1);
        }
        graphics.setColor(color);
        graphics.drawString(string, n11, n10);
    }

    public static class NameFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{TextItem.PIECE_NAME, TextItem.LABEL});
        }
    }

    public static class TextSource
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{TextItem.SRC_VARIABLE, TextItem.SRC_FIXED};
        }
    }

    public static class FontStyleConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new StringEnumConfigurer(string, string2, FontManager.getFontManager().getFontNames());
        }
    }
}

