/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CompoundPieceCollection;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.SumProperties;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Labeler;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.FormattedString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterDetailViewer
extends AbstractConfigurable
implements Drawable,
DragSourceMotionListener,
MouseMotionListener,
MouseListener,
KeyListener {
    public static final String LATEST_VERSION = "2";
    public static final String USE_KEYBOARD = "ShowCounterDetails";
    public static final String PREFERRED_DELAY = "PreferredDelay";
    public static final String DELAY = "delay";
    public static final String ALWAYS_SHOW_LOC = "alwaysshowloc";
    public static final String DRAW_PIECES = "showgraph";
    public static final String GRAPH_SINGLE_DEPRECATED = "showgraphsingle";
    public static final String MINIMUM_DISPLAYABLE = "minDisplayPieces";
    public static final String HOTKEY = "hotkey";
    public static final String SHOW_TEXT = "showtext";
    public static final String SHOW_TEXT_SINGLE_DEPRECATED = "showtextsingle";
    public static final String ZOOM_LEVEL = "zoomlevel";
    public static final String DRAW_PIECES_AT_ZOOM = "graphicsZoom";
    public static final String BORDER_WIDTH = "borderWidth";
    public static final String SHOW_NOSTACK = "showNoStack";
    public static final String SHOW_MOVE_SELECTED = "showMoveSelectde";
    public static final String SHOW_NON_MOVABLE = "showNonMovable";
    public static final String SHOW_DECK = "showDeck";
    public static final String UNROTATE_PIECES = "unrotatePieces";
    public static final String DISPLAY = "display";
    public static final String LAYER_LIST = "layerList";
    public static final String SUMMARY_REPORT_FORMAT = "summaryReportFormat";
    public static final String COUNTER_REPORT_FORMAT = "counterReportFormat";
    public static final String EMPTY_HEX_REPORT_FORMAT = "emptyHexReportForma";
    public static final String VERSION = "version";
    public static final String FG_COLOR = "fgColor";
    public static final String BG_COLOR = "bgColor";
    public static final String FONT_SIZE = "fontSize";
    public static final String PROPERTY_FILTER = "propertyFilter";
    public static final String TOP_LAYER = "from top-most layer only";
    public static final String ALL_LAYERS = "from all layers";
    public static final String INC_LAYERS = "from listed layers only";
    public static final String EXC_LAYERS = "from layers other than those listed";
    public static final String FILTER = "by using a property filter";
    public static final String SUM = "sum(propertyName)";
    protected KeyStroke hotkey = KeyStroke.getKeyStroke(32, 2);
    protected Map map;
    protected int delay = 700;
    protected Timer delayTimer;
    protected boolean graphicsVisible = false;
    protected boolean textVisible = false;
    protected MouseEvent currentMousePosition;
    protected int minimumDisplayablePieces = 2;
    protected boolean alwaysShowLoc = false;
    protected boolean drawPieces = true;
    protected boolean drawSingleDeprecated = false;
    protected boolean showText = false;
    protected boolean showTextSingleDeprecated = false;
    protected boolean unrotatePieces = false;
    protected boolean showDeck = false;
    protected double zoomLevel = 1.0;
    protected double graphicsZoomLevel = 1.0;
    protected int borderWidth = 0;
    protected boolean showNoStack = false;
    protected boolean showMoveSelected = false;
    protected boolean showNonMovable = false;
    protected String displayWhat = "from top-most layer only";
    protected String[] displayLayers = new String[0];
    protected FormattedString summaryReportFormat = new FormattedString("$LocationName$");
    protected FormattedString counterReportFormat = new FormattedString("");
    protected FormattedString emptyHexReportFormat = new FormattedString("$LocationName$");
    protected String version = "";
    protected Color fgColor = Color.black;
    protected Color bgColor;
    protected int fontSize = 9;
    protected PropertyExpression propertyFilter = new PropertyExpression();
    protected Rectangle bounds;
    protected boolean mouseInView = true;
    protected List<GamePiece> displayablePieces = null;
    protected JComponent view;

    public CounterDetailViewer() {
        this.delayTimer = new Timer(this.delay, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CounterDetailViewer.this.mouseInView) {
                    CounterDetailViewer.this.showDetails();
                }
            }
        });
        this.delayTimer.setRepeats(false);
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.view = this.map.getView();
        this.validator = new SingleChildInstance(this.map, this.getClass());
        this.map.addDrawComponent(this);
        String string = this.hotkey == null ? "" : "(" + HotKeyConfigurer.getString(this.hotkey) + ")";
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.general_tab"), new BooleanConfigurer(USE_KEYBOARD, Resources.getString("CounterDetailViewer.use_prompt", string), Boolean.FALSE));
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.general_tab"), new IntConfigurer(PREFERRED_DELAY, Resources.getString("CounterDetailViewer.delay_prompt"), new Integer(this.delay)));
        this.view.addMouseMotionListener(this);
        this.view.addMouseListener(this);
        this.view.addKeyListener(this);
        DragSource.getDefaultDragSource().addDragSourceMotionListener(this);
        this.setAttributeTranslatable(VERSION, false);
        this.setAttributeTranslatable(SUMMARY_REPORT_FORMAT, true);
        this.setAttributeTranslatable(COUNTER_REPORT_FORMAT, true);
    }

    @Override
    public void draw(Graphics graphics, Map map) {
        if (this.currentMousePosition != null && this.view.getVisibleRect().contains(this.currentMousePosition.getPoint())) {
            this.draw(graphics, this.currentMousePosition.getPoint(), this.view);
        }
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    public void draw(Graphics graphics, Point point, JComponent jComponent) {
        if (!this.graphicsVisible && !this.textVisible) {
            return;
        }
        this.bounds = new Rectangle(point.x, point.y, 0, 0);
        if (this.graphicsVisible) {
            this.drawGraphics(graphics, point, jComponent, this.displayablePieces);
        }
        if (this.textVisible) {
            this.drawText(graphics, point, jComponent, this.displayablePieces);
        }
    }

    @Deprecated
    protected void drawGraphics(Graphics graphics, Point point, JComponent jComponent, PieceIterator pieceIterator) {
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        while (pieceIterator.hasMoreElements()) {
            arrayList.add(pieceIterator.nextPiece());
        }
        this.drawGraphics(graphics, point, jComponent, arrayList);
    }

    protected void drawGraphics(Graphics graphics, Point point, JComponent jComponent, List<GamePiece> list) {
        this.fixBounds(list);
        if (this.bounds.width > 0) {
            Rectangle rectangle = jComponent.getVisibleRect();
            this.bounds.x = Math.min(this.bounds.x, rectangle.x + rectangle.width - this.bounds.width);
            if (this.bounds.x < rectangle.x) {
                this.bounds.x = rectangle.x;
            }
            this.bounds.y = Math.min(this.bounds.y, rectangle.y + rectangle.height - this.bounds.height) - (this.isTextUnderCounters() ? 15 : 0);
            int n = rectangle.y + (this.textVisible ? graphics.getFontMetrics().getHeight() + 6 : 0);
            if (this.bounds.y < n) {
                this.bounds.y = n;
            }
            if (this.bgColor != null) {
                graphics.setColor(this.bgColor);
                graphics.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            }
            if (this.fgColor != null) {
                graphics.setColor(this.fgColor);
                graphics.drawRect(this.bounds.x - 1, this.bounds.y - 1, this.bounds.width + 1, this.bounds.height + 1);
                graphics.drawRect(this.bounds.x - 2, this.bounds.y - 2, this.bounds.width + 3, this.bounds.height + 3);
            }
            Shape shape = graphics.getClip();
            int n2 = this.borderWidth;
            double d = this.graphicsZoomLevel;
            for (int i = 0; i < list.size(); ++i) {
                String string;
                GamePiece gamePiece = list.get(i);
                Rectangle rectangle2 = this.getBounds(gamePiece);
                if (this.unrotatePieces) {
                    gamePiece.setProperty("useUnrotatedShape", Boolean.TRUE);
                }
                graphics.setClip(this.bounds.x - 3, this.bounds.y - 3, this.bounds.width + 5, this.bounds.height + 5);
                gamePiece.draw(graphics, this.bounds.x - (int)((double)rectangle2.x * d) + n2, this.bounds.y - (int)((double)rectangle2.y * d) + this.borderWidth, jComponent, d);
                if (this.unrotatePieces) {
                    gamePiece.setProperty("useUnrotatedShape", Boolean.FALSE);
                }
                graphics.setClip(shape);
                if (this.isTextUnderCounters() && (string = this.counterReportFormat.getLocalizedText(gamePiece)).length() > 0) {
                    int n3 = this.bounds.x - (int)((double)rectangle2.x * d) + n2;
                    int n4 = this.bounds.y + this.bounds.height + 10;
                    this.drawLabel(graphics, new Point(n3, n4), string, 0, 0);
                }
                this.bounds.translate((int)((double)rectangle2.width * d), 0);
                n2 += this.borderWidth;
            }
        }
    }

    protected void fixBounds(List<GamePiece> list) {
        for (GamePiece gamePiece : list) {
            Dimension dimension = this.getBounds(gamePiece).getSize();
            this.bounds.width += (int)Math.round((double)dimension.width * this.graphicsZoomLevel) + this.borderWidth;
            this.bounds.height = Math.max(this.bounds.height, (int)Math.round((double)dimension.height * this.graphicsZoomLevel) + this.borderWidth * 2);
        }
        this.bounds.width += this.borderWidth;
        this.bounds.y -= this.bounds.height;
    }

    protected Rectangle getBounds(GamePiece gamePiece) {
        if (this.unrotatePieces) {
            gamePiece.setProperty("useUnrotatedShape", Boolean.TRUE);
        }
        Rectangle rectangle = gamePiece.getShape().getBounds();
        if (this.unrotatePieces) {
            gamePiece.setProperty("useUnrotatedShape", Boolean.FALSE);
        }
        return rectangle;
    }

    protected boolean isTextUnderCounters() {
        return this.textVisible && this.counterReportFormat.getFormat().length() > 0;
    }

    @Deprecated
    protected void drawText(Graphics graphics, Point point, JComponent jComponent, PieceIterator pieceIterator) {
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        while (pieceIterator.hasMoreElements()) {
            arrayList.add(pieceIterator.nextPiece());
        }
        this.drawText(graphics, point, jComponent, arrayList);
    }

    protected void drawText(Graphics graphics, Point point, JComponent jComponent, List<GamePiece> list) {
        String string = "";
        int n = this.bounds.x - this.bounds.width;
        int n2 = this.bounds.y - 5;
        String string2 = Resources.getString("Map.offboard");
        if (this.displayablePieces.isEmpty()) {
            Point point2 = this.map.mapCoordinates(this.currentMousePosition.getPoint());
            Point point3 = this.map.snapTo(point2);
            String string3 = this.map.localizedLocationName(point3);
            this.emptyHexReportFormat.setProperty("LocationName", string3.equals(string2) ? "" : string3);
            this.emptyHexReportFormat.setProperty("CurrentMap", this.map.getLocalizedMapName());
            Board board = this.map.findBoard(point3);
            String string4 = board == null ? "" : board.getLocalizedName();
            this.emptyHexReportFormat.setProperty("CurrentBoard", string4);
            Zone zone = this.map.findZone(point3);
            String string5 = zone == null ? "" : zone.getLocalizedName();
            this.emptyHexReportFormat.setProperty("CurrentZone", string5);
            string = this.emptyHexReportFormat.getLocalizedText();
            n -= graphics.getFontMetrics().stringWidth(string) / 2;
        } else {
            GamePiece gamePiece = this.displayablePieces.get(0);
            String string6 = (String)gamePiece.getLocalizedProperty("LocationName");
            this.emptyHexReportFormat.setProperty("LocationName", string6.equals(string2) ? "" : string6);
            string = this.summaryReportFormat.getLocalizedText(new SumProperties(this.displayablePieces));
            n += this.borderWidth * list.size() + 2;
        }
        if (string.length() > 0) {
            this.drawLabel(graphics, new Point(n, n2), string, 1, 4);
        }
    }

    @Deprecated
    protected void drawLabel(Graphics graphics, Point point, String string) {
        this.drawLabel(graphics, point, string, 1, 4);
    }

    protected void drawLabel(Graphics graphics, Point point, String string, int n, int n2) {
        if (string != null) {
            Color color = this.fgColor == null ? Color.black : this.fgColor;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            Labeler.drawLabel(graphics, string, point.x, point.y, new Font("Dialog", 0, this.fontSize), n, n2, color, this.bgColor, color);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    protected void showDetails() {
        this.displayablePieces = this.getDisplayablePieces();
        double d = this.getZoom();
        if (this.displayablePieces.size() < this.minimumDisplayablePieces) {
            if (this.displayablePieces.size() > 0) {
                this.graphicsVisible = d < this.zoomLevel;
                this.textVisible = d < this.zoomLevel && (this.summaryReportFormat.getFormat().length() > 0 || this.counterReportFormat.getFormat().length() > 0);
            } else {
                this.textVisible = this.minimumDisplayablePieces == 0 && this.emptyHexReportFormat.getFormat().length() > 0;
                this.graphicsVisible = false;
            }
        } else {
            this.graphicsVisible = this.drawPieces;
            this.textVisible = this.showText && (this.summaryReportFormat.getFormat().length() > 0 || this.counterReportFormat.getFormat().length() > 0);
        }
        this.map.repaint();
    }

    protected double getZoom() {
        return this.map.getZoom();
    }

    protected List<GamePiece> getDisplayablePieces() {
        GamePiece[] gamePieceArray = this.map.getPieces();
        Visitor visitor = new Visitor(new Filter(), this.map, this.map.mapCoordinates(this.currentMousePosition.getPoint()));
        DeckVisitorDispatcher deckVisitorDispatcher = new DeckVisitorDispatcher(visitor);
        for (int i = gamePieceArray.length - 1; i >= 0; --i) {
            deckVisitorDispatcher.accept(gamePieceArray[i]);
        }
        return visitor.getPieces();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.graphicsVisible || this.textVisible) {
            this.hideDetails();
        } else {
            this.currentMousePosition = mouseEvent;
            if (Boolean.FALSE.equals(GameModule.getGameModule().getPrefs().getValue(USE_KEYBOARD))) {
                if (this.delayTimer.isRunning()) {
                    this.delayTimer.stop();
                }
                this.delayTimer.setInitialDelay(this.getPreferredDelay());
                this.delayTimer.start();
            }
        }
    }

    protected int getPreferredDelay() {
        return (Integer)GameModule.getGameModule().getPrefs().getValue(PREFERRED_DELAY);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseInView = true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseInView = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.delayTimer.isRunning()) {
            this.delayTimer.stop();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseInView = true;
        if (this.delayTimer.isRunning()) {
            this.delayTimer.stop();
        }
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
        if (this.delayTimer.isRunning()) {
            this.delayTimer.stop();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.hotkey != null && Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(USE_KEYBOARD))) {
            if (this.hotkey.equals(KeyStroke.getKeyStrokeForEvent(keyEvent))) {
                this.showDetails();
            } else {
                this.hideDetails();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    protected void hideDetails() {
        this.graphicsVisible = false;
        this.textVisible = false;
        this.map.repaint();
    }

    @Override
    public Configurer getConfigurer() {
        if (this.map == null) {
            this.version = LATEST_VERSION;
        } else if (!this.version.equals(LATEST_VERSION)) {
            this.upgrade();
        }
        return super.getConfigurer();
    }

    protected void upgrade() {
        this.minimumDisplayablePieces = !this.drawPieces && !this.showText ? Integer.MAX_VALUE : (this.drawSingleDeprecated ? 1 : 2);
        this.fgColor = this.map.getHighlighter() instanceof ColoredBorder ? ((ColoredBorder)this.map.getHighlighter()).getColor() : Color.black;
        this.bgColor = new Color(255 - this.fgColor.getRed(), 255 - this.fgColor.getGreen(), 255 - this.fgColor.getBlue());
        this.version = LATEST_VERSION;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{VERSION, DELAY, HOTKEY, BG_COLOR, FG_COLOR, MINIMUM_DISPLAYABLE, ZOOM_LEVEL, DRAW_PIECES, DRAW_PIECES_AT_ZOOM, GRAPH_SINGLE_DEPRECATED, BORDER_WIDTH, SHOW_TEXT, SHOW_TEXT_SINGLE_DEPRECATED, FONT_SIZE, SUMMARY_REPORT_FORMAT, COUNTER_REPORT_FORMAT, EMPTY_HEX_REPORT_FORMAT, DISPLAY, LAYER_LIST, PROPERTY_FILTER, SHOW_NOSTACK, SHOW_MOVE_SELECTED, SHOW_NON_MOVABLE, UNROTATE_PIECES, SHOW_DECK};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Version", "Recommended Delay before display (ms):  ", "Keyboard shortcut to display:  ", "Background color:  ", "Border/text color:  ", "Display when at least this many pieces will be included:  ", "Always display when zoom level less than:  ", "Draw pieces?", "Draw pieces using zoom factor:  ", "Display unit graphics for single counter?", "Width of gap between pieces:  ", "Display text?", "Display text report for single counter?", "Font size:  ", "Summary text above pieces:  ", "Text below each piece:  ", "Text for empty location:  ", "Include individual pieces:  ", "Listed layers", "Piece selection property filter:  ", "Include non-stacking pieces?", "Include move-when-selected pieces?", "Include non-movable pieces?", "Show pieces in un-rotated state?", "Include top piece in Deck?"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, KeyStroke.class, Color.class, Color.class, MinConfig.class, Double.class, Boolean.class, Double.class, Boolean.class, Integer.class, Boolean.class, Boolean.class, Integer.class, ReportFormatConfig.class, CounterFormatConfig.class, EmptyFormatConfig.class, DisplayConfig.class, String[].class, PropertyExpression.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class};
    }

    @Override
    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "StackViewer");
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map.removeDrawComponent(this);
        this.view.removeMouseMotionListener(this);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (DELAY.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.delay = (Integer)object;
            }
        } else if (HOTKEY.equals(string)) {
            this.hotkey = object instanceof String ? HotKeyConfigurer.decode((String)object) : (KeyStroke)object;
        } else if (DRAW_PIECES.equals(string)) {
            if (object instanceof Boolean) {
                this.drawPieces = (Boolean)object;
            } else if (object instanceof String) {
                this.drawPieces = "true".equals(object);
            }
        } else if (GRAPH_SINGLE_DEPRECATED.equals(string)) {
            if (object instanceof Boolean) {
                this.drawSingleDeprecated = (Boolean)object;
            } else if (object instanceof String) {
                this.drawSingleDeprecated = "true".equals(object);
            }
        } else if (SHOW_TEXT.equals(string)) {
            if (object instanceof Boolean) {
                this.showText = (Boolean)object;
            } else if (object instanceof String) {
                this.showText = "true".equals(object);
            }
        } else if (SHOW_TEXT_SINGLE_DEPRECATED.equals(string)) {
            if (object instanceof Boolean) {
                this.showTextSingleDeprecated = (Boolean)object;
            } else if (object instanceof String) {
                this.showTextSingleDeprecated = "true".equals(object);
            }
        } else if (ZOOM_LEVEL.equals(string)) {
            if (object instanceof String) {
                object = new Double((String)object);
            }
            this.zoomLevel = (Double)object;
        } else if (DRAW_PIECES_AT_ZOOM.equals(string)) {
            if (object instanceof String) {
                object = new Double((String)object);
            }
            this.graphicsZoomLevel = (Double)object;
        } else if (BORDER_WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.borderWidth = (Integer)object;
        } else if (SHOW_NOSTACK.equals(string)) {
            if (object instanceof Boolean) {
                this.showNoStack = (Boolean)object;
            } else if (object instanceof String) {
                this.showNoStack = "true".equals(object);
            }
        } else if (SHOW_MOVE_SELECTED.equals(string)) {
            if (object instanceof Boolean) {
                this.showMoveSelected = (Boolean)object;
            } else if (object instanceof String) {
                this.showMoveSelected = "true".equals(object);
            }
        } else if (SHOW_NON_MOVABLE.equals(string)) {
            if (object instanceof Boolean) {
                this.showNonMovable = (Boolean)object;
            } else if (object instanceof String) {
                this.showNonMovable = "true".equals(object);
            }
        } else if (SHOW_DECK.equals(string)) {
            if (object instanceof Boolean) {
                this.showDeck = (Boolean)object;
            } else if (object instanceof String) {
                this.showDeck = "true".equals(object);
            }
        } else if (UNROTATE_PIECES.equals(string)) {
            if (object instanceof Boolean) {
                this.unrotatePieces = (Boolean)object;
            } else if (object instanceof String) {
                this.unrotatePieces = "true".equals(object);
            }
        } else if (DISPLAY.equals(string)) {
            this.displayWhat = (String)object;
        } else if (LAYER_LIST.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.displayLayers = object;
        } else if (EMPTY_HEX_REPORT_FORMAT.equals(string)) {
            this.emptyHexReportFormat.setFormat((String)object);
        } else if (SUMMARY_REPORT_FORMAT.equals(string)) {
            this.summaryReportFormat.setFormat((String)object);
        } else if (COUNTER_REPORT_FORMAT.equals(string)) {
            this.counterReportFormat.setFormat((String)object);
        } else if (MINIMUM_DISPLAYABLE.equals(string)) {
            try {
                this.minimumDisplayablePieces = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalBuildException(numberFormatException);
            }
        } else if (VERSION.equals(string)) {
            this.version = (String)object;
        } else if (FG_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.fgColor = object == null ? Color.black : (Color)object;
        } else if (BG_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.bgColor = (Color)object;
        } else if (FONT_SIZE.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.fontSize = (Integer)object;
            }
        } else if (PROPERTY_FILTER.equals(string)) {
            this.propertyFilter.setExpression((String)object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (DELAY.equals(string)) {
            return String.valueOf(this.delay);
        }
        if (HOTKEY.equals(string)) {
            return HotKeyConfigurer.encode(this.hotkey);
        }
        if (DRAW_PIECES.equals(string)) {
            return String.valueOf(this.drawPieces);
        }
        if (GRAPH_SINGLE_DEPRECATED.equals(string)) {
            return String.valueOf(this.drawSingleDeprecated);
        }
        if (SHOW_TEXT.equals(string)) {
            return String.valueOf(this.showText);
        }
        if (SHOW_TEXT_SINGLE_DEPRECATED.equals(string)) {
            return String.valueOf(this.showTextSingleDeprecated);
        }
        if (ZOOM_LEVEL.equals(string)) {
            return String.valueOf(this.zoomLevel);
        }
        if (DRAW_PIECES_AT_ZOOM.equals(string)) {
            return String.valueOf(this.graphicsZoomLevel);
        }
        if (BORDER_WIDTH.equals(string)) {
            return String.valueOf(this.borderWidth);
        }
        if (SHOW_NOSTACK.equals(string)) {
            return String.valueOf(this.showNoStack);
        }
        if (SHOW_MOVE_SELECTED.equals(string)) {
            return String.valueOf(this.showMoveSelected);
        }
        if (SHOW_NON_MOVABLE.equals(string)) {
            return String.valueOf(this.showNonMovable);
        }
        if (SHOW_DECK.equals(string)) {
            return String.valueOf(this.showDeck);
        }
        if (UNROTATE_PIECES.equals(string)) {
            return String.valueOf(this.unrotatePieces);
        }
        if (DISPLAY.equals(string)) {
            return this.displayWhat;
        }
        if (LAYER_LIST.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.displayLayers);
        }
        if (EMPTY_HEX_REPORT_FORMAT.equals(string)) {
            return this.emptyHexReportFormat.getFormat();
        }
        if (SUMMARY_REPORT_FORMAT.equals(string)) {
            return this.summaryReportFormat.getFormat();
        }
        if (COUNTER_REPORT_FORMAT.equals(string)) {
            return this.counterReportFormat.getFormat();
        }
        if (MINIMUM_DISPLAYABLE.equals(string)) {
            return String.valueOf(this.minimumDisplayablePieces);
        }
        if (VERSION.equals(string)) {
            return this.version;
        }
        if (FG_COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.fgColor);
        }
        if (BG_COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.bgColor);
        }
        if (FONT_SIZE.equals(string)) {
            return String.valueOf(this.fontSize);
        }
        if (PROPERTY_FILTER.equals(string)) {
            return this.propertyFilter.getExpression();
        }
        return null;
    }

    public static String getConfigureTypeName() {
        return "Mouse-over Stack Viewer";
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (BORDER_WIDTH.equals(string) || DRAW_PIECES_AT_ZOOM.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return CounterDetailViewer.this.drawPieces;
                }
            };
        }
        if (FONT_SIZE.equals(string) || SUMMARY_REPORT_FORMAT.equals(string) || COUNTER_REPORT_FORMAT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return CounterDetailViewer.this.showText;
                }
            };
        }
        if (DRAW_PIECES.equals(string) || SHOW_TEXT.equals(string) || SHOW_NOSTACK.equals(string) || SHOW_DECK.equals(string) || DISPLAY.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return true;
                }
            };
        }
        if (LAYER_LIST.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.INC_LAYERS) || CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.EXC_LAYERS);
                }
            };
        }
        if (PROPERTY_FILTER.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.FILTER);
                }
            };
        }
        if (EMPTY_HEX_REPORT_FORMAT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return CounterDetailViewer.this.showText && CounterDetailViewer.this.minimumDisplayablePieces == 0;
                }
            };
        }
        if (SHOW_MOVE_SELECTED.equals(string) || SHOW_NON_MOVABLE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return CounterDetailViewer.this.showNoStack;
                }
            };
        }
        if (VERSION.equals(string) || SHOW_TEXT_SINGLE_DEPRECATED.equals(string) || GRAPH_SINGLE_DEPRECATED.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return false;
                }
            };
        }
        return null;
    }

    public static class CounterFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{"PieceName"});
        }
    }

    public static class ReportFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{"LocationName", "CurrentMap", "CurrentBoard", "CurrentZone", CounterDetailViewer.SUM});
        }
    }

    public static class EmptyFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{"LocationName", "CurrentMap", "CurrentBoard", "CurrentZone"});
        }
    }

    public static class MinConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{"0", "1", CounterDetailViewer.LATEST_VERSION};
        }
    }

    public static class DisplayConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{CounterDetailViewer.TOP_LAYER, CounterDetailViewer.ALL_LAYERS, CounterDetailViewer.INC_LAYERS, CounterDetailViewer.EXC_LAYERS, CounterDetailViewer.FILTER};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Visitor
    extends PieceFinder.Movable {
        protected List<GamePiece> pieces;
        protected Filter filter = null;
        protected CompoundPieceCollection collection;
        protected int lastLayer = -1;
        protected int insertPos = 0;
        protected Point foundPieceAt;

        public Visitor(Filter filter, Map map, Point point) {
            super(map, point);
            if (map.getPieceCollection() instanceof CompoundPieceCollection) {
                this.collection = (CompoundPieceCollection)map.getPieceCollection();
            }
            this.pieces = new ArrayList<GamePiece>();
            this.filter = filter;
        }

        @Override
        public Object visitDeck(Deck deck) {
            GamePiece gamePiece;
            if (this.foundPieceAt == null && (gamePiece = deck.topPiece()) != null && !Boolean.TRUE.equals(gamePiece.getProperty("Obscured"))) {
                Rectangle rectangle = (Rectangle)deck.getShape();
                rectangle.x += deck.getPosition().x;
                rectangle.y += deck.getPosition().y;
                if (rectangle.contains(this.pt)) {
                    this.apply(gamePiece);
                }
            }
            return null;
        }

        @Override
        public Object visitStack(Stack stack) {
            boolean bl;
            boolean bl2 = this.foundPieceAt == null ? super.visitStack(stack) != null : (bl = this.foundPieceAt.equals(stack.getPosition()));
            if (bl) {
                Iterator<GamePiece> iterator = stack.getPiecesIterator();
                while (iterator.hasNext()) {
                    this.apply(iterator.next());
                }
            }
            return null;
        }

        @Override
        public Object visitDefault(GamePiece gamePiece) {
            if (this.foundPieceAt == null ? super.visitDefault(gamePiece) != null : this.foundPieceAt.equals(gamePiece.getPosition())) {
                this.apply(gamePiece);
            }
            return null;
        }

        protected void apply(GamePiece gamePiece) {
            int n = 0;
            String string = "";
            n = this.collection.getLayerForPiece(gamePiece);
            string = this.collection.getLayerNameForPiece(gamePiece);
            if (this.filter == null || this.filter.accept(gamePiece, n, string)) {
                if (n != this.lastLayer) {
                    this.insertPos = 0;
                    this.lastLayer = n;
                }
                if (this.foundPieceAt == null) {
                    this.foundPieceAt = gamePiece.getPosition();
                }
                this.pieces.add(this.insertPos++, gamePiece);
            }
        }

        public List<GamePiece> getPieces() {
            return this.pieces;
        }
    }

    protected class Filter
    implements PieceFilter {
        protected int topLayer = -1;

        public boolean accept(GamePiece gamePiece) {
            return this.accept(gamePiece, 0, "");
        }

        public boolean accept(GamePiece gamePiece, int n, String string) {
            if (Boolean.TRUE.equals(gamePiece.getProperty("Invisible"))) {
                return false;
            }
            if (Boolean.TRUE.equals(gamePiece.getProperty("NoStack")) && !CounterDetailViewer.this.showNoStack) {
                return false;
            }
            if (Boolean.TRUE.equals(gamePiece.getProperty("cannotMove")) && !CounterDetailViewer.this.showNonMovable) {
                return false;
            }
            if (Boolean.TRUE.equals(gamePiece.getProperty("Immobile")) && !CounterDetailViewer.this.showMoveSelected) {
                return false;
            }
            if (gamePiece.getParent() instanceof Deck && !CounterDetailViewer.this.showDeck) {
                return false;
            }
            if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.FILTER)) {
                return CounterDetailViewer.this.propertyFilter.accept(gamePiece);
            }
            if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.ALL_LAYERS)) {
                return true;
            }
            if (this.topLayer < 0) {
                this.topLayer = n;
            }
            if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.TOP_LAYER)) {
                return n == this.topLayer;
            }
            if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.INC_LAYERS)) {
                for (int i = 0; i < CounterDetailViewer.this.displayLayers.length; ++i) {
                    if (!string.equals(CounterDetailViewer.this.displayLayers[i])) continue;
                    return true;
                }
            } else if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.EXC_LAYERS)) {
                for (int i = 0; i < CounterDetailViewer.this.displayLayers.length; ++i) {
                    if (!string.equals(CounterDetailViewer.this.displayLayers[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

