/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeckGlobalKeyCommand
extends MassKeyCommand {
    public DeckGlobalKeyCommand() {
        this.globalCommand = new DeckGlobalCommand(this);
        this.setConfigureName("");
    }

    public DeckGlobalKeyCommand(String string) {
        this();
        this.decode(string);
    }

    public static String getConfigureTypeName() {
        return "Deck Global Key Command";
    }

    @Override
    public void addTo(Buildable buildable) {
        if (buildable instanceof Map) {
            this.map = (Map)buildable;
        }
        if (buildable instanceof PropertySource) {
            this.propertySource = (PropertySource)((Object)buildable);
        }
        ((DrawPile)buildable).addGlobalKeyCommand(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((DrawPile)buildable).removeGlobalKeyCommand(this);
    }

    public KeyCommand getKeyCommand(Deck deck) {
        return new DeckKeyCommand(this.getLocalizedConfigureName(), null, deck);
    }

    @Override
    public PieceFilter getFilter() {
        if (this.propertiesFilter == null || this.propertiesFilter.getExpression() == null || this.propertiesFilter.getExpression().length() == 0) {
            return null;
        }
        return super.getFilter();
    }

    public void apply(Deck deck) {
        GameModule.getGameModule().sendAndLog(((DeckGlobalCommand)this.globalCommand).apply(deck, this.getFilter()));
    }

    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        sequenceEncoder.append(this.getConfigureName()).append(this.getAttributeValueString("hotkey")).append(this.getAttributeValueString("filter")).append(this.getAttributeValueString("deckCount")).append(this.getAttributeValueString("reportFormat")).append(this.getLocalizedConfigureName());
        return sequenceEncoder.getValue();
    }

    public void decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        this.setConfigureName(decoder.nextToken(""));
        this.setAttribute("hotkey", decoder.nextKeyStroke('A'));
        this.setAttribute("filter", decoder.nextToken(null));
        this.setAttribute("deckCount", decoder.nextInt(0));
        this.setAttribute("reportFormat", decoder.nextToken(""));
        this.localizedName = decoder.nextToken(this.getConfigureName());
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Command:  ", "Global Command:  ", "Matching properties:  ", "Affects:  ", "Report Format:  "};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", "hotkey", "filter", "deckCount", "reportFormat"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, KeyStroke.class, PropertyExpression.class, DeckPolicyConfig2.class, MassKeyCommand.ReportFormatConfig.class};
    }

    public static class DeckGlobalCommand
    extends GlobalCommand {
        public DeckGlobalCommand(RecursionLimiter.Loopable loopable) {
            super(loopable);
        }

        public Command apply(Deck deck, PieceFilter pieceFilter) {
            Command command;
            String string = this.reportFormat.getText();
            if (string.length() > 0) {
                command = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "*" + string);
                command.execute();
            } else {
                command = new NullCommand();
            }
            GlobalCommand.Visitor visitor = new GlobalCommand.Visitor(this, command, pieceFilter, this.keyStroke);
            DeckVisitorDispatcher deckVisitorDispatcher = new DeckVisitorDispatcher(visitor);
            deckVisitorDispatcher.accept(deck);
            visitor.getTracker().repaint();
            command = visitor.getCommand();
            return command;
        }
    }

    public static class DeckPolicyConfig2
    extends MassKeyCommand.DeckPolicyConfig {
        public DeckPolicyConfig2() {
            this.typeConfig.setValidValues(new String[]{"All pieces", "Fixed number of pieces"});
            this.prompt.setText("Affects:  ");
        }
    }

    class DeckKeyCommand
    extends KeyCommand {
        private static final long serialVersionUID = 1L;
        protected Deck deck;

        public DeckKeyCommand(String string, KeyStroke keyStroke, Deck deck) {
            super(string, keyStroke, deck);
            this.deck = deck;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DeckGlobalKeyCommand.this.apply(this.deck);
        }
    }
}

