/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ProgressDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.logging.Logger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageSaver
extends AbstractConfigurable {
    protected LaunchButton launch;
    protected Map map;
    protected boolean promptToSplit = false;
    protected static final String DEFAULT_ICON = "/images/camera.gif";
    protected static ProgressDialog dialog;
    protected static final String HOTKEY = "hotkey";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String TOOLTIP = "tooltip";
    protected static final String ICON_NAME = "icon";

    public ImageSaver() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageSaver.this.writeMapAsImage();
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON_NAME, actionListener);
        this.launch.setAttribute(TOOLTIP, "Save Map as PNG image");
        this.launch.setAttribute(BUTTON_TEXT, "");
        this.launch.setAttribute(ICON_NAME, DEFAULT_ICON);
    }

    public ImageSaver(Map map) {
        this.map = map;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().add(this.launch);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().remove(this.launch);
        this.map.getToolBar().revalidate();
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, ICON_NAME, HOTKEY};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Button Text:  ", "Tooltip Text:  ", "Button icon:  ", "Hotkey:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, KeyStroke.class};
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.launch.setAttribute(string, object);
    }

    @Override
    public String getAttributeValueString(String string) {
        return this.launch.getAttributeValueString(string);
    }

    public void writeMapAsImage() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.setSelectedFile(new File(fileChooser.getCurrentDirectory(), GameModule.getGameModule().getLocalizedGameName() + "Map.png"));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.map.getView());
        if (fileChooser.showSaveDialog(frame) != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        dialog = new ProgressDialog(frame, "Saving Map Image", "Saving map image...");
        int n = "Saving map image as ".length() + file.getName().length() + 6;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("N");
        }
        dialog.setLabel(stringBuilder.toString());
        dialog.pack();
        dialog.setLabel("Saving map image as ");
        dialog.setIndeterminate(true);
        dialog.setLocationRelativeTo(frame);
        Dimension dimension = this.map.mapSize();
        if (dimension.width == 0) {
            dimension.width = 1;
        }
        if (dimension.height == 0) {
            dimension.height = 1;
        }
        int n2 = (int)Math.round((double)dimension.width * this.map.getZoom());
        int n3 = (int)Math.round((double)dimension.height * this.map.getZoom());
        if (n2 < 1 || n3 < 1) {
            if (dimension.width < dimension.height) {
                n2 = 1;
                n3 = dimension.height / dimension.width;
            } else {
                n3 = 1;
                n2 = dimension.width / dimension.height;
            }
        }
        this.writeMapRectAsImage(file, 0, 0, n2, n3);
        dialog.setVisible(true);
    }

    protected void writeMapRectAsImage(File file, int n, int n2, int n3, int n4) {
        final SnapshotTask snapshotTask = new SnapshotTask(file, n, n2, n3, n4);
        snapshotTask.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                    dialog.setProgress((Integer)propertyChangeEvent.getNewValue());
                } else if ("state".equals(propertyChangeEvent.getPropertyName()) && (SwingWorker.StateValue)propertyChangeEvent.getNewValue() == SwingWorker.StateValue.DONE) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        });
        dialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                snapshotTask.cancel(true);
            }
        });
        snapshotTask.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void writeImage(OutputStream[] outputStreamArray) throws IOException {
        Dimension dimension = this.map.getEdgeBuffer();
        int n = (int)((double)(this.map.mapSize().width - 2 * dimension.width) * this.map.getZoom());
        int n2 = (int)((double)(this.map.mapSize().height - 2 * dimension.height) * this.map.getZoom());
        for (int i = 0; i < outputStreamArray.length; ++i) {
            int n3 = n2 / outputStreamArray.length;
            if (i == outputStreamArray.length - 1) {
                n3 = n2 - n3 * (outputStreamArray.length - 1);
            }
            Image image = this.map.getView().createImage(n, n3);
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            this.map.paintRegion(graphics2D, new Rectangle(-((int)(this.map.getZoom() * (double)dimension.width)), -((int)(this.map.getZoom() * (double)dimension.height)) + n3 * i, n, n2), null);
            graphics2D.dispose();
            try {
                MediaTracker mediaTracker = new MediaTracker(this.map.getView());
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
            }
            catch (Exception exception) {
                Logger.log(exception);
            }
            try {
                if (image instanceof RenderedImage) {
                    ImageIO.write((RenderedImage)((Object)image), "png", outputStreamArray[i]);
                    continue;
                }
                throw new IOException("Bad image type");
            }
            finally {
                try {
                    outputStreamArray[i].close();
                }
                catch (IOException iOException) {
                    Logger.log(iOException);
                }
            }
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "ImageCapture");
    }

    public static String getConfigureTypeName() {
        return "Image Capture Tool";
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SnapshotTask
    extends SwingWorker<Void, Void> {
        private int tiles;
        private int tilesDone = 0;
        private final File file;
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final Color bg;
        private final List<File> files;

        public SnapshotTask(File file, int n, int n2, int n3, int n4) {
            this.bg = ColorConfigurer.stringToColor(ImageSaver.this.map.getAttributeValueString("backgroundcolor"));
            this.files = new ArrayList<File>();
            this.file = file;
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeImage(final File file, BufferedImage bufferedImage, Rectangle rectangle) throws IOException {
            Object object;
            this.files.add(file);
            if (file.exists()) {
                if (!file.canWrite()) {
                    throw new IOException("Cannot write to the file \"" + file.getAbsolutePath() + "\"");
                }
            } else {
                object = file.getParentFile();
                if (((File)object).isDirectory() && !((File)object).canWrite()) {
                    throw new IOException("Cannot write to the directory \"" + ((File)object).getAbsolutePath() + "\"");
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    dialog.setLabel("Saving map image as " + file.getName() + ":");
                    dialog.setIndeterminate(true);
                }
            });
            object = bufferedImage.createGraphics();
            Color color = ((Graphics)object).getColor();
            ((Graphics)object).setColor(this.bg);
            ((Graphics)object).fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            ((Graphics)object).setColor(color);
            ((Graphics2D)object).translate(-rectangle.x, -rectangle.y);
            ImageSaver.this.map.paintRegion((Graphics)object, rectangle, null);
            ((Graphics)object).dispose();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    dialog.setIndeterminate(false);
                }
            });
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
            imageWriter.addIIOWriteProgressListener(new IIOWriteProgressListener(){

                public void imageComplete(ImageWriter imageWriter) {
                }

                public void imageProgress(ImageWriter imageWriter, float f) {
                    SnapshotTask.this.setProgress(Math.round(((float)(100 * SnapshotTask.this.tilesDone) + f) / (float)SnapshotTask.this.tiles));
                }

                public void imageStarted(ImageWriter imageWriter, int n) {
                }

                public void thumbnailComplete(ImageWriter imageWriter) {
                }

                public void thumbnailProgress(ImageWriter imageWriter, float f) {
                }

                public void thumbnailStarted(ImageWriter imageWriter, int n, int n2) {
                }

                public void writeAborted(ImageWriter imageWriter) {
                }
            });
            ImageOutputStream imageOutputStream = null;
            try {
                imageOutputStream = ImageIO.createImageOutputStream(file);
                if (imageOutputStream == null) {
                    throw new IOException("Failed to write file " + file.getAbsolutePath());
                }
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(bufferedImage);
                imageOutputStream.close();
            }
            finally {
                imageWriter.dispose();
                IOUtils.closeQuietly(imageOutputStream);
            }
        }

        public Void doInBackground() throws IOException {
            this.setProgress(0);
            int n = this.w;
            int n2 = this.h;
            BufferedImage bufferedImage = null;
            while ((long)n * (long)n2 > 0x1FFFFFFFL) {
                if (n > n2) {
                    n = (int)Math.ceil((double)n / 2.0);
                    continue;
                }
                n2 = (int)Math.ceil((double)n2 / 2.0);
            }
            while (bufferedImage == null) {
                try {
                    bufferedImage = new BufferedImage(n, n2, 2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (n > n2) {
                        n = (int)Math.ceil((double)n / 2.0);
                        continue;
                    }
                    n2 = (int)Math.ceil((double)n2 / 2.0);
                }
            }
            if (n == this.w && n2 == this.h) {
                this.tiles = 1;
                this.writeImage(this.file, bufferedImage, new Rectangle(0, 0, this.w, this.h));
            } else {
                String string;
                String string2;
                String string3 = this.file.getName();
                if (string3.endsWith(".png")) {
                    string2 = string3.substring(0, string3.lastIndexOf("."));
                    string = ".png";
                } else {
                    string2 = string3;
                    string = "";
                }
                int n3 = (int)Math.ceil((double)this.w / (double)n);
                int n4 = (int)Math.ceil((double)this.h / (double)n2);
                this.tiles = n3 * n4;
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        File file = new File(this.file.getParent(), string2 + "." + i + "." + j + string);
                        Rectangle rectangle = new Rectangle(n * i, n2 * j, Math.min(n, this.w - n * i), Math.min(n2, this.h - n2 * j));
                        this.writeImage(file, bufferedImage, rectangle);
                        ++this.tilesDone;
                    }
                }
            }
            return null;
        }

        protected void done() {
            try {
                this.get();
            }
            catch (CancellationException cancellationException) {
                for (File file : this.files) {
                    file.delete();
                }
            }
            catch (InterruptedException interruptedException) {
                ErrorDialog.bug(interruptedException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof IOException) {
                    WriteErrorDialog.error((Throwable)executionException, (IOException)throwable, this.files.get(this.files.size() - 1));
                }
                ErrorDialog.bug(executionException);
            }
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ImageSaver.DEFAULT_ICON);
        }
    }
}

