/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOS_Thread
extends AbstractConfigurable
implements MouseListener,
MouseMotionListener,
Drawable,
Configurable,
UniqueIdManager.Identifyable,
CommandEncoder {
    public static final String LOS_THREAD_COMMAND = "LOS\t";
    public static final String NAME = "threadName";
    public static final String SNAP_LOS = "snapLOS";
    public static final String SNAP_START = "snapStart";
    public static final String SNAP_END = "snapEnd";
    public static final String REPORT = "report";
    public static final String PERSISTENCE = "persistence";
    public static final String PERSISTENT_ICON_NAME = "persistentIconName";
    public static final String GLOBAL = "global";
    public static final String LOS_COLOR = "threadColor";
    public static final String HOTKEY = "hotkey";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON_NAME = "iconName";
    public static final String LABEL = "label";
    public static final String DRAW_RANGE = "drawRange";
    public static final String HIDE_COUNTERS = "hideCounters";
    public static final String HIDE_OPACITY = "hideOpacity";
    public static final String RANGE_BACKGROUND = "rangeBg";
    public static final String RANGE_FOREGROUND = "rangeFg";
    public static final String RANGE_SCALE = "scale";
    public static final String RANGE_ROUNDING = "round";
    public static final String ROUND_UP = "Up";
    public static final String ROUND_DOWN = "Down";
    public static final String ROUND_OFF = "Nearest whole number";
    public static Font RANGE_FONT = new Font("Dialog", 0, 11);
    public static final String DEFAULT_ICON = "/images/thread.gif";
    public static final String FROM_LOCATION = "FromLocation";
    public static final String TO_LOCATION = "ToLocation";
    public static final String CHECK_COUNT = "NumberOfLocationsChecked";
    public static final String CHECK_LIST = "AllLocationsChecked";
    public static final String RANGE = "Range";
    public static final String NEVER = "Never";
    public static final String ALWAYS = "Always";
    public static final String CTRL_CLICK = "Ctrl-Click & Drag";
    public static final String WHEN_PERSISTENT = "When Persisting";
    protected static UniqueIdManager idMgr = new UniqueIdManager("LOS_Thread");
    protected boolean retainAfterRelease = false;
    protected long lastRelease = 0L;
    protected Map map;
    protected LaunchButton launch;
    protected KeyStroke hotkey;
    protected Point anchor;
    protected Point arrow;
    protected boolean visible = false;
    protected boolean drawRange;
    protected int rangeScale;
    protected double rangeRounding = 0.5;
    protected boolean hideCounters;
    protected int hideOpacity = 0;
    protected String fixedColor;
    protected Color threadColor = Color.black;
    protected Color rangeFg = Color.white;
    protected Color rangeBg = Color.black;
    protected boolean snapStart;
    protected boolean snapEnd;
    protected Point lastAnchor = new Point();
    protected Point lastArrow = new Point();
    protected Rectangle lastRangeRect = new Rectangle();
    protected String anchorLocation = "";
    protected String lastLocation = "";
    protected String lastRange = "";
    protected FormattedString reportFormat = new FormattedString("$playerId$ Checked LOS from $FromLocation$ to $AllLocationsChecked$");
    protected List<String> checkList = new ArrayList<String>();
    protected String persistence = "Ctrl-Click & Drag";
    protected String persistentIconName;
    protected String global = "Always";
    protected String threadId = "";
    protected boolean persisting = false;
    protected boolean mirroring = false;
    protected String iconName;
    protected boolean ctrlWhenClick = false;
    protected boolean initializing;

    public LOS_Thread() {
        this.anchor = new Point(0, 0);
        this.arrow = new Point(0, 0);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LOS_Thread.this.launch();
            }
        };
        this.launch = new LaunchButton("Thread", TOOLTIP, LABEL, HOTKEY, ICON_NAME, actionListener);
        this.launch.setAttribute(ICON_NAME, DEFAULT_ICON);
        this.launch.setAttribute(TOOLTIP, "Show LOS Thread");
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public void addTo(Buildable buildable) {
        idMgr.add(this);
        this.map = (Map)buildable;
        this.map.getView().addMouseMotionListener(this);
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.launch);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getPrefs().addOption(this.getConfigureName(), new BooleanConfigurer(SNAP_LOS, Resources.getString("LOS_Thread.snap_thread_preference")));
        if (this.fixedColor == null) {
            ColorConfigurer colorConfigurer = new ColorConfigurer(LOS_COLOR, Resources.getString("LOS_Thread.thread_color_preference"));
            GameModule.getGameModule().getPrefs().addOption(this.getConfigureName(), colorConfigurer);
            this.threadColor = (Color)GameModule.getGameModule().getPrefs().getValue(LOS_COLOR);
            colorConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LOS_Thread.this.threadColor = (Color)propertyChangeEvent.getNewValue();
                }
            });
            colorConfigurer.fireUpdate();
        }
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.launch);
        GameModule.getGameModule().removeCommandEncoder(this);
        idMgr.remove(this);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, LABEL, TOOLTIP, ICON_NAME, HOTKEY, REPORT, PERSISTENCE, PERSISTENT_ICON_NAME, GLOBAL, SNAP_START, SNAP_END, DRAW_RANGE, RANGE_SCALE, RANGE_ROUNDING, HIDE_COUNTERS, HIDE_OPACITY, LOS_COLOR, RANGE_FOREGROUND, RANGE_BACKGROUND};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (DRAW_RANGE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.drawRange = (Boolean)object;
        } else if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (RANGE_SCALE.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.rangeScale = (Integer)object;
        } else if (RANGE_ROUNDING.equals(string)) {
            this.rangeRounding = ROUND_UP.equals(object) ? 1.0 : (ROUND_DOWN.equals(object) ? 0.0 : 0.5);
        } else if (HIDE_COUNTERS.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.hideCounters = (Boolean)object;
        } else if (HIDE_OPACITY.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.setTransparency((Integer)object);
        } else if (RANGE_FOREGROUND.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.rangeFg = (Color)object;
        } else if (RANGE_BACKGROUND.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.rangeBg = (Color)object;
        } else if (LOS_COLOR.equals(string)) {
            if (object instanceof Color) {
                object = ColorConfigurer.colorToString((Color)object);
            }
            this.fixedColor = (String)object;
            this.threadColor = ColorConfigurer.stringToColor(this.fixedColor);
        } else if (SNAP_START.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.snapStart = (Boolean)object;
        } else if (SNAP_END.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.snapEnd = (Boolean)object;
        } else if (REPORT.equals(string)) {
            this.reportFormat.setFormat((String)object);
        } else if (PERSISTENCE.equals(string)) {
            this.persistence = (String)object;
        } else if (PERSISTENT_ICON_NAME.equals(string)) {
            this.persistentIconName = (String)object;
        } else if (GLOBAL.equals(string)) {
            this.global = (String)object;
        } else if (ICON_NAME.equals(string)) {
            this.iconName = (String)object;
            this.launch.setAttribute(ICON_NAME, this.iconName);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    protected void setTransparency(int n) {
        this.hideOpacity = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    @Override
    public String getAttributeValueString(String string) {
        if (DRAW_RANGE.equals(string)) {
            return String.valueOf(this.drawRange);
        }
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (RANGE_SCALE.equals(string)) {
            return String.valueOf(this.rangeScale);
        }
        if (RANGE_ROUNDING.equals(string)) {
            if (this.rangeRounding == 1.0) {
                return ROUND_UP;
            }
            if (this.rangeRounding == 0.0) {
                return ROUND_DOWN;
            }
            return ROUND_OFF;
        }
        if (HIDE_COUNTERS.equals(string)) {
            return String.valueOf(this.hideCounters);
        }
        if (HIDE_OPACITY.equals(string)) {
            return String.valueOf(this.hideOpacity);
        }
        if (RANGE_FOREGROUND.equals(string)) {
            return ColorConfigurer.colorToString(this.rangeFg);
        }
        if (RANGE_BACKGROUND.equals(string)) {
            return ColorConfigurer.colorToString(this.rangeBg);
        }
        if (LOS_COLOR.equals(string)) {
            return this.fixedColor;
        }
        if (SNAP_START.equals(string)) {
            return String.valueOf(this.snapStart);
        }
        if (SNAP_END.equals(string)) {
            return String.valueOf(this.snapEnd);
        }
        if (REPORT.equals(string)) {
            return this.reportFormat.getFormat();
        }
        if (PERSISTENCE.equals(string)) {
            return this.persistence;
        }
        if (PERSISTENT_ICON_NAME.equals(string)) {
            return this.persistentIconName;
        }
        if (GLOBAL.equals(string)) {
            return this.global;
        }
        if (ICON_NAME.equals(string)) {
            return this.iconName;
        }
        return this.launch.getAttributeValueString(string);
    }

    public void setup(boolean bl) {
        this.launch.setEnabled(bl);
    }

    public String getState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.anchor.x).append(this.anchor.y).append(this.arrow.x).append(this.arrow.y);
        sequenceEncoder.append(this.persisting);
        sequenceEncoder.append(this.mirroring);
        return sequenceEncoder.getValue();
    }

    public void setState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.anchor.x = decoder.nextInt(this.anchor.x);
        this.anchor.y = decoder.nextInt(this.anchor.y);
        this.arrow.x = decoder.nextInt(this.arrow.x);
        this.arrow.y = decoder.nextInt(this.arrow.y);
        this.setPersisting(decoder.nextBoolean(false));
        this.setMirroring(decoder.nextBoolean(false));
    }

    @Override
    public void draw(Graphics graphics, Map map) {
        if (this.initializing || !this.visible) {
            return;
        }
        graphics.setColor(this.threadColor);
        Point point = this.map.componentCoordinates(this.anchor);
        Point point2 = this.map.componentCoordinates(this.arrow);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        if (this.drawRange) {
            if (this.rangeScale > 0) {
                int n = (int)(this.rangeRounding + this.anchor.getLocation().distance(this.arrow.getLocation()) / (double)this.rangeScale);
                this.drawRange(graphics, n);
            } else {
                Board board = this.map.findBoard(this.anchor);
                MapGrid mapGrid = null;
                if (board != null) {
                    mapGrid = board.getGrid();
                }
                if (mapGrid != null && mapGrid instanceof ZonedGrid) {
                    Point point3 = new Point(this.anchor);
                    point3.translate(-board.bounds().x, -board.bounds().y);
                    Zone zone = ((ZonedGrid)board.getGrid()).findZone(point3);
                    if (zone != null) {
                        mapGrid = zone.getGrid();
                    }
                }
                if (mapGrid != null) {
                    this.drawRange(graphics, mapGrid.range(this.anchor, this.arrow));
                }
            }
        }
        this.lastAnchor = point;
        this.lastArrow = point2;
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    protected void launch() {
        if (!this.visible) {
            this.map.pushMouseListener(this);
            if (this.hideCounters) {
                this.map.setPieceOpacity((float)this.hideOpacity / 100.0f);
                this.map.repaint();
            }
            this.visible = true;
            this.anchor.move(0, 0);
            this.arrow.move(0, 0);
            this.retainAfterRelease = false;
            this.initializing = true;
        } else if (this.persisting) {
            this.setPersisting(false);
        }
    }

    @Override
    public void setId(String string) {
        this.threadId = string;
    }

    @Override
    public String getId() {
        return this.threadId;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.initializing = false;
        if (this.visible && !this.persisting && !this.mirroring) {
            Point point = mouseEvent.getPoint();
            if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(SNAP_LOS)) || this.snapStart) {
                point = this.map.snapTo(point);
            }
            this.anchor = point;
            this.lastLocation = this.anchorLocation = this.map.localizedLocationName(this.anchor);
            this.lastRange = "";
            this.checkList.clear();
            this.ctrlWhenClick = mouseEvent.isControlDown();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.persisting && !this.mirroring) {
            if (!(!this.retainAfterRelease || this.ctrlWhenClick && this.persistence.equals(CTRL_CLICK))) {
                this.retainAfterRelease = false;
                if (this.global.equals(ALWAYS)) {
                    LOSCommand lOSCommand = new LOSCommand(this, this.getAnchor(), this.getArrow(), false, true);
                    GameModule.getGameModule().sendAndLog(lOSCommand);
                }
            } else if (mouseEvent.getWhen() != this.lastRelease) {
                this.visible = false;
                if (this.global.equals(ALWAYS) || this.global.equals(WHEN_PERSISTENT)) {
                    if (this.persistence.equals(ALWAYS) || this.ctrlWhenClick && this.persistence.equals(CTRL_CLICK)) {
                        this.anchor = this.lastAnchor;
                        LOSCommand lOSCommand = new LOSCommand(this, this.getAnchor(), this.getArrow(), true, false);
                        GameModule.getGameModule().sendAndLog(lOSCommand);
                        this.setPersisting(true);
                    } else {
                        LOSCommand lOSCommand = new LOSCommand(this, this.getAnchor(), this.getArrow(), false, false);
                        GameModule.getGameModule().sendAndLog(lOSCommand);
                    }
                }
                this.map.setPieceOpacity(1.0f);
                this.map.popMouseListener();
                this.map.repaint();
            }
            this.lastRelease = mouseEvent.getWhen();
            if (this.getLosCheckCount() > 0) {
                this.reportFormat.setProperty(FROM_LOCATION, this.anchorLocation);
                this.reportFormat.setProperty(TO_LOCATION, this.lastLocation);
                this.reportFormat.setProperty(RANGE, this.lastRange);
                this.reportFormat.setProperty(CHECK_COUNT, String.valueOf(this.getLosCheckCount()));
                this.reportFormat.setProperty(CHECK_LIST, this.getLosCheckList());
                GameModule.getGameModule().getChatter().send(this.reportFormat.getLocalizedText());
            }
        }
        this.ctrlWhenClick = false;
    }

    protected void setPersisting(boolean bl) {
        this.persisting = bl;
        this.visible = bl;
        this.setMirroring(false);
        if (this.persisting) {
            this.launch.setAttribute(ICON_NAME, this.persistentIconName);
        } else {
            this.launch.setAttribute(ICON_NAME, this.iconName);
            this.map.repaint();
        }
    }

    protected boolean isPersisting() {
        return this.persisting;
    }

    protected void setMirroring(boolean bl) {
        this.mirroring = bl;
        if (this.mirroring) {
            this.visible = true;
        }
    }

    protected boolean isMirroring() {
        return this.mirroring;
    }

    protected Point getAnchor() {
        return new Point(this.anchor);
    }

    protected void setEndPoints(Point point, Point point2) {
        this.anchor.x = point.x;
        this.anchor.y = point.y;
        this.arrow.x = point2.x;
        this.arrow.y = point2.y;
        this.map.repaint();
    }

    protected Point getArrow() {
        return new Point(this.arrow);
    }

    protected int getLosCheckCount() {
        return this.checkList.size();
    }

    protected String getLosCheckList() {
        String string = "";
        for (String string2 : this.checkList) {
            string = string + (string.length() > 0 ? ", " : "") + string2;
        }
        return string;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.visible && !this.persisting && !this.mirroring) {
            this.retainAfterRelease = true;
            Point point = mouseEvent.getPoint();
            this.map.scrollAtEdge(point, 15);
            if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(SNAP_LOS)) || this.snapEnd) {
                point = this.map.componentCoordinates(this.map.snapTo(this.map.mapCoordinates(point)));
            }
            this.arrow = this.map.mapCoordinates(point);
            String string = this.map.localizedLocationName(this.arrow);
            if (!this.checkList.contains(string) && !string.equals(this.anchorLocation)) {
                this.checkList.add(string);
                this.lastLocation = string;
            }
            Point point2 = this.map.mapCoordinates(this.lastAnchor);
            Point point3 = this.map.mapCoordinates(this.lastArrow);
            int n = (int)(1.0 / this.map.getZoom() * 2.0);
            Rectangle rectangle = new Rectangle(Math.min(point2.x, point3.x) - n, Math.min(point2.y, point3.y) - n, Math.abs(point2.x - point3.x) + 1 + n * 2, Math.abs(point2.y - point3.y) + 1 + n * 2);
            this.map.repaint(rectangle);
            if (this.drawRange) {
                rectangle = new Rectangle(this.lastRangeRect);
                rectangle.width += (int)((double)rectangle.width / this.map.getZoom()) + 1;
                rectangle.height += (int)((double)rectangle.height / this.map.getZoom()) + 1;
                this.map.repaint(rectangle);
            }
        }
    }

    public void drawRange(Graphics graphics, int n) {
        Point point = this.map.componentCoordinates(this.arrow);
        Point point2 = this.map.componentCoordinates(this.anchor);
        graphics.setColor(Color.black);
        graphics.setFont(RANGE_FONT);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i >= 1; i /= 10) {
            stringBuilder.append("8");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("8");
        }
        String string = Resources.getString("LOS_Thread.range");
        int n2 = fontMetrics.stringWidth(" " + string + "  " + stringBuilder.toString());
        int n3 = fontMetrics.getAscent() + 2;
        int n4 = point.x - point2.x;
        int n5 = point.y - point2.y;
        int n6 = point.x + (int)((double)((n2 / 2 + 20) * n4) / Math.sqrt(n4 * n4 + n5 * n5));
        int n7 = point.y + (int)((double)((n3 / 2 + 20) * n5) / Math.sqrt(n4 * n4 + n5 * n5));
        graphics.fillRect(n6 - n2 / 2, n7 + n3 / 2 - fontMetrics.getAscent(), n2, n3);
        graphics.setColor(Color.white);
        graphics.drawString(string + " " + n, n6 - n2 / 2 + fontMetrics.stringWidth(" "), n7 + n3 / 2);
        this.lastRangeRect = new Rectangle(n6 - n2 / 2, n7 + n3 / 2 - fontMetrics.getAscent(), n2 + 1, n3 + 1);
        Point point3 = this.map.mapCoordinates(new Point(this.lastRangeRect.x, this.lastRangeRect.y));
        this.lastRangeRect.x = point3.x;
        this.lastRangeRect.y = point3.y;
        this.lastRange = String.valueOf(n);
    }

    public static String getConfigureTypeName() {
        return "Line of Sight Thread";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "LOS");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Thread name:  ", "Button text:  ", "Tooltip text:  ", "Button Icon:  ", "Hotkey:  ", "Report Format:  ", "Persistence:  ", "Button Icon when LOS persisting:  ", "Visible to Opponent:  ", "Force start of thread to snap to grid?", "Force end of thread to snap to grid?", "Draw Range?", "Pixels per range unit (0 to use Grid calculation):  ", "Round fractions:  ", "Hide Pieces while drawing?", "Opacity of hidden pieces (0-100%):  ", "Thread color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, KeyStroke.class, ReportFormatConfig.class, PersistenceOptions.class, IconConfig.class, GlobalOptions.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, RoundingOptions.class, Boolean.class, Integer.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        VisibilityCondition visibilityCondition = null;
        if (RANGE_SCALE.equals(string) || RANGE_ROUNDING.equals(string)) {
            visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return LOS_Thread.this.drawRange;
                }
            };
        } else if (HIDE_OPACITY.equals(string)) {
            visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return LOS_Thread.this.hideCounters;
                }
            };
        } else if (PERSISTENT_ICON_NAME.equals(string)) {
            visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return LOS_Thread.this.persistence.equals(LOS_Thread.CTRL_CLICK) || LOS_Thread.this.persistence.equals(LOS_Thread.ALWAYS);
                }
            };
        }
        return visibilityCondition;
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public Command decode(String string) {
        SequenceEncoder.Decoder decoder = null;
        if (string.startsWith(LOS_THREAD_COMMAND + this.getId())) {
            decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
            decoder.nextToken();
            Point point = new Point(decoder.nextInt(0), decoder.nextInt(0));
            Point point2 = new Point(decoder.nextInt(0), decoder.nextInt(0));
            boolean bl = decoder.nextBoolean(false);
            boolean bl2 = decoder.nextBoolean(false);
            return new LOSCommand(this, point, point2, bl, bl2);
        }
        return null;
    }

    @Override
    public String encode(Command command) {
        if (command instanceof LOSCommand) {
            LOSCommand lOSCommand = (LOSCommand)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder(lOSCommand.target.getId(), '\t');
            sequenceEncoder.append(lOSCommand.newAnchor.x).append(lOSCommand.newAnchor.y).append(lOSCommand.newArrow.x).append(lOSCommand.newArrow.y).append(lOSCommand.newPersisting).append(lOSCommand.newMirroring);
            return LOS_THREAD_COMMAND + sequenceEncoder.getValue();
        }
        return null;
    }

    public static class LOSCommand
    extends Command {
        protected LOS_Thread target;
        protected String oldState;
        protected Point newAnchor;
        protected Point oldAnchor;
        protected Point newArrow;
        protected Point oldArrow;
        protected boolean newPersisting;
        protected boolean oldPersisting;
        protected boolean newMirroring;
        protected boolean oldMirroring;

        public LOSCommand(LOS_Thread lOS_Thread, Point point, Point point2, boolean bl, boolean bl2) {
            this.target = lOS_Thread;
            this.oldAnchor = this.target.getAnchor();
            this.oldArrow = this.target.getArrow();
            this.oldPersisting = this.target.isPersisting();
            this.oldMirroring = this.target.isMirroring();
            this.newAnchor = point;
            this.newArrow = point2;
            this.newPersisting = bl;
            this.newMirroring = bl2;
        }

        protected void executeCommand() {
            this.target.setEndPoints(this.newAnchor, this.newArrow);
            this.target.setPersisting(this.newPersisting);
            this.target.setMirroring(this.newMirroring);
        }

        protected Command myUndoCommand() {
            return new LOSCommand(this.target, this.oldAnchor, this.oldArrow, this.oldPersisting, this.oldMirroring);
        }
    }

    public static class GlobalOptions
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{LOS_Thread.WHEN_PERSISTENT, LOS_Thread.NEVER, LOS_Thread.ALWAYS};
        }
    }

    public static class PersistenceOptions
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{LOS_Thread.CTRL_CLICK, LOS_Thread.NEVER, LOS_Thread.ALWAYS};
        }
    }

    public static class RoundingOptions
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{LOS_Thread.ROUND_UP, LOS_Thread.ROUND_DOWN, LOS_Thread.ROUND_OFF};
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{LOS_Thread.FROM_LOCATION, LOS_Thread.TO_LOCATION, LOS_Thread.RANGE, LOS_Thread.CHECK_COUNT, LOS_Thread.CHECK_LIST});
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, LOS_Thread.DEFAULT_ICON);
        }
    }
}

