/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.Embellishment;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.ToolBarComponent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MassKeyCommand
extends AbstractConfigurable
implements RecursionLimiter.Loopable {
    public static final String DEPRECATED_NAME = "text";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String HOTKEY = "buttonHotkey";
    public static final String KEY_COMMAND = "hotkey";
    public static final String AFFECTED_PIECE_NAMES = "names";
    public static final String PROPERTIES_FILTER = "filter";
    public static final String REPORT_SINGLE = "reportSingle";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String CONDITION = "condition";
    public static final String DECK_COUNT = "deckCount";
    private static final String IF_ACTIVE = "If layer is active";
    private static final String IF_INACTIVE = "If layer is inactive";
    private static final String ALWAYS = "Always";
    public static final String CHECK_PROPERTY = "property";
    public static final String CHECK_VALUE = "propValue";
    protected LaunchButton launch;
    protected KeyStroke stroke = KeyStroke.getKeyStroke(0, 0);
    protected String[] names = new String[0];
    protected String condition;
    protected String checkProperty;
    protected String checkValue;
    protected PropertyExpression propertiesFilter = new PropertyExpression();
    protected PropertySource propertySource;
    protected PieceFilter filter;
    protected Map map;
    protected GlobalCommand globalCommand = new GlobalCommand(this);
    protected FormattedString reportFormat = new FormattedString();

    public MassKeyCommand() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MassKeyCommand.this.apply();
            }
        };
        this.launch = new LaunchButton("CTRL", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
    }

    @Override
    public void addTo(Buildable buildable) {
        if (buildable instanceof Map) {
            this.map = (Map)buildable;
        }
        if (buildable instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)buildable)).getToolBar().add(this.launch);
        }
        if (buildable instanceof PropertySource) {
            this.propertySource = (PropertySource)((Object)buildable);
        }
        this.setAttributeTranslatable(NAME, false);
    }

    public void apply() {
        this.apply(this.map);
    }

    public void apply(Map map) {
        GameModule.getGameModule().sendAndLog(this.globalCommand.apply(map, this.getFilter()));
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        if (this.condition == null) {
            return new String[]{"Description:  ", "Key Command:  ", "Matching properties:  ", "Apply to contents of Decks:  ", "Button text:  ", "Tooltip text:  ", "Button Icon:  ", "Hotkey:  ", "Suppress individual reports?", "Report Format:  "};
        }
        return new String[]{"Description:  ", "Key Command:  ", "Matching properties:  ", "Apply to contents of Decks:  ", "Button text:  ", "Tooltip text:  ", "Button Icon:  ", "Hotkey:  ", "Suppress individual reports?", "Report Format:  ", "Apply Command:  "};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, KEY_COMMAND, PROPERTIES_FILTER, DECK_COUNT, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY, REPORT_SINGLE, REPORT_FORMAT, CONDITION, CHECK_VALUE, CHECK_PROPERTY, AFFECTED_PIECE_NAMES};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        if (this.condition == null) {
            return new Class[]{String.class, KeyStroke.class, PropertyExpression.class, DeckPolicyConfig.class, String.class, String.class, IconConfig.class, KeyStroke.class, Boolean.class, ReportFormatConfig.class};
        }
        return new Class[]{String.class, KeyStroke.class, String.class, DeckPolicyConfig.class, String.class, String.class, IconConfig.class, KeyStroke.class, Boolean.class, ReportFormatConfig.class, Prompt.class};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (KEY_COMMAND.equals(string)) {
            return HotKeyConfigurer.encode(this.stroke);
        }
        if (AFFECTED_PIECE_NAMES.equals(string)) {
            return this.names == null || this.names.length == 0 ? null : StringArrayConfigurer.arrayToString(this.names);
        }
        if (CHECK_PROPERTY.equals(string)) {
            return this.propertiesFilter != null ? null : this.checkProperty;
        }
        if (CHECK_VALUE.equals(string)) {
            return this.propertiesFilter != null ? null : this.checkValue;
        }
        if (PROPERTIES_FILTER.equals(string)) {
            return this.propertiesFilter.getExpression();
        }
        if (CONDITION.equals(string)) {
            return ALWAYS.equals(this.condition) ? null : this.condition;
        }
        if (REPORT_SINGLE.equals(string)) {
            return String.valueOf(this.globalCommand.isReportSingle());
        }
        if (DECK_COUNT.equals(string)) {
            return String.valueOf(this.globalCommand.getSelectFromDeck());
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.reportFormat.getFormat();
        }
        return this.launch.getAttributeValueString(string);
    }

    public static String getConfigureTypeName() {
        return "Global Key Command";
    }

    protected LaunchButton getLaunchButton() {
        return this.launch;
    }

    protected void setLaunchButton(LaunchButton launchButton) {
        this.launch = launchButton;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "GlobalKeyCommand");
    }

    @Override
    public void removeFrom(Buildable buildable) {
        if (buildable instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)buildable)).getToolBar().remove(this.launch);
        }
    }

    public PieceFilter getFilter() {
        this.buildFilter();
        return this.filter;
    }

    private void buildFilter() {
        if (this.checkValue != null) {
            this.propertiesFilter.setExpression(this.checkProperty + "=" + this.checkValue);
        }
        if (this.propertiesFilter != null) {
            this.filter = this.propertiesFilter.getFilter(this.propertySource);
        }
        if (this.filter != null && this.condition != null) {
            this.filter = new BooleanAndPieceFilter(this.filter, new PieceFilter(){

                public boolean accept(GamePiece gamePiece) {
                    boolean bl = false;
                    if (MassKeyCommand.ALWAYS.equals(MassKeyCommand.this.condition)) {
                        bl = true;
                    } else if (MassKeyCommand.IF_ACTIVE.equals(MassKeyCommand.this.condition)) {
                        bl = Embellishment.getLayerWithMatchingActivateCommand(gamePiece, MassKeyCommand.this.stroke, true) != null;
                    } else if (MassKeyCommand.IF_INACTIVE.equals(MassKeyCommand.this.condition)) {
                        bl = Embellishment.getLayerWithMatchingActivateCommand(gamePiece, MassKeyCommand.this.stroke, false) != null;
                    }
                    return bl;
                }
            });
        }
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (DEPRECATED_NAME.equals(string)) {
            this.setAttribute(NAME, object);
            this.setAttribute(BUTTON_TEXT, object);
        } else if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            if (this.launch.getAttributeValueString(TOOLTIP) == null) {
                this.launch.setAttribute(TOOLTIP, object);
            }
        } else if (KEY_COMMAND.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.stroke = (KeyStroke)object;
            this.globalCommand.setKeyStroke(this.stroke);
        } else if (AFFECTED_PIECE_NAMES.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.names = object;
            if (this.names.length == 0) {
                this.names = null;
            } else {
                this.filter = new PieceFilter(){

                    public boolean accept(GamePiece gamePiece) {
                        for (int i = 0; i < MassKeyCommand.this.names.length; ++i) {
                            if (!Decorator.getInnermost(gamePiece).getName().equals(MassKeyCommand.this.names[i])) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        } else if (CHECK_PROPERTY.equals(string)) {
            this.checkProperty = (String)object;
        } else if (CHECK_VALUE.equals(string)) {
            this.checkValue = (String)object;
        } else if (PROPERTIES_FILTER.equals(string)) {
            this.propertiesFilter.setExpression((String)object);
        } else if (CONDITION.equals(string)) {
            this.condition = (String)object;
        } else if (REPORT_SINGLE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.globalCommand.setReportSingle((Boolean)object);
        } else if (DECK_COUNT.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.globalCommand.setSelectFromDeck((Integer)object);
        } else if (REPORT_FORMAT.equals(string)) {
            this.reportFormat.setFormat((String)object);
            this.globalCommand.setReportFormat((String)object);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public String getComponentName() {
        return this.getConfigureName();
    }

    @Override
    public String getComponentTypeName() {
        return MassKeyCommand.getConfigureTypeName();
    }

    public static class DeckPolicyConfig
    extends Configurer
    implements ConfigurerFactory {
        protected static final String FIXED = "Fixed number of pieces";
        protected static final String NONE = "No pieces";
        protected static final String ALL = "All pieces";
        protected IntConfigurer intConfig;
        protected StringEnumConfigurer typeConfig = new StringEnumConfigurer(null, "", new String[]{"All pieces", "No pieces", "Fixed number of pieces"});
        protected JLabel prompt;
        protected Box controls;

        public DeckPolicyConfig() {
            super(null, "");
            this.intConfig = new IntConfigurer(null, "");
            this.controls = Box.createHorizontalBox();
            this.prompt = new JLabel("Within a Deck, apply to:  ");
            this.controls.add(this.prompt);
            this.controls.add(this.typeConfig.getControls());
            this.controls.add(this.intConfig.getControls());
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DeckPolicyConfig.this.intConfig.getControls().setVisible(DeckPolicyConfig.FIXED.equals(DeckPolicyConfig.this.typeConfig.getValueString()));
                    Window window = SwingUtilities.getWindowAncestor(DeckPolicyConfig.this.intConfig.getControls());
                    if (window != null) {
                        window.pack();
                    }
                }
            };
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DeckPolicyConfig.this.setValue(new Integer(DeckPolicyConfig.this.getIntValue()));
                }
            };
            this.typeConfig.addPropertyChangeListener(propertyChangeListener);
            this.typeConfig.addPropertyChangeListener(propertyChangeListener2);
            this.intConfig.addPropertyChangeListener(propertyChangeListener2);
        }

        public Component getControls() {
            return this.controls;
        }

        public String getValueString() {
            return String.valueOf(this.getIntValue());
        }

        public int getIntValue() {
            String string = this.typeConfig.getValueString();
            if (ALL.equals(string)) {
                return -1;
            }
            if (NONE.equals(string)) {
                return 0;
            }
            return this.intConfig.getIntValue(1);
        }

        public void setValue(Object object) {
            if (this.typeConfig != null) {
                this.typeConfig.setFrozen(true);
                this.intConfig.setFrozen(true);
                if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    switch (n) {
                        case 0: {
                            this.typeConfig.setValue(NONE);
                            this.intConfig.setValue(new Integer(1));
                            break;
                        }
                        case -1: {
                            this.typeConfig.setValue(ALL);
                            this.intConfig.setValue(new Integer(1));
                            break;
                        }
                        default: {
                            this.typeConfig.setValue(FIXED);
                            this.intConfig.setValue(n);
                        }
                    }
                    this.intConfig.getControls().setVisible(FIXED.equals(this.typeConfig.getValueString()));
                }
            }
            super.setValue(object);
            if (this.typeConfig != null) {
                this.typeConfig.setFrozen(false);
                this.intConfig.setFrozen(false);
            }
        }

        public void setValue(String string) {
            if (string != null) {
                this.setValue(new Integer(string));
            }
        }

        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            this.setName(string2);
            this.key = string;
            return this;
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[0]);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/keyCommand.gif");
        }
    }

    public static class Prompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{MassKeyCommand.ALWAYS, MassKeyCommand.IF_ACTIVE, MassKeyCommand.IF_INACTIVE};
        }
    }
}

