/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.Repainter;
import VASSAL.tools.imageop.ScaleOp;
import VASSAL.tools.imageop.SourceOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
extends AbstractConfigurable
implements GridContainer {
    public static final String NAME = "name";
    public static final String IMAGE = "image";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String COLOR = "color";
    public static final String REVERSIBLE = "reversible";
    protected Point pos = new Point(0, 0);
    protected Rectangle boundaries = new Rectangle(0, 0, 500, 500);
    protected String imageFile;
    protected boolean reversible = false;
    protected boolean reversed = false;
    protected boolean fixedBoundaries = false;
    protected Color color = null;
    protected MapGrid grid = null;
    protected Map map;
    protected double magnification = 1.0;
    @Deprecated
    protected String boardName = "Board 1";
    @Deprecated
    protected Image boardImage;
    protected SourceOp boardImageOp;
    protected ScaleOp scaledImageOp;
    private ConcurrentMap<Point, Future<BufferedImage>> requested = new ConcurrentHashMap<Point, Future<BufferedImage>>();
    private java.util.Map<Point, Float> alpha = new ConcurrentHashMap<Point, Float>();
    private static Comparator<Point> tileOrdering = new Comparator<Point>(){

        @Override
        public int compare(Point point, Point point2) {
            if (point.y < point2.y) {
                return -1;
            }
            if (point.y > point2.y) {
                return 1;
            }
            return point.x - point2.x;
        }
    };

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public String getLocalizedName() {
        String string = this.getLocalizedConfigureName();
        return string != null ? string : "";
    }

    public String getName() {
        String string = this.getConfigureName();
        return string != null ? string : "";
    }

    @Override
    public void addTo(Buildable buildable) {
        this.validator = new SingleChildInstance(this, MapGrid.class);
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, IMAGE, REVERSIBLE, WIDTH, HEIGHT, COLOR};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Board name:  ", "Board image:  ", "Reversible:  ", "Board width:  ", "Board height:  ", "Background color:  "};
    }

    public static String getConfigureTypeName() {
        return "Board";
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Image.class, Boolean.class, Integer.class, Integer.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (REVERSIBLE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Board.this.imageFile != null;
                }
            };
        }
        if (WIDTH.equals(string) || HEIGHT.equals(string) || COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Board.this.imageFile == null;
                }
            };
        }
        return null;
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (IMAGE.equals(string)) {
            return this.imageFile;
        }
        if (WIDTH.equals(string)) {
            return this.imageFile == null ? String.valueOf(this.boundaries.width) : null;
        }
        if (HEIGHT.equals(string)) {
            return this.imageFile == null ? String.valueOf(this.boundaries.height) : null;
        }
        if (COLOR.equals(string)) {
            return this.imageFile == null ? ColorConfigurer.colorToString(this.color) : null;
        }
        if (REVERSIBLE.equals(string)) {
            return String.valueOf(this.reversible);
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (IMAGE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.imageFile = (String)object;
            this.boardImageOp = this.imageFile == null || this.imageFile.trim().length() == 0 ? null : Op.loadLarge(this.imageFile);
        } else if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.boundaries.setSize((Integer)object, this.boundaries.height);
            }
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.boundaries.setSize(this.boundaries.width, (Integer)object);
            }
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
        } else if (REVERSIBLE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.reversible = (Boolean)object;
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{HexGrid.class, SquareGrid.class, RegionGrid.class, ZonedGrid.class};
    }

    public void draw(Graphics graphics, int n, int n2, double d, Component component) {
        this.drawRegion(graphics, new Point(n, n2), new Rectangle(n, n2, Math.round((float)d * (float)this.boundaries.width), Math.round((float)d * (float)this.boundaries.height)), d, component);
    }

    protected void drawTile(Graphics graphics, Future<BufferedImage> future, int n, int n2, Component component) {
        block4: {
            try {
                graphics.drawImage(future.get(), n, n2, component);
            }
            catch (CancellationException cancellationException) {
                ErrorDialog.bug(cancellationException);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                if (Op.handleException(executionException)) break block4;
                ErrorDialog.bug(executionException);
            }
        }
    }

    public void drawRegion(Graphics graphics, Point point, Rectangle rectangle, double d, Component component) {
        Rectangle rectangle2;
        if (rectangle.intersects(rectangle2 = new Rectangle(point.x, point.y, Math.round((float)this.boundaries.width * (float)(d *= this.magnification)), Math.round((float)this.boundaries.height * (float)d)))) {
            rectangle = rectangle.intersection(rectangle2);
            if (this.boardImageOp != null) {
                Point[] pointArray;
                ImageOp imageOp;
                if (d == 1.0 && !this.reversed) {
                    imageOp = this.boardImageOp;
                } else {
                    if (this.scaledImageOp == null || this.scaledImageOp.getScale() != d) {
                        this.scaledImageOp = Op.scale(this.boardImageOp, d);
                    }
                    imageOp = this.reversed ? Op.rotate(this.scaledImageOp, 180.0) : this.scaledImageOp;
                }
                Rectangle rectangle3 = new Rectangle(rectangle.x - point.x, rectangle.y - point.y, rectangle.width, rectangle.height);
                int n = imageOp.getTileWidth();
                int n2 = imageOp.getTileHeight();
                for (Point point2 : pointArray = imageOp.getTileIndices(rectangle3)) {
                    int n3 = point.x + point2.x * n;
                    int n4 = point.y + point2.y * n2;
                    int n5 = Math.min(n, point.x + rectangle2.width - n3);
                    int n6 = Math.min(n2, point.y + rectangle2.height - n4);
                    Repainter repainter = component == null ? null : new Repainter(component, n3, n4, n5, n6);
                    try {
                        Future<BufferedImage> future = imageOp.getFutureTile(point2.x, point2.y, repainter);
                        if (component == null) {
                            this.drawTile(graphics, future, n3, n4, component);
                            continue;
                        }
                        if (future.isDone()) {
                            Graphics2D graphics2D;
                            Serializable serializable;
                            if (this.requested.containsKey(point2)) {
                                this.requested.remove(point2);
                                serializable = point2;
                                graphics2D = new Animator(100, (TimingTarget)new TimingTargetAdapter((Point)serializable, component, n3, n4, n5, n6){
                                    final /* synthetic */ Point val$t;
                                    final /* synthetic */ Component val$obs;
                                    final /* synthetic */ int val$tx;
                                    final /* synthetic */ int val$ty;
                                    final /* synthetic */ int val$tw;
                                    final /* synthetic */ int val$th;
                                    {
                                        this.val$t = point;
                                        this.val$obs = component;
                                        this.val$tx = n;
                                        this.val$ty = n2;
                                        this.val$tw = n3;
                                        this.val$th = n4;
                                    }

                                    public void timingEvent(float f) {
                                        Board.this.alpha.put(this.val$t, Float.valueOf(f));
                                        this.val$obs.repaint(this.val$tx, this.val$ty, this.val$tw, this.val$th);
                                    }
                                });
                                graphics2D.setResolution(20);
                                graphics2D.start();
                                continue;
                            }
                            serializable = this.alpha.get(point2);
                            if (serializable != null && ((Float)serializable).floatValue() < 1.0f) {
                                graphics2D = (Graphics2D)graphics;
                                Composite composite = graphics2D.getComposite();
                                graphics2D.setComposite(AlphaComposite.getInstance(3, ((Float)serializable).floatValue()));
                                this.drawTile(graphics2D, future, n3, n4, component);
                                graphics2D.setComposite(composite);
                                continue;
                            }
                            this.alpha.remove(point2);
                            this.drawTile(graphics, future, n3, n4, component);
                            continue;
                        }
                        this.requested.putIfAbsent(point2, future);
                    }
                    catch (CancellationException cancellationException) {
                        ErrorDialog.bug(cancellationException);
                    }
                    catch (ExecutionException executionException) {
                        ErrorDialog.bug(executionException);
                    }
                }
                for (Point point2 : this.requested.keySet().toArray(new Point[0])) {
                    if (Arrays.binarySearch(pointArray, point2, tileOrdering) >= 0) continue;
                    this.requested.remove(point2);
                }
            } else if (this.color != null) {
                graphics.setColor(this.color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (this.grid != null) {
                this.grid.draw(graphics, rectangle2, rectangle, d, this.reversed);
            }
        }
    }

    @Deprecated
    public synchronized Image getScaledImage(double d, Component component) {
        try {
            ScaleOp scaleOp = Op.scale(this.boardImageOp, d);
            return (this.reversed ? Op.rotate(scaleOp, 180.0) : scaleOp).getImage(null);
        }
        catch (CancellationException cancellationException) {
            ErrorDialog.bug(cancellationException);
        }
        catch (InterruptedException interruptedException) {
            ErrorDialog.bug(interruptedException);
        }
        catch (ExecutionException executionException) {
            ErrorDialog.bug(executionException);
        }
        return null;
    }

    public void setReversed(boolean bl) {
        if (this.reversible && this.reversed != bl) {
            this.reversed = bl;
            this.scaledImageOp = null;
        }
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Point localCoordinates(Point point) {
        if (this.reversed) {
            point.x = this.bounds().width - point.x;
            point.y = this.bounds().height - point.y;
        }
        if (this.magnification != 1.0) {
            point.x = (int)Math.round((double)point.x / this.magnification);
            point.y = (int)Math.round((double)point.y / this.magnification);
        }
        return point;
    }

    public Point globalCoordinates(Point point) {
        if (this.magnification != 1.0) {
            point.x = (int)Math.round((double)point.x * this.magnification);
            point.y = (int)Math.round((double)point.y * this.magnification);
        }
        if (this.reversed) {
            point.x = this.bounds().width - point.x;
            point.y = this.bounds().height - point.y;
        }
        return point;
    }

    @Override
    public void setGrid(MapGrid mapGrid) {
        this.grid = mapGrid;
    }

    @Override
    public void removeGrid(MapGrid mapGrid) {
        if (this.grid == mapGrid) {
            this.grid = null;
        }
    }

    @Override
    public Board getBoard() {
        return this;
    }

    @Override
    public Dimension getSize() {
        return this.bounds().getSize();
    }

    public MapGrid getGrid() {
        return this.grid;
    }

    public Board copy() {
        Board board = new Board();
        board.build(this.getBuildElement(Builder.createNewDocument()));
        return board;
    }

    @Deprecated
    public void fixImage(Component component) {
    }

    @Deprecated
    public void fixImage() {
    }

    public String locationName(Point point) {
        return this.grid == null ? null : this.grid.locationName(this.localCoordinates(point));
    }

    public String localizedLocationName(Point point) {
        return this.grid == null ? null : this.grid.localizedLocationName(this.localCoordinates(point));
    }

    public Point snapTo(Point point) {
        return this.grid == null ? point : this.globalCoordinates(this.grid.snapTo(this.localCoordinates(point)));
    }

    public boolean isLocationRestricted(Point point) {
        return this.grid == null ? false : this.grid.isLocationRestricted(this.localCoordinates(point));
    }

    public String fileName() {
        return this.imageFile;
    }

    public Point relativePosition() {
        return this.pos;
    }

    public Rectangle bounds() {
        if (this.imageFile != null && this.boardImageOp != null && !this.fixedBoundaries) {
            this.boundaries.setSize(this.boardImageOp.getSize());
            if (this.magnification != 1.0) {
                this.boundaries.setSize((int)Math.round(this.magnification * (double)this.boundaries.width), (int)Math.round(this.magnification * (double)this.boundaries.height));
            }
            this.fixedBoundaries = true;
        }
        return new Rectangle(this.boundaries);
    }

    @Deprecated
    protected void fixBounds() {
    }

    public void translate(int n, int n2) {
        this.boundaries.translate(n, n2);
    }

    public void setLocation(int n, int n2) {
        this.boundaries.setLocation(n, n2);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Board.htm");
    }

    @Deprecated
    public void cleanUp() {
        if (this.imageFile != null) {
            GameModule.getGameModule().getDataArchive().unCacheImage("images/" + this.imageFile);
        }
        if (this.boardImage != null) {
            GameModule.getGameModule().getDataArchive().unCacheImage(this.boardImage);
            this.boardImage = null;
        }
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double d) {
        this.magnification = d;
        this.fixedBoundaries = false;
        this.bounds();
    }

    @Deprecated
    public static class Cleanup
    implements GameComponent {
        private static Cleanup instance;
        private Set<Board> toClean = new HashSet<Board>();
        private boolean gameStarted = false;

        public static void init() {
            if (instance == null) {
                instance = new Cleanup();
            }
        }

        private Cleanup() {
            GameModule.getGameModule().getGameState().addGameComponent(this);
        }

        public static Cleanup getInstance() {
            return instance;
        }

        public void addBoard(Board board) {
            this.toClean.add(board);
        }

        public Command getRestoreCommand() {
            return null;
        }

        public void setup(boolean bl) {
            if (this.gameStarted && !bl) {
                for (Board board : this.toClean) {
                    board.cleanUp();
                }
                this.toClean.clear();
            }
            this.gameStarted = bl;
        }
    }
}

