/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering;
import VASSAL.tools.AdjustableSpeedScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class GridEditor
extends JDialog
implements MouseListener,
KeyListener {
    protected static final String SET = "Set Grid Shape";
    protected static final String CANCEL = "Cancel";
    protected static final String CANCEL_SET = "Cancel Set";
    protected static final String OK = "Save";
    protected static final String NUMBERING = "Numbering";
    protected EditableGrid grid;
    protected Board board;
    protected JPanel view;
    protected JScrollPane scroll;
    protected boolean setMode;
    protected Point hp1;
    protected Point hp2;
    protected Point hp3;
    protected JButton okButton;
    protected JButton canSetButton;
    protected JButton setButton;
    protected JButton numberingButton;
    protected boolean saveGridVisible;
    protected boolean saveNumberingVisible;
    protected double saveDx;
    protected double saveDy;
    protected Point saveOrigin;
    protected static final int DELTA = 1;
    protected static final double DDELTA = 0.1;
    protected static final int FAST = 5;
    protected static final int ERROR_MARGIN = 5;

    public GridEditor(EditableGrid editableGrid) {
        this.setTitle("Edit " + editableGrid.getGridName());
        this.setModal(true);
        this.grid = editableGrid;
        GridContainer gridContainer = editableGrid.getContainer();
        if (gridContainer != null) {
            this.board = gridContainer.getBoard();
        }
        this.saveGridVisible = editableGrid.isVisible();
        if (editableGrid.getGridNumbering() != null) {
            this.saveNumberingVisible = editableGrid.getGridNumbering().isVisible();
        }
        this.saveDx = editableGrid.getDx();
        this.saveDy = editableGrid.getDy();
        this.saveOrigin = editableGrid.getOrigin();
        this.initComponents();
    }

    protected void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GridEditor.this.cancel();
            }
        });
        this.view = new GridPanel(this.board);
        this.view.addMouseListener(this);
        this.view.addKeyListener(this);
        this.view.setFocusable(true);
        this.scroll = new AdjustableSpeedScrollPane(this.view, 22, 32);
        this.scroll.setPreferredSize(new Dimension(800, 600));
        this.add((Component)this.scroll, "Center");
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Arrow Keys - Move Grid"));
        box.add(new JLabel("Control-Arrow Keys - Resize Grid"));
        box.add(new JLabel("Shift Key - Increase speed of other keys"));
        JPanel jPanel = new JPanel();
        this.okButton = new JButton(OK);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GridEditor.this.cancelSetMode();
                GridEditor.this.setVisible(false);
            }
        });
        jPanel.add(this.okButton);
        JButton jButton = new JButton(CANCEL);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GridEditor.this.cancel();
            }
        });
        jPanel.add(jButton);
        this.setButton = new JButton(SET);
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GridEditor.this.startSetMode();
            }
        });
        this.setButton.setRequestFocusEnabled(false);
        jPanel.add(this.setButton);
        this.canSetButton = new JButton(CANCEL_SET);
        this.canSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GridEditor.this.cancelSetMode();
            }
        });
        this.canSetButton.setVisible(false);
        this.canSetButton.setRequestFocusEnabled(false);
        jPanel.add(this.canSetButton);
        this.numberingButton = new JButton(NUMBERING);
        this.numberingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RegularGridNumbering)GridEditor.this.grid.getGridNumbering()).setAttribute("visible", !GridEditor.this.grid.getGridNumbering().isVisible());
                GridEditor.this.repaint();
            }
        });
        this.numberingButton.setEnabled(this.grid.getGridNumbering() != null);
        this.numberingButton.setVisible(true);
        this.numberingButton.setRequestFocusEnabled(false);
        jPanel.add(this.numberingButton);
        Box box2 = Box.createVerticalBox();
        box2.add(box);
        box2.add(jPanel);
        this.add((Component)box2, "South");
        this.scroll.revalidate();
        this.pack();
        this.repaint();
    }

    protected void cancel() {
        this.cancelSetMode();
        this.grid.setDx(this.saveDx);
        this.grid.setDy(this.saveDy);
        this.grid.setOrigin(this.saveOrigin);
        this.setVisible(false);
    }

    protected void cancelSetMode() {
        this.canSetButton.setVisible(false);
        this.setButton.setVisible(true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.setMode = false;
        this.grid.setVisible(this.saveGridVisible);
        if (this.grid.getGridNumbering() != null && this.saveNumberingVisible) {
            ((RegularGridNumbering)this.grid.getGridNumbering()).setAttribute("visible", this.saveNumberingVisible);
        }
        this.repaint();
    }

    protected void startSetMode() {
        this.hp1 = null;
        this.hp2 = null;
        this.hp3 = null;
        this.setMode = true;
        this.canSetButton.setVisible(true);
        this.setButton.setVisible(false);
        this.view.setCursor(Cursor.getPredefinedCursor(1));
        this.grid.setVisible(false);
        JOptionPane.showMessageDialog(null, "Click on 3 adjacent points around the edge of any map grid cell");
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.setMode) {
            return;
        }
        boolean bl = this.grid.isSideways();
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (keyEvent.isControlDown()) {
                    if (bl) {
                        this.adjustDx(-1, keyEvent);
                        break;
                    }
                    this.adjustDy(-1, keyEvent);
                    break;
                }
                if (bl) {
                    this.adjustX0(-1, keyEvent);
                    break;
                }
                this.adjustY0(-1, keyEvent);
                break;
            }
            case 40: {
                if (keyEvent.isControlDown()) {
                    if (bl) {
                        this.adjustDx(1, keyEvent);
                        break;
                    }
                    this.adjustDy(1, keyEvent);
                    break;
                }
                if (bl) {
                    this.adjustX0(1, keyEvent);
                    break;
                }
                this.adjustY0(1, keyEvent);
                break;
            }
            case 37: {
                if (keyEvent.isControlDown()) {
                    if (bl) {
                        this.adjustDy(-1, keyEvent);
                        break;
                    }
                    this.adjustDx(-1, keyEvent);
                    break;
                }
                if (bl) {
                    this.adjustY0(-1, keyEvent);
                    break;
                }
                this.adjustX0(-1, keyEvent);
                break;
            }
            case 39: {
                if (keyEvent.isControlDown()) {
                    if (bl) {
                        this.adjustDy(1, keyEvent);
                        break;
                    }
                    this.adjustDx(1, keyEvent);
                    break;
                }
                if (bl) {
                    this.adjustY0(1, keyEvent);
                    break;
                }
                this.adjustX0(1, keyEvent);
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
        keyEvent.consume();
    }

    public void rebuild() {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.rebuild();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.setMode) {
            if (this.hp1 == null) {
                this.hp1 = mouseEvent.getPoint();
            } else if (this.hp2 == null) {
                this.hp2 = mouseEvent.getPoint();
            } else if (this.hp3 == null) {
                this.hp3 = mouseEvent.getPoint();
                this.calculate();
                this.cancelSetMode();
            }
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void adjustX0(int n, KeyEvent keyEvent) {
        int n2 = n * 1;
        if (keyEvent.isShiftDown()) {
            n2 *= 5;
        }
        Point point = this.grid.getOrigin();
        this.setNewOrigin(new Point(point.x + n2, point.y));
    }

    protected void adjustY0(int n, KeyEvent keyEvent) {
        int n2 = n * 1;
        if (keyEvent.isShiftDown()) {
            n2 *= 5;
        }
        Point point = this.grid.getOrigin();
        this.setNewOrigin(new Point(point.x, point.y + n2));
    }

    protected void adjustDx(int n, KeyEvent keyEvent) {
        double d = (double)n * 0.1;
        if (keyEvent.isShiftDown()) {
            d *= 5.0;
        }
        this.grid.setDx(this.grid.getDx() + d);
    }

    protected void adjustDy(int n, KeyEvent keyEvent) {
        double d = (double)n * 0.1;
        if (keyEvent.isShiftDown()) {
            d *= 5.0;
        }
        this.grid.setDy(this.grid.getDy() + d);
    }

    protected void setNewOrigin(Point point) {
        int n = (int)Math.round(this.grid.getDx());
        int n2 = (int)Math.round(this.grid.getDy());
        if (point.x < -n) {
            point.x += n;
        } else if (point.x > n) {
            point.x -= n;
        }
        if (point.y < -n2) {
            point.y += n2;
        } else if (point.y > n2) {
            point.y -= n2;
        }
        this.grid.setOrigin(point);
    }

    protected boolean isHorizontal(Point point, Point point2) {
        return Math.abs(point2.y - point.y) <= 5;
    }

    protected boolean isVertical(Point point, Point point2) {
        return Math.abs(point2.x - point.x) <= 5;
    }

    protected boolean isPerpendicular(Point point, Point point2) {
        return this.isHorizontal(point, point2) || this.isVertical(point, point2);
    }

    protected void reportShapeError() {
        JOptionPane.showMessageDialog(null, "Doesn't look like a " + this.grid.getGridName() + "!", "Grid Shape Error", 0);
    }

    public abstract void calculate();

    public static interface EditableGrid {
        public double getDx();

        public double getDy();

        public Point getOrigin();

        public void setDx(double var1);

        public void setDy(double var1);

        public void setOrigin(Point var1);

        public boolean isSideways();

        public void setSideways(boolean var1);

        public GridContainer getContainer();

        public GridNumbering getGridNumbering();

        public boolean isVisible();

        public void setVisible(boolean var1);

        public String getGridName();
    }

    protected class GridPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected Board board;

        public GridPanel() {
            this.setFocusTraversalKeysEnabled(false);
        }

        public GridPanel(Board board) {
            this();
            this.setBoard(board);
        }

        public void setBoard(Board board) {
            this.board = board;
            this.setSize(this.board.getSize());
            this.setPreferredSize(this.board.getSize());
        }

        public Board getBoard() {
            return this.board;
        }

        public void paint(Graphics graphics) {
            if (this.board != null) {
                Rectangle rectangle = this.getVisibleRect();
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.board.draw(graphics, 0, 0, 1.0, this);
                if (GridEditor.this.setMode) {
                    this.highlight(graphics, GridEditor.this.hp1);
                    this.highlight(graphics, GridEditor.this.hp2);
                    this.highlight(graphics, GridEditor.this.hp3);
                }
            } else {
                super.paint(graphics);
            }
        }

        protected void highlight(Graphics graphics, Point point) {
            if (point != null) {
                graphics.setColor(Color.red);
                graphics.fillOval(point.x - 1, point.y - 1, 3, 3);
                graphics.drawOval(point.x - 5, point.y - 5, 10, 10);
            }
        }

        public boolean isFocusable() {
            return true;
        }
    }
}

