/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.PolygonEditor;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZoneHighlight;
import VASSAL.build.module.properties.ChangePropertyCommandEncoder;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.properties.ZoneProperty;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zone
extends AbstractConfigurable
implements GridContainer,
MutablePropertiesContainer,
PropertySource,
GameComponent {
    public static final String NAME = "name";
    public static final String PATH = "path";
    public static final String USE_PARENT_GRID = "useParentGrid";
    public static final String LOCATION_FORMAT = "locationFormat";
    public static final String GRID_LOCATION = "gridLocation";
    public static final String USE_HIGHLIGHT = "useHighlight";
    public static final String HIGHLIGHT_PROPERTY = "highlightProperty";
    protected static final Dimension DEFAULT_SIZE = new Dimension(600, 600);
    protected String locationFormat = "$name$";
    protected FormattedString format = new FormattedString();
    protected Polygon myPolygon;
    protected MapGrid grid = null;
    protected ZonedGrid parentGrid;
    protected boolean useParentGrid;
    protected PropertyChangeListener globalPropertyListener;
    protected MutablePropertiesContainer propsContainer = new MutablePropertiesContainer.Impl();
    protected PropertyChangeListener repaintOnPropertyChange = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Zone.this.repaint();
        }
    };
    protected int lastBoundsX = -1;
    protected int lastBoundsY = -1;
    protected double lastScale = -1.0;
    protected Shape lastScaledShape = null;
    protected Shape lastTransformedShape = null;
    protected Polygon lastPolygon = null;
    protected ZoneHighlight highlighter = null;
    protected boolean useHighlight = false;
    protected String highlightPropertyName = "";
    protected MutableProperty highlightProperty = null;
    protected PropertyChangeListener highlightPropertyChangeListener = null;

    public Zone() {
        this.myPolygon = new Polygon();
        this.setConfigureName("");
    }

    public String getName() {
        return this.getConfigureName();
    }

    public String getLocalizedName() {
        return this.getLocalizedConfigureName();
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, LOCATION_FORMAT, PATH, USE_PARENT_GRID, USE_HIGHLIGHT, HIGHLIGHT_PROPERTY};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Location Format:  ", "Shape", "Use board's grid?", "Use Highlighting?", "Highlight Property:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, LocationFormatConfig.class, ShapeEditor.class, Boolean.class, Boolean.class, String.class};
    }

    @Override
    public void addTo(Buildable buildable) {
        this.parentGrid = (ZonedGrid)buildable;
        this.parentGrid.addZone(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(new ChangePropertyCommandEncoder(this));
        this.setAttributeTranslatable(HIGHLIGHT_PROPERTY, false);
    }

    public void repaint() {
        if (this.getMap() != null) {
            this.getMap().repaint();
        }
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((ZonedGrid)buildable).removeZone(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    public static String getConfigureTypeName() {
        return "Zone";
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (PATH.equals(string)) {
            return PolygonEditor.polygonToString(this.myPolygon);
        }
        if (LOCATION_FORMAT.equals(string)) {
            return this.locationFormat;
        }
        if (USE_PARENT_GRID.equals(string)) {
            return String.valueOf(this.useParentGrid);
        }
        if (USE_HIGHLIGHT.equals(string)) {
            return String.valueOf(this.useHighlight);
        }
        if (HIGHLIGHT_PROPERTY.equals(string)) {
            return this.highlightPropertyName;
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (PATH.equals(string)) {
            PolygonEditor.reset(this.myPolygon, (String)object);
        } else if (LOCATION_FORMAT.equals(string)) {
            this.locationFormat = (String)object;
        } else if (USE_PARENT_GRID.equals(string)) {
            this.useParentGrid = "true".equals(object) || Boolean.TRUE.equals(object);
        } else if (USE_HIGHLIGHT.equals(string)) {
            this.useHighlight = "true".equals(object) || Boolean.TRUE.equals(object);
        } else if (HIGHLIGHT_PROPERTY.equals(string)) {
            this.highlightPropertyName = (String)object;
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (HIGHLIGHT_PROPERTY.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Zone.this.useHighlight;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        Class[] classArray;
        if (this.useParentGrid) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = ZoneProperty.class;
        } else {
            Class[] classArray3 = new Class[4];
            classArray3[0] = HexGrid.class;
            classArray3[1] = SquareGrid.class;
            classArray3[2] = RegionGrid.class;
            classArray = classArray3;
            classArray3[3] = ZoneProperty.class;
        }
        return classArray;
    }

    @Override
    public void addMutableProperty(String string, MutableProperty mutableProperty) {
        mutableProperty.addMutablePropertyChangeListener(this.repaintOnPropertyChange);
        this.propsContainer.addMutableProperty(string, mutableProperty);
    }

    @Override
    public MutableProperty removeMutableProperty(String string) {
        MutableProperty mutableProperty = this.propsContainer.removeMutableProperty(string);
        if (mutableProperty != null) {
            mutableProperty.removeMutablePropertyChangeListener(this.repaintOnPropertyChange);
        }
        return mutableProperty;
    }

    public Point getLocation(String string) throws MapGrid.BadCoords {
        Object object;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.locationFormat, '$');
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (decoder.hasMoreTokens()) {
            object = decoder.nextToken();
            boolean bl2 = bl = !bl;
            if (((String)object).length() <= 0) continue;
            if (!bl || !decoder.hasMoreTokens()) {
                stringBuilder.append(Pattern.quote((String)object));
                continue;
            }
            if (((String)object).equals(NAME)) {
                stringBuilder.append(Pattern.quote(this.getConfigureName()));
                continue;
            }
            if (!((String)object).equals(GRID_LOCATION) || this.getGrid() == null) continue;
            stringBuilder.append("(.*)");
            ++n;
        }
        if (stringBuilder.length() == 0) {
            throw new MapGrid.BadCoords();
        }
        object = Pattern.compile(stringBuilder.toString());
        Matcher matcher = ((Pattern)object).matcher(string);
        if (!matcher.matches()) {
            throw new MapGrid.BadCoords();
        }
        assert (matcher.groupCount() == n);
        Point point = null;
        if (n > 0) {
            String string2 = string.substring(matcher.start(n), matcher.end(n));
            point = this.getGrid().getLocation(string2);
            if (point == null || !this.contains(point)) {
                throw new MapGrid.BadCoords();
            }
            return point;
        }
        point = new Point(0, 0);
        for (int i = 0; i < this.myPolygon.npoints; ++i) {
            point.translate(this.myPolygon.xpoints[i], this.myPolygon.ypoints[i]);
        }
        point.x /= this.myPolygon.npoints;
        point.y /= this.myPolygon.npoints;
        if (this.contains(point)) {
            return point;
        }
        point.x = this.myPolygon.xpoints[0];
        point.y = this.myPolygon.ypoints[0];
        return point;
    }

    public String locationName(Point point) {
        this.format.setFormat(this.locationFormat);
        this.format.setProperty(NAME, this.getConfigureName());
        String string = null;
        if (this.getGrid() != null) {
            string = this.getGrid().locationName(point);
        }
        this.format.setProperty(GRID_LOCATION, string);
        return this.format.getText();
    }

    public String localizedLocationName(Point point) {
        this.format.setFormat(this.locationFormat);
        this.format.setProperty(NAME, this.getLocalizedConfigureName());
        String string = null;
        if (this.getGrid() != null) {
            string = this.getGrid().localizedLocationName(point);
        }
        this.format.setProperty(GRID_LOCATION, string);
        return this.format.getLocalizedText();
    }

    public boolean contains(Point point) {
        return this.myPolygon.contains(point);
    }

    public Point snapTo(Point point) {
        Point point2 = point;
        if (this.getGrid() != null) {
            point2 = this.getGrid().snapTo(point);
        }
        return point2;
    }

    @Override
    public Dimension getSize() {
        return this.myPolygon.getBounds().getSize();
    }

    @Override
    public void removeGrid(MapGrid mapGrid) {
        if (this.grid == mapGrid) {
            mapGrid = null;
        }
    }

    @Override
    public Board getBoard() {
        return this.parentGrid == null ? null : this.parentGrid.getBoard();
    }

    public Map getMap() {
        return this.parentGrid == null ? null : this.parentGrid.getBoard().getMap();
    }

    public ZonedGrid getParentGrid() {
        return this.parentGrid;
    }

    @Override
    public void setGrid(MapGrid mapGrid) {
        this.grid = mapGrid;
    }

    public MapGrid getGrid() {
        if (this.useParentGrid) {
            return this.parentGrid != null ? this.parentGrid.getBackgroundGrid() : null;
        }
        return this.grid;
    }

    public boolean isUseParentGrid() {
        return this.useParentGrid;
    }

    public Shape getShape() {
        return this.myPolygon;
    }

    public Rectangle getBounds() {
        return this.myPolygon.getBounds();
    }

    public void setHighlight(ZoneHighlight zoneHighlight) {
        this.highlighter = zoneHighlight;
    }

    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.getGrid() != null && this.getGrid().isVisible() || this.highlighter != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape = graphics2D.getClip();
            Area area = new Area(rectangle2);
            Shape shape2 = this.getCachedShape(this.myPolygon, rectangle.x, rectangle.y, d);
            area.intersect(new Area(shape2));
            graphics2D.setClip(area);
            if (this.getGrid() != null && this.getGrid().isVisible()) {
                this.getGrid().draw(graphics, rectangle, rectangle2, d, bl);
            }
            if (this.highlighter != null) {
                this.highlighter.draw(graphics2D, shape2, d);
            }
            graphics2D.setClip(shape);
        }
    }

    protected Shape getScaledShape(Polygon polygon, double d) {
        if (d == this.lastScale && this.lastPolygon == polygon && this.lastScaledShape != null) {
            return this.lastScaledShape;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        this.lastScaledShape = affineTransform.createTransformedShape(polygon);
        this.lastScale = d;
        this.lastPolygon = polygon;
        return this.lastScaledShape;
    }

    protected Shape getCachedShape(Polygon polygon, int n, int n2, double d) {
        if (polygon.equals(this.lastPolygon) && n == this.lastBoundsX && n2 == this.lastBoundsY && d == this.lastScale) {
            return this.lastTransformedShape;
        }
        Shape shape = this.getScaledShape(this.myPolygon, d);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        this.lastTransformedShape = affineTransform.createTransformedShape(shape);
        this.lastPolygon = this.myPolygon;
        this.lastBoundsX = n;
        this.lastBoundsY = n2;
        this.lastScale = d;
        return this.lastTransformedShape;
    }

    @Override
    public Object getProperty(Object object) {
        Object object2 = null;
        MutableProperty mutableProperty = this.propsContainer.getMutableProperty(String.valueOf(object));
        object2 = mutableProperty != null ? mutableProperty.getPropertyValue() : this.getMap().getProperty(object);
        return object2;
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        Object object2 = null;
        MutableProperty mutableProperty = this.propsContainer.getMutableProperty(String.valueOf(object));
        if (mutableProperty != null) {
            object2 = mutableProperty.getPropertyValue();
        }
        if (object2 == null) {
            object2 = this.getMap().getLocalizedProperty(object);
        }
        return object2;
    }

    @Override
    public MutableProperty getMutableProperty(String string) {
        return this.propsContainer.getMutableProperty(string);
    }

    @Override
    public String getMutablePropertiesContainerId() {
        return this.getMap().getMapName() + ":" + this.getConfigureName();
    }

    @Override
    public void setup(boolean bl) {
        if (bl) {
            if (this.useHighlight && this.highlightPropertyName.length() > 0) {
                this.highlightProperty = MutableProperty.Util.findMutableProperty(this.highlightPropertyName, Arrays.asList(this, this.getMap(), GameModule.getGameModule()));
                if (this.highlightProperty != null) {
                    if (this.highlightPropertyChangeListener == null) {
                        this.highlightPropertyChangeListener = new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                Zone.this.setHighlighter((String)propertyChangeEvent.getNewValue());
                            }
                        };
                    }
                    this.highlightProperty.addMutablePropertyChangeListener(this.highlightPropertyChangeListener);
                    this.setHighlighter(this.highlightProperty.getPropertyValue());
                }
            }
        } else if (this.highlightProperty != null && this.highlightPropertyChangeListener != null) {
            this.highlightProperty.removeMutablePropertyChangeListener(this.highlightPropertyChangeListener);
            this.highlightProperty = null;
        }
    }

    public void setHighlighter(String string) {
        this.highlighter = this.parentGrid.getZoneHighlight(string);
        this.repaint();
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    public static class Editor
    extends Configurer {
        private JButton button;
        private PolygonEditor editor;
        private Board board;
        private JDialog frame;
        protected AdjustableSpeedScrollPane scroll;
        protected Polygon savePoly;
        protected final JLabel warning = new JLabel("Zone has not been defined");

        public Editor(final Zone zone) {
            super(Zone.PATH, null);
            this.button = new JButton("Define Shape");
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.init(zone);
                }
            });
            this.editor = new PolygonEditor(new Polygon(zone.myPolygon.xpoints, zone.myPolygon.ypoints, zone.myPolygon.npoints)){
                private static final long serialVersionUID = 1L;

                protected void paintBackground(Graphics graphics) {
                    if (Editor.this.board != null) {
                        Rectangle rectangle = this.getVisibleRect();
                        graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        Editor.this.board.draw(graphics, 0, 0, 1.0, Editor.this.editor);
                    } else {
                        super.paintBackground(graphics);
                    }
                    Editor.this.warning.setVisible(Editor.this.editor != null && (Editor.this.editor.getPolygon() == null || ((Editor)Editor.this).editor.getPolygon().npoints == 0));
                }
            };
            this.frame = new JDialog((Frame)null, zone.getConfigureName(), true);
            this.frame.setLayout(new BoxLayout(this.frame.getContentPane(), 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(3, 2));
            jPanel.add(new JLabel("Drag to create initial shape"));
            jPanel.add(new JLabel("Right-click to add point"));
            jPanel.add(new JLabel("Left-click to move points"));
            jPanel.add(new JLabel("DEL to remove point"));
            this.warning.setForeground(Color.red);
            this.warning.setVisible(false);
            jPanel.add(this.warning);
            jPanel.setAlignmentX(0.0f);
            this.frame.add(jPanel);
            JButton jButton = new JButton("Set Coordinates directly");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(Editor.this.frame, "Enter x,y coordinates of polygon vertices,\nseparated by spaces", PolygonEditor.polygonToString(Editor.this.editor.getPolygon()).replace(';', ' '));
                    if (string != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        while (stringTokenizer.hasMoreTokens()) {
                            stringBuilder.append(stringTokenizer.nextToken());
                            if (!stringTokenizer.hasMoreTokens()) continue;
                            stringBuilder.append(';');
                        }
                        string = stringBuilder.toString();
                        PolygonEditor.reset(Editor.this.editor.getPolygon(), string);
                        Editor.this.editor.repaint();
                    }
                }
            });
            jButton.setAlignmentX(0.0f);
            this.frame.add(jButton);
            this.scroll = new AdjustableSpeedScrollPane(this.editor);
            this.editor.setScroll(this.scroll);
            this.frame.add(this.scroll);
            JPanel jPanel2 = new JPanel();
            JButton jButton2 = new JButton("Ok");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.setValue((Object)Editor.this.getValueString());
                    Editor.this.frame.setVisible(false);
                }
            });
            JButton jButton3 = new JButton("Cancel");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.editor.setPolygon(Editor.this.savePoly);
                    Editor.this.setValue((Object)Editor.this.getValueString());
                    Editor.this.frame.setVisible(false);
                }
            });
            jPanel2.add(jButton2);
            jPanel2.add(jButton3);
            this.frame.add(jPanel2);
        }

        private void init(Zone zone) {
            this.board = zone.getBoard();
            this.editor.setPreferredSize(this.board != null ? this.board.getSize() : DEFAULT_SIZE);
            this.editor.reset();
            this.savePoly = this.editor.clonePolygon();
            Rectangle rectangle = this.editor.getPolygon().getBounds();
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            if (!this.editor.getVisibleRect().contains(point)) {
                this.editor.center(point);
            }
            this.frame.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setSize(Math.min(this.frame.getWidth(), dimension.width * 2 / 3), Math.min(this.frame.getHeight(), dimension.height * 2 / 3));
            this.frame.setVisible(true);
        }

        public Component getControls() {
            return this.button;
        }

        public String getValueString() {
            return PolygonEditor.polygonToString(this.editor.getPolygon());
        }

        public void setValue(String string) {
            PolygonEditor.reset(this.editor.getPolygon(), string);
        }
    }

    public static class ShapeEditor
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new Editor((Zone)autoConfigurable);
        }
    }

    public static class LocationFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{Zone.NAME, Zone.GRID_LOCATION});
        }
    }
}

