/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.properties.ChangePropertyCommand;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.command.Command;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;

public interface MutableProperty {
    public String getPropertyValue();

    public Command setPropertyValue(String var1);

    public void addMutablePropertyChangeListener(PropertyChangeListener var1);

    public void removeMutablePropertyChangeListener(PropertyChangeListener var1);

    public MutablePropertiesContainer getParent();

    public static class Impl
    implements MutableProperty {
        private PropertyChangeSupport propSupport;
        private String value = "";
        private String propertyName;
        private MutablePropertiesContainer parent;

        public Impl(String string, Object object) {
            this.propertyName = string;
            this.propSupport = new PropertyChangeSupport(this);
        }

        public void addMutablePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void addTo(MutablePropertiesContainer mutablePropertiesContainer) {
            this.parent = mutablePropertiesContainer;
            this.parent.addMutableProperty(this.propertyName, this);
        }

        public void setPropertyName(String string) {
            if (this.parent != null) {
                this.parent.removeMutableProperty(this.propertyName);
                this.parent.addMutableProperty(string, this);
            }
            this.propertyName = string;
        }

        public void removeFromContainer() {
            if (this.parent != null) {
                this.parent.removeMutableProperty(this.propertyName);
            }
        }

        public String getPropertyValue() {
            return this.value;
        }

        public MutablePropertiesContainer getParent() {
            return this.parent;
        }

        public void removeMutablePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propSupport.removePropertyChangeListener(propertyChangeListener);
        }

        protected Command getChangeCommand(String string, String string2) {
            return new ChangePropertyCommand(this, this.propertyName, string, string2);
        }

        public Command setPropertyValue(String string) {
            if (string == null) {
                string = "";
            }
            String string2 = this.value;
            Command command = this.getChangeCommand(this.value, string);
            this.value = string;
            this.propSupport.firePropertyChange(this.propertyName, string2, string);
            return command;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Util {
        public static MutableProperty findMutableProperty(String string, List<MutablePropertiesContainer> list) {
            MutablePropertiesContainer mutablePropertiesContainer;
            MutableProperty mutableProperty = null;
            Iterator<MutablePropertiesContainer> iterator = list.iterator();
            while (iterator.hasNext() && (mutableProperty = (mutablePropertiesContainer = iterator.next()) == null ? null : mutablePropertiesContainer.getMutableProperty(string)) == null) {
            }
            return mutableProperty;
        }
    }
}

