/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.properties.EnumeratedPropertyPrompt;
import VASSAL.build.module.properties.IncrementProperty;
import VASSAL.build.module.properties.NumericPropertyPrompt;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.build.module.properties.PropertySetter;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class PropertyChangerConfigurer
extends Configurer {
    protected static final String PLAIN_TYPE = "Set value directly";
    protected static final String INCREMENT_TYPE = "Increment numeric value";
    protected static final String PROMPT_TYPE = "Prompt user";
    protected static final String SELECT_TYPE = "Prompt user to select from list";
    protected static final char PLAIN_CODE = 'P';
    protected static final char PROMPT_CODE = 'R';
    protected static final char ENUM_CODE = 'E';
    protected static final char INCR_CODE = 'I';
    protected static final Map<Class<? extends PropertyChanger>, Character> typeToCode = new HashMap<Class<? extends PropertyChanger>, Character>();
    protected static final Map<Class<? extends PropertyChanger>, String> typeToDescription = new HashMap<Class<? extends PropertyChanger>, String>();
    protected static final Map<String, Character> descriptionToCode = new HashMap<String, Character>();
    protected Constraints constraints;
    protected JPanel controls;
    protected StringEnumConfigurer typeConfig;
    protected StringConfigurer valueConfig;
    protected StringConfigurer promptConfig;
    protected StringConfigurer incrConfig;
    protected StringArrayConfigurer validValuesConfig;

    public PropertyChangerConfigurer(String string, String string2, Constraints constraints) {
        super(string, string2);
        this.constraints = constraints;
        this.setValue(new PropertySetter("", null));
    }

    public Component getControls() {
        if (this.controls == null) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PropertyChangerConfigurer.this.updateValue();
                    PropertyChangerConfigurer.this.updateControls();
                }
            };
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 0));
            this.typeConfig = new StringEnumConfigurer(null, "Type:  ", new String[]{PLAIN_TYPE, INCREMENT_TYPE, PROMPT_TYPE, SELECT_TYPE});
            this.typeConfig.addPropertyChangeListener(propertyChangeListener);
            this.valueConfig = new StringConfigurer(null, "New Value:  ");
            this.valueConfig.addPropertyChangeListener(propertyChangeListener);
            this.promptConfig = new StringConfigurer(null, "Prompt:  ");
            this.promptConfig.addPropertyChangeListener(propertyChangeListener);
            this.incrConfig = new StringConfigurer(null, "Increment by:  ");
            this.incrConfig.addPropertyChangeListener(propertyChangeListener);
            this.validValuesConfig = new StringArrayConfigurer(null, "Valid Values");
            this.validValuesConfig.addPropertyChangeListener(propertyChangeListener);
            this.controls.add(this.typeConfig.getControls());
            this.controls.add(this.valueConfig.getControls());
            this.controls.add(this.promptConfig.getControls());
            this.controls.add(this.incrConfig.getControls());
            this.controls.add(this.validValuesConfig.getControls());
            this.updateControls();
        }
        return this.controls;
    }

    protected void updateControls() {
        PropertyChanger propertyChanger = this.getPropertyChanger();
        this.typeConfig.setValue(typeToDescription.get(propertyChanger.getClass()));
        if (propertyChanger instanceof PropertySetter) {
            this.valueConfig.setValue(((PropertySetter)propertyChanger).getRawValue());
            this.valueConfig.getControls().setVisible(true);
        } else {
            this.valueConfig.getControls().setVisible(false);
        }
        if (propertyChanger instanceof IncrementProperty) {
            this.incrConfig.setValue(String.valueOf(((IncrementProperty)propertyChanger).getIncrement()));
            this.incrConfig.getControls().setVisible(true);
        } else {
            this.incrConfig.getControls().setVisible(false);
        }
        if (propertyChanger instanceof PropertyPrompt) {
            this.promptConfig.setValue(((PropertyPrompt)propertyChanger).getPrompt());
            this.promptConfig.getControls().setVisible(true);
        } else {
            this.promptConfig.getControls().setVisible(false);
        }
        if (propertyChanger instanceof EnumeratedPropertyPrompt) {
            this.validValuesConfig.setValue(((EnumeratedPropertyPrompt)propertyChanger).getValidValues());
            this.validValuesConfig.getControls().setVisible(true);
        } else {
            this.validValuesConfig.getControls().setVisible(false);
        }
    }

    protected void updateValue() {
        PropertyChanger propertyChanger;
        switch (descriptionToCode.get(this.typeConfig.getValueString()).charValue()) {
            case 'R': {
                propertyChanger = new PropertyPrompt(this.constraints, this.promptConfig.getValueString());
                break;
            }
            case 'I': {
                propertyChanger = new IncrementProperty(this, this.incrConfig.getValueString(), this.constraints);
                break;
            }
            case 'E': {
                propertyChanger = new EnumeratedPropertyPrompt(this.constraints, this.promptConfig.getValueString(), this.validValuesConfig.getStringArray());
                break;
            }
            default: {
                propertyChanger = new PropertySetter(this.valueConfig.getValueString(), this.constraints);
            }
        }
        this.setValue(propertyChanger);
    }

    public String getValueString() {
        PropertyChanger propertyChanger = this.getPropertyChanger();
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        if (propertyChanger != null) {
            switch (typeToCode.get(propertyChanger.getClass()).charValue()) {
                case 'R': {
                    sequenceEncoder.append('R').append(((PropertyPrompt)propertyChanger).getPrompt());
                    break;
                }
                case 'I': {
                    sequenceEncoder.append('I').append(((IncrementProperty)propertyChanger).getIncrement());
                    break;
                }
                case 'E': {
                    sequenceEncoder.append('E').append(((PropertyPrompt)propertyChanger).getPrompt()).append(((EnumeratedPropertyPrompt)propertyChanger).getValidValues());
                    break;
                }
                case 'P': {
                    sequenceEncoder.append('P').append(((PropertySetter)propertyChanger).getRawValue());
                }
            }
        }
        return sequenceEncoder.getValue();
    }

    public PropertyChanger getPropertyChanger() {
        return (PropertyChanger)this.getValue();
    }

    public void setValue(String string) {
        PropertyChanger propertyChanger;
        if (string == null || string.length() == 0) {
            string = Character.toString('P');
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        switch (decoder.nextChar('P')) {
            case 'R': {
                propertyChanger = new PropertyPrompt(this.constraints, decoder.nextToken("Enter new value"));
                break;
            }
            case 'I': {
                propertyChanger = new IncrementProperty(this, decoder.nextToken("1"), this.constraints);
                break;
            }
            case 'E': {
                propertyChanger = new EnumeratedPropertyPrompt(this.constraints, decoder.nextToken("Select new value"), decoder.nextStringArray(0));
                break;
            }
            default: {
                propertyChanger = new PropertySetter(decoder.nextToken("new value"), this.constraints);
            }
        }
        this.setValue(propertyChanger);
    }

    static {
        typeToCode.put(PropertySetter.class, new Character('P'));
        typeToCode.put(PropertyPrompt.class, new Character('R'));
        typeToCode.put(NumericPropertyPrompt.class, new Character('R'));
        typeToCode.put(IncrementProperty.class, new Character('I'));
        typeToCode.put(EnumeratedPropertyPrompt.class, new Character('E'));
        typeToDescription.put(PropertySetter.class, PLAIN_TYPE);
        typeToDescription.put(PropertyPrompt.class, PROMPT_TYPE);
        typeToDescription.put(NumericPropertyPrompt.class, PROMPT_TYPE);
        typeToDescription.put(IncrementProperty.class, INCREMENT_TYPE);
        typeToDescription.put(EnumeratedPropertyPrompt.class, SELECT_TYPE);
        descriptionToCode.put(PLAIN_TYPE, new Character('P'));
        descriptionToCode.put(INCREMENT_TYPE, new Character('I'));
        descriptionToCode.put(PROMPT_TYPE, new Character('R'));
        descriptionToCode.put(SELECT_TYPE, new Character('E'));
    }

    public static interface Constraints
    extends PropertyPrompt.Constraints,
    IncrementProperty.Constraints,
    PropertySource {
    }
}

