/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.turn.CounterTurnLevel;
import VASSAL.build.module.turn.ListTurnLevel;
import VASSAL.build.module.turn.TurnComponent;
import VASSAL.build.module.turn.TurnTracker;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TurnLevel
extends TurnComponent {
    protected static final String NAME = "name";
    protected static final String PROP = "property";
    protected static final String TURN_FORMAT = "turnFormat";
    protected static final String LEVEL_VALUE = "value";
    protected TurnTracker turn;
    protected JDialog setDialog;
    protected JPanel levelSetControls = null;
    protected Component childSetControls = null;
    protected TurnComponent parent = null;
    protected String propertyName;
    protected int start = 1;
    protected int current = 1;
    protected int currentSubLevel = 0;
    protected boolean subLevelRolledOver = false;
    protected boolean rolledOver = false;
    protected MutableProperty.Impl myValue = new MutableProperty.Impl("", this);
    protected FormattedString turnFormat = new FormattedString("$value$");
    private static final Dimension FILLER = new Dimension(0, 3);

    protected abstract String getState();

    protected abstract void setState(String var1);

    protected abstract String getValueString();

    protected abstract String getLongestValueName();

    protected abstract Component getSetControl();

    public void findMaximumStrings(List<String> list, int n) {
        String string = this.getLongestFormattedValue();
        if (list.size() < n + 1 || list.get(n) == null || list.get(n).length() < string.length()) {
            list.add(n, string);
        }
        for (Buildable buildable : this.getBuildables()) {
            if (!(buildable instanceof TurnLevel)) continue;
            ((TurnLevel)buildable).findMaximumStrings(list, n + 1);
        }
    }

    protected String getLongestFormattedValue() {
        this.turnFormat.setProperty(LEVEL_VALUE, this.getLongestValueName());
        return this.turnFormat.getText();
    }

    protected boolean hasSubLevelRolledOver() {
        return this.subLevelRolledOver;
    }

    protected boolean isActive() {
        return true;
    }

    protected void reset() {
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).reset();
        }
        this.currentSubLevel = 0;
    }

    protected void advance() {
        this.rolledOver = false;
        this.subLevelRolledOver = false;
        if (this.getTurnLevelCount() > 0) {
            TurnLevel turnLevel = this.getTurnLevel(this.currentSubLevel);
            turnLevel.advance();
            if (turnLevel.hasRolledOver()) {
                ++this.currentSubLevel;
                if (this.currentSubLevel >= this.getTurnLevelCount()) {
                    this.currentSubLevel = 0;
                    this.subLevelRolledOver = true;
                }
                this.getTurnLevel(this.currentSubLevel).setLow();
            }
        }
    }

    protected void retreat() {
        this.rolledOver = false;
        this.subLevelRolledOver = false;
        if (this.getTurnLevelCount() > 0) {
            TurnLevel turnLevel = this.getTurnLevel(this.currentSubLevel);
            turnLevel.retreat();
            if (turnLevel.hasRolledOver()) {
                --this.currentSubLevel;
                if (this.currentSubLevel < 0) {
                    this.currentSubLevel = this.getTurnLevelCount() - 1;
                    this.subLevelRolledOver = true;
                }
                this.getTurnLevel(this.currentSubLevel).setHigh();
            }
        }
    }

    public String getTurnString() {
        this.turnFormat.setProperty(LEVEL_VALUE, this.getValueString());
        return this.turnFormat.getText();
    }

    public List<TurnLevel> getActiveChildLevels() {
        ArrayList<TurnLevel> arrayList = new ArrayList<TurnLevel>();
        if (this.getTurnLevelCount() > 0) {
            TurnLevel turnLevel = this.getTurnLevel(this.currentSubLevel);
            arrayList.add(turnLevel);
            arrayList.addAll(turnLevel.getActiveChildLevels());
        }
        return arrayList;
    }

    protected void buildConfigMenu(JMenu jMenu) {
        JMenu jMenu2 = this.getConfigMenu();
        if (jMenu2 != null) {
            jMenu.add(jMenu2);
        }
    }

    protected JMenu getConfigMenu() {
        JMenu jMenu = new JMenu(this.getConfigureName());
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).buildConfigMenu(jMenu);
        }
        return jMenu.getItemCount() == 0 ? null : jMenu;
    }

    public boolean isConfigurable() {
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            if (!this.getTurnLevel(i).isConfigurable()) continue;
            return true;
        }
        return false;
    }

    protected Component getSetControls(JDialog jDialog, TurnTracker turnTracker) {
        this.turn = turnTracker;
        this.setDialog = jDialog;
        this.levelSetControls = new JPanel();
        this.levelSetControls.setLayout(new BoxLayout(this.levelSetControls, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add(Box.createRigidArea(FILLER));
        jPanel.add(this.getSetControl());
        jPanel.add(Box.createRigidArea(FILLER));
        if (this.getTurnLevelCount() > 1) {
            String[] stringArray = new String[this.getTurnLevelCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.getTurnLevel(i).getConfigureName();
            }
            StringEnumConfigurer stringEnumConfigurer = new StringEnumConfigurer(null, " Select:  ", stringArray);
            stringEnumConfigurer.setValue(this.getTurnLevel(this.currentSubLevel).getConfigureName());
            stringEnumConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = ((StringEnumConfigurer)propertyChangeEvent.getSource()).getValueString();
                    for (int i = 0; i < TurnLevel.this.getTurnLevelCount(); ++i) {
                        if (!string.equals(TurnLevel.this.getTurnLevel(i).getConfigureName())) continue;
                        TurnLevel.this.currentSubLevel = i;
                        TurnLevel.this.addChildControls();
                    }
                }
            });
            jPanel.add(stringEnumConfigurer.getControls());
            jPanel.add(Box.createRigidArea(FILLER));
        }
        this.levelSetControls.add(jPanel);
        this.levelSetControls.add(Box.createRigidArea(FILLER));
        this.addChildControls();
        return this.levelSetControls;
    }

    protected void addChildControls() {
        if (this.childSetControls != null) {
            this.levelSetControls.remove(this.childSetControls);
        }
        if (this.getTurnLevelCount() > 0) {
            this.childSetControls = this.getTurnLevel(this.currentSubLevel).getSetControls(this.setDialog, this.turn);
            this.levelSetControls.add(this.childSetControls);
            this.setDialog.pack();
        }
    }

    protected TurnTracker getTurn() {
        return this.turn;
    }

    protected void setRolledOver(boolean bl) {
        this.rolledOver = bl;
    }

    protected boolean hasRolledOver() {
        return this.rolledOver;
    }

    protected void setLow() {
        if (this.getTurnLevelCount() > 0) {
            this.currentSubLevel = 0;
            this.getTurnLevel(this.currentSubLevel).setLow();
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    protected void setHigh() {
        if (this.getTurnLevelCount() > 0) {
            this.currentSubLevel = this.getTurnLevelCount() - 1;
            this.getTurnLevel(this.currentSubLevel).setHigh();
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Description:  ", "Property Name:  ", "Turn Level Format ($levelx$):  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, TurnFormatConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, PROP, TURN_FORMAT};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (PROP.equals(string)) {
            this.propertyName = (String)object;
            this.myValue.setPropertyName(this.propertyName);
        } else if (TURN_FORMAT.equals(string)) {
            this.turnFormat.setFormat((String)object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (TURN_FORMAT.equals(string)) {
            return this.turnFormat.getFormat();
        }
        if (PROP.equals(string)) {
            return this.propertyName;
        }
        return "";
    }

    @Override
    public void addTo(Buildable buildable) {
        this.parent = (TurnComponent)buildable;
        ((TurnComponent)buildable).addLevel(this);
        MutableProperty.Impl impl = (MutableProperty.Impl)GameModule.getGameModule().getMutableProperty(this.propertyName);
        if (impl == null) {
            this.myValue.addTo(GameModule.getGameModule());
        } else {
            this.myValue = impl;
        }
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((TurnComponent)buildable).removeLevel(this);
        this.myValue.removeFromContainer();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{CounterTurnLevel.class, ListTurnLevel.class};
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData componentI18nData = super.getI18nData();
        componentI18nData.setAttributeTranslatable(PROP, false);
        return componentI18nData;
    }

    public static class TurnFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{TurnLevel.LEVEL_VALUE});
        }
    }
}

