/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.turn.CounterTurnLevel;
import VASSAL.build.module.turn.ListTurnLevel;
import VASSAL.build.module.turn.TurnComponent;
import VASSAL.build.module.turn.TurnGlobalHotkey;
import VASSAL.build.module.turn.TurnLevel;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.IconButton;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurnTracker
extends TurnComponent
implements CommandEncoder,
GameComponent,
ActionListener,
UniqueIdManager.Identifyable {
    protected static UniqueIdManager idMgr = new UniqueIdManager("TurnTracker");
    protected static final String COMMAND_PREFIX = "TURN";
    public static final String NAME = "name";
    public static final String HOT_KEY = "hotkey";
    public static final String NEXT_HOT_KEY = "nexthotkey";
    public static final String PREV_HOT_KEY = "prevhotkey";
    public static final String ICON = "icon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String BUTTON_TOOLTIP = "buttonTooltip";
    public static final String TURN_FORMAT = "turnFormat";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String TOOLTIP = "tooltip";
    public static final String LENGTH = "length";
    public static final String LENGTH_STYLE = "lengthStyle";
    protected static final String FONT_SIZE = "turnFontSize";
    protected static final String FONT_BOLD = "turnFontBold";
    protected static final String DOCKED = "turnDocked";
    protected static final String OLD_TURN = "oldTurn";
    protected static final String NEW_TURN = "newTurn";
    protected static final String LEVEL = "level";
    protected static final String TURN_FONT = "Dialog";
    protected static String SET_COMMAND;
    protected static String DOCK_COMMAND;
    protected static String UNDOCK_COMMAND;
    protected static final String NEXT = "Next";
    protected static final String PREV = "Prev";
    protected static final String SET = "Set";
    protected static final String PROP_VALUE = "_value";
    protected static final String PROP_COMMAND = "_command";
    protected static final String[] FONT_FAMILYS;
    protected static final String LENGTH_VARIABLE = "Variable";
    protected static final String LENGTH_MAXIMUM = "Maximum";
    protected static final String LENGTH_FIXED = "Fixed";
    protected FormattedString turnFormat = new FormattedString("$level1$ $level2$ $level3$ $level4$");
    protected FormattedString reportFormat = new FormattedString("* <$playerId$> Turn Updated from $oldTurn$ to $newTurn$");
    protected TurnWindow turnWindow;
    protected TurnWidget turnWidget;
    protected JPanel launchWidget;
    protected SetDialog setDialog;
    protected LaunchButton launch;
    protected KeyStrokeListener nextListener;
    protected KeyStrokeListener prevListener;
    protected String savedState = "";
    protected String savedSetState = "";
    protected String savedTurn = "";
    protected JPopupMenu popup;
    protected int currentLevel = 0;
    protected String id;
    protected int width = -1;
    protected String lengthStyle = "Maximum";
    protected MutableProperty.Impl lastCommand = new MutableProperty.Impl("Set", this);
    protected MutableProperty.Impl lastTurn = new MutableProperty.Impl("", this);
    private static final Dimension FILLER;

    public TurnTracker() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!TurnTracker.this.isDocked()) {
                    TurnTracker.this.turnWindow.setControls();
                    TurnTracker.this.turnWindow.setVisible(!TurnTracker.this.turnWindow.isShowing());
                    TurnTracker.this.turnWindow.setFocusable(true);
                }
            }
        };
        this.setConfigureName(Resources.getString("TurnTracker.turn"));
        this.launch = new LaunchButton(Resources.getString("TurnTracker.turn"), BUTTON_TOOLTIP, BUTTON_TEXT, HOT_KEY, ICON, actionListener);
        this.launch.setToolTipText(Resources.getString("TurnTracker.turn_tracker"));
        SET_COMMAND = Resources.getString("TurnTracker.set_turn");
        DOCK_COMMAND = Resources.getString("General.dock");
        UNDOCK_COMMAND = Resources.getString("General.undock");
        IntConfigurer intConfigurer = new IntConfigurer(FONT_SIZE, Resources.getString("TurnTracker.size_pref"), new Integer(14));
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(FONT_BOLD, Resources.getString("TurnTracker.bold_pref"), Boolean.FALSE);
        BooleanConfigurer booleanConfigurer2 = new BooleanConfigurer(DOCKED, Resources.getString("TurnTracker.docked_pref"), Boolean.FALSE);
        String string = Resources.getString("TurnTracker.turn_counter");
        GameModule.getGameModule().getPrefs().addOption(string, intConfigurer);
        GameModule.getGameModule().getPrefs().addOption(string, booleanConfigurer);
        GameModule.getGameModule().getPrefs().addOption(string, booleanConfigurer2);
        intConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TurnTracker.this.setDisplayFont();
            }
        });
        booleanConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TurnTracker.this.setDisplayFont();
            }
        });
        booleanConfigurer2.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TurnTracker.this.setDocked(TurnTracker.this.isDocked());
            }
        });
        this.nextListener = new KeyStrokeListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TurnTracker.this.turnWidget.doNext();
            }
        });
        GameModule.getGameModule().addKeyStrokeListener(this.nextListener);
        this.prevListener = new KeyStrokeListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TurnTracker.this.turnWidget.doPrev();
            }
        });
        GameModule.getGameModule().addKeyStrokeListener(this.prevListener);
        this.turnWidget = new TurnWidget();
    }

    public String getState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        sequenceEncoder.append(this.currentLevel);
        Iterator<TurnLevel> iterator = this.getTurnLevels();
        while (iterator.hasNext()) {
            TurnLevel turnLevel = iterator.next();
            sequenceEncoder.append(turnLevel.getState());
        }
        return sequenceEncoder.getValue();
    }

    public void setState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        this.currentLevel = decoder.nextInt(0);
        Iterator<TurnLevel> iterator = this.getTurnLevels();
        while (iterator.hasNext()) {
            TurnLevel turnLevel = iterator.next();
            turnLevel.setState(decoder.nextToken(""));
        }
        this.setLaunchToolTip();
        this.updateTurnDisplay(SET);
    }

    protected void setLaunchToolTip() {
        this.launch.setToolTipText(this.getTurnString());
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, BUTTON_TEXT, ICON, BUTTON_TOOLTIP, HOT_KEY, NEXT_HOT_KEY, PREV_HOT_KEY, TURN_FORMAT, REPORT_FORMAT, TOOLTIP, LENGTH_STYLE, LENGTH};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.clearGlobalProperties();
            this.setConfigureName((String)object);
            this.lastCommand.setPropertyName(this.getConfigureName() + PROP_COMMAND);
            this.lastTurn.setPropertyName(this.getConfigureName() + PROP_VALUE);
        } else if (REPORT_FORMAT.equals(string)) {
            this.reportFormat.setFormat((String)object);
        } else if (TURN_FORMAT.equals(string)) {
            this.turnFormat.setFormat((String)object);
        } else if (TOOLTIP.equals(string)) {
            this.turnWidget.setLabelToolTipText((String)object);
        } else if (LENGTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.width = (Integer)object;
        } else if (LENGTH_STYLE.equals(string)) {
            this.lengthStyle = (String)object;
            if (LENGTH_VARIABLE.equals(this.lengthStyle)) {
                this.width = 0;
            } else if (LENGTH_MAXIMUM.equals(this.lengthStyle)) {
                this.width = -1;
            }
        } else if (NEXT_HOT_KEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.nextListener.setKeyStroke((KeyStroke)object);
            this.turnWidget.setNextStroke((KeyStroke)object);
        } else if (PREV_HOT_KEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.prevListener.setKeyStroke((KeyStroke)object);
            this.turnWidget.setPrevStroke((KeyStroke)object);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    protected void setWidgetWidth() {
        if (LENGTH_FIXED.equals(this.lengthStyle)) {
            this.turnWidget.setWidth(this.width);
        } else if (LENGTH_MAXIMUM.equals(this.lengthStyle)) {
            this.turnWidget.setWidth(this.getMaximumWidth());
        } else {
            this.turnWidget.setWidth(0);
        }
    }

    protected int getMaximumWidth() {
        String string = this.getMaximumTurnString();
        int n = this.turnWidget.getWidth(string);
        return n + 2;
    }

    protected void setDisplayFont() {
        this.turnWidget.setLabelFont(this.getDisplayFont());
        if (!this.isDocked() && this.turnWindow != null) {
            this.turnWindow.pack();
        }
    }

    protected Font getDisplayFont() {
        int n = this.getFontStyle();
        int n2 = this.getFontSize();
        return new Font(TURN_FONT, n, n2);
    }

    protected void setFontSize() {
        this.setDisplayFont();
    }

    protected int getFontSize() {
        return (Integer)GameModule.getGameModule().getPrefs().getValue(FONT_SIZE);
    }

    protected int getFontStyle() {
        return (Boolean)GameModule.getGameModule().getPrefs().getValue(FONT_BOLD) != false ? 1 : 0;
    }

    protected boolean isDocked() {
        return (Boolean)GameModule.getGameModule().getPrefs().getValue(DOCKED);
    }

    protected void setDocked(boolean bl) {
        GameModule.getGameModule().getPrefs().setValue(DOCKED, bl);
        this.launch.setVisible(!bl);
        if (bl) {
            this.turnWindow.setWidget(null);
            this.turnWindow.setVisible(false);
            this.launchWidget.add((Component)this.turnWidget, "Center");
            this.launchWidget.setVisible(GameModule.getGameModule().getGameState().isGameStarted());
        } else {
            this.launchWidget.setVisible(false);
            this.launchWidget.remove(this.turnWidget);
            this.turnWindow.setWidget(this.turnWidget);
            this.turnWindow.setVisible(GameModule.getGameModule().getGameState().isGameStarted());
            this.turnWindow.setFocusable(true);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName() + "";
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.reportFormat.getFormat();
        }
        if (TURN_FORMAT.equals(string)) {
            return this.turnFormat.getFormat();
        }
        if (TOOLTIP.equals(string)) {
            return this.turnWidget.getLabelToolTipText();
        }
        if (LENGTH.equals(string)) {
            return String.valueOf(this.width);
        }
        if (LENGTH_STYLE.equals(string)) {
            return this.lengthStyle;
        }
        if (NEXT_HOT_KEY.equals(string)) {
            return HotKeyConfigurer.encode(this.nextListener.getKeyStroke());
        }
        if (PREV_HOT_KEY.equals(string)) {
            return HotKeyConfigurer.encode(this.prevListener.getKeyStroke());
        }
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Button text:  ", "Button Icon:  ", "Button Tooltip:  ", "Show/hide Hotkey:  ", "Next Turn Hotkey:  ", "Previous Turn Hotkey:  ", "Turn Name Format:  ", "Report Format:  ", "Turn Label Tooltip Text:  ", "Turn Label Length:  ", "Turn label Display length:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, String.class, KeyStroke.class, KeyStroke.class, KeyStroke.class, TurnFormatConfig.class, ReportFormatConfig.class, String.class, LengthStyleConfig.class, Integer.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (LENGTH.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return TurnTracker.LENGTH_FIXED.equals(TurnTracker.this.lengthStyle);
                }
            };
        }
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{CounterTurnLevel.class, ListTurnLevel.class, TurnGlobalHotkey.class};
    }

    public static String getConfigureTypeName() {
        return "Turn Counter";
    }

    @Override
    public void addTo(Buildable buildable) {
        this.turnWindow = new TurnWindow();
        this.turnWindow.pack();
        this.turnWindow.setVisible(false);
        this.launchWidget = new JPanel();
        this.launchWidget.setLayout(new BorderLayout());
        this.launchWidget.setBorder(BorderFactory.createEtchedBorder());
        GameModule.getGameModule().getToolBar().add(this.launchWidget);
        this.launchWidget.setAlignmentY(0.0f);
        this.launchWidget.setVisible(false);
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.launch.setAlignmentY(0.0f);
        this.launch.setEnabled(false);
        this.setDocked(this.isDocked());
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        idMgr.add(this);
        this.lastCommand.addTo((MutablePropertiesContainer)((Object)buildable));
        this.lastTurn.addTo((MutablePropertiesContainer)((Object)buildable));
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
        GameModule.getGameModule().getToolBar().remove(this.launchWidget);
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        this.lastCommand.removeFromContainer();
        this.lastTurn.removeFromContainer();
        this.clearGlobalProperties();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.htm");
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected void captureState() {
        this.savedState = this.getState();
        this.savedTurn = this.getTurnString();
    }

    protected void save() {
        if (!this.savedState.equals(this.getState())) {
            this.reportFormat.setProperty(OLD_TURN, this.savedTurn);
            this.reportFormat.setProperty(NEW_TURN, this.getTurnString());
            String string = this.updateString(this.reportFormat.getText(), new String[]{"\\n", "\\t"}, new String[]{" - ", " "});
            Chatter.DisplayText displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + string);
            displayText.execute();
            displayText.append(new SetTurn(this, this.savedState));
            GameModule.getGameModule().sendAndLog(displayText);
            this.setLaunchToolTip();
        }
        this.captureState();
    }

    protected String getMaximumTurnString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Buildable buildable : this.getBuildables()) {
            if (!(buildable instanceof TurnLevel)) continue;
            ((TurnLevel)buildable).findMaximumStrings(arrayList, 0);
        }
        this.turnFormat.clearProperties();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.turnFormat.setProperty(LEVEL + (i + 1), (String)arrayList.get(i));
        }
        return this.turnFormat.getText(GameModule.getGameModule());
    }

    protected String getTurnString() {
        this.turnFormat.clearProperties();
        List<TurnLevel> list = this.getActiveChildLevels();
        for (int i = 0; i < 15; ++i) {
            this.turnFormat.setProperty(LEVEL + (i + 1), i < list.size() ? list.get(i).getTurnString() : "");
        }
        return this.turnFormat.getText(GameModule.getGameModule());
    }

    protected List<TurnLevel> getActiveChildLevels() {
        ArrayList<TurnLevel> arrayList = new ArrayList<TurnLevel>();
        TurnLevel turnLevel = this.getTurnLevel(this.currentLevel);
        if (turnLevel != null) {
            arrayList.add(turnLevel);
            arrayList.addAll(turnLevel.getActiveChildLevels());
        }
        return arrayList;
    }

    protected int getLevelCount() {
        return this.getActiveChildLevels().size();
    }

    protected void next() {
        if (this.getTurnLevelCount() == 0) {
            return;
        }
        TurnLevel turnLevel = this.getTurnLevel(this.currentLevel);
        turnLevel.advance();
        if (turnLevel.hasRolledOver()) {
            ++this.currentLevel;
            if (this.currentLevel >= this.getTurnLevelCount()) {
                this.currentLevel = 0;
            }
            this.getTurnLevel(this.currentLevel).setLow();
        }
        this.updateTurnDisplay(NEXT);
        this.doGlobalkeys();
    }

    protected void prev() {
        if (this.getTurnLevelCount() == 0) {
            return;
        }
        TurnLevel turnLevel = this.getTurnLevel(this.currentLevel);
        turnLevel.retreat();
        if (turnLevel.hasRolledOver()) {
            --this.currentLevel;
            if (this.currentLevel < 0) {
                this.currentLevel = this.getTurnLevelCount() - 1;
            }
            this.getTurnLevel(this.currentLevel).setHigh();
        }
        this.updateTurnDisplay(PREV);
        this.doGlobalkeys();
    }

    protected void doGlobalkeys() {
        for (TurnGlobalHotkey turnGlobalHotkey : this.getComponentsOf(TurnGlobalHotkey.class)) {
            turnGlobalHotkey.apply();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SET_COMMAND)) {
            this.set();
        } else if (string.equals(DOCK_COMMAND)) {
            this.setDocked(true);
        } else if (string.equals(UNDOCK_COMMAND)) {
            this.setDocked(false);
        }
    }

    protected void set() {
        this.savedSetState = this.getState();
        if (this.setDialog == null) {
            this.setDialog = new SetDialog();
            this.setDialog.setTitle(Resources.getString("TurnTracker.set_turn2", this.getConfigureName()));
        }
        this.setDialog.setControls(this);
        this.setDialog.setVisible(true);
    }

    protected void updateTurnDisplay(String string) {
        this.lastCommand.setPropertyValue(string);
        this.lastTurn.setPropertyValue(this.getTurnString());
        this.turnWidget.setControls();
        this.turnWidget.repaint();
        this.turnWindow.pack();
        this.turnWindow.setFocusable(true);
        this.turnWindow.requestFocus();
    }

    protected void clearGlobalProperties() {
        this.lastCommand.setPropertyValue(null);
        this.lastTurn.setPropertyValue(null);
    }

    @Override
    public Command decode(String string) {
        SetTurn setTurn = null;
        if (string.startsWith(COMMAND_PREFIX + this.getId())) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken("");
            setTurn = new SetTurn(decoder.nextToken(""), this);
        }
        return setTurn;
    }

    @Override
    public String encode(Command command) {
        String string = null;
        if (command instanceof SetTurn) {
            SetTurn setTurn = (SetTurn)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            sequenceEncoder.append(COMMAND_PREFIX + setTurn.getTurn().getId());
            sequenceEncoder.append(setTurn.newState);
            return sequenceEncoder.getValue();
        }
        return string;
    }

    @Override
    public void setup(boolean bl) {
        this.launch.setEnabled(bl);
        this.turnWindow.setVisible(false);
        this.launchWidget.setVisible(this.isDocked() && bl);
        if (bl) {
            this.lastCommand.setPropertyValue(SET);
            this.lastTurn.setPropertyValue("");
            this.turnWidget.setControls();
            this.setWidgetWidth();
        } else {
            this.reset();
        }
    }

    protected void reset() {
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).reset();
        }
        this.currentLevel = 0;
        this.setLaunchToolTip();
        this.clearGlobalProperties();
    }

    public String updateString(String string, String[] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.replace(stringBuilder, stringArray[i], stringArray2[i]);
        }
        return stringBuilder.toString();
    }

    public void replace(StringBuilder stringBuilder, String string, String string2) {
        int n = stringBuilder.indexOf(string);
        while (n >= 0) {
            stringBuilder = stringBuilder.replace(n, n + 2, string2);
            n = stringBuilder.indexOf(string);
        }
    }

    @Deprecated
    public void replace(StringBuffer stringBuffer, String string, String string2) {
        int n = stringBuffer.indexOf(string);
        while (n >= 0) {
            stringBuffer = stringBuffer.replace(n, n + 2, string2);
            n = stringBuffer.indexOf(string);
        }
    }

    @Override
    public Command getRestoreCommand() {
        return new SetTurn(this.getState(), this);
    }

    protected void buildPopup() {
        this.popup = new JPopupMenu();
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                TurnTracker.this.turnWidget.repaint();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                TurnTracker.this.turnWidget.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        JMenuItem jMenuItem = this.isDocked() ? new JMenuItem(UNDOCK_COMMAND) : new JMenuItem(DOCK_COMMAND);
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem(SET_COMMAND);
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        JMenu jMenu = new JMenu(Resources.getString("TurnTracker.configure"));
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).buildConfigMenu(jMenu);
        }
        if (jMenu.getItemCount() > 0) {
            this.popup.add(jMenu);
        }
    }

    protected void addItem(JMenu jMenu, String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
    }

    protected void cancelSet() {
        this.setState(this.savedSetState);
        this.turnWindow.setVisible(true);
        this.turnWindow.setFocusable(true);
    }

    protected void saveSet() {
        this.save();
        this.updateTurnDisplay(SET);
        this.doGlobalkeys();
    }

    static {
        FONT_FAMILYS = new String[]{TURN_FONT, "DialogInput", "Monospaced", "SanSerif", "Serif"};
        FILLER = new Dimension(0, 3);
    }

    public static class SetTurn
    extends Command {
        private String oldState;
        private String newState;
        private TurnTracker turn;

        public SetTurn(String string, TurnTracker turnTracker) {
            this.newState = string;
            this.oldState = turnTracker.getState();
            this.turn = turnTracker;
        }

        public SetTurn(TurnTracker turnTracker, String string) {
            this.newState = turnTracker.getState();
            this.oldState = string;
            this.turn = turnTracker;
        }

        public TurnTracker getTurn() {
            return this.turn;
        }

        protected void executeCommand() {
            this.turn.setState(this.newState);
        }

        protected Command myUndoCommand() {
            return new SetTurn(this.oldState, this.turn);
        }
    }

    protected class SetDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected JPanel panel;
        protected JPanel controls;
        protected JPanel levelControls;
        protected Component childControls;
        protected TurnTracker turn;
        protected JDialog me;

        protected SetDialog() {
            super(GameModule.getGameModule().getFrame());
            this.controls = null;
            this.levelControls = null;
            this.childControls = null;
            this.initComponents();
            this.setLocation(100, 100);
            this.me = this;
        }

        protected void initComponents() {
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TurnTracker.this.cancelSet();
                    SetDialog.this.setVisible(false);
                }
            });
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.add(this.panel);
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(Resources.getString("General.save"));
            jButton.setToolTipText(Resources.getString("TurnTracker.save_changes"));
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TurnTracker.this.saveSet();
                    SetDialog.this.setVisible(false);
                }
            });
            JButton jButton2 = new JButton(Resources.getString("General.cancel"));
            jButton2.setToolTipText(Resources.getString("TurnTracker.discard_changes"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TurnTracker.this.cancelSet();
                    SetDialog.this.setVisible(false);
                }
            });
            jPanel.add(jButton2);
            this.add(jPanel);
        }

        public void setControls(TurnTracker turnTracker) {
            this.turn = turnTracker;
            if (this.controls != null) {
                this.panel.remove(this.controls);
            }
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.levelControls = new JPanel();
            this.levelControls.setLayout(new BoxLayout(this.levelControls, 1));
            if (TurnTracker.this.getTurnLevelCount() > 1) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
                String[] stringArray = new String[TurnTracker.this.getTurnLevelCount()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TurnTracker.this.getTurnLevel(i).getConfigureName();
                }
                StringEnumConfigurer stringEnumConfigurer = new StringEnumConfigurer(null, Resources.getString("TurnTracker.select"), stringArray);
                stringEnumConfigurer.setValue(TurnTracker.this.getTurnLevel(TurnTracker.this.currentLevel).getConfigureName());
                stringEnumConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        String string = ((StringEnumConfigurer)propertyChangeEvent.getSource()).getValueString();
                        for (int i = 0; i < TurnTracker.this.getTurnLevelCount(); ++i) {
                            if (!string.equals(TurnTracker.this.getTurnLevel(i).getConfigureName())) continue;
                            TurnTracker.this.currentLevel = i;
                            TurnTracker.this.updateTurnDisplay(TurnTracker.SET);
                            SetDialog.this.addChildControls();
                        }
                    }
                });
                jPanel.add(Box.createRigidArea(FILLER));
                jPanel.add(stringEnumConfigurer.getControls());
                jPanel.add(Box.createRigidArea(FILLER));
                this.levelControls.add(jPanel);
                this.levelControls.add(Box.createRigidArea(FILLER));
            }
            this.addChildControls();
            this.controls.add(this.levelControls);
            this.panel.add(this.controls);
            this.pack();
        }

        protected void addChildControls() {
            if (this.childControls != null) {
                this.levelControls.remove(this.childControls);
            }
            this.childControls = TurnTracker.this.getTurnLevel(TurnTracker.this.currentLevel).getSetControls(this.me, this.turn);
            this.levelControls.add(this.childControls);
            this.pack();
        }
    }

    protected class TurnWidget
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        private IconButton nextButton;
        private IconButton prevButton;
        protected final int BUTTON_SIZE = 22;
        protected JLabel turnLabel = new JLabel();

        protected TurnWidget() {
            this.initComponents();
        }

        public void setLabelFont(Font font) {
            this.turnLabel.setFont(font);
        }

        public void setWidth(int n) {
            if (n > 0) {
                this.turnLabel.setMinimumSize(new Dimension(n, 22));
                this.turnLabel.setPreferredSize(new Dimension(n, 22));
            } else {
                this.turnLabel.setMinimumSize(null);
                this.turnLabel.setPreferredSize(null);
            }
        }

        public void setLabelToolTipText(String string) {
            this.turnLabel.setToolTipText(string);
        }

        public String getLabelToolTipText() {
            return this.turnLabel.getToolTipText();
        }

        public Color getColor() {
            return this.turnLabel.getBackground();
        }

        public int getWidth(String string) {
            return this.turnLabel.getGraphics().getFontMetrics().stringWidth(string);
        }

        protected void doNext() {
            TurnTracker.this.captureState();
            TurnTracker.this.next();
            TurnTracker.this.save();
        }

        protected void doPrev() {
            TurnTracker.this.captureState();
            TurnTracker.this.prev();
            TurnTracker.this.save();
        }

        protected void initComponents() {
            this.setLayout(new BorderLayout(5, 5));
            this.nextButton = new IconButton(0, 22);
            this.setNextStroke(TurnTracker.this.nextListener.getKeyStroke());
            this.nextButton.setAlignmentY(0.0f);
            this.nextButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TurnWidget.this.doNext();
                }
            });
            this.prevButton = new IconButton(1, 22);
            this.setPrevStroke(TurnTracker.this.prevListener.getKeyStroke());
            this.prevButton.setAlignmentY(0.0f);
            this.prevButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TurnWidget.this.doPrev();
                }
            });
            this.turnLabel.setFont(TurnTracker.this.getDisplayFont());
            this.turnLabel.setFocusable(false);
            this.turnLabel.setHorizontalTextPosition(0);
            this.turnLabel.setHorizontalAlignment(0);
            this.turnLabel.addMouseListener(this);
            this.turnLabel.setBackground(Color.WHITE);
            this.turnLabel.setToolTipText(Resources.getString("TurnTracker.click_to_configure"));
            this.add((Component)this.prevButton, "Before");
            this.add((Component)this.turnLabel, "Center");
            this.add((Component)this.nextButton, "After");
            this.addMouseListener(this);
        }

        public void setNextStroke(KeyStroke keyStroke) {
            String string = Resources.getString("TurnTracker.next_turn") + (keyStroke == null ? "" : " [" + HotKeyConfigurer.getString(keyStroke) + "]");
            this.nextButton.setToolTipText(string);
        }

        public void setPrevStroke(KeyStroke keyStroke) {
            String string = Resources.getString("TurnTracker.prev_turn") + (keyStroke == null ? "" : " [" + HotKeyConfigurer.getString(keyStroke) + "]");
            this.prevButton.setToolTipText(string);
        }

        public void setControls() {
            String string = TurnTracker.this.updateString(TurnTracker.this.getTurnString(), new String[]{"\\n", "\\t"}, new String[]{"\n", "    "});
            this.turnLabel.setText(string);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isMetaDown()) {
                this.doPopup(mouseEvent.getPoint());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void doPopup(Point point) {
            TurnTracker.this.buildPopup();
            if (this.isShowing()) {
                TurnTracker.this.popup.show(this, point.x, point.y);
            }
        }
    }

    protected class TurnWindow
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected TurnWidget widget;

        protected TurnWindow() {
            super(GameModule.getGameModule().getFrame());
            this.setTitle(TurnTracker.this.getConfigureName());
            this.pack();
            this.setLocation(100, 100);
            this.setFocusable(true);
        }

        protected void setWidget(TurnWidget turnWidget) {
            if (turnWidget == null) {
                if (this.widget != null) {
                    this.remove(this.widget);
                }
            } else {
                this.add(turnWidget);
            }
            this.pack();
        }

        protected void setControls() {
            if (this.widget != null) {
                this.widget.setControls();
            }
            this.pack();
        }
    }

    public static class LengthStyleConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{TurnTracker.LENGTH_VARIABLE, TurnTracker.LENGTH_FIXED, TurnTracker.LENGTH_MAXIMUM};
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{TurnTracker.OLD_TURN, TurnTracker.NEW_TURN});
        }
    }

    public static class TurnFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            TurnTracker turnTracker = (TurnTracker)autoConfigurable;
            String[] stringArray = new String[turnTracker.getLevelCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = TurnTracker.LEVEL + (i + 1);
            }
            return new FormattedStringConfigurer(string, string2, stringArray);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((TurnTracker)autoConfigurable).launch.getAttributeValueString(TurnTracker.ICON));
        }
    }
}

