/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxWidget
extends Widget
implements ItemListener,
PropertyChangeListener {
    private JPanel panel;
    private JComboBox box;
    private DefaultComboBoxModel widgets = new DefaultComboBoxModel();
    private CardLayout layout = new CardLayout();
    private JPanel multiPanel = new JPanel();
    private List<Widget> built = new ArrayList<Widget>();
    private Dimension size = new Dimension();
    private Map<Object, String> keys = new HashMap<Object, String>();
    private int count = 0;

    public static String getConfigureTypeName() {
        return "Pull-down Menu";
    }

    @Override
    public void add(Buildable buildable) {
        if (buildable instanceof Widget) {
            Widget widget = (Widget)buildable;
            this.widgets.addElement(widget);
            widget.addPropertyChangeListener(this);
            if (this.panel != null) {
                this.multiPanel.add(this.getKey(widget), widget.getComponent());
            }
        }
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        if (buildable instanceof Widget) {
            this.widgets.removeElement(buildable);
        }
        super.remove(buildable);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("name".equals(propertyChangeEvent.getPropertyName()) && this.box != null) {
            this.box.revalidate();
        }
    }

    @Override
    public Component getComponent() {
        if (this.panel == null) {
            this.rebuild();
            this.box = new JComboBox();
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.multiPanel.setLayout(this.layout);
            if (this.size.width > 0 && this.size.height > 0) {
                this.multiPanel.setPreferredSize(this.size);
            }
            this.box.setModel(this.widgets);
            this.box.setRenderer(new Widget.MyCellRenderer());
            this.box.addItemListener(this);
            this.panel.add(this.box);
            this.panel.add(this.multiPanel);
            this.itemStateChanged(null);
        }
        return this.panel;
    }

    private String getKey(Object object) {
        String string = this.keys.get(object);
        if (string == null) {
            string = String.valueOf(this.count++);
            this.keys.put(object, string);
        }
        return string;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.box.getSelectedItem() != null) {
            Widget widget = (Widget)this.box.getSelectedItem();
            if (!this.built.contains(widget)) {
                this.multiPanel.add(this.getKey(widget), widget.getComponent());
                this.built.add(widget);
            }
            this.layout.show(this.multiPanel, this.getKey(widget));
        }
    }

    private boolean allChildrenBuilt() {
        return this.box != null && this.box.getModel().getSize() == this.built.size();
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName", "width", "height"};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("entryName".equals(string)) {
            this.setConfigureName((String)object);
        } else if ("width".equals(string)) {
            this.size.width = Integer.parseInt(object.toString());
        } else if ("height".equals(string)) {
            this.size.height = Integer.parseInt(object.toString());
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("entryName".equals(string)) {
            return this.getConfigureName();
        }
        if ("width".equals(string)) {
            int n = this.allChildrenBuilt() ? this.multiPanel.getLayout().preferredLayoutSize((Container)this.multiPanel).width : this.size.width;
            return new Integer(n).toString();
        }
        if ("height".equals(string)) {
            int n = this.allChildrenBuilt() ? this.multiPanel.getLayout().preferredLayoutSize((Container)this.multiPanel).height : this.size.height;
            return new Integer(n).toString();
        }
        return null;
    }
}

