/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart
extends Widget {
    public static final String NAME = "chartName";
    public static final String FILE = "fileName";
    private Component chart;
    private String fileName;
    private SourceOp srcOp;
    private JLabel label;

    @Override
    public Component getComponent() {
        if (this.chart == null) {
            this.label = new JLabel();
            SourceOp sourceOp = this.srcOp = this.fileName == null || this.fileName.trim().length() == 0 ? null : Op.load(this.fileName);
            if (this.srcOp != null) {
                this.label.setIcon(new OpIcon(this.srcOp));
            }
            Dimension dimension = this.label.getPreferredSize();
            if (dimension.width > 300 || dimension.height > 300) {
                AdjustableSpeedScrollPane adjustableSpeedScrollPane = new AdjustableSpeedScrollPane(this.label);
                adjustableSpeedScrollPane.getViewport().setPreferredSize(this.label.getPreferredSize());
                adjustableSpeedScrollPane.getViewport().setAlignmentY(0.0f);
                this.chart = adjustableSpeedScrollPane;
            } else {
                this.chart = this.label;
            }
        }
        return this.chart;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void addTo(Buildable buildable) {
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.htm", "Chart");
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
            if (this.label != null) {
                SourceOp sourceOp = this.srcOp = this.fileName == null || this.fileName.trim().length() == 0 ? null : Op.load(this.fileName);
                if (this.srcOp != null) {
                    this.label.setIcon(new OpIcon(this.srcOp));
                    this.label.revalidate();
                }
            }
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, FILE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Image:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Image.class};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        return null;
    }

    public static String getConfigureTypeName() {
        return "Chart";
    }
}

