/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.io.IOUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlChart
extends Widget
implements MouseListener {
    public static final String NAME = "chartName";
    public static final String FILE = "fileName";
    private String fileName;
    private JScrollPane scroller;
    private JEditorPane htmlWin;

    private boolean isURL() {
        return this.htmlWin.getDocument().getProperty("stream") != null;
    }

    private void setText(String string) {
        this.htmlWin.setText(string);
        this.htmlWin.getDocument().putProperty("stream", null);
        this.htmlWin.revalidate();
    }

    private void setFile(String string) {
        this.setText(this.getFile(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFile(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(GameModule.getGameModule().getDataArchive().getInputStream(string));
            string2 = IOUtils.toString(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            try {
                ErrorDialog.dataError(new BadDataReport(this, Resources.getString("Error.not_found", "Chart"), string, (Throwable)iOException));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(bufferedInputStream);
        }
        IOUtils.closeQuietly(bufferedInputStream);
        return string2;
    }

    @Override
    public Component getComponent() {
        if (this.htmlWin == null) {
            this.htmlWin = new JEditorPane();
            this.htmlWin.setEditable(false);
            this.htmlWin.setContentType("text/html");
            XTMLEditorKit xTMLEditorKit = new XTMLEditorKit();
            this.htmlWin.setEditorKit(xTMLEditorKit);
            this.htmlWin.addHyperlinkListener(new HtmlChartHyperlinkListener());
            this.htmlWin.addMouseListener(this);
            this.setFile(this.fileName);
            this.scroller = new ScrollPane(this.htmlWin);
            this.scroller.getViewport().setPreferredSize(this.htmlWin.getPreferredSize());
            this.scroller.getViewport().setAlignmentY(0.0f);
        }
        return this.scroller;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void addTo(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "HTML Chart";
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.htm", "HtmlChart");
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
            if (this.htmlWin != null) {
                this.setFile(this.fileName);
            }
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, FILE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "HTML File:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Return to default page");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HtmlChart.this.setFile(HtmlChart.this.fileName);
                }
            });
            jPopupMenu.add(jMenuItem);
            if (mouseEvent.getComponent().isShowing()) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public class XTMLEditorKit
    extends HTMLEditorKit {
        private static final long serialVersionUID = 1L;

        public ViewFactory getViewFactory() {
            return new XTMLFactory();
        }

        public class XTMLFactory
        extends HTMLEditorKit.HTMLFactory
        implements ViewFactory {
            public View create(Element element) {
                String string;
                HTML.Tag tag = (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (tag instanceof HTML.Tag && element.getName().equals("img") && (string = (String)element.getAttributes().getAttribute(HTML.Attribute.SRC)).indexOf("/") < 0) {
                    return new ImageComponentView(element);
                }
                return super.create(element);
            }

            public class ImageComponentView
            extends ComponentView {
                protected String imageName;
                protected SourceOp srcOp;

                public ImageComponentView(Element element) {
                    super(element);
                    this.imageName = (String)element.getAttributes().getAttribute(HTML.Attribute.SRC);
                    this.srcOp = this.imageName == null || this.imageName.trim().length() == 0 ? null : Op.load(this.imageName);
                }

                protected Component createComponent() {
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(new OpIcon(this.srcOp));
                    return jLabel;
                }
            }
        }
    }

    public class HtmlChartHyperlinkListener
    implements HyperlinkListener {
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (!HtmlChart.this.isURL() && hyperlinkEvent.getDescription().indexOf("/") < 0 || hyperlinkEvent.getURL() == null) {
                    HtmlChart.this.setFile(hyperlinkEvent.getDescription());
                } else {
                    try {
                        HtmlChart.this.htmlWin.setPage(hyperlinkEvent.getURL());
                    }
                    catch (IOException iOException) {
                        ReadErrorDialog.error(iOException, hyperlinkEvent.getURL().toString());
                    }
                    HtmlChart.this.htmlWin.revalidate();
                }
            }
        }
    }
}

