/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.TabWidget;
import VASSAL.build.widget.WidgetMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapWidget
extends Widget {
    protected JPanel panel = new JPanel();
    protected JComponent mapHolder;
    protected WidgetMap map;
    protected Buildable parent;
    protected JTabbedPane tab;

    public MapWidget() {
        this.panel.setLayout(new BorderLayout());
    }

    public static String getConfigureTypeName() {
        return "Map";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.htm", "Map");
    }

    @Override
    public void build(Element element) {
        if (element == null) {
            WidgetMap widgetMap = new WidgetMap();
            widgetMap.build(null);
            widgetMap.addTo(this);
            this.add(widgetMap);
        } else {
            super.build(element);
        }
        this.rebuild();
    }

    @Override
    public Component getComponent() {
        if (this.tab == null && this.parent instanceof TabWidget) {
            this.tab = (JTabbedPane)((TabWidget)this.parent).getComponent();
            if (this.tab.getClientProperty(TabSwitcher.class) == null) {
                TabSwitcher tabSwitcher = new TabSwitcher(this.tab);
                this.tab.putClientProperty(TabSwitcher.class, tabSwitcher);
                this.tab.setDropTarget(new DropTarget(this.tab, 2, tabSwitcher));
            }
        }
        return this.panel;
    }

    @Override
    public void addTo(Buildable buildable) {
        super.addTo(buildable);
        this.parent = buildable;
    }

    @Override
    public void add(Buildable buildable) {
        if (buildable instanceof WidgetMap) {
            if (this.mapHolder != null) {
                this.panel.remove(this.mapHolder);
                this.mapHolder = null;
            }
            this.map = (WidgetMap)buildable;
            this.mapHolder = this.map.getLayeredPane();
            this.panel.add((Component)this.mapHolder, "Center");
            this.panel.add((Component)this.map.getToolBar(), "North");
            this.panel.revalidate();
        }
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        if (buildable instanceof WidgetMap) {
            this.panel.remove(this.mapHolder);
            this.panel.remove(this.map.getToolBar());
            this.mapHolder = null;
        }
        super.remove(buildable);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName"};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("entryName".equals(string)) {
            this.setConfigureName((String)object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("entryName".equals(string)) {
            return this.getConfigureName();
        }
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public WidgetMap getMap() {
        return this.map;
    }

    protected static class TabSwitcher
    implements DropTargetListener {
        protected JTabbedPane tab;

        public TabSwitcher(JTabbedPane jTabbedPane) {
            this.tab = jTabbedPane;
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this.tab != null) {
                Point point = dropTargetDragEvent.getLocation();
                int n = this.tab.getUI().tabForCoordinate(this.tab, point.x, point.y);
                if (n >= 0 && n != this.tab.getSelectedIndex()) {
                    this.tab.setSelectedIndex(n);
                    this.tab.repaint();
                }
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }
    }
}

