/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.SynchEncoder;
import VASSAL.chat.jabber.AccountInfo;
import VASSAL.chat.jabber.JabberPlayer;
import VASSAL.chat.jabber.JabberRoom;
import VASSAL.chat.jabber.PacketProcessor;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.LockableRoomTreeRenderer;
import VASSAL.chat.ui.MessageBoardControlsInitializer;
import VASSAL.chat.ui.PrivateMessageAction;
import VASSAL.chat.ui.RoomInteractionControlsInitializer;
import VASSAL.chat.ui.SendSoundAction;
import VASSAL.chat.ui.ShowProfileAction;
import VASSAL.chat.ui.SimpleStatusControlsInitializer;
import VASSAL.chat.ui.SynchAction;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.VCard;

public class JabberClient
implements ChatServerConnection,
PacketListener,
ServerStatus,
ChatControlsInitializer,
PlayerEncoder {
    private static final String QUERY_ROOMS = "http://jabber.org/protocol/muc#rooms";
    private MessageBoard msgSvr;
    private XMPPConnection conn;
    private String host;
    private int port = 5222;
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private JabberPlayer me;
    private String conferenceService;
    private MonitorRooms monitor;
    private CommandEncoder encoder;
    private final JabberRoom defaultRoom;
    private MultiUserChat currentChat;
    private AccountInfo account;
    private SynchEncoder synchEncoder;
    protected MessageBoardControlsInitializer messageBoardControls;
    protected RoomInteractionControlsInitializer roomControls;
    protected SimpleStatusControlsInitializer playerStatusControls;
    protected JabberPlayer.Manager playerMgr = new JabberPlayer.Manager();
    protected JabberRoom.Manager roomMgr = new JabberRoom.Manager();

    public JabberClient(CommandEncoder commandEncoder, String string, int n, AccountInfo accountInfo) {
        XMPPConnection.DEBUG_ENABLED = "true".equals(System.getProperty("enableJabber"));
        this.host = string;
        this.conferenceService = "conference." + string;
        this.encoder = commandEncoder;
        this.account = accountInfo;
        this.defaultRoom = this.roomMgr.getRoomByName(this, "Main Room");
        this.messageBoardControls = new MessageBoardControlsInitializer(Resources.getString("Chat.messages"), this.msgSvr);
        this.roomControls = new RoomInteractionControlsInitializer(this);
        this.roomControls.addPlayerActionFactory(ShowProfileAction.factory());
        this.roomControls.addPlayerActionFactory(SynchAction.factory(this));
        this.roomControls.addPlayerActionFactory(PrivateMessageAction.factory(this, new PrivateChatManager(this)));
        this.roomControls.addPlayerActionFactory(SendSoundAction.factory(this, Resources.getString("Chat.send_wakeup"), "wakeUpSound", "phone1.wav"));
        this.playerStatusControls = new SimpleStatusControlsInitializer(this);
        this.synchEncoder = new SynchEncoder(this, this);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public boolean isConnected() {
        return this.conn != null && this.conn.isConnected();
    }

    public void sendToOthers(Command command) {
        if (this.currentChat != null) {
            try {
                this.currentChat.sendMessage(this.encoder.encode(command));
            }
            catch (XMPPException xMPPException) {
                this.reportXMPPException(xMPPException);
            }
        }
    }

    public void setConnected(boolean bl) {
        if (bl) {
            if (!this.isConnected()) {
                if (this.conn != null) {
                    this.conn.disconnect();
                }
                try {
                    String string = this.account.getUserName();
                    String string2 = this.account.getPassword();
                    this.playerMgr.getPlayerByLogin(this, this.account.getUserName()).setName(this.account.getRealName());
                    ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration(this.host, this.port);
                    connectionConfiguration.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
                    connectionConfiguration.setCompressionEnabled(true);
                    connectionConfiguration.setSASLAuthenticationEnabled(false);
                    connectionConfiguration.setDebuggerEnabled(XMPPConnection.DEBUG_ENABLED);
                    this.conn = new XMPPConnection(connectionConfiguration);
                    this.conn.connect();
                    this.conn.addConnectionListener((org.jivesoftware.smack.ConnectionListener)new ConnectionListener());
                    try {
                        this.conn.login(string, string2, "VASSAL");
                    }
                    catch (XMPPException xMPPException) {
                        if (xMPPException.getXMPPError() != null && xMPPException.getXMPPError().getCode() == 401) {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("name", this.me.getName());
                            try {
                                this.conn.getAccountManager().createAccount(string, string2, hashMap);
                            }
                            catch (XMPPException xMPPException2) {
                                if (xMPPException2.getXMPPError() != null && xMPPException2.getXMPPError().getCode() == 409) {
                                    this.fireStatus(Resources.getString("Chat.invalid_password", string));
                                    this.setConnected(false);
                                    return;
                                }
                                throw xMPPException;
                            }
                            this.conn.login(string, string2, "VASSAL");
                            VCard vCard = new VCard();
                            vCard.setNickName(this.me.getName());
                            vCard.save(this.conn);
                        }
                        throw xMPPException;
                    }
                    this.monitor = new MonitorRooms();
                    this.monitor.init();
                    this.propSupport.firePropertyChange("Connected", null, Boolean.TRUE);
                    this.setRoom(this.defaultRoom);
                }
                catch (XMPPException xMPPException) {
                    this.reportXMPPException(xMPPException);
                    if (xMPPException.getWrappedThrowable() != null && xMPPException.getWrappedThrowable().getLocalizedMessage() != null) {
                        this.fireStatus(xMPPException.getWrappedThrowable().getMessage());
                    }
                    this.setConnected(false);
                }
            }
        } else {
            if (this.isConnected()) {
                this.leaveCurrentRoom();
                if (this.monitor != null) {
                    this.monitor.disconnect();
                }
                this.conn.disconnect();
            }
            this.conn = null;
            this.monitor = null;
            this.currentChat = null;
            this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
            this.playerMgr.clear();
            this.roomMgr.clear();
        }
    }

    private void leaveCurrentRoom() {
        if (this.currentChat != null) {
            this.currentChat.leave();
            this.currentChat.removeMessageListener((PacketListener)this);
            this.currentChat = null;
        }
    }

    public void initializeControls(ChatServerControls chatServerControls) {
        this.playerStatusControls.initializeControls(chatServerControls);
        this.messageBoardControls.initializeControls(chatServerControls);
        this.roomControls.initializeControls(chatServerControls);
        GameModule.getGameModule().addCommandEncoder(this.synchEncoder);
        chatServerControls.getRoomTree().setCellRenderer(new LockableRoomTreeRenderer());
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        this.messageBoardControls.uninitializeControls(chatServerControls);
        this.roomControls.uninitializeControls(chatServerControls);
        this.playerStatusControls.uninitializeControls(chatServerControls);
        GameModule.getGameModule().removeCommandEncoder(this.synchEncoder);
    }

    public void processPacket(Packet packet) {
        Message message = (Message)packet;
        if (!message.getFrom().equals(this.currentChat.getRoom() + "/" + this.currentChat.getNickname())) {
            this.propSupport.firePropertyChange("Msg", null, message.getBody());
        }
    }

    public Room getRoom() {
        return this.monitor.getCurrentRoom();
    }

    public String getCurrentRoomJID() {
        return this.currentChat == null ? null : this.currentChat.getRoom();
    }

    public void setRoom(Room room) {
        JabberRoom jabberRoom = null;
        try {
            jabberRoom = room instanceof JabberRoom ? (JabberRoom)room : this.roomMgr.getRoomByName(this, room.getName());
            if (!jabberRoom.equals(this.getRoom())) {
                this.leaveCurrentRoom();
                this.currentChat = jabberRoom.join(this, (JabberPlayer)this.getUserInfo());
                this.monitor.sendRoomChanged();
            }
        }
        catch (XMPPException xMPPException) {
            this.reportXMPPException(xMPPException);
            this.propSupport.firePropertyChange("Status", null, "Failed to join room");
        }
    }

    public Room[] getAvailableRooms() {
        return this.monitor.getAvailableRooms();
    }

    protected void fireRoomsUpdated() {
        this.propSupport.firePropertyChange("AvailableRooms", null, this.getAvailableRooms());
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }

    protected void fireStatus(String string) {
        this.propSupport.firePropertyChange("Status", null, string);
    }

    public Player getUserInfo() {
        return this.playerMgr.getPlayerByLogin(this, this.account.getUserName());
    }

    public void setUserInfo(Player player) {
        if (this.monitor != null) {
            this.monitor.sendStatus((SimplePlayer)player);
        }
    }

    public void sendTo(Player player, Command command) {
        Chat chat = this.conn.getChatManager().createChat(((JabberPlayer)player).getJid(), null);
        try {
            chat.sendMessage(this.encoder.encode(command));
        }
        catch (XMPPException xMPPException) {
            this.reportXMPPException(xMPPException);
        }
    }

    private void reportXMPPException(XMPPException xMPPException) {
        xMPPException.printStackTrace();
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    public ServerStatus getStatusServer() {
        return this;
    }

    public XMPPConnection getConnection() {
        return this.conn;
    }

    public String getModule() {
        return "JabberTestModule";
    }

    public String getConferenceService() {
        return this.conferenceService;
    }

    public static String unescapeNode(String string) {
        return StringUtils.unescapeNode((String)string);
    }

    public CommandEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(CommandEncoder commandEncoder) {
        this.encoder = commandEncoder;
    }

    public ServerStatus.ModuleSummary[] getHistory(String string) {
        return new ServerStatus.ModuleSummary[0];
    }

    public ServerStatus.ModuleSummary[] getStatus() {
        ArrayList arrayList = new ArrayList();
        try {
            for (HostedRoom hostedRoom : MultiUserChat.getHostedRooms((XMPPConnection)this.conn, (String)this.conferenceService)) {
                MultiUserChat.getRoomInfo((XMPPConnection)this.conn, (String)hostedRoom.getJid());
            }
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return arrayList.toArray(new ServerStatus.ModuleSummary[arrayList.size()]);
    }

    public String[] getSupportedTimeRanges() {
        return new String[0];
    }

    public static void main(String[] stringArray) {
        XMPPConnection.DEBUG_ENABLED = true;
        CommandEncoder commandEncoder = new CommandEncoder(){

            public Command decode(String string) {
                System.err.println(string);
                return null;
            }

            public String encode(Command command) {
                return null;
            }
        };
        final String string = stringArray.length == 0 ? "test" : stringArray[0];
        final String string2 = stringArray.length == 0 ? "test" : stringArray[1];
        AccountInfo accountInfo = new AccountInfo(){

            public String getPassword() {
                return string2;
            }

            public String getUserName() {
                return string;
            }

            public String getModule() {
                return "JabberTestModule";
            }

            public String getRealName() {
                return string;
            }
        };
        JabberClient jabberClient = new JabberClient(commandEncoder, "localhost", 5222, accountInfo);
        jabberClient.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.err.println(propertyChangeEvent.getPropertyName() + "=" + propertyChangeEvent.getNewValue());
            }
        });
        ChatServerControls chatServerControls = new ChatServerControls();
        chatServerControls.setClient(jabberClient);
        JFrame jFrame = new JFrame(string);
        jFrame.add(chatServerControls.getControls());
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public String getHost() {
        return this.host;
    }

    public String playerToString(Player player) {
        return ((JabberPlayer)player).getJid();
    }

    public Player stringToPlayer(String string) {
        return this.playerMgr.getPlayer(string);
    }

    private class ConnectionListener
    implements org.jivesoftware.smack.ConnectionListener {
        private ConnectionListener() {
        }

        public void connectionClosed() {
        }

        public void connectionClosedOnError(Exception exception) {
            XMPPException xMPPException;
            String string = exception.getMessage();
            if (exception instanceof XMPPException && (xMPPException = (XMPPException)((Object)exception)).getStreamError() != null && "conflict".equals(xMPPException.getStreamError().getCode())) {
                string = "Another user has logged in using the same account.  Disconnecting";
            }
            if (string != null) {
                JabberClient.this.fireStatus(string);
            }
            JabberClient.this.setConnected(false);
        }

        public void reconnectingIn(int n) {
        }

        public void reconnectionFailed(Exception exception) {
        }

        public void reconnectionSuccessful() {
        }
    }

    private class MonitorRooms
    implements PacketListener,
    ParticipantStatusListener {
        private static final String ROOM_CHANGE_ACTION = "changedRoom";
        private MultiUserChat monitorRoom;
        private Comparator<Room> roomSortOrder = new Comparator<Room>(){

            @Override
            public int compare(Room room, Room room2) {
                if (room.equals(JabberClient.this.defaultRoom) && !room2.equals(JabberClient.this.defaultRoom)) {
                    return -1;
                }
                if (room2.equals(JabberClient.this.defaultRoom) && !room.equals(JabberClient.this.defaultRoom)) {
                    return 1;
                }
                return room.getName().compareTo(room2.getName());
            }
        };

        private MonitorRooms() {
        }

        public void init() throws XMPPException {
            block2: {
                new TrackRooms().addTo(JabberClient.this.conn);
                new TrackStatus(this.getMonitorRoomJID().toLowerCase()).addTo(JabberClient.this.conn);
                this.monitorRoom = new MultiUserChat(JabberClient.this.conn, this.getMonitorRoomJID());
                this.monitorRoom.addMessageListener((PacketListener)this);
                this.monitorRoom.addParticipantStatusListener((ParticipantStatusListener)this);
                this.monitorRoom.join(StringUtils.parseName((String)JabberClient.this.conn.getUser()));
                try {
                    this.monitorRoom.sendConfigurationForm(new Form("submit"));
                }
                catch (XMPPException xMPPException) {
                    if (xMPPException.getXMPPError().getCode() == 403) break block2;
                    throw xMPPException;
                }
            }
        }

        public String getMonitorRoomJID() {
            return StringUtils.escapeNode((String)JabberClient.this.getModule()) + "@" + JabberClient.this.getConferenceService();
        }

        public void sendStatus(SimplePlayer simplePlayer) {
            this.sendStatus(simplePlayer, null);
        }

        public void sendStatus(SimplePlayer simplePlayer, String string) {
            SimpleStatus simpleStatus = (SimpleStatus)simplePlayer.getStatus();
            Presence presence = new Presence(Presence.Type.available);
            presence.setStatus("");
            presence.setMode(Presence.Mode.chat);
            presence.setProperty("looking", (Object)simpleStatus.isLooking());
            presence.setProperty("away", (Object)simpleStatus.isAway());
            presence.setProperty("realName", (Object)simplePlayer.getName());
            presence.setTo(string == null ? this.monitorRoom.getRoom() : string);
            JabberClient.this.conn.sendPacket((Packet)presence);
        }

        public Room[] getAvailableRooms() {
            Set set;
            List list;
            HashMap<JabberRoom, Collection<JabberPlayer>> hashMap = new HashMap<JabberRoom, Collection<JabberPlayer>>();
            for (JabberPlayer object2 : JabberClient.this.playerMgr.getAllPlayers()) {
                JabberRoom jabberRoom = object2.getJoinedRoom();
                if (jabberRoom == null) continue;
                list = (ArrayList<JabberPlayer>)hashMap.get(jabberRoom);
                if (list == null) {
                    list = new ArrayList<JabberPlayer>();
                    hashMap.put(jabberRoom, list);
                }
                list.add(object2);
            }
            if (!hashMap.containsKey(JabberClient.this.defaultRoom)) {
                set = Collections.emptyList();
                hashMap.put(JabberClient.this.defaultRoom, set);
            }
            set = hashMap.keySet();
            for (JabberRoom jabberRoom : set) {
                list = (List)hashMap.get(jabberRoom);
                jabberRoom.setPlayers(list.toArray(new JabberPlayer[list.size()]));
            }
            Room[] roomArray = set.toArray(new Room[set.size()]);
            Arrays.sort(roomArray, this.roomSortOrder);
            return roomArray;
        }

        public JabberRoom getCurrentRoom() {
            String string = JabberClient.this.getCurrentRoomJID();
            return JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, string);
        }

        public void sendRoomChanged() throws XMPPException {
            Message message = this.monitorRoom.createMessage();
            message.setBody(ROOM_CHANGE_ACTION);
            this.monitorRoom.sendMessage(message);
        }

        public void disconnect() {
            this.monitorRoom.leave();
        }

        public String getAbsolutePlayerJID(String string) {
            return StringUtils.parseResource((String)string) + "@" + JabberClient.this.host + "/VASSAL";
        }

        private void sendRoomQuery(String string) {
            System.out.println("Sending room query to " + string);
            DiscoverItems discoverItems = new DiscoverItems();
            discoverItems.setType(IQ.Type.GET);
            discoverItems.setTo(string);
            discoverItems.setNode(JabberClient.QUERY_ROOMS);
            JabberClient.this.conn.sendPacket((Packet)discoverItems);
        }

        public void processPacket(Packet packet) {
            Message message = (Message)packet;
            if (ROOM_CHANGE_ACTION.equals(message.getBody())) {
                String string = this.getAbsolutePlayerJID(packet.getFrom());
                JabberClient.this.playerMgr.getPlayer(this.getAbsolutePlayerJID(packet.getFrom()));
                this.sendRoomQuery(string);
            }
        }

        public void joined(String string) {
            JabberClient.this.playerMgr.getPlayer(this.getAbsolutePlayerJID(string));
        }

        public void left(String string) {
            String string2 = this.getAbsolutePlayerJID(string);
            JabberClient.this.playerMgr.deletePlayer(string2);
            JabberClient.this.fireRoomsUpdated();
        }

        public void kicked(String string, String string2, String string3) {
        }

        public void voiceGranted(String string) {
        }

        public void voiceRevoked(String string) {
        }

        public void banned(String string, String string2, String string3) {
        }

        public void membershipGranted(String string) {
        }

        public void membershipRevoked(String string) {
        }

        public void moderatorGranted(String string) {
        }

        public void moderatorRevoked(String string) {
        }

        public void ownershipGranted(String string) {
        }

        public void ownershipRevoked(String string) {
        }

        public void adminGranted(String string) {
        }

        public void adminRevoked(String string) {
        }

        public void nicknameChanged(String string, String string2) {
        }

        private class TrackRooms
        extends PacketProcessor {
            private PacketFilter roomResponseFilter = new AndFilter(new PacketFilter[]{new IQTypeFilter(IQ.Type.RESULT), new PacketTypeFilter(DiscoverItems.class)});
            private PacketFilter newPlayerFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new FromContainsFilter(MonitorRooms.this.getMonitorRoomJID())});

            public void process(Packet packet) {
                if (this.roomResponseFilter.accept(packet)) {
                    DiscoverItems discoverItems = (DiscoverItems)packet;
                    JabberPlayer jabberPlayer = JabberClient.this.playerMgr.getPlayer(packet.getFrom());
                    Iterator iterator = discoverItems.getItems();
                    while (iterator.hasNext()) {
                        String string = ((DiscoverItems.Item)iterator.next()).getEntityID();
                        if (string.equals(MonitorRooms.this.monitorRoom.getRoom())) continue;
                        jabberPlayer.join(JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, string));
                    }
                    JabberClient.this.fireRoomsUpdated();
                } else if (this.newPlayerFilter.accept(packet)) {
                    MonitorRooms.this.sendRoomQuery(MonitorRooms.this.getAbsolutePlayerJID(packet.getFrom()));
                }
            }

            public boolean acceptPacket(Packet packet) {
                boolean bl = false;
                if (this.roomResponseFilter.accept(packet)) {
                    bl = JabberClient.QUERY_ROOMS.equals(((DiscoverItems)packet).getNode());
                } else if (this.newPlayerFilter.accept(packet)) {
                    bl = ((Presence)packet).isAvailable();
                }
                return bl;
            }
        }

        private class TrackStatus
        extends PacketProcessor {
            String prefix;

            public TrackStatus(String string) {
                this.prefix = string;
            }

            public boolean acceptPacket(Packet packet) {
                String string;
                Presence presence;
                boolean bl = false;
                if (packet instanceof Presence && (presence = (Presence)packet).getType() == Presence.Type.available && presence.getMode() == Presence.Mode.chat && (string = presence.getFrom()) != null && string.toLowerCase().startsWith(this.prefix)) {
                    bl = true;
                }
                return bl;
            }

            public void process(Packet packet) {
                Presence presence = (Presence)packet;
                JabberPlayer jabberPlayer = JabberClient.this.playerMgr.getPlayer(MonitorRooms.this.getAbsolutePlayerJID(presence.getFrom()));
                SimpleStatus simpleStatus = (SimpleStatus)jabberPlayer.getStatus();
                String string = simpleStatus == null ? "" : simpleStatus.getProfile();
                Object object = presence.getProperty("looking");
                Object object2 = presence.getProperty("away");
                simpleStatus = new SimpleStatus(object == null ? false : (Boolean)object, object2 == null ? false : (Boolean)object2, string);
                jabberPlayer.setStatus(simpleStatus);
                jabberPlayer.setName(String.valueOf(presence.getProperty("realName")));
                JabberClient.this.fireRoomsUpdated();
            }
        }
    }
}

