/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.chat.LockableRoom;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.JabberPlayer;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;

public class JabberRoom
extends SimpleRoom
implements LockableRoom {
    private String jid;
    private RoomInfo info;
    private boolean ownedByMe;

    private JabberRoom(String string, String string2, RoomInfo roomInfo) {
        super(string);
        this.jid = string2;
        this.info = roomInfo;
    }

    public String getJID() {
        return this.jid;
    }

    public boolean isLocked() {
        return this.info != null && this.info.isMembersOnly();
    }

    public MultiUserChat join(JabberClient jabberClient, JabberPlayer jabberPlayer) throws XMPPException {
        MultiUserChat multiUserChat;
        block4: {
            multiUserChat = new MultiUserChat(jabberClient.getConnection(), this.getJID());
            multiUserChat.join(StringUtils.parseName((String)jabberPlayer.getJid()));
            try {
                multiUserChat.sendConfigurationForm(new Form("submit"));
                this.ownedByMe = true;
            }
            catch (XMPPException xMPPException) {
                if (xMPPException.getXMPPError().getCode() == 403) break block4;
                throw xMPPException;
            }
        }
        try {
            multiUserChat.changeSubject(this.getName());
        }
        catch (XMPPException xMPPException) {
            // empty catch block
        }
        multiUserChat.addMessageListener((PacketListener)jabberClient);
        return multiUserChat;
    }

    public boolean equals(Object object) {
        if (object instanceof JabberRoom) {
            JabberRoom jabberRoom = (JabberRoom)object;
            return jabberRoom.jid.equals(this.jid);
        }
        return false;
    }

    public int hashCode() {
        return this.jid.hashCode();
    }

    public boolean isOwnedByMe() {
        return this.ownedByMe;
    }

    public static class Manager {
        private Map<String, JabberRoom> jidToRoom = new HashMap<String, JabberRoom>();

        public synchronized JabberRoom getRoomByJID(JabberClient jabberClient, String string) {
            if (string == null) {
                return null;
            }
            JabberRoom jabberRoom = this.jidToRoom.get(string);
            if (jabberRoom == null) {
                String string2 = "<no name>";
                RoomInfo roomInfo = null;
                try {
                    roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)jabberClient.getConnection(), (String)string);
                    string2 = roomInfo.getSubject();
                }
                catch (XMPPException xMPPException) {
                    xMPPException.printStackTrace();
                }
                jabberRoom = new JabberRoom(string2, string, roomInfo);
                this.jidToRoom.put(string, jabberRoom);
            }
            return jabberRoom;
        }

        public synchronized JabberRoom getRoomByName(JabberClient jabberClient, String string) {
            String string2 = StringUtils.escapeNode((String)(jabberClient.getModule() + "/" + string)).toLowerCase() + "@" + jabberClient.getConferenceService();
            JabberRoom jabberRoom = this.jidToRoom.get(string2);
            if (jabberRoom == null) {
                jabberRoom = new JabberRoom(string, string2, null);
                this.jidToRoom.put(string2, jabberRoom);
            }
            return jabberRoom;
        }

        public void deleteRoom(String string) {
            this.jidToRoom.remove(string);
        }

        public synchronized void clear() {
            this.jidToRoom.clear();
        }
    }
}

