/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.messageboard;

import VASSAL.chat.messageboard.Message;
import VASSAL.i18n.Resources;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable msgTable;
    private DefaultTableModel model;
    private JTextArea msgText;
    private List<Message> msgList = new ArrayList<Message>();

    public MessageViewer() {
        this.initComponents();
    }

    public void setMessages(Enumeration<Message> enumeration) {
        this.msgList.clear();
        this.msgText.setText("");
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(Resources.getString("Chat.sender"));
        vector2.addElement(Resources.getString("Chat.date"));
        while (enumeration.hasMoreElements()) {
            Message message = enumeration.nextElement();
            this.msgList.add(message);
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement(message.getSender());
            vector3.addElement(Resources.formatDate(message.getDate()));
            vector.addElement(vector3);
        }
        this.model = new DefaultTableModel(vector, vector2);
        this.msgTable.setModel(this.model);
        if (!this.msgList.isEmpty()) {
            this.msgTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void initComponents() {
        JSplitPane jSplitPane = new JSplitPane(1);
        this.model = new DefaultTableModel(new Object[]{Resources.getString("Chat.sender"), Resources.getString("Chat.date")}, 0);
        this.msgTable = new JTable(this.model);
        this.msgTable.getSelectionModel().addListSelectionListener(new ShowMsgText());
        JScrollPane jScrollPane = new JScrollPane(this.msgTable);
        jSplitPane.add(jScrollPane);
        this.msgText = new JTextArea(10, 25);
        this.msgText.setLineWrap(true);
        this.msgText.setWrapStyleWord(true);
        this.msgText.setEditable(false);
        jScrollPane = new JScrollPane(this.msgText);
        jScrollPane.setBorder(new TitledBorder(Resources.getString("Chat.message")));
        jSplitPane.add(jScrollPane);
        this.add(jSplitPane);
    }

    private class ShowMsgText
    implements ListSelectionListener {
        private ShowMsgText() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = MessageViewer.this.msgTable.getSelectedRow();
            if (n >= 0 && n < MessageViewer.this.msgList.size()) {
                MessageViewer.this.msgText.setText(((Message)MessageViewer.this.msgList.get(n)).getText());
            } else {
                MessageViewer.this.msgText.setText("");
            }
        }
    }
}

