/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.Node;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.Properties;

public class Protocol {
    public static final String REGISTER = "REG\t";
    public static final String REG_REQUEST = "REG_REQUEST\t";
    public static final String JOIN = "JOIN\t";
    public static final String FORWARD = "FWD\t";
    public static final String STATS = "STATS\t";
    public static final String LIST = "LIST\t";
    public static final String CONTENTS = "SERVER_CONTENTS\t";
    public static final String NODE_INFO = "NODE_INFO\t";
    public static final String ROOM_INFO = "ROOM_INFO\t";
    public static final String LOGIN = "LOGIN\t";
    public static final String KICK = "KICK\t";

    public static String encodeRegisterCommand(String string, String string2, String string3) {
        String string4 = new SequenceEncoder(string, '\t').append(string2).append(string3).getValue();
        return REGISTER + string4;
    }

    public static String[] decodeRegisterCommand(String string) {
        String[] stringArray = null;
        if (string.startsWith(REGISTER)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(REGISTER.length()), '\t');
            stringArray = new String[]{decoder.nextToken(), decoder.nextToken(), decoder.nextToken()};
        }
        return stringArray;
    }

    public static String encodeJoinCommand(String string) {
        return JOIN + string;
    }

    public static String encodeJoinCommand(String string, String string2) {
        return JOIN + string + "\t" + string2;
    }

    public static String[] decodeJoinCommand(String string) {
        String[] stringArray = null;
        if (string.startsWith(JOIN)) {
            String[] stringArray2 = string.split("\\t");
            if (stringArray2.length == 2) {
                stringArray = new String[]{stringArray2[1]};
            } else if (stringArray2.length == 3) {
                stringArray = new String[]{stringArray2[1], stringArray2[2]};
            }
        }
        return stringArray;
    }

    public static String encodeForwardCommand(String string, String string2) {
        String string3 = new SequenceEncoder(string, '\t').append(string2).getValue();
        return FORWARD + string3;
    }

    public static String[] decodeForwardCommand(String string) {
        String[] stringArray = null;
        if (string.startsWith(FORWARD)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(FORWARD.length()), '\t');
            stringArray = new String[]{decoder.nextToken(), decoder.nextToken()};
        }
        return stringArray;
    }

    public static String encodeStatsCommand(String string) {
        return STATS + string;
    }

    public static String[] decodeStatsCommand(String string) {
        String[] stringArray = null;
        if (string.startsWith(STATS)) {
            stringArray = new String[]{string.substring(STATS.length())};
        }
        return stringArray;
    }

    public static String encodeNodeInfoCommand(Node node) {
        String string = node.getInfo();
        if (string == null) {
            string = "";
        }
        return NODE_INFO + new SequenceEncoder(node.getPath(), '=').append(string).getValue();
    }

    public static String[] decodeNodeInfoCommand(String string) {
        String[] stringArray = null;
        if (string.startsWith(NODE_INFO)) {
            stringArray = new String[2];
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(NODE_INFO.length()), '=');
            stringArray[0] = decoder.nextToken();
            stringArray[1] = decoder.nextToken();
        }
        return stringArray;
    }

    public static String encodeRoomsInfo(Node[] nodeArray) {
        Properties properties = new Properties();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getInfo() == null || nodeArray[i].getInfo().length() <= 0) continue;
            properties.setProperty(nodeArray[i].getId(), nodeArray[i].getInfo());
        }
        String string = new PropertiesEncoder(properties).getStringValue();
        return string == null ? ROOM_INFO : ROOM_INFO + string;
    }

    public static Properties decodeRoomsInfo(String string) {
        Properties properties = null;
        if (string.startsWith(ROOM_INFO)) {
            try {
                properties = new PropertiesEncoder(string.substring(ROOM_INFO.length())).getProperties();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return properties;
    }

    public static String encodeListCommand(Node[] nodeArray) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getPath() == null || nodeArray[i].getInfo() == null) continue;
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder('=');
            sequenceEncoder2.append(nodeArray[i].getPath()).append(nodeArray[i].getInfo());
            sequenceEncoder.append(sequenceEncoder2.getValue());
        }
        String string = sequenceEncoder.getValue();
        return string == null ? LIST : LIST + string;
    }

    public static Node decodeListCommand(String string) {
        Node node = null;
        if (string.startsWith(LIST)) {
            Node node2 = new Node(null, null, null);
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(LIST.length()), '\t');
            while (decoder.hasMoreTokens()) {
                String string2 = decoder.nextToken();
                SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(string2, '=');
                String string3 = decoder2.nextToken();
                String string4 = decoder2.nextToken();
                Node.build(node2, string3).setInfo(string4);
            }
            node = node2;
        }
        return node;
    }

    public static boolean decodeRegisterRequest(String string) {
        return string.startsWith(REG_REQUEST);
    }

    public static String encodeRegisterRequest() {
        return REG_REQUEST;
    }

    public static String encodeLoginCommand(String string) {
        return LOGIN + string;
    }

    public static String decodeLoginCommand(String string) {
        String string2 = null;
        if (string.startsWith(LOGIN)) {
            string2 = string.substring(LOGIN.length());
        }
        return string2;
    }

    public static String encodeKickCommand(String string) {
        return KICK + string;
    }

    public static String[] decodeKickCommand(String string) {
        String[] stringArray = null;
        if (string.startsWith(KICK)) {
            stringArray = new String[]{string.substring(KICK.length())};
        }
        return stringArray;
    }
}

