/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.MsgSender;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.PlayerNode;
import VASSAL.chat.node.Protocol;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class ServerNode
extends Node {
    private static final Logger logger = Logger.getLogger(ServerNode.class.getName());
    private SendContentsTask sendContents = new SendContentsTask();

    public ServerNode() {
        super(null, null, null);
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.sendContents, 0L, 1000L);
    }

    public synchronized void forward(String string, String string2) {
        MsgSender msgSender = this.getMsgSender(string);
        msgSender.send(string2);
    }

    public synchronized MsgSender getMsgSender(String string) {
        MsgSender[] msgSenderArray;
        Node[] nodeArray = new Node[]{this};
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
        while (decoder.hasMoreTokens()) {
            int n;
            Node node;
            int n2;
            msgSenderArray = decoder.nextToken();
            if ("*".equals(msgSenderArray)) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                Node[] nodeArray2 = nodeArray;
                int n3 = nodeArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    node = nodeArray2[n2];
                    arrayList.addAll(Arrays.asList(node.getChildren()));
                }
                nodeArray = arrayList.toArray(new Node[arrayList.size()]);
                continue;
            }
            if (msgSenderArray.startsWith("~")) {
                msgSenderArray = msgSenderArray.substring(1);
                ArrayList<Node> arrayList = new ArrayList<Node>();
                Node[] nodeArray3 = nodeArray;
                int n4 = nodeArray3.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    node = nodeArray3[n2];
                    for (Node node2 : node.getChildren()) {
                        if (msgSenderArray.equals(node2.getId())) continue;
                        arrayList.add(node2);
                    }
                }
                nodeArray = arrayList.toArray(new Node[arrayList.size()]);
                continue;
            }
            int n5 = nodeArray.length;
            for (n = 0; n < n5; ++n) {
                Node node3 = nodeArray[n].getChild((String)msgSenderArray);
                if (node3 == null) continue;
                nodeArray = new Node[]{node3};
                break;
            }
            if (n != n5) continue;
            nodeArray = new Node[]{};
        }
        msgSenderArray = new MsgSender[nodeArray.length];
        System.arraycopy(nodeArray, 0, msgSenderArray, 0, nodeArray.length);
        return new MsgSender(){

            public void send(String string) {
                for (int i = 0; i < msgSenderArray.length; ++i) {
                    msgSenderArray[i].send(string);
                }
            }
        };
    }

    public synchronized void disconnect(Node node) {
        Node node2 = this.getModule(node);
        if (node2 != null) {
            Node node3 = node.getParent();
            node3.remove(node);
            if (node3.getChildren().length == 0) {
                node3.getParent().remove(node3);
            }
            if (node2.getChildren().length == 0) {
                this.remove(node2);
            }
            this.sendContents(node2);
        }
    }

    protected synchronized void sendContents(Node node) {
        this.sendContents.markChanged(node);
    }

    public synchronized void registerNode(String string, Node node) {
        Node node2 = Node.build(this, string);
        node2.add(node);
        Node node3 = this.getModule(node2);
        if (node3 != null) {
            this.sendContents(node3);
        }
    }

    public Node getModule(Node node) {
        Node node2;
        for (node2 = node; node2 != null && node2.getParent() != this; node2 = node2.getParent()) {
        }
        return node2;
    }

    public synchronized void move(Node node, String string) {
        Node node2 = this.getModule(node);
        Node node3 = Node.build(this, string);
        node3.add(node);
        Node node4 = this.getModule(node3);
        if (node4 != null) {
            this.sendContents(node4);
        }
        if (node2 != node4 && node2 != null) {
            this.sendContents(node2);
        }
    }

    public synchronized void updateInfo(Node node) {
        Node node2 = this.getModule(node);
        if (node2 != null) {
            this.sendContents(node2);
        }
    }

    public synchronized void kick(PlayerNode playerNode, String string) {
        String string2;
        Node node = playerNode.getParent();
        try {
            string2 = new PropertiesEncoder(node.getInfo()).getProperties().getProperty("owner");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (string2 == null || !string2.equals(playerNode.getId())) {
            return;
        }
        Node node2 = node.getChild(string);
        if (node2 == null) {
            return;
        }
        Node node3 = node.getParent().getChildren()[0];
        this.move(node2, node3.getPath());
    }

    private static class SendContentsTask
    extends TimerTask {
        private Set<Node> modules = new HashSet<Node>();

        private SendContentsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markChanged(Node node) {
            Set<Node> set = this.modules;
            synchronized (set) {
                this.modules.add(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSet<Node> hashSet = new HashSet<Node>();
            Set<Node> set = this.modules;
            synchronized (set) {
                hashSet.addAll(this.modules);
            }
            for (Node node : hashSet) {
                logger.fine("Sending contents of " + node.getId());
                Node[] nodeArray = node.getLeafDescendants();
                Node[] nodeArray2 = node.getChildren();
                String string = Protocol.encodeListCommand(nodeArray);
                node.send(string);
                logger.finer(string);
                String string2 = Protocol.encodeRoomsInfo(nodeArray2);
                node.send(string2);
                logger.finer(string2);
            }
            set = this.modules;
            synchronized (set) {
                this.modules.clear();
            }
        }
    }
}

