/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.ui.BasicChatControlsInitializer;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.RoomTree;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.VisibilityOption;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.menu.MenuManager;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class ChatServerControls
extends AbstractBuildable {
    protected RoomTree currentRoom;
    protected JTextField newRoom;
    protected JToolBar toolbar;
    protected RoomTree roomTree;
    protected JButton launch;
    protected ChatServerConnection client;
    protected JPanel controlPanel;
    protected ComponentSplitter.SplitPane splitter;
    protected ChatControlsInitializer oldClient;
    protected BasicChatControlsInitializer basicControls;

    public ChatServerControls() {
        JSplitPane jSplitPane = new JSplitPane(1);
        this.roomTree = new RoomTree();
        JScrollPane jScrollPane = new JScrollPane(this.roomTree);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(Resources.getString("Chat.new_game")));
        this.newRoom = new JTextField(12);
        this.newRoom.setMaximumSize(this.newRoom.getPreferredSize());
        box.add(this.newRoom);
        jPanel.add(box);
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), Resources.getString("Chat.active_games")));
        jSplitPane.setLeftComponent(jPanel);
        this.currentRoom = new RoomTree();
        this.currentRoom.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                throw new ExpandVetoException(treeExpansionEvent);
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        jScrollPane = new JScrollPane(this.currentRoom);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), Resources.getString("Chat.current_game")));
        jSplitPane.setRightComponent(jScrollPane);
        jSplitPane.setDividerLocation(160);
        jSplitPane.setPreferredSize(new Dimension(320, 120));
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.add("Center", jSplitPane);
        this.toolbar = new JToolBar();
        this.controlPanel.add("North", this.toolbar);
        this.toolbar.addSeparator();
    }

    public void addTo(Buildable buildable) {
        GameModule gameModule = GameModule.getGameModule();
        this.setClient((ChatServerConnection)gameModule.getServer());
        this.launch = new JButton(Resources.getString("Chat.server"));
        this.launch.setAlignmentY(0.0f);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatServerControls.this.toggleVisible();
            }
        };
        this.launch.addActionListener(actionListener);
        final KeyStrokeListener keyStrokeListener = new KeyStrokeListener(actionListener);
        keyStrokeListener.setKeyStroke(KeyStroke.getKeyStroke(83, 8));
        URL uRL = this.getClass().getResource("/images/connect.gif");
        if (uRL != null) {
            this.launch.setIcon(new ImageIcon(uRL));
            this.launch.setText(null);
        }
        final IconConfigurer iconConfigurer = new IconConfigurer("serverControlsIcon", Resources.getString("Chat.server_controls_button_icon"), "/images/connect.gif");
        iconConfigurer.setValue("/images/connect.gif");
        GlobalOptions.getInstance().addOption(iconConfigurer);
        iconConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChatServerControls.this.launch.setIcon(iconConfigurer.getIconValue());
            }
        });
        iconConfigurer.fireUpdate();
        final HotKeyConfigurer hotKeyConfigurer = new HotKeyConfigurer("serverControlsHotKey", Resources.getString("Chat.server_controls_hotkey"), keyStrokeListener.getKeyStroke());
        GlobalOptions.getInstance().addOption(hotKeyConfigurer);
        hotKeyConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                keyStrokeListener.setKeyStroke((KeyStroke)hotKeyConfigurer.getValue());
                ChatServerControls.this.launch.setToolTipText(Resources.getString("Chat.server_controls_tooltip", HotKeyConfigurer.getString(keyStrokeListener.getKeyStroke())));
            }
        });
        hotKeyConfigurer.fireUpdate();
        gameModule.addKeyStrokeListener(keyStrokeListener);
        gameModule.getToolBar().add(this.launch);
    }

    public void toggleVisible() {
        if (this.controlPanel.getTopLevelAncestor() == null) {
            if (GlobalOptions.getInstance().isUseSingleWindow()) {
                this.splitter = new ComponentSplitter().splitRight(GameModule.getGameModule().getControlPanel(), this.controlPanel, false);
                this.splitter.revalidate();
                Runnable runnable = new Runnable(){

                    public void run() {
                        ChatServerControls.this.splitter.showComponent();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                JFrame jFrame = new JFrame(Resources.getString("Chat.server"));
                jFrame.setDefaultCloseOperation(1);
                jFrame.add(this.controlPanel);
                jFrame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(jFrame));
                String string = "BoundsOfClientWindow";
                VisibilityOption visibilityOption = new VisibilityOption(string, jFrame);
                GameModule.getGameModule().getPrefs().addOption(visibilityOption);
                jFrame.setVisible(true);
            }
        } else if (this.splitter != null) {
            this.splitter.toggleVisibility();
        } else {
            this.controlPanel.getTopLevelAncestor().setVisible(!this.controlPanel.getTopLevelAncestor().isVisible());
        }
    }

    public JPanel getControls() {
        return this.controlPanel;
    }

    public void setClient(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
        if (chatServerConnection instanceof ChatControlsInitializer) {
            if (this.basicControls != null) {
                this.basicControls.uninitializeControls(this);
            }
            if (this.oldClient != null) {
                this.oldClient.uninitializeControls(this);
            }
            this.basicControls = new BasicChatControlsInitializer(chatServerConnection);
            this.basicControls.initializeControls(this);
            ((ChatControlsInitializer)((Object)chatServerConnection)).initializeControls(this);
            this.oldClient = (ChatControlsInitializer)((Object)chatServerConnection);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ChatServerControls.this.roomTree.setRooms((Room[])propertyChangeEvent.getNewValue());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        this.client.addPropertyChangeListener("AvailableRooms", propertyChangeListener);
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (propertyChangeEvent.getNewValue() == null) {
                            ChatServerControls.this.currentRoom.setRooms(new Room[0]);
                        } else {
                            ChatServerControls.this.currentRoom.setRooms(new Room[]{(Room)propertyChangeEvent.getNewValue()});
                            Object object = ChatServerControls.this.currentRoom.getModel().getRoot();
                            Object object2 = ChatServerControls.this.currentRoom.getModel().getChild(object, 0);
                            ChatServerControls.this.currentRoom.expandPath(new TreePath(new Object[]{object, object2}));
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        this.client.addPropertyChangeListener("Room", propertyChangeListener2);
    }

    public ChatServerConnection getClient() {
        return this.client;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void setAttribute(String string, Object object) {
    }

    public String getAttributeValueString(String string) {
        return null;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public RoomTree getCurrentRoom() {
        return this.currentRoom;
    }

    public JTextField getNewRoom() {
        return this.newRoom;
    }

    public RoomTree getRoomTree() {
        return this.roomTree;
    }
}

