/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimpleRoom;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingworker.SwingWorker;

public class ServerStatusView
extends JTabbedPane
implements ChangeListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final String SELECTION_PROPERTY = "ServerStatusView.selection";
    private ServerStatus status;
    private DefaultTreeModel model;
    private DefaultTreeModel[] historicalModels;
    private JTree treeCurrent;
    private JTree[] historicalTrees;
    private int totalPlayers;
    private SwingWorker<ServerStatus.ModuleSummary[], Void> cur_request = null;
    private SwingWorker<ServerStatus.ModuleSummary[], Void> hist_request = null;

    public ServerStatusView(ServerStatus serverStatus) {
        this.status = serverStatus;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JButton jButton = new JButton(Resources.getString("Chat.refresh"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerStatusView.this.refresh();
            }
        });
        jToolBar.add(jButton);
        jPanel.add((Component)jToolBar, "North");
        this.treeCurrent = this.createTree();
        jPanel.add((Component)new JScrollPane(this.treeCurrent), "Center");
        this.model = (DefaultTreeModel)this.treeCurrent.getModel();
        this.addTab(Resources.getString("Chat.current"), jPanel);
        this.addChangeListener(this);
        this.setBorder(new TitledBorder(Resources.getString("Chat.server_connections")));
        this.setStatusServer(this.status);
    }

    private void buildHistoricalTabs() {
        while (this.getTabCount() > 1) {
            this.removeTabAt(this.getTabCount() - 1);
        }
        if (this.status != null) {
            String[] stringArray = this.status.getSupportedTimeRanges();
            this.historicalTrees = new JTree[stringArray.length];
            this.historicalModels = new DefaultTreeModel[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.historicalTrees[i] = this.createTree();
                this.historicalModels[i] = (DefaultTreeModel)this.historicalTrees[i].getModel();
                this.addTab(stringArray[i], new JScrollPane(this.historicalTrees[i]));
            }
        }
    }

    private JTree createTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Resources.getString("General.VASSAL"));
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, true);
        JTree jTree = new JTree(defaultTreeModel);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setCellRenderer(new Render());
        jTree.expandRow(0);
        jTree.setLargeModel(true);
        jTree.setRowHeight(18);
        jTree.addTreeSelectionListener(this);
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                JComponent jComponent = (JComponent)treeExpansionEvent.getSource();
                jComponent.setSize(jComponent.getPreferredSize());
                jComponent.revalidate();
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        return jTree;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.status == null) {
            return;
        }
        this.refresh(this.getSelectedIndex());
        this.fireSelectionChanged();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.fireSelectionChanged();
    }

    private void fireSelectionChanged() {
        Object object = null;
        TreePath treePath = null;
        int n = this.getSelectedIndex();
        switch (n) {
            case 0: {
                treePath = this.treeCurrent.getSelectionPath();
                break;
            }
            default: {
                treePath = this.historicalTrees[n - 1].getSelectionPath();
            }
        }
        if (treePath != null) {
            object = treePath.getLastPathComponent();
        }
        if (object instanceof DefaultMutableTreeNode) {
            object = ((DefaultMutableTreeNode)object).getUserObject();
        }
        this.firePropertyChange(SELECTION_PROPERTY, null, object);
    }

    public void refresh() {
        this.refresh(0);
    }

    private void refresh(final int n) {
        if (n == 0) {
            if (this.cur_request != null && !this.cur_request.isDone()) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.cur_request = new SwingWorker<ServerStatus.ModuleSummary[], Void>(){

                public ServerStatus.ModuleSummary[] doInBackground() {
                    return ServerStatusView.this.status.getStatus();
                }

                protected void done() {
                    try {
                        if (ServerStatusView.this.getSelectedIndex() == 0) {
                            ServerStatusView.this.refresh(ServerStatusView.this.model, (ServerStatus.ModuleSummary[])this.get());
                            ServerStatusView.this.fireSelectionChanged();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        ErrorDialog.bug(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        executionException.printStackTrace();
                    }
                    if (ServerStatusView.this.hist_request == null || ServerStatusView.this.hist_request.isDone()) {
                        ServerStatusView.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    ServerStatusView.this.cur_request = null;
                }
            };
            this.cur_request.execute();
        } else {
            if (this.hist_request != null && !this.hist_request.isDone()) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.hist_request = new SwingWorker<ServerStatus.ModuleSummary[], Void>(){

                public ServerStatus.ModuleSummary[] doInBackground() {
                    return ServerStatusView.this.status.getHistory(ServerStatusView.this.getTitleAt(n));
                }

                protected void done() {
                    int n2 = ServerStatusView.this.getSelectedIndex();
                    if (n2 == n) {
                        try {
                            ServerStatusView.this.refresh(ServerStatusView.this.historicalModels[n2 - 1], (ServerStatus.ModuleSummary[])this.get());
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        catch (ExecutionException executionException) {
                            executionException.printStackTrace();
                        }
                        ServerStatusView.this.fireSelectionChanged();
                    } else if (n2 != 0) {
                        ServerStatusView.this.hist_request = null;
                        ServerStatusView.this.refresh(n2);
                    }
                    if (ServerStatusView.this.cur_request == null || ServerStatusView.this.cur_request.isDone()) {
                        ServerStatusView.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this.hist_request.execute();
        }
    }

    private void refresh(DefaultTreeModel defaultTreeModel, ServerStatus.ModuleSummary[] moduleSummaryArray) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultTreeModel.getRoot();
        this.totalPlayers = 0;
        while (mutableTreeNode.getChildCount() > 0) {
            defaultTreeModel.removeNodeFromParent((MutableTreeNode)mutableTreeNode.getChildAt(0));
        }
        if (moduleSummaryArray.length == 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Resources.getString("Chat.no_connections"));
            defaultMutableTreeNode.setAllowsChildren(false);
        } else {
            for (ServerStatus.ModuleSummary moduleSummary : moduleSummaryArray) {
                defaultTreeModel.insertNodeInto(this.createNode(moduleSummary), mutableTreeNode, mutableTreeNode.getChildCount());
            }
        }
        mutableTreeNode.setUserObject(Resources.getString("General.VASSAL") + " (" + this.totalPlayers + ")");
    }

    private DefaultMutableTreeNode createNode(Object object) {
        Object object2;
        Object[] objectArray = null;
        if (object instanceof ServerStatus.ModuleSummary) {
            object2 = (ServerStatus.ModuleSummary)object;
            objectArray = ((ServerStatus.ModuleSummary)object2).getRooms();
            int n = ((ServerStatus.ModuleSummary)object2).numPlayers();
            ((ServerStatus.ModuleSummary)object2).setModuleName(((ServerStatus.ModuleSummary)object2).getModuleName() + " (" + n + ")");
            this.totalPlayers += n;
        } else if (object instanceof SimpleRoom) {
            object2 = (SimpleRoom)object;
            List<Player> list = ((SimpleRoom)object2).getPlayerList();
            ((SimpleRoom)object2).setName(((SimpleRoom)object2).getName() + " (" + list.size() + ")");
            objectArray = list.toArray(new Player[list.size()]);
        }
        object2 = new DefaultMutableTreeNode(object);
        if (objectArray != null) {
            for (Room room : objectArray) {
                ((DefaultMutableTreeNode)object2).add(this.createNode(room));
            }
        }
        ((DefaultMutableTreeNode)object2).setAllowsChildren(objectArray != null);
        return object2;
    }

    public void setStatusServer(ServerStatus serverStatus) {
        this.status = serverStatus;
        this.buildHistoricalTabs();
        this.setEnabled(serverStatus != null);
    }

    public static class Render
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl3) {
                this.setIcon(null);
            }
            this.putClientProperty("html.disable", Boolean.TRUE);
            return this;
        }
    }
}

