/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SynchCommand;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class SynchAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Player p;
    private ChatServerConnection client;

    public SynchAction(Player player, ChatServerConnection chatServerConnection) {
        super(Resources.getString("Chat.synchronize"));
        this.p = player;
        this.client = chatServerConnection;
        Room room = null;
        for (Room room2 : chatServerConnection.getAvailableRooms()) {
            if (!room2.getPlayerList().contains(player)) continue;
            room = room2;
        }
        if (player != null && GameModule.getGameModule() != null && !player.equals(chatServerConnection.getUserInfo()) && chatServerConnection.getRoom() != null && chatServerConnection.getRoom().equals(room)) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            GameModule.getGameModule().getGameState().setup(false);
            this.client.sendTo(this.p, new SynchCommand(this.client.getUserInfo(), this.client));
        }
    }

    public static PlayerActionFactory factory(final ChatServerConnection chatServerConnection) {
        return new PlayerActionFactory(){

            public Action getAction(Player player, JTree jTree) {
                return new SynchAction(player, chatServerConnection);
            }
        };
    }
}

