/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.module.ExtensionElement;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.PropertiesWindow;
import VASSAL.launch.EditorWindow;
import VASSAL.tools.ReflectionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionTree
extends ConfigureTree {
    private static final long serialVersionUID = 1L;
    private ModuleExtension extension;

    public ExtensionTree(Configurable configurable, HelpWindow helpWindow, ModuleExtension moduleExtension, EditorWindow editorWindow) {
        super(configurable, helpWindow, editorWindow);
        this.extension = moduleExtension;
        this.setCellRenderer(new ExtensionRenderer());
    }

    private boolean isEditable(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            for (ExtensionElement extensionElement : this.extension.getComponentsOf(ExtensionElement.class)) {
                if (extensionElement.getExtension() != defaultMutableTreeNode.getUserObject()) continue;
                return true;
            }
            if (defaultMutableTreeNode.getParent() instanceof DefaultMutableTreeNode) {
                return this.isEditable((DefaultMutableTreeNode)defaultMutableTreeNode.getParent());
            }
        }
        return false;
    }

    public Configurable[] getPath(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object[] objectArray = defaultMutableTreeNode.getUserObjectPath();
        Configurable[] configurableArray = new Configurable[objectArray.length - 1];
        for (int i = 0; i < configurableArray.length; ++i) {
            configurableArray[i] = (Configurable)objectArray[i + 1];
        }
        return configurableArray;
    }

    @Override
    public void externalInsert(Configurable configurable, Configurable configurable2) {
        super.externalInsert(configurable, configurable2);
        if (!this.isEditable(configurable)) {
            this.extension.add(new ExtensionElement(configurable2, this.getPath(this.getTreeNode(configurable))));
        }
    }

    @Override
    protected Action buildAddAction(final Configurable configurable, final Class<? extends Buildable> clazz) {
        return new AbstractAction("Add " + ExtensionTree.getConfigureName(clazz)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                Configurable configurable3 = null;
                try {
                    configurable3 = (Configurable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable throwable) {
                    ReflectionUtils.handleNewInstanceFailure(throwable, clazz);
                }
                if (configurable3 != null) {
                    final Configurable configurable2 = configurable3;
                    configurable2.build(null);
                    if (configurable2 instanceof PieceSlot) {
                        ((PieceSlot)configurable2).updateGpId(ExtensionTree.this.extension);
                    }
                    if (configurable2.getConfigurer() != null) {
                        if (ExtensionTree.this.insert(configurable, configurable2, ExtensionTree.this.getTreeNode(configurable).getChildCount())) {
                            PropertiesWindow propertiesWindow = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ExtensionTree.this), false, configurable2, ExtensionTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                public void save() {
                                    super.save();
                                    if (!ExtensionTree.this.isEditable(configurable)) {
                                        ExtensionElement extensionElement = new ExtensionElement(configurable2, ExtensionTree.this.getPath(ExtensionTree.this.getTreeNode(configurable)));
                                        ExtensionTree.this.extension.add(extensionElement);
                                    }
                                }

                                public void cancel() {
                                    ExtensionTree.this.remove(configurable, configurable2);
                                    this.dispose();
                                }
                            };
                            propertiesWindow.setVisible(true);
                        }
                    } else {
                        boolean bl = ExtensionTree.this.insert(configurable, configurable2, ExtensionTree.this.getTreeNode(configurable).getChildCount());
                        if (bl && !ExtensionTree.this.isEditable(ExtensionTree.this.getTreeNode(configurable))) {
                            ExtensionTree.this.extension.add(new ExtensionElement(configurable2, ExtensionTree.this.getPath(ExtensionTree.this.getTreeNode(configurable))));
                        }
                    }
                }
            }
        };
    }

    @Override
    protected Action buildImportAction(final Configurable configurable) {
        AbstractAction abstractAction = new AbstractAction("Add Imported Class"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                final Configurable configurable3 = ExtensionTree.this.importConfigurable();
                if (configurable3 != null) {
                    try {
                        configurable3.build(null);
                        final Configurable configurable2 = configurable;
                        if (configurable3.getConfigurer() != null) {
                            PropertiesWindow propertiesWindow = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ExtensionTree.this), false, configurable3, ExtensionTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                public void save() {
                                    super.save();
                                    ExtensionTree.this.insert(configurable2, configurable3, ExtensionTree.this.getTreeNode(configurable2).getChildCount());
                                    if (!ExtensionTree.this.isEditable(configurable)) {
                                        ExtensionElement extensionElement = new ExtensionElement(configurable3, ExtensionTree.this.getPath(ExtensionTree.this.getTreeNode(configurable)));
                                        ExtensionTree.this.extension.add(extensionElement);
                                    }
                                }

                                public void cancel() {
                                    this.dispose();
                                }
                            };
                            propertiesWindow.setVisible(true);
                        } else {
                            ExtensionTree.this.insert(configurable2, configurable3, ExtensionTree.this.getTreeNode(configurable2).getChildCount());
                        }
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(ExtensionTree.this.getTopLevelAncestor(), "Error adding " + ConfigureTree.getConfigureName(configurable3) + " to " + ConfigureTree.getConfigureName(configurable) + "\n" + exception.getMessage(), "Illegal configuration", 0);
                    }
                }
            }
        };
        return abstractAction;
    }

    private boolean isEditable(Configurable configurable) {
        return this.isEditable(this.getTreeNode(configurable));
    }

    @Override
    protected Action buildEditAction(Configurable configurable) {
        return this.isEditable(configurable) ? super.buildEditAction(configurable) : null;
    }

    @Override
    protected Action buildCutAction(Configurable configurable) {
        return this.isEditable(configurable) ? super.buildCutAction(configurable) : null;
    }

    @Override
    protected Action buildPasteAction(final Configurable configurable) {
        Action action = null;
        if (this.isEditable(configurable)) {
            action = super.buildPasteAction(configurable);
        } else {
            action = new AbstractAction("Paste"){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtensionTree.this.cutData != null) {
                        DefaultMutableTreeNode defaultMutableTreeNode = ExtensionTree.this.getTreeNode(configurable);
                        Configurable configurable3 = (Configurable)ExtensionTree.this.cutData.getUserObject();
                        if (ExtensionTree.this.remove(ExtensionTree.this.getParent(ExtensionTree.this.cutData), configurable3) && ExtensionTree.this.insert(configurable, configurable3, defaultMutableTreeNode.getChildCount())) {
                            ExtensionTree.this.extension.add(new ExtensionElement(configurable3, ExtensionTree.this.getPath(defaultMutableTreeNode)));
                        }
                    } else if (ExtensionTree.this.copyData != null) {
                        Configurable configurable4 = (Configurable)ExtensionTree.this.copyData.getUserObject();
                        Configurable configurable2 = null;
                        try {
                            configurable2 = (Configurable)configurable4.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Throwable throwable) {
                            ReflectionUtils.handleNewInstanceFailure(throwable, configurable4.getClass());
                        }
                        if (configurable2 != null) {
                            configurable2.build(configurable4.getBuildElement(Builder.createNewDocument()));
                            if (ExtensionTree.this.insert(configurable, configurable2, ExtensionTree.this.getTreeNode(configurable).getChildCount())) {
                                ExtensionTree.this.updateGpIds(configurable2);
                                ExtensionTree.this.extension.add(new ExtensionElement(configurable2, ExtensionTree.this.getPath(ExtensionTree.this.getTreeNode(configurable))));
                            }
                        }
                    }
                    ExtensionTree.this.cutData = null;
                    ExtensionTree.this.updateEditMenu();
                }
            };
            action.setEnabled(this.isValidPasteTarget(configurable));
        }
        return action;
    }

    @Override
    protected boolean isValidPasteTarget(Configurable configurable) {
        return this.cutData != null && super.isValidParent(configurable, (Configurable)this.cutData.getUserObject()) && this.isEditable(this.getParent(this.cutData)) || this.copyData != null && super.isValidParent(configurable, (Configurable)this.copyData.getUserObject());
    }

    @Override
    protected void updateGpIds(Configurable configurable) {
        if (configurable instanceof PieceSlot) {
            ((PieceSlot)configurable).updateGpId(this.extension);
        } else {
            for (Configurable configurable2 : configurable.getConfigureComponents()) {
                this.updateGpIds(configurable2);
            }
        }
    }

    @Override
    protected Action buildMoveAction(Configurable configurable) {
        return this.isEditable((DefaultMutableTreeNode)this.getTreeNode(configurable).getParent()) ? super.buildMoveAction(configurable) : null;
    }

    @Override
    protected Action buildDeleteAction(final Configurable configurable) {
        AbstractAction abstractAction = null;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(configurable);
        if (defaultMutableTreeNode.getParent() != null && this.isEditable(defaultMutableTreeNode)) {
            final Configurable configurable2 = (Configurable)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            abstractAction = new AbstractAction("Delete"){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ExtensionTree.this.remove(configurable2, configurable);
                    if (bl && !ExtensionTree.this.isEditable(configurable2)) {
                        for (ExtensionElement extensionElement : ExtensionTree.this.extension.getComponentsOf(ExtensionElement.class)) {
                            if (extensionElement.getExtension() != configurable) continue;
                            ExtensionTree.this.extension.remove(extensionElement);
                            break;
                        }
                    }
                }
            };
        }
        return abstractAction;
    }

    @Override
    protected Action buildCloneAction(final Configurable configurable) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(configurable);
        final DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (this.isEditable(defaultMutableTreeNode2)) {
            return super.buildCloneAction(configurable);
        }
        if (defaultMutableTreeNode2 != null) {
            return new AbstractAction("Clone"){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    Configurable configurable2 = null;
                    try {
                        configurable2 = (Configurable)configurable.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable throwable) {
                        ReflectionUtils.handleNewInstanceFailure(throwable, configurable.getClass());
                    }
                    if (configurable2 != null) {
                        configurable2.build(configurable.getBuildElement(Builder.createNewDocument()));
                        if (ExtensionTree.this.insert((Configurable)defaultMutableTreeNode2.getUserObject(), configurable2, defaultMutableTreeNode2.getChildCount())) {
                            ExtensionTree.this.extension.add(new ExtensionElement(configurable2, ExtensionTree.this.getPath(defaultMutableTreeNode2)));
                        }
                    }
                }
            };
        }
        return null;
    }

    @Override
    protected Action buildEditPiecesAction(Configurable configurable) {
        Action action = null;
        if (this.isEditable(configurable)) {
            action = super.buildEditPiecesAction(configurable);
        }
        return action;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && this.isEditable((DefaultMutableTreeNode)treePath.getLastPathComponent())) {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    protected boolean isValidParent(Configurable configurable, Configurable configurable2) {
        return super.isValidParent(configurable, configurable2) && this.isEditable(configurable);
    }

    @Override
    protected void updateEditMenu() {
        super.updateEditMenu();
        this.deleteAction.setEnabled(this.selected != null && this.isEditable(this.selected));
        this.cutAction.setEnabled(this.selected != null && this.isEditable(this.selected));
        this.propertiesAction.setEnabled(this.selected != null && this.isEditable(this.selected) && this.selected.getConfigurer() != null);
    }

    class ExtensionRenderer
    extends ConfigureTree.Renderer {
        private static final long serialVersionUID = 1L;

        ExtensionRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            component.setForeground(ExtensionTree.this.isEditable((DefaultMutableTreeNode)object) ? Color.BLACK : Color.GRAY);
            return component;
        }
    }
}

