/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class StringArrayConfigurer
extends Configurer {
    private JPanel panel;
    private JList list;
    private DefaultListModel model;
    private static final String[] EMPTY = new String[0];

    public StringArrayConfigurer(String string, String string2, Object object) {
        super(string, string2, object);
    }

    public StringArrayConfigurer(String string, String string2) {
        super(string, string2);
    }

    public DefaultListModel getModel() {
        return this.model;
    }

    public void addValue(String string) {
        if (this.value == null) {
            this.setValue(new String[]{string});
        } else {
            String[] stringArray = new String[Array.getLength(this.value) + 1];
            System.arraycopy(this.value, 0, stringArray, 0, stringArray.length - 1);
            stringArray[stringArray.length - 1] = string;
            this.setValue(stringArray);
        }
    }

    public void removeValue(String string) {
        String[] stringArray = this.getStringArray();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            String[] stringArray2 = new String[Array.getLength(this.value) - 1];
            if (i > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, i);
            }
            if (i < stringArray.length - 1) {
                System.arraycopy(stringArray, i + 1, stringArray2, i, stringArray.length - 1 - i);
            }
            this.setValue(stringArray2);
            return;
        }
    }

    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            Box box = Box.createHorizontalBox();
            Box box2 = Box.createVerticalBox();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.model = new DefaultListModel();
            this.updateModel();
            this.list = new JList(this.model);
            this.list.setPrototypeCellValue("MMMMMMMM");
            this.list.setVisibleRowCount(2);
            this.list.setSelectionMode(0);
            final JTextField jTextField = new JTextField(8);
            jTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, jTextField.getPreferredSize().height));
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = jTextField.getText();
                    StringArrayConfigurer.this.addValue(string);
                    jTextField.setText("");
                }
            };
            ActionListener actionListener2 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (StringArrayConfigurer.this.value == null) {
                        StringArrayConfigurer.this.addValue(jTextField.getText());
                    } else {
                        int n = StringArrayConfigurer.this.list.getSelectedIndex();
                        if (n < 0) {
                            n = StringArrayConfigurer.this.list.getModel().getSize();
                        }
                        String[] stringArray = new String[Array.getLength(StringArrayConfigurer.this.value) + 1];
                        if (n > 0) {
                            System.arraycopy(StringArrayConfigurer.this.value, 0, stringArray, 0, n);
                        }
                        stringArray[n] = jTextField.getText();
                        if (n < stringArray.length) {
                            System.arraycopy(StringArrayConfigurer.this.value, n, stringArray, n + 1, stringArray.length - n - 1);
                        }
                        StringArrayConfigurer.this.setValue(stringArray);
                        jTextField.setText("");
                        StringArrayConfigurer.this.list.setSelectedIndex(n + 1);
                    }
                }
            };
            JButton jButton = new JButton(Resources.getString("General.add"));
            jButton.addActionListener(actionListener);
            jTextField.addActionListener(actionListener2);
            box2.add(jTextField);
            box.add(jButton);
            JButton jButton2 = new JButton(Resources.getString("General.remove"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = StringArrayConfigurer.this.list.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        StringArrayConfigurer.this.removeValue((String)objectArray[i]);
                    }
                }
            });
            box.add(jButton2);
            JButton jButton3 = new JButton(Resources.getString("General.insert"));
            jButton3.addActionListener(actionListener2);
            box.add(jButton3);
            box2.add(box);
            JSplitPane jSplitPane = new JSplitPane(1);
            jSplitPane.setLeftComponent(box2);
            jSplitPane.setRightComponent(new ScrollPane(this.list));
            this.panel.add(jSplitPane);
            this.panel.setBorder(new TitledBorder(this.name));
        }
        return this.panel;
    }

    public String[] getStringArray() {
        if (this.value instanceof String[]) {
            return (String[])this.value;
        }
        return EMPTY;
    }

    public String getValueString() {
        return StringArrayConfigurer.arrayToString(this.getStringArray());
    }

    public static String arrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < stringArray.length; ++i) {
            sequenceEncoder.append(stringArray[i] != null ? stringArray[i] : "");
        }
        return sequenceEncoder.getValue();
    }

    public void setValue(Object stringArray) {
        if (stringArray == null) {
            stringArray = EMPTY;
        }
        super.setValue(stringArray);
        this.updateModel();
    }

    public void setValue(String string) {
        String[] stringArray = StringArrayConfigurer.stringToArray(string);
        this.setValue(stringArray);
    }

    public static String[] stringToArray(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        ArrayList<String> arrayList = new ArrayList<String>();
        while (decoder.hasMoreTokens()) {
            arrayList.add(decoder.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void updateModel() {
        if (this.model != null) {
            this.model.removeAllElements();
            String[] stringArray = this.getStringArray();
            for (int i = 0; i < stringArray.length; ++i) {
                this.model.addElement(stringArray[i]);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final StringArrayConfigurer stringArrayConfigurer = new StringArrayConfigurer(null, "Visible to these players:  ");
        stringArrayConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.err.println(stringArrayConfigurer.getName() + " = " + stringArrayConfigurer.getValueString());
            }
        });
        stringArrayConfigurer.setValue("Rack,Shack,Benny");
        jFrame.add(stringArrayConfigurer.getControls());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

