/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.ValidationReport;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ValidationReportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private CallBack callback;

    public ValidationReportDialog(ValidationReport validationReport, CallBack callBack) {
        super((Frame)GameModule.getGameModule().getFrame(), false);
        this.setTitle("Problems found in module");
        this.callback = callBack;
        Box box = Box.createVerticalBox();
        this.add(box);
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        List<String> list = validationReport.getWarnings();
        switch (list.size()) {
            case 0: {
                box.add(new JLabel("No problems found"));
                jPanel.add(this.createOkButton());
                break;
            }
            case 1: {
                box.add(new JLabel("A problem was found in this module."));
                box.add(new JLabel(list.get(0).toString() + "."));
                jPanel.add(this.createOkButton());
                jPanel.add(this.createCancelButton());
                break;
            }
            default: {
                box.add(new JLabel("The following problems were found in this module."));
                box.add(new JLabel("If not fixed, they could cause bugs during game play."));
                JList<Object> jList = new JList<Object>(list.toArray());
                jList.setVisibleRowCount(Math.min(jList.getVisibleRowCount(), list.size()));
                box.add(new ScrollPane(jList));
                jPanel.add(this.createOkButton());
                jPanel.add(this.createCancelButton());
            }
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JButton createCancelButton() {
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidationReportDialog.this.callback.cancel();
                ValidationReportDialog.this.dispose();
            }
        });
        return jButton;
    }

    private JButton createOkButton() {
        JButton jButton = new JButton("Ignore, save anyway");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidationReportDialog.this.callback.ok();
                ValidationReportDialog.this.dispose();
            }
        });
        return jButton;
    }

    public static interface CallBack {
        public void ok();

        public void cancel();
    }
}

