/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.RemovePiece;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.ImagePicker;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.KeySpecifier;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.StateMergeable;
import VASSAL.i18n.Localization;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class BasicPiece
implements TranslatablePiece,
StateMergeable {
    public static final String ID = "piece;";
    private static Highlighter highlighter;
    public static final String LOCATION_NAME = "LocationName";
    public static final String CURRENT_MAP = "CurrentMap";
    public static final String CURRENT_BOARD = "CurrentBoard";
    public static final String CURRENT_ZONE = "CurrentZone";
    public static final String CURRENT_X = "CurrentX";
    public static final String CURRENT_Y = "CurrentY";
    public static final String OLD_LOCATION_NAME = "OldLocationName";
    public static final String OLD_MAP = "OldMap";
    public static final String OLD_BOARD = "OldBoard";
    public static final String OLD_ZONE = "OldZone";
    public static final String OLD_X = "OldX";
    public static final String OLD_Y = "OldY";
    public static final String BASIC_NAME = "BasicName";
    public static final String PIECE_NAME = "PieceName";
    public static final String DECK_NAME = "DeckName";
    public static Font POPUP_MENU_FONT;
    protected JPopupMenu popup;
    protected Rectangle imageBounds;
    protected ScaledImagePainter imagePainter = new ScaledImagePainter();
    private Map map;
    private KeyCommand[] commands;
    private Stack parent;
    private Point pos = new Point(0, 0);
    private String id;
    private java.util.Map<Object, Object> props;
    @Deprecated
    private char cloneKey;
    @Deprecated
    private char deleteKey;
    @Deprecated
    protected Image image;
    protected String imageName;
    private String commonName;

    public BasicPiece() {
        this("piece;;;;;");
    }

    public BasicPiece(String string) {
        this.mySetType(string);
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.cloneKey = decoder.nextChar('\u0000');
        this.deleteKey = decoder.nextChar('\u0000');
        this.imageName = decoder.nextToken();
        this.commonName = decoder.nextToken();
        this.imagePainter.setImageName(this.imageName);
        this.commands = null;
    }

    public String getType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(this.cloneKey > '\u0000' ? String.valueOf(this.cloneKey) : "", ';');
        return ID + sequenceEncoder.append(this.deleteKey > '\u0000' ? String.valueOf(this.deleteKey) : "").append(this.imageName).append(this.commonName).getValue();
    }

    public void setMap(Map map) {
        if (map != this.map) {
            this.commands = null;
            this.map = map;
        }
    }

    public Map getMap() {
        return this.getParent() == null ? this.map : this.getParent().getMap();
    }

    public Object getProperty(Object object) {
        if (BASIC_NAME.equals(object)) {
            return this.getName();
        }
        return this.getPublicProperty(object);
    }

    public Object getPublicProperty(Object object) {
        Object object2;
        if ("KeyCommands".equals(object)) {
            return this.getKeyCommands();
        }
        if (LOCATION_NAME.equals(object)) {
            return this.getMap() == null ? "" : this.getMap().locationName(this.getPosition());
        }
        if (PIECE_NAME.equals(object)) {
            return Decorator.getOutermost(this).getName();
        }
        if (CURRENT_MAP.equals(object)) {
            return this.getMap() == null ? "" : this.getMap().getConfigureName();
        }
        if (DECK_NAME.equals(object)) {
            return this.getParent() instanceof Deck ? ((Deck)this.getParent()).getDeckName() : "";
        }
        if (CURRENT_BOARD.equals(object)) {
            Board board;
            if (this.getMap() != null && (board = this.getMap().findBoard(this.getPosition())) != null) {
                return board.getName();
            }
            return "";
        }
        if (CURRENT_ZONE.equals(object)) {
            Zone zone;
            if (this.getMap() != null && (zone = this.getMap().findZone(this.getPosition())) != null) {
                return zone.getName();
            }
            return "";
        }
        if (CURRENT_X.equals(object)) {
            return String.valueOf(this.getPosition().x);
        }
        if (CURRENT_Y.equals(object)) {
            return String.valueOf(this.getPosition().y);
        }
        if ("visibleState".equals(object)) {
            return "";
        }
        Object object3 = object2 = this.props == null ? null : this.props.get(object);
        if (object2 == null) {
            Zone zone;
            Map map = this.getMap();
            Zone zone2 = zone = map == null ? null : map.findZone(this.getPosition());
            object2 = zone != null ? zone.getProperty(object) : (map != null ? map.getProperty(object) : GameModule.getGameModule().getProperty(object));
        }
        return object2;
    }

    public Object getLocalizedProperty(Object object) {
        if (BASIC_NAME.equals(object)) {
            return this.getLocalizedName();
        }
        return this.getLocalizedPublicProperty(object);
    }

    public Object getLocalizedPublicProperty(Object object) {
        Object object2;
        if ("KeyCommands".equals(object)) {
            return this.getProperty(object);
        }
        if (LOCATION_NAME.equals(object)) {
            return this.getMap() == null ? "" : this.getMap().localizedLocationName(this.getPosition());
        }
        if (PIECE_NAME.equals(object)) {
            return Decorator.getOutermost(this).getName();
        }
        if (BASIC_NAME.equals(object)) {
            return this.getLocalizedName();
        }
        if (CURRENT_MAP.equals(object)) {
            return this.getMap() == null ? "" : this.getMap().getLocalizedConfigureName();
        }
        if (DECK_NAME.equals(object)) {
            return this.getParent() instanceof Deck ? ((Deck)this.getParent()).getLocalizedDeckName() : "";
        }
        if (CURRENT_BOARD.equals(object)) {
            Board board;
            if (this.getMap() != null && (board = this.getMap().findBoard(this.getPosition())) != null) {
                return board.getLocalizedName();
            }
            return "";
        }
        if (CURRENT_ZONE.equals(object)) {
            Zone zone;
            if (this.getMap() != null && (zone = this.getMap().findZone(this.getPosition())) != null) {
                return zone.getLocalizedName();
            }
            return "";
        }
        if (CURRENT_X.equals(object)) {
            return this.getProperty(object);
        }
        if (CURRENT_Y.equals(object)) {
            return this.getProperty(object);
        }
        if ("visibleState".equals(object)) {
            return this.getProperty(object);
        }
        Object object3 = object2 = this.props == null ? null : this.props.get(object);
        if (object2 == null) {
            Zone zone;
            Map map = this.getMap();
            Zone zone2 = zone = map == null ? null : map.findZone(this.getPosition());
            object2 = zone != null ? zone.getLocalizedProperty(object) : (map != null ? map.getLocalizedProperty(object) : GameModule.getGameModule().getLocalizedProperty(object));
        }
        return object2;
    }

    public void setProperty(Object object, Object object2) {
        if (this.props == null) {
            this.props = new HashMap<Object, Object>();
        }
        if (object2 == null) {
            this.props.remove(object);
        } else {
            this.props.put(object, object2);
        }
    }

    protected Object prefsValue(String string) {
        return GameModule.getGameModule().getPrefs().getValue(string);
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if (this.imageBounds == null) {
            this.imageBounds = this.boundingBox();
        }
        this.imagePainter.draw(graphics, n + (int)(d * (double)this.imageBounds.x), n2 + (int)(d * (double)this.imageBounds.y), d, component);
    }

    protected KeyCommand[] getKeyCommands() {
        Object object;
        if (this.commands == null) {
            object = new ArrayList();
            GamePiece gamePiece = Decorator.getOutermost(this);
            if (this.cloneKey > '\u0000') {
                ((ArrayList)object).add(new KeyCommand("Clone", KeyStroke.getKeyStroke((int)this.cloneKey, 2), gamePiece));
            }
            if (this.deleteKey > '\u0000') {
                ((ArrayList)object).add(new KeyCommand("Delete", KeyStroke.getKeyStroke((int)this.deleteKey, 2), gamePiece));
            }
            this.commands = ((ArrayList)object).toArray(new KeyCommand[((ArrayList)object).size()]);
        }
        boolean bl = (object = Decorator.getOutermost(this)).getMap() != null && object.getParent() != null && object.getParent().topPiece() != this.getParent().bottomPiece();
        this.enableCommand("Move up", bl);
        this.enableCommand("Move down", bl);
        this.enableCommand("Move to top", bl);
        this.enableCommand("Move to bottom", bl);
        this.enableCommand("Clone", object.getMap() != null);
        this.enableCommand("Delete", object.getMap() != null);
        return this.commands;
    }

    private void enableCommand(String string, boolean bl) {
        for (int i = 0; i < this.commands.length; ++i) {
            if (!string.equals(this.commands[i].getName())) continue;
            this.commands[i].setEnabled(bl);
        }
    }

    private boolean isEnabled(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return false;
        }
        for (int i = 0; i < this.commands.length; ++i) {
            if (!keyStroke.equals(this.commands[i].getKeyStroke())) continue;
            return this.commands[i].isEnabled();
        }
        return true;
    }

    public Point getPosition() {
        return this.getParent() == null ? new Point(this.pos) : this.getParent().getPosition();
    }

    public void setPosition(Point point) {
        if (this.getMap() != null && this.getParent() == null) {
            this.getMap().repaint(this.getMap().boundingBoxOf(Decorator.getOutermost(this)));
        }
        this.pos = point;
        if (this.getMap() != null && this.getParent() == null) {
            this.getMap().repaint(this.getMap().boundingBoxOf(Decorator.getOutermost(this)));
        }
    }

    public Stack getParent() {
        return this.parent;
    }

    public void setParent(Stack stack) {
        this.parent = stack;
    }

    public Rectangle boundingBox() {
        if (this.imageBounds == null) {
            this.imageBounds = ImageUtils.getBounds(this.imagePainter.getImageSize());
        }
        return new Rectangle(this.imageBounds);
    }

    public Shape getShape() {
        return this.boundingBox();
    }

    public boolean equals(GamePiece gamePiece) {
        return gamePiece == this;
    }

    public String getName() {
        return this.commonName;
    }

    public String getLocalizedName() {
        String string = "Piece." + this.getName();
        return Localization.getInstance().translate(string, this.getName());
    }

    public Command keyEvent(KeyStroke keyStroke) {
        this.getKeyCommands();
        if (!this.isEnabled(keyStroke)) {
            return null;
        }
        Command command = null;
        GamePiece gamePiece = Decorator.getOutermost(this);
        if (KeyStroke.getKeyStroke((int)this.cloneKey, 2).equals(keyStroke)) {
            GamePiece gamePiece2 = ((AddPiece)GameModule.getGameModule().decode(GameModule.getGameModule().encode(new AddPiece(gamePiece)))).getTarget();
            gamePiece2.setId(null);
            GameModule.getGameModule().getGameState().addPiece(gamePiece2);
            gamePiece2.setState(gamePiece.getState());
            command = new AddPiece(gamePiece2);
            if (this.getMap() != null) {
                command.append(this.getMap().placeOrMerge(gamePiece2, this.getPosition()));
                KeyBuffer.getBuffer().remove(gamePiece);
                KeyBuffer.getBuffer().add(gamePiece2);
                if (GlobalOptions.getInstance().autoReportEnabled() && !Boolean.TRUE.equals(gamePiece.getProperty("InvisibleToOthers"))) {
                    String string = "* " + gamePiece.getLocalizedName();
                    String string2 = this.getMap().locationName(gamePiece.getPosition());
                    string = string2 != null ? string + " cloned in " + string2 + " * " : string + "cloned *";
                    Chatter.DisplayText displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
                    displayText.execute();
                    command = command.append(displayText);
                }
            }
        } else if (KeyStroke.getKeyStroke((int)this.deleteKey, 2).equals(keyStroke)) {
            command = new RemovePiece(gamePiece);
            if (this.getMap() != null && GlobalOptions.getInstance().autoReportEnabled() && !Boolean.TRUE.equals(gamePiece.getProperty("InvisibleToOthers"))) {
                String string = "* " + gamePiece.getLocalizedName();
                String string3 = this.getMap().locationName(gamePiece.getPosition());
                string = string3 != null ? string + " deleted from " + string3 + " * " : string + " deleted *";
                Chatter.DisplayText displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
                command = command.append(displayText);
            }
            command.execute();
        } else if (this.getMap() != null && keyStroke.equals(this.getMap().getStackMetrics().getMoveUpKey())) {
            if (this.parent != null) {
                String string = this.parent.getState();
                int n = this.parent.indexOf(gamePiece);
                if (n < this.parent.getPieceCount() - 1) {
                    this.parent.insert(gamePiece, n + 1);
                    command = new ChangePiece(this.parent.getId(), string, this.parent.getState());
                } else {
                    this.getMap().getPieceCollection().moveToFront(this.parent);
                }
            } else {
                this.getMap().getPieceCollection().moveToFront(gamePiece);
            }
        } else if (this.getMap() != null && keyStroke.equals(this.getMap().getStackMetrics().getMoveDownKey())) {
            if (this.parent != null) {
                String string = this.parent.getState();
                int n = this.parent.indexOf(gamePiece);
                if (n > 0) {
                    this.parent.insert(gamePiece, n - 1);
                    command = new ChangePiece(this.parent.getId(), string, this.parent.getState());
                } else {
                    this.getMap().getPieceCollection().moveToBack(this.parent);
                }
            } else {
                this.getMap().getPieceCollection().moveToBack(gamePiece);
            }
        } else if (this.getMap() != null && keyStroke.equals(this.getMap().getStackMetrics().getMoveTopKey())) {
            this.parent = gamePiece.getParent();
            if (this.parent != null) {
                String string = this.parent.getState();
                if (this.parent.indexOf(gamePiece) < this.parent.getPieceCount() - 1) {
                    this.parent.insert(gamePiece, this.parent.getPieceCount() - 1);
                    command = new ChangePiece(this.parent.getId(), string, this.parent.getState());
                } else {
                    this.getMap().getPieceCollection().moveToFront(this.parent);
                }
            } else {
                this.getMap().getPieceCollection().moveToFront(gamePiece);
            }
        } else if (this.getMap() != null && keyStroke.equals(this.getMap().getStackMetrics().getMoveBottomKey())) {
            this.parent = this.getParent();
            if (this.parent != null) {
                String string = this.parent.getState();
                if (this.parent.indexOf(gamePiece) > 0) {
                    this.parent.insert(gamePiece, 0);
                    command = new ChangePiece(this.parent.getId(), string, this.parent.getState());
                } else {
                    this.getMap().getPieceCollection().moveToBack(this.parent);
                }
            } else {
                this.getMap().getPieceCollection().moveToBack(gamePiece);
            }
        }
        return command;
    }

    public String getState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        String string = this.map == null ? "null" : this.map.getIdentifier();
        sequenceEncoder.append(string);
        Point point = this.getPosition();
        sequenceEncoder.append(point.x).append(point.y);
        sequenceEncoder.append(this.getGpId());
        return sequenceEncoder.getValue();
    }

    public void setState(String string) {
        GamePiece gamePiece = Decorator.getOutermost(this);
        Map map = this.getMap();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string2 = decoder.nextToken();
        Map map2 = null;
        if (!"null".equals(string2) && (map2 = Map.getMapById(string2)) == null) {
            Decorator.reportDataError(this, Resources.getString("Error.not_found", "Map"), "mapId=" + string2);
        }
        Point point = new Point(decoder.nextInt(0), decoder.nextInt(0));
        this.setPosition(point);
        if (map2 != map) {
            if (map2 != null) {
                map2.addPiece(gamePiece);
            } else if (map != null) {
                map.removePiece(gamePiece);
                this.setMap(null);
            } else {
                this.setMap(null);
            }
        }
        this.setGpId(decoder.nextToken(""));
    }

    public void mergeState(String string, String string2) {
        if (!string.equals(string2)) {
            this.setState(string);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public static Highlighter getHighlighter() {
        if (highlighter == null) {
            highlighter = new ColoredBorder();
        }
        return highlighter;
    }

    public static void setHighlighter(Highlighter highlighter) {
        BasicPiece.highlighter = highlighter;
    }

    public String getDescription() {
        return "Basic Piece";
    }

    public String getGpId() {
        String string = (String)this.getProperty("PieceId");
        return string == null ? "" : string;
    }

    public void setGpId(String string) {
        this.setProperty("PieceId", string == null ? "" : string);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("BasicPiece.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public String toString() {
        return super.toString() + "[name=" + this.getName() + ",type=" + this.getType() + ",state=" + this.getState() + "]";
    }

    public PieceI18nData getI18nData() {
        PieceI18nData pieceI18nData = new PieceI18nData(this);
        pieceI18nData.add(this.commonName, "Basic piece name");
        return pieceI18nData;
    }

    static {
        POPUP_MENU_FONT = new Font("Dialog", 0, 11);
    }

    private static class Ed
    implements PieceEditor {
        private JPanel panel;
        private KeySpecifier cloneKeyInput;
        private KeySpecifier deleteKeyInput;
        private JTextField pieceName;
        private ImagePicker picker;
        private String state;

        private Ed(BasicPiece basicPiece) {
            this.state = basicPiece.getState();
            this.initComponents(basicPiece);
        }

        private void initComponents(BasicPiece basicPiece) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.picker = new ImagePicker();
            this.picker.setImageName(basicPiece.imageName);
            this.panel.add(this.picker);
            this.cloneKeyInput = new KeySpecifier(basicPiece.cloneKey);
            this.deleteKeyInput = new KeySpecifier(basicPiece.deleteKey);
            this.pieceName = new JTextField(12);
            this.pieceName.setText(basicPiece.commonName);
            this.pieceName.setMaximumSize(this.pieceName.getPreferredSize());
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel("Name:  "));
            box2.add(this.pieceName);
            box.add(box2);
            if (basicPiece.cloneKey != '\u0000') {
                box2 = Box.createHorizontalBox();
                box2.add(new JLabel("To Clone:  "));
                box2.add(this.cloneKeyInput);
                box.add(box2);
            }
            if (basicPiece.deleteKey != '\u0000') {
                box2 = Box.createHorizontalBox();
                box2.add(new JLabel("To Delete:  "));
                box2.add(this.deleteKeyInput);
                box.add(box2);
            }
            this.panel.add(box);
        }

        public void reset(BasicPiece basicPiece) {
        }

        public Component getControls() {
            return this.panel;
        }

        public String getState() {
            return this.state;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(this.cloneKeyInput.getKey(), ';');
            String string = sequenceEncoder.append(this.deleteKeyInput.getKey()).append(this.picker.getImageName()).append(this.pieceName.getText()).getValue();
            return BasicPiece.ID + string;
        }
    }
}

