/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.Map;
import VASSAL.command.Command;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.SimplePieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.StateMergeable;
import VASSAL.i18n.Localization;
import VASSAL.i18n.PieceI18nData;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import java.awt.Point;
import java.util.NoSuchElementException;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Decorator
implements GamePiece,
StateMergeable {
    protected GamePiece piece;
    private Decorator dec;

    public void setInner(GamePiece gamePiece) {
        this.piece = gamePiece;
        if (gamePiece != null) {
            gamePiece.setProperty("Outer", this);
        }
    }

    @Override
    public void setMap(Map map) {
        this.piece.setMap(map);
    }

    public GamePiece getInner() {
        return this.piece;
    }

    @Override
    public Map getMap() {
        return this.piece.getMap();
    }

    @Override
    public void setParent(Stack stack) {
        this.piece.setParent(stack);
    }

    @Override
    public Stack getParent() {
        return this.piece.getParent();
    }

    @Override
    public Object getProperty(Object object) {
        if ("KeyCommands".equals(object)) {
            return this.getKeyCommands();
        }
        if ("Inner".equals(object)) {
            return this.piece;
        }
        if ("Outer".equals(object)) {
            return this.dec;
        }
        if ("visibleState".equals(object)) {
            return this.myGetState() + this.piece.getProperty(object);
        }
        return this.piece.getProperty(object);
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if ("KeyCommands".equals(object)) {
            return this.getProperty(object);
        }
        if ("Inner".equals(object)) {
            return this.getProperty(object);
        }
        if ("Outer".equals(object)) {
            return this.getProperty(object);
        }
        if ("visibleState".equals(object)) {
            return this.getProperty(object);
        }
        return this.piece.getLocalizedProperty(object);
    }

    @Override
    public void setProperty(Object object, Object object2) {
        if ("Inner".equals(object)) {
            this.setInner((GamePiece)object2);
        } else if ("Outer".equals(object)) {
            this.dec = (Decorator)object2;
        } else {
            this.piece.setProperty(object, object2);
        }
    }

    public Decorator getOuter() {
        return this.dec;
    }

    @Override
    public void setPosition(Point point) {
        this.piece.setPosition(point);
    }

    @Override
    public Point getPosition() {
        return this.piece.getPosition();
    }

    public abstract void mySetState(String var1);

    @Override
    public void setState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
        this.mySetState(decoder.nextToken());
        try {
            this.piece.setState(decoder.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("No state for Decorator=" + this.myGetType());
        }
    }

    @Override
    public void mergeState(String string, String string2) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
        String string3 = decoder.nextToken();
        String string4 = decoder.nextToken();
        SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(string2, '\t');
        String string5 = decoder2.nextToken();
        String string6 = decoder2.nextToken();
        if (!string5.equals(string3)) {
            this.mySetState(string3);
        }
        if (this.piece instanceof StateMergeable) {
            ((StateMergeable)((Object)this.piece)).mergeState(string4, string6);
        } else {
            this.piece.setState(string4);
        }
    }

    public abstract String myGetState();

    @Override
    public String getState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(this.myGetState(), '\t');
        sequenceEncoder.append(this.piece.getState());
        return sequenceEncoder.getValue();
    }

    public abstract String myGetType();

    @Override
    public String getType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(this.myGetType(), '\t');
        sequenceEncoder.append(this.piece.getType());
        return sequenceEncoder.getValue();
    }

    protected abstract KeyCommand[] myGetKeyCommands();

    protected KeyCommand[] getKeyCommands() {
        KeyCommand[] keyCommandArray = this.myGetKeyCommands();
        KeyCommand[] keyCommandArray2 = (KeyCommand[])this.piece.getProperty("KeyCommands");
        if (keyCommandArray2 == null) {
            return keyCommandArray;
        }
        if (keyCommandArray == null) {
            return keyCommandArray2;
        }
        KeyCommand[] keyCommandArray3 = new KeyCommand[keyCommandArray2.length + keyCommandArray.length];
        System.arraycopy(keyCommandArray, 0, keyCommandArray3, 0, keyCommandArray.length);
        System.arraycopy(keyCommandArray2, 0, keyCommandArray3, keyCommandArray.length, keyCommandArray2.length);
        return keyCommandArray3;
    }

    public abstract Command myKeyEvent(KeyStroke var1);

    @Override
    public Command keyEvent(KeyStroke keyStroke) {
        Command command = this.myKeyEvent(keyStroke);
        return command == null ? this.piece.keyEvent(keyStroke) : command.append(this.piece.keyEvent(keyStroke));
    }

    @Override
    public String getId() {
        return this.piece.getId();
    }

    @Override
    public void setId(String string) {
        this.piece.setId(string);
    }

    public static GamePiece getOutermost(GamePiece gamePiece) {
        while (gamePiece.getProperty("Outer") != null) {
            gamePiece = (GamePiece)gamePiece.getProperty("Outer");
        }
        return gamePiece;
    }

    public static GamePiece getInnermost(GamePiece gamePiece) {
        while (gamePiece instanceof Decorator) {
            gamePiece = ((Decorator)gamePiece).piece;
        }
        return gamePiece;
    }

    public static GamePiece getDecorator(GamePiece gamePiece, Class<?> clazz) {
        while (gamePiece instanceof Decorator) {
            if (clazz.isInstance(gamePiece)) {
                return gamePiece;
            }
            gamePiece = ((Decorator)gamePiece).piece;
        }
        return null;
    }

    public PieceEditor getEditor() {
        return new SimplePieceEditor(this);
    }

    public String toString() {
        if (this.piece == null) {
            return super.toString();
        }
        return super.toString() + "[name=" + this.getName() + ",type=" + this.getType() + ",state=" + this.getState() + "]";
    }

    @Override
    public String getLocalizedName() {
        return this.piece.getLocalizedName();
    }

    public PieceI18nData getI18nData() {
        return new PieceI18nData(this);
    }

    protected PieceI18nData getI18nData(String string, String string2) {
        PieceI18nData pieceI18nData = new PieceI18nData(this);
        pieceI18nData.add(string, string2);
        return pieceI18nData;
    }

    protected PieceI18nData getI18nData(String[] stringArray, String[] stringArray2) {
        PieceI18nData pieceI18nData = new PieceI18nData(this);
        for (int i = 0; i < stringArray.length; ++i) {
            pieceI18nData.add(stringArray[i], stringArray2[i]);
        }
        return pieceI18nData;
    }

    protected String getCommandDescription(String string, String string2) {
        String string3 = "";
        if (string != null && string.length() > 0) {
            string3 = string3 + string + ": ";
        }
        return string3 + string2;
    }

    protected String getTranslation(String string) {
        String string2 = "Piece." + string;
        return Localization.getInstance().translate(string2, string);
    }

    protected static void reportDataError(EditablePiece editablePiece, String string, String string2, Throwable throwable) {
        ErrorDialog.dataError(new BadDataReport(editablePiece, string, string2, throwable));
    }

    protected static void reportDataError(EditablePiece editablePiece, String string, String string2) {
        ErrorDialog.dataError(new BadDataReport(editablePiece, string, string2));
    }

    protected static void reportDataError(EditablePiece editablePiece, String string) {
        ErrorDialog.dataError(new BadDataReport(editablePiece, string));
    }
}

