/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.KeyModifiersConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MultiImagePicker;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Embellishment
extends Decorator
implements TranslatablePiece {
    public static final String OLD_ID = "emb;";
    public static final String ID = "emb2;";
    public static final String IMAGE = "_Image";
    public static final String NAME = "_Name";
    public static final String LEVEL = "_Level";
    public static final String ACTIVE = "_Active";
    protected String activateKey = "";
    protected String upKey;
    protected String downKey;
    protected int activateModifiers;
    protected int upModifiers;
    protected int downModifiers;
    protected String upCommand;
    protected String downCommand;
    protected String activateCommand;
    protected String resetCommand;
    protected FormattedString resetLevel = new FormattedString("1");
    protected boolean loopLevels;
    protected KeyStroke resetKey;
    protected boolean followProperty;
    protected String propertyName = "";
    protected int firstLevelValue;
    protected KeyStroke rndKey;
    private String rndText = "";
    protected int value = -1;
    protected String activationStatus = "";
    protected int nValues;
    protected int xOff;
    protected int yOff;
    protected String[] imageName;
    protected String[] commonName;
    protected Rectangle[] size;
    protected ScaledImagePainter[] imagePainter;
    protected boolean drawUnderneathWhenSelected = false;
    protected String name = "";
    protected KeyCommand[] commands;
    protected KeyCommand up = null;
    protected KeyCommand down = null;
    protected Rectangle lastBounds = null;
    protected Area lastShape = null;

    public Embellishment() {
        this("emb2;Activate", null);
    }

    public Embellishment(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public boolean isActive() {
        return this.value > 0;
    }

    public void setActive(boolean bl) {
        this.value = bl ? Math.abs(this.value) : -Math.abs(this.value);
    }

    public int getValue() {
        return Math.abs(this.value) - 1;
    }

    public void setValue(int n) {
        if (n >= this.nValues) {
            throw new IllegalArgumentException();
        }
        this.value = this.value > 0 ? n + 1 : -n - 1;
    }

    public void mySetType(String string) {
        if (!string.startsWith(ID)) {
            this.originalSetType(string);
        } else {
            string = string.substring(ID.length());
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
            this.activateCommand = decoder.nextToken("Activate");
            this.activateModifiers = decoder.nextInt(2);
            this.activateKey = decoder.nextToken("A");
            this.upCommand = decoder.nextToken("Increase");
            this.upModifiers = decoder.nextInt(2);
            this.upKey = decoder.nextToken("]");
            this.downCommand = decoder.nextToken("Decrease");
            this.downModifiers = decoder.nextInt(2);
            this.downKey = decoder.nextToken("[");
            this.resetCommand = decoder.nextToken("Reset");
            this.resetKey = decoder.nextKeyStroke('R');
            this.resetLevel = new FormattedString(decoder.nextToken("1"));
            this.drawUnderneathWhenSelected = decoder.nextBoolean(false);
            this.xOff = decoder.nextInt(0);
            this.yOff = decoder.nextInt(0);
            this.imageName = decoder.nextStringArray(0);
            this.commonName = decoder.nextStringArray(this.imageName.length);
            this.loopLevels = decoder.nextBoolean(true);
            this.name = decoder.nextToken("");
            this.rndKey = decoder.nextKeyStroke(null);
            this.rndText = decoder.nextToken("");
            this.followProperty = decoder.nextBoolean(false);
            this.propertyName = decoder.nextToken("");
            this.firstLevelValue = decoder.nextInt(1);
            this.value = this.activateKey.length() > 0 ? -1 : 1;
            this.nValues = this.imageName.length;
            this.size = new Rectangle[this.imageName.length];
            this.imagePainter = new ScaledImagePainter[this.imageName.length];
            for (int i = 0; i < this.imageName.length; ++i) {
                this.imagePainter[i] = new ScaledImagePainter();
                this.imagePainter[i].setImageName(this.imageName[i]);
            }
        }
        this.commands = null;
    }

    private void originalSetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), ';');
        this.activateKey = decoder2.nextToken().toUpperCase();
        this.activateModifiers = 2;
        if (decoder2.hasMoreTokens()) {
            this.resetCommand = decoder2.nextToken();
            this.resetKey = decoder2.nextKeyStroke(null);
            this.resetLevel.setFormat(decoder2.nextToken("0"));
        } else {
            this.resetKey = null;
            this.resetCommand = "";
            this.resetLevel.setFormat("0");
        }
        this.activateCommand = decoder.nextToken();
        this.drawUnderneathWhenSelected = this.activateCommand.startsWith("_");
        if (this.drawUnderneathWhenSelected) {
            this.activateCommand = this.activateCommand.substring(1);
        }
        this.value = this.activateKey.length() > 0 ? -1 : 1;
        this.upKey = decoder.nextToken().toUpperCase();
        this.upCommand = decoder.nextToken();
        this.upModifiers = 2;
        this.downKey = decoder.nextToken().toUpperCase();
        this.downCommand = decoder.nextToken();
        this.downModifiers = 2;
        this.xOff = decoder.nextInt(0);
        this.yOff = decoder.nextInt(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (decoder.hasMoreTokens()) {
            arrayList.add(decoder.nextToken());
        }
        this.nValues = arrayList.size();
        this.imageName = new String[arrayList.size()];
        this.commonName = new String[arrayList.size()];
        this.size = new Rectangle[this.imageName.length];
        this.imagePainter = new ScaledImagePainter[this.imageName.length];
        for (int i = 0; i < this.imageName.length; ++i) {
            String string2 = (String)arrayList.get(i);
            SequenceEncoder.Decoder decoder3 = new SequenceEncoder.Decoder(string2, ',');
            this.imageName[i] = decoder3.nextToken();
            this.imagePainter[i] = new ScaledImagePainter();
            this.imagePainter[i].setImageName(this.imageName[i]);
            if (!decoder3.hasMoreTokens()) continue;
            this.commonName[i] = decoder3.nextToken();
        }
        this.loopLevels = true;
    }

    public String getLocalizedName() {
        return this.getName(true);
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        String string;
        this.checkPropertyLevel();
        String string2 = null;
        String string3 = string = 0 < this.value && this.value - 1 < this.commonName.length ? this.getCommonName(bl, this.value - 1) : null;
        if (string != null && string.length() > 0) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '+');
            String string4 = decoder.nextToken();
            if (decoder.hasMoreTokens()) {
                String string5 = decoder.nextToken();
                string2 = string4.length() == 0 ? (bl ? this.piece.getLocalizedName() : this.piece.getName()) + string5 : string4 + (bl ? this.piece.getLocalizedName() : this.piece.getName());
            } else {
                string2 = string4;
            }
        } else {
            string2 = bl ? this.piece.getLocalizedName() : this.piece.getName();
        }
        return string2;
    }

    public void mySetState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.value = decoder.nextInt(1);
        this.activationStatus = decoder.nextToken(this.value < 0 ? "" : this.activateKey);
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.activateCommand).append(this.activateModifiers).append(this.activateKey).append(this.upCommand).append(this.upModifiers).append(this.upKey).append(this.downCommand).append(this.downModifiers).append(this.downKey).append(this.resetCommand).append(this.resetKey).append(this.resetLevel.getFormat()).append(this.drawUnderneathWhenSelected).append(this.xOff).append(this.yOff).append(this.imageName).append(this.commonName).append(this.loopLevels).append(this.name).append(this.rndKey).append(this.rndText).append(this.followProperty).append(this.propertyName).append(this.firstLevelValue);
        return ID + sequenceEncoder.getValue();
    }

    @Deprecated
    public String oldGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(this.activateKey, ';');
        sequenceEncoder2.append(this.resetCommand).append(this.resetKey).append(String.valueOf(this.resetLevel));
        sequenceEncoder.append(sequenceEncoder2.getValue()).append(this.drawUnderneathWhenSelected ? "_" + this.activateCommand : this.activateCommand).append(this.upKey).append(this.upCommand).append(this.downKey).append(this.downCommand).append(this.xOff).append(this.yOff);
        for (int i = 0; i < this.nValues; ++i) {
            if (this.commonName[i] != null) {
                SequenceEncoder sequenceEncoder3 = new SequenceEncoder(this.imageName[i], ',');
                sequenceEncoder.append(sequenceEncoder3.append(this.commonName[i]).getValue());
                continue;
            }
            sequenceEncoder.append(this.imageName[i]);
        }
        return ID + sequenceEncoder.getValue();
    }

    public String myGetState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        return sequenceEncoder.append(String.valueOf(this.value)).append(this.activationStatus).getValue();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
        this.checkPropertyLevel();
        if (!this.isActive()) {
            return;
        }
        int n3 = this.value - 1;
        if (n3 < this.imagePainter.length && this.imagePainter[n3] != null) {
            Rectangle rectangle = this.getCurrentImageBounds();
            this.imagePainter[n3].draw(graphics, n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y), d, component);
        }
        if (this.drawUnderneathWhenSelected && Boolean.TRUE.equals(this.getProperty("Selected"))) {
            this.piece.draw(graphics, n, n2, component, d);
        }
    }

    protected void checkPropertyLevel() {
        if (!this.followProperty || this.propertyName.length() == 0) {
            return;
        }
        Object object = Decorator.getOutermost(this).getProperty(this.propertyName);
        String string = object == null || object.equals("") ? String.valueOf(this.firstLevelValue) : String.valueOf(object);
        try {
            int n = Integer.parseInt(string) - this.firstLevelValue + 1;
            if (n <= 0) {
                n = 1;
            }
            if (n > this.nValues) {
                n = this.nValues;
            }
            this.value = this.isActive() ? n : -n;
        }
        catch (NumberFormatException numberFormatException) {
            Embellishment.reportDataError(this, Resources.getString("Error.non_number_error"), "followProperty[" + this.propertyName + "]=" + string, numberFormatException);
        }
    }

    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
            GamePiece gamePiece = Decorator.getOutermost(this);
            if (this.activateCommand.length() > 0 && this.activateKey.length() > 0) {
                KeyCommand keyCommand = new KeyCommand(this.activateCommand, KeyStroke.getKeyStroke((int)this.activateKey.charAt(0), this.activateModifiers), gamePiece, this);
                keyCommand.setEnabled(this.nValues > 0);
                arrayList.add(keyCommand);
            }
            if (this.upCommand.length() > 0 && this.upKey.length() > 0 && this.nValues > 1 && !this.followProperty) {
                this.up = new KeyCommand(this.upCommand, KeyStroke.getKeyStroke((int)this.upKey.charAt(0), this.upModifiers), gamePiece, this);
                arrayList.add(this.up);
            }
            if (this.downCommand.length() > 0 && this.downKey.length() > 0 && this.nValues > 1 && !this.followProperty) {
                this.down = new KeyCommand(this.downCommand, KeyStroke.getKeyStroke((int)this.downKey.charAt(0), this.downModifiers), gamePiece, this);
                arrayList.add(this.down);
            }
            if (this.resetKey != null && this.resetCommand.length() > 0 && !this.followProperty) {
                arrayList.add(new KeyCommand(this.resetCommand, this.resetKey, gamePiece, this));
            }
            if (this.rndKey != null && this.rndText.length() > 0 && !this.followProperty) {
                arrayList.add(new KeyCommand(this.rndText, this.rndKey, gamePiece, this));
            }
            this.commands = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        if (this.up != null) {
            this.up.setEnabled(this.loopLevels || Math.abs(this.value) < this.imageName.length);
        }
        if (this.down != null) {
            this.down.setEnabled(this.loopLevels || Math.abs(this.value) > 1);
        }
        return this.commands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        String string;
        int n;
        char c = this.getMatchingActivationChar(keyStroke);
        ChangeTracker changeTracker = null;
        if (c != '\u0000' && this.nValues > 0) {
            changeTracker = new ChangeTracker(this);
            n = this.activationStatus.indexOf(c);
            if (n < 0) {
                this.activationStatus = this.activationStatus + c;
            } else {
                string = this.activationStatus.substring(0, n);
                String string2 = this.activationStatus.substring(n + 1);
                this.activationStatus = string + string2;
            }
            this.value = this.activationStatus.length() == this.activateKey.length() ? Math.abs(this.value) : -Math.abs(this.value);
        }
        if (!this.followProperty) {
            for (n = 0; n < this.upKey.length(); ++n) {
                if (!KeyStroke.getKeyStroke((int)this.upKey.charAt(n), this.upModifiers).equals(keyStroke)) continue;
                if (changeTracker == null) {
                    changeTracker = new ChangeTracker(this);
                }
                int n2 = Math.abs(this.value);
                if (++n2 > this.nValues) {
                    n2 = this.loopLevels ? 1 : this.nValues;
                }
                this.value = this.value > 0 ? n2 : -n2;
                break;
            }
            for (n = 0; n < this.downKey.length(); ++n) {
                if (!KeyStroke.getKeyStroke((int)this.downKey.charAt(n), this.downModifiers).equals(keyStroke)) continue;
                if (changeTracker == null) {
                    changeTracker = new ChangeTracker(this);
                }
                int n3 = Math.abs(this.value);
                if (--n3 < 1) {
                    n3 = this.loopLevels ? this.nValues : 1;
                }
                this.value = this.value > 0 ? n3 : -n3;
                break;
            }
            if (this.resetKey != null && this.resetKey.equals(keyStroke)) {
                if (changeTracker == null) {
                    changeTracker = new ChangeTracker(this);
                }
                GamePiece gamePiece = Decorator.getOutermost(this);
                string = this.resetLevel.getText(gamePiece);
                try {
                    int n4 = Integer.parseInt(string);
                    this.setValue(Math.abs(n4) - 1);
                    this.setActive(n4 > 0);
                }
                catch (NumberFormatException numberFormatException) {
                    Embellishment.reportDataError(this, Resources.getString("Error.non_number_error"), this.resetLevel.debugInfo(string, "resetLevel"), numberFormatException);
                }
            }
            if (this.rndKey != null && this.rndKey.equals(keyStroke)) {
                if (changeTracker == null) {
                    changeTracker = new ChangeTracker(this);
                }
                n = 0;
                n = GameModule.getGameModule().getRNG().nextInt(this.nValues) + 1;
                this.value = this.value > 0 ? n : -n;
            }
        }
        return changeTracker != null ? changeTracker.getChangeCommand() : null;
    }

    private char getMatchingActivationChar(KeyStroke keyStroke) {
        for (int i = 0; i < this.activateKey.length(); ++i) {
            if (keyStroke == null || !keyStroke.equals(KeyStroke.getKeyStroke((int)this.activateKey.charAt(i), this.activateModifiers))) continue;
            return this.activateKey.charAt(i);
        }
        return '\u0000';
    }

    @Deprecated
    protected Image getCurrentImage() throws IOException {
        if (this.value <= 0 || this.imageName[this.value - 1] == null || this.imageName[this.value - 1].length() == 0 || this.imagePainter[this.value - 1] == null || this.imagePainter[this.value - 1].getSource() == null) {
            return null;
        }
        return this.imagePainter[this.value - 1].getSource().getImage();
    }

    public Rectangle boundingBox() {
        Rectangle rectangle = this.piece.boundingBox();
        if (this.value > 0) {
            rectangle.add(this.getCurrentImageBounds());
        }
        return rectangle;
    }

    public Rectangle getCurrentImageBounds() {
        if (this.value > 0) {
            int n = this.value - 1;
            if (n >= this.size.length) {
                return new Rectangle();
            }
            if (this.size[n] == null) {
                if (this.imagePainter[n] != null) {
                    this.size[n] = ImageUtils.getBounds(this.imagePainter[n].getImageSize());
                    this.size[n].translate(this.xOff, this.yOff);
                } else {
                    this.size[n] = new Rectangle();
                }
            }
            return this.size[n];
        }
        return new Rectangle();
    }

    public Shape getShape() {
        Shape shape = this.piece.getShape();
        if (this.value > 0 && !this.drawUnderneathWhenSelected) {
            Rectangle rectangle = this.getCurrentImageBounds();
            if (shape.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                return shape;
            }
            Area area = new Area(shape);
            if (!rectangle.equals(this.lastBounds)) {
                this.lastShape = new Area(rectangle);
                this.lastBounds = new Rectangle(rectangle);
            }
            area.add(this.lastShape);
            return area;
        }
        return shape;
    }

    public String getDescription() {
        String string = this.name;
        if ((this.name == null || this.name.length() == 0) && this.imageName.length > 0 && this.imageName[0] != null && this.imageName[0].length() > 0) {
            string = this.imageName[0];
        }
        if (string == null || string.length() == 0) {
            return "Layer";
        }
        return "Layer - " + string;
    }

    public Object getProperty(Object object) {
        if (object.equals(this.name + IMAGE)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.imageName[Math.abs(this.value) - 1];
            }
            return "";
        }
        if (object.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.strip(this.commonName[Math.abs(this.value) - 1]);
            }
            return "";
        }
        if (object.equals(this.name + LEVEL)) {
            this.checkPropertyLevel();
            return String.valueOf(this.value);
        }
        if (object.equals(this.name + ACTIVE)) {
            return String.valueOf(this.isActive());
        }
        if (object.equals("visibleState")) {
            String string = String.valueOf(super.getProperty(object));
            if (this.drawUnderneathWhenSelected) {
                string = string + this.getProperty("Selected");
            }
            return string;
        }
        return super.getProperty(object);
    }

    public Object getLocalizedProperty(Object object) {
        if (object.equals(this.name + IMAGE) || object.equals(this.name + LEVEL) || object.equals(this.name + ACTIVE) || object.equals("visibleState")) {
            return this.getProperty(object);
        }
        if (object.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.strip(this.getLocalizedCommonName(Math.abs(this.value) - 1));
            }
            return "";
        }
        return super.getLocalizedProperty(object);
    }

    protected String strip(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("+")) {
            return string.substring(1);
        }
        if (string.endsWith("+")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected String getCommonName(boolean bl, int n) {
        return bl ? this.getLocalizedCommonName(n) : this.commonName[n];
    }

    protected String getLocalizedCommonName(int n) {
        String string = this.commonName[n];
        if (string == null) {
            return null;
        }
        String string2 = this.getTranslation(this.strip(string));
        if (string.startsWith("+")) {
            return "+" + string2;
        }
        if (string.endsWith("+")) {
            return string2 + "+";
        }
        return string2;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Layer.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece gamePiece, KeyStroke keyStroke, boolean bl) {
        Embellishment embellishment = (Embellishment)Decorator.getDecorator(gamePiece, Embellishment.class);
        while (embellishment != null) {
            for (int i = 0; i < embellishment.activateKey.length(); ++i) {
                if (!keyStroke.equals(KeyStroke.getKeyStroke((int)embellishment.activateKey.charAt(i), embellishment.activateModifiers))) continue;
                if (bl && embellishment.isActive()) {
                    return embellishment;
                }
                if (bl || embellishment.isActive()) break;
                return embellishment;
            }
            embellishment = (Embellishment)Decorator.getDecorator(embellishment.piece, Embellishment.class);
        }
        return null;
    }

    public PieceI18nData getI18nData() {
        String string;
        PieceI18nData pieceI18nData = new PieceI18nData(this);
        String string2 = string = this.name.length() > 0 ? this.name + ": " : "";
        if (this.activateKey.length() > 0) {
            pieceI18nData.add(this.activateCommand, string + "Activate command");
        }
        if (!this.followProperty) {
            pieceI18nData.add(this.upCommand, string + "Increase command");
            pieceI18nData.add(this.downCommand, string + "Decrease command");
            pieceI18nData.add(this.resetCommand, string + "Reset command");
            pieceI18nData.add(this.rndText, string + "Random command");
        }
        for (int i = 0; i < this.commonName.length; ++i) {
            pieceI18nData.add(this.strip(this.commonName[i]), string + "Level " + (i + 1) + " name");
        }
        return pieceI18nData;
    }

    private static class Ed
    implements PieceEditor {
        private MultiImagePicker images;
        private JTextField activateKeyInput = new JTextField("A");
        private JTextField upKeyInput = new JTextField("]");
        private JTextField downKeyInput = new JTextField("[");
        private JTextField activateCommand = new JTextField("Activate");
        private KeyModifiersConfigurer activateModifiers = new KeyModifiersConfigurer(null, "  key:  ");
        private JTextField upCommand = new JTextField("Increase");
        private KeyModifiersConfigurer upModifiers = new KeyModifiersConfigurer(null, "  key:  ");
        private JTextField downCommand = new JTextField("Decrease");
        private KeyModifiersConfigurer downModifiers = new KeyModifiersConfigurer(null, "  key:  ");
        private JTextField rndCommand = new JTextField(8);
        private JTextField xOffInput = new JTextField(2);
        private JTextField yOffInput = new JTextField(2);
        private JTextField levelNameInput = new JTextField(8);
        private JRadioButton prefix = new JRadioButton("is prefix");
        private JRadioButton suffix = new JRadioButton("is suffix");
        private JCheckBox alwaysActive = new JCheckBox("Always active?");
        private JCheckBox drawUnderneath = new JCheckBox("Underneath when highlighted?");
        private JTextField resetLevel = new JTextField(2);
        private JTextField resetCommand = new JTextField(8);
        private JCheckBox loop = new JCheckBox("Loop through levels?");
        private HotKeyConfigurer resetKey = new HotKeyConfigurer(null, "  Keyboard:  ");
        private JTextField name = new JTextField(8);
        private JPanel controls = new JPanel();
        private List<String> names;
        private List<Integer> isPrefix;
        private static final Integer NEITHER = new Integer(0);
        private static final Integer PREFIX = new Integer(1);
        private static final Integer SUFFIX = new Integer(2);
        private HotKeyConfigurer rndKeyConfig;
        private BooleanConfigurer followConfig;
        private StringConfigurer propertyConfig;
        private IntConfigurer firstLevelConfig;
        private Box reset1Controls;
        private Box reset2Controls;
        private Box rnd1Controls;
        private Box rnd2Controls;

        public Ed(Embellishment embellishment) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Name:  "));
            box.add(this.name);
            this.controls.add(box);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(5, 3));
            jPanel.add(this.resetKey.getControls());
            this.activateCommand.setMaximumSize(this.activateCommand.getPreferredSize());
            jPanel.add(this.activateCommand);
            jPanel.add(this.activateModifiers.getControls());
            jPanel.add(this.activateKeyInput);
            this.upCommand.setMaximumSize(this.upCommand.getPreferredSize());
            jPanel.add(this.upCommand);
            jPanel.add(this.upModifiers.getControls());
            jPanel.add(this.upKeyInput);
            this.downCommand.setMaximumSize(this.downCommand.getPreferredSize());
            jPanel.add(this.downCommand);
            jPanel.add(this.downModifiers.getControls());
            jPanel.add(this.downKeyInput);
            this.reset1Controls = Box.createHorizontalBox();
            this.reset1Controls.add(new JLabel("Reset to level:  "));
            this.reset1Controls.add(this.resetLevel);
            jPanel.add(this.reset1Controls);
            this.reset2Controls = Box.createHorizontalBox();
            this.reset2Controls.add(new JLabel("  Command:  "));
            this.reset2Controls.add(this.resetCommand);
            jPanel.add(this.reset2Controls);
            jPanel.add(this.resetKey.getControls());
            this.rnd1Controls = Box.createHorizontalBox();
            this.rnd1Controls.add(new JLabel("Randomize:  "));
            jPanel.add(this.rnd1Controls);
            this.rnd2Controls = Box.createHorizontalBox();
            this.rnd2Controls.add(new JLabel("  Command:  "));
            this.rndCommand = new JTextField(12);
            this.rndCommand.setMaximumSize(this.rndCommand.getPreferredSize());
            this.rndCommand.setText(embellishment.rndText);
            this.rnd2Controls.add(this.rndCommand);
            jPanel.add(this.rnd2Controls);
            this.rndKeyConfig = new HotKeyConfigurer(null, "  Keyboard:  ", embellishment.rndKey);
            jPanel.add(this.rndKeyConfig.getControls());
            Box box2 = Box.createVerticalBox();
            this.alwaysActive.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (Ed.this.alwaysActive.isSelected()) {
                        Ed.this.activateCommand.setText("");
                        Ed.this.activateKeyInput.setText("");
                        Ed.this.activateCommand.setEnabled(false);
                        Ed.this.activateKeyInput.setEnabled(false);
                    } else {
                        Ed.this.activateCommand.setText("Activate");
                        Ed.this.activateKeyInput.setText("A");
                        Ed.this.activateCommand.setEnabled(true);
                        Ed.this.activateKeyInput.setEnabled(true);
                    }
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(3, 2));
            jPanel2.add(this.alwaysActive);
            jPanel2.add(this.drawUnderneath);
            jPanel2.add(this.loop);
            box2.add(jPanel2);
            box2.add(jPanel);
            Box box3 = Box.createHorizontalBox();
            this.xOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.xOffInput.setText("0");
            this.yOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.yOffInput.setText("0");
            box3.add(new JLabel("Offset: "));
            box3.add(this.xOffInput);
            box3.add(new JLabel(","));
            box3.add(this.yOffInput);
            jPanel2.add(box3);
            this.followConfig = new BooleanConfigurer(null, "Levels follow Property Value?");
            jPanel2.add(this.followConfig.getControls());
            Box box4 = Box.createHorizontalBox();
            this.propertyConfig = new StringConfigurer(null, "Property Name:  ");
            box4.add(this.propertyConfig.getControls());
            this.firstLevelConfig = new IntConfigurer(null, " Level 1 = ", embellishment.firstLevelValue);
            box4.add(this.firstLevelConfig.getControls());
            jPanel2.add(box4);
            this.followConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.this.showHideFields();
                }
            });
            this.controls.add(box2);
            this.images = new MultiImagePicker();
            this.controls.add(this.images);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridLayout(2, 2));
            box2 = Box.createHorizontalBox();
            box2.add(new JLabel("Level Name:  "));
            this.levelNameInput.setMaximumSize(this.levelNameInput.getPreferredSize());
            this.levelNameInput.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    Ed.this.changeLevelName();
                }
            });
            box2.add(this.levelNameInput);
            jPanel3.add(box2);
            box2 = Box.createHorizontalBox();
            this.prefix.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Ed.this.prefix.isSelected()) {
                        Ed.this.suffix.setSelected(false);
                    }
                    Ed.this.changeLevelName();
                }
            });
            this.suffix.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Ed.this.suffix.isSelected()) {
                        Ed.this.prefix.setSelected(false);
                    }
                    Ed.this.changeLevelName();
                }
            });
            box2.add(this.prefix);
            box2.add(this.suffix);
            jPanel3.add(box2);
            JButton jButton = new JButton("Add Level");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.names.add(null);
                    Ed.this.isPrefix.add(null);
                    Ed.this.images.addEntry();
                }
            });
            jPanel3.add(jButton);
            jButton = new JButton("Remove Level");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Ed.this.images.getList().getSelectedIndex();
                    if (n >= 0) {
                        Ed.this.names.remove(n);
                        Ed.this.isPrefix.remove(n);
                        Ed.this.images.removeEntryAt(n);
                    }
                }
            });
            jPanel3.add(jButton);
            this.controls.add(jPanel3);
            this.images.getList().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Ed.this.updateLevelName();
                }
            });
            this.reset(embellishment);
        }

        protected void showHideFields() {
            boolean bl = this.followConfig.booleanValue() == false;
            this.loop.setEnabled(bl);
            this.propertyConfig.getControls().setVisible(!bl);
            this.firstLevelConfig.getControls().setVisible(!bl);
            this.reset1Controls.setVisible(bl);
            this.reset2Controls.setVisible(bl);
            this.resetKey.getControls().setVisible(bl);
            this.rnd1Controls.setVisible(bl);
            this.rnd2Controls.setVisible(bl);
            this.rndKeyConfig.getControls().setVisible(bl);
            this.upCommand.setVisible(bl);
            this.upModifiers.getControls().setVisible(bl);
            this.upKeyInput.setVisible(bl);
            this.downCommand.setVisible(bl);
            this.downModifiers.getControls().setVisible(bl);
            this.downKeyInput.setVisible(bl);
        }

        private void updateLevelName() {
            int n = this.images.getList().getSelectedIndex();
            if (n < 0) {
                this.levelNameInput.setText(null);
            } else {
                this.levelNameInput.setText(this.names.get(n));
                this.prefix.setSelected(PREFIX.equals(this.isPrefix.get(n)));
                this.suffix.setSelected(SUFFIX.equals(this.isPrefix.get(n)));
            }
        }

        private void changeLevelName() {
            int n = this.images.getList().getSelectedIndex();
            if (n >= 0) {
                String string = this.levelNameInput.getText();
                this.names.set(n, string);
                if (this.prefix.isSelected()) {
                    this.isPrefix.set(n, PREFIX);
                } else if (this.suffix.isSelected()) {
                    this.isPrefix.set(n, SUFFIX);
                } else {
                    this.isPrefix.set(n, NEITHER);
                }
            } else if (n == 0) {
                this.names.set(n, null);
                this.isPrefix.set(n, NEITHER);
            }
        }

        public String getState() {
            return this.alwaysActive.isSelected() ? "1" : "-1";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            for (String string : this.images.getImageNameList()) {
                arrayList.add(string);
                String string2 = this.names.get(n);
                if (string2 != null && string2.length() > 0) {
                    string2 = PREFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder(string2, '+').append("").getValue() : (SUFFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder("", '+').append(string2).getValue() : new SequenceEncoder(string2, '+').getValue());
                }
                arrayList2.add(string2);
                ++n;
            }
            try {
                Integer.parseInt(this.xOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.xOffInput.setText("0");
            }
            try {
                Integer.parseInt(this.yOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.yOffInput.setText("0");
            }
            sequenceEncoder.append(this.activateCommand.getText()).append(this.activateModifiers.getValueString()).append(this.activateKeyInput.getText()).append(this.upCommand.getText()).append(this.upModifiers.getValueString()).append(this.upKeyInput.getText()).append(this.downCommand.getText()).append(this.downModifiers.getValueString()).append(this.downKeyInput.getText()).append(this.resetCommand.getText()).append((KeyStroke)this.resetKey.getValue()).append(this.resetLevel.getText()).append(this.drawUnderneath.isSelected()).append(this.xOffInput.getText()).append(this.yOffInput.getText()).append(arrayList.toArray(new String[arrayList.size()])).append(arrayList2.toArray(new String[arrayList2.size()])).append(this.loop.isSelected()).append(this.name.getText()).append((KeyStroke)this.rndKeyConfig.getValue()).append(this.rndCommand.getText() == null ? "" : this.rndCommand.getText().trim()).append(this.followConfig.getValueString()).append(this.propertyConfig.getValueString()).append(this.firstLevelConfig.getValueString());
            return Embellishment.ID + sequenceEncoder.getValue();
        }

        @Deprecated
        public String oldgetType() {
            Object object;
            Object object2;
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            int n = 0;
            for (String object32 : this.images.getImageNameList()) {
                object2 = this.names.get(n);
                if (this.names.get(n) != null && object2 != null && ((String)object2).length() > 0) {
                    object = new SequenceEncoder(object32, ',');
                    object2 = PREFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder((String)object2, '+').append("").getValue() : (SUFFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder("", '+').append((String)object2).getValue() : new SequenceEncoder((String)object2, '+').getValue());
                    sequenceEncoder.append(((SequenceEncoder)object).append((String)object2).getValue());
                } else {
                    sequenceEncoder.append(object32);
                }
                ++n;
            }
            try {
                Integer.parseInt(this.xOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.xOffInput.setText("0");
            }
            try {
                Integer.parseInt(this.yOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.yOffInput.setText("0");
            }
            Object object4 = this.activateCommand.getText();
            if (this.drawUnderneath.isSelected()) {
                object4 = "_" + (String)object4;
            }
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(this.activateKeyInput.getText(), ';');
            sequenceEncoder2.append(this.resetCommand.getText()).append((KeyStroke)this.resetKey.getValue()).append(this.resetLevel.getText());
            object2 = new SequenceEncoder(null, ';');
            ((SequenceEncoder)object2).append(sequenceEncoder2.getValue()).append((String)object4).append(this.upKeyInput.getText()).append(this.upCommand.getText()).append(this.downKeyInput.getText()).append(this.downCommand.getText()).append(this.xOffInput.getText()).append(this.yOffInput.getText());
            object = Embellishment.ID + ((SequenceEncoder)object2).getValue() + ';' + (sequenceEncoder.getValue() == null ? "" : sequenceEncoder.getValue());
            return object;
        }

        public Component getControls() {
            return this.controls;
        }

        public void reset(Embellishment embellishment) {
            this.name.setText(embellishment.name);
            this.names = new ArrayList<String>();
            this.isPrefix = new ArrayList<Integer>();
            for (int i = 0; i < embellishment.commonName.length; ++i) {
                String string = embellishment.commonName[i];
                Integer n = NEITHER;
                if (string != null && string.length() > 0) {
                    SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '+');
                    String string2 = decoder.nextToken();
                    if (decoder.hasMoreTokens()) {
                        String string3 = decoder.nextToken();
                        if (string2.length() == 0) {
                            string = string3;
                            n = SUFFIX;
                        } else {
                            string = string2;
                            n = PREFIX;
                        }
                    } else {
                        string = string2;
                    }
                }
                this.names.add(string);
                this.isPrefix.add(n);
            }
            this.alwaysActive.setSelected(embellishment.activateKey.length() == 0);
            this.drawUnderneath.setSelected(embellishment.drawUnderneathWhenSelected);
            this.loop.setSelected(embellishment.loopLevels);
            this.images.clear();
            this.activateKeyInput.setText(embellishment.activateKey);
            this.activateCommand.setText(embellishment.activateCommand);
            this.activateModifiers.setValue(new Integer(embellishment.activateModifiers));
            this.upKeyInput.setText(embellishment.upKey);
            this.upCommand.setText(embellishment.upCommand);
            this.upModifiers.setValue(new Integer(embellishment.upModifiers));
            this.downKeyInput.setText(embellishment.downKey);
            this.downCommand.setText(embellishment.downCommand);
            this.downModifiers.setValue(new Integer(embellishment.downModifiers));
            this.resetKey.setValue(embellishment.resetKey);
            this.resetCommand.setText(embellishment.resetCommand);
            this.resetLevel.setText(embellishment.resetLevel.getFormat());
            this.xOffInput.setText(String.valueOf(embellishment.xOff));
            this.yOffInput.setText(String.valueOf(embellishment.yOff));
            this.images.setImageList(embellishment.imageName);
            this.followConfig.setValue(embellishment.followProperty);
            this.propertyConfig.setValue(embellishment.propertyName);
            if (this.images.getImageNameList().isEmpty()) {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            }
            this.updateLevelName();
            this.showHideFields();
        }
    }
}

