/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MovementMarkable
extends Decorator
implements TranslatablePiece {
    public static final String ID = "markmoved;";
    private int xOffset = 0;
    private int yOffset = 0;
    private String command;
    private KeyStroke key;
    private IconConfigurer movedIcon = new IconConfigurer(null, "Marker Image:  ", "/images/moved.gif");
    private boolean hasMoved = false;

    public MovementMarkable() {
        this("markmoved;moved;0;0", null);
    }

    public MovementMarkable(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public boolean isMoved() {
        return this.hasMoved;
    }

    public void setMoved(boolean bl) {
        this.hasMoved = bl;
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.movedIcon.setValue(decoder.nextToken());
        this.xOffset = decoder.nextInt(0);
        this.yOffset = decoder.nextInt(0);
        this.command = decoder.nextToken("Mark Moved");
        this.key = decoder.nextKeyStroke('M');
    }

    public void mySetState(String string) {
        this.hasMoved = "true".equals(string);
    }

    public String myGetState() {
        return String.valueOf(this.hasMoved);
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.movedIcon.getValueString()).append(this.xOffset).append(this.yOffset).append(this.command).append(this.key);
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[]{new KeyCommand(this.command, this.key, Decorator.getOutermost(this), this)};
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        if (keyStroke != null && keyStroke.equals(this.key)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            Decorator.getOutermost(this).setProperty("Moved", !this.hasMoved);
            return changeTracker.getChangeCommand();
        }
        return null;
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public Rectangle boundingBox() {
        Rectangle rectangle = this.piece.boundingBox();
        rectangle.add(this.piece.boundingBox());
        Dimension dimension = this.getImageSize();
        rectangle.add(new Rectangle(this.xOffset, this.yOffset, dimension.width, dimension.height));
        return rectangle;
    }

    public String getName() {
        return this.piece.getName();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
        if (this.hasMoved && this.movedIcon.getIconValue() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(d, d);
            this.movedIcon.getIconValue().paintIcon(component, graphics, (int)Math.round((double)n / d) + this.xOffset, (int)Math.round((double)n2 / d) + this.yOffset);
            graphics2D.setTransform(affineTransform);
        }
    }

    private Dimension getImageSize() {
        Icon icon = this.movedIcon.getIconValue();
        return icon != null ? new Dimension(icon.getIconWidth(), icon.getIconHeight()) : new Dimension();
    }

    public String getDescription() {
        return "Mark When Moved";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MarkMoved.htm");
    }

    public Object getLocalizedProperty(Object object) {
        if ("Moved".equals(object)) {
            return this.isMoved() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getLocalizedProperty(object);
    }

    public Object getProperty(Object object) {
        if ("Moved".equals(object)) {
            return this.isMoved() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getProperty(object);
    }

    public void setProperty(Object object, Object object2) {
        if ("Moved".equals(object)) {
            this.setMoved(Boolean.TRUE.equals(object2));
            this.piece.setProperty(object, object2);
        } else {
            super.setProperty(object, object2);
        }
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, "Mark Moved command");
    }

    private static class Ed
    implements PieceEditor {
        private IconConfigurer iconConfig;
        private IntConfigurer xOff;
        private IntConfigurer yOff;
        private StringConfigurer command;
        private HotKeyConfigurer key;
        private Box box;

        private Ed(MovementMarkable movementMarkable) {
            this.iconConfig = movementMarkable.movedIcon;
            this.box = Box.createVerticalBox();
            this.command = new StringConfigurer(null, "Command:  ", movementMarkable.command);
            this.box.add(this.command.getControls());
            this.key = new HotKeyConfigurer(null, "Keyboard command:  ", movementMarkable.key);
            this.box.add(this.key.getControls());
            this.box.add(this.iconConfig.getControls());
            this.xOff = new IntConfigurer(null, "Horizontal Offset:  ", new Integer(movementMarkable.xOffset));
            this.yOff = new IntConfigurer(null, "Vertical Offset:  ", new Integer(movementMarkable.yOffset));
            this.box.add(this.xOff.getControls());
            this.box.add(this.yOff.getControls());
        }

        public Component getControls() {
            boolean bl = false;
            for (Map map : Map.getMapList()) {
                String string = map.getAttributeValueString("markMoved");
                bl = bl || "Always".equals(string) || "Use Preferences Setting".equals(string);
            }
            if (!bl) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(Ed.this.box, "You must enable the \"Mark Pieces that Move\" option in one or more Map Windows", "Option not enabled", 2);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            return this.box;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.iconConfig.getValueString()).append(this.xOff.getValueString()).append(this.yOff.getValueString()).append(this.command.getValueString()).append((KeyStroke)this.key.getValue());
            return MovementMarkable.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "false";
        }
    }
}

