/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class PropertySheet
extends Decorator
implements TranslatablePiece {
    public static final String ID = "propertysheet;";
    protected String oldState;
    protected String menuName;
    protected KeyStroke launchKeyStroke;
    protected KeyCommand launch;
    protected Color backgroundColor;
    protected String m_definition;
    protected PropertySheetDialog frame;
    protected JButton applyButton;
    static final String[] COMMIT_VALUES = new String[]{"Every Keystroke", "Apply Button or Enter Key", "Close Window or Enter Key"};
    static final int COMMIT_IMMEDIATELY = 0;
    static final int COMMIT_ON_APPLY = 1;
    static final int COMMIT_ON_CLOSE = 2;
    static final int COMMIT_DEFAULT = 0;
    static final String[] TYPE_VALUES = new String[]{"Text", "Multi-line text", "Label Only", "Tick Marks", "Tick Marks with Max Field", "Tick Marks with Value Field", "Tick Marks with Value & Max", "Spinner"};
    static final int TEXT_FIELD = 0;
    static final int TEXT_AREA = 1;
    static final int LABEL_ONLY = 2;
    static final int TICKS = 3;
    static final int TICKS_MAX = 4;
    static final int TICKS_VAL = 5;
    static final int TICKS_VALMAX = 6;
    static final int SPINNER = 7;
    protected int commitStyle = 0;
    protected boolean isUpdating;
    protected String state;
    protected java.util.Map<String, Object> properties = new HashMap<String, Object>();
    protected List<JComponent> m_fields;
    static final char TYPE_DELIMITOR = ';';
    static final char DEF_DELIMITOR = '~';
    static final char STATE_DELIMITOR = '~';
    static final char LINE_DELIMINATOR = '|';
    static final char VALUE_DELIMINATOR = '/';

    public PropertySheet() {
        this("propertysheet;;Properties;P;;;;", null);
    }

    public PropertySheet(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.m_definition = decoder.nextToken();
        this.menuName = decoder.nextToken();
        String string2 = decoder.nextToken("");
        this.commitStyle = decoder.nextInt(0);
        String string3 = decoder.hasMoreTokens() ? decoder.nextToken() : "";
        String string4 = decoder.hasMoreTokens() ? decoder.nextToken() : "";
        String string5 = decoder.hasMoreTokens() ? decoder.nextToken() : "";
        String string6 = decoder.nextToken("");
        this.backgroundColor = string3.equals("") ? null : new Color(this.atoi(string3), this.atoi(string4), this.atoi(string5));
        this.frame = null;
        this.launchKeyStroke = string6.length() > 0 ? HotKeyConfigurer.decode(string6) : (string2.length() > 0 ? KeyStroke.getKeyStroke((int)string2.charAt(0), 2) : KeyStroke.getKeyStroke(80, 2));
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String myGetState() {
        return this.state;
    }

    public void mySetState(String string) {
        this.state = string;
        this.updateFieldsFromState();
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        String string = this.backgroundColor == null ? "" : Integer.toString(this.backgroundColor.getRed());
        String string2 = this.backgroundColor == null ? "" : Integer.toString(this.backgroundColor.getGreen());
        String string3 = this.backgroundColor == null ? "" : Integer.toString(this.backgroundColor.getBlue());
        String string4 = Integer.toString(this.commitStyle);
        sequenceEncoder.append(this.m_definition).append(this.menuName).append("").append(string4).append(string).append(string2).append(string3).append(this.launchKeyStroke);
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        this.launch = new KeyCommand(this.menuName, this.launchKeyStroke, Decorator.getOutermost(this), this);
        return new KeyCommand[]{this.launch};
    }

    int atoi(String string) {
        int n = 0;
        if (string != null) {
            for (int i = 0; i < string.length() && Character.isDigit(string.charAt(i)); ++i) {
                n = n * 10 + string.charAt(i) - 48;
            }
        }
        return n;
    }

    int atoiRight(String string) {
        int n = 0;
        if (string != null) {
            int n2 = 1;
            int n3 = string.length() - 1;
            while (n3 >= 0 && Character.isDigit(string.charAt(n3))) {
                n += n2 * (string.charAt(n3) - 48);
                --n3;
                n2 *= 10;
            }
        }
        return n;
    }

    private void updateStateFromFields() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('~');
        for (JComponent jComponent : this.m_fields) {
            if (jComponent instanceof JTextComponent) {
                sequenceEncoder.append(((JTextComponent)jComponent).getText().replace('\n', '|'));
                continue;
            }
            if (jComponent instanceof TickPanel) {
                sequenceEncoder.append(((TickPanel)jComponent).getValue());
                continue;
            }
            sequenceEncoder.append("Unknown");
        }
        if (sequenceEncoder.getValue() != null && !sequenceEncoder.getValue().equals(this.state)) {
            this.mySetState(sequenceEncoder.getValue());
            GamePiece gamePiece = Decorator.getOutermost(this);
            if (gamePiece.getId() != null) {
                GameModule.getGameModule().sendAndLog(new ChangePiece(gamePiece.getId(), this.oldState, gamePiece.getState()));
            }
        }
    }

    private void updateFieldsFromState() {
        this.isUpdating = true;
        this.properties.clear();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.m_definition, '~');
        SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(this.state, '~');
        int n = 0;
        while (decoder.hasMoreTokens()) {
            String string = decoder.nextToken();
            if (string.length() != 0) {
                int n2 = string.charAt(0) - 48;
                string = string.substring(1);
                String string2 = decoder2.nextToken("");
                switch (n2) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        int n3 = string2.indexOf(47);
                        this.properties.put(string, n3 > 0 ? string2.substring(0, n3) : string2);
                        break;
                    }
                    default: {
                        this.properties.put(string, string2);
                    }
                }
                string2 = string2.replace('|', '\n');
                if (this.frame != null) {
                    JComponent jComponent = this.m_fields.get(n);
                    if (jComponent instanceof JTextComponent) {
                        JTextComponent jTextComponent = (JTextComponent)jComponent;
                        int n4 = Math.min(jTextComponent.getCaretPosition(), string2.length());
                        jTextComponent.setText(string2);
                        jTextComponent.setCaretPosition(n4);
                    } else if (jComponent instanceof TickPanel) {
                        ((TickPanel)jComponent).updateValue(string2);
                    }
                }
            }
            ++n;
        }
        if (this.applyButton != null) {
            this.applyButton.setEnabled(false);
        }
        this.isUpdating = false;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.launch.matches(keyStroke)) {
            if (this.frame == null) {
                Object object;
                Container container;
                this.m_fields = new ArrayList<JComponent>();
                Map map = this.piece.getMap();
                Frame frame = null;
                if (map != null && map.getView() != null) {
                    container = map.getView().getTopLevelAncestor();
                    if (container instanceof JFrame) {
                        frame = (Frame)container;
                    }
                } else {
                    frame = GameModule.getGameModule().getFrame();
                }
                this.frame = new PropertySheetDialog(frame);
                container = new JPanel();
                JScrollPane jScrollPane = new JScrollPane(container, 20, 30);
                this.frame.add(jScrollPane);
                if (this.commitStyle == 1) {
                    this.applyButton = new JButton("Apply");
                    this.applyButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (PropertySheet.this.applyButton != null) {
                                PropertySheet.this.applyButton.setEnabled(false);
                            }
                            PropertySheet.this.updateStateFromFields();
                        }
                    });
                    this.applyButton.setMnemonic(65);
                    this.applyButton.setEnabled(false);
                }
                DocumentListener documentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.update(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.update(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.update(documentEvent);
                    }

                    public void update(DocumentEvent documentEvent) {
                        if (!PropertySheet.this.isUpdating) {
                            switch (PropertySheet.this.commitStyle) {
                                case 0: {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            PropertySheet.this.updateStateFromFields();
                                        }
                                    });
                                    break;
                                }
                                case 1: {
                                    PropertySheet.this.applyButton.setEnabled(true);
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                    }
                };
                container.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(1, 3, 1, 3);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 1;
                SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.m_definition, '~');
                SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(this.state, '~');
                while (decoder.hasMoreTokens() && ((String)(object = decoder.nextToken())).length() != 0) {
                    JComponent jComponent;
                    int n = ((String)object).charAt(0) - 48;
                    String string = ((String)object).substring(1);
                    switch (n) {
                        case 0: {
                            jComponent = new JTextField(decoder2.nextToken(""));
                            ((JTextComponent)jComponent).getDocument().addDocumentListener(documentListener);
                            ((JTextField)jComponent).addActionListener(this.frame);
                            this.m_fields.add(jComponent);
                            break;
                        }
                        case 1: {
                            jComponent = new JTextArea(decoder2.nextToken("").replace('|', '\n'));
                            ((JTextComponent)jComponent).getDocument().addDocumentListener(documentListener);
                            this.m_fields.add(jComponent);
                            jComponent = new ScrollPane(jComponent);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            jComponent = new TickPanel(decoder2.nextToken(""), n);
                            ((TickPanel)jComponent).addDocumentListener(documentListener);
                            ((TickPanel)jComponent).addActionListener(this.frame);
                            if (this.backgroundColor != null) {
                                jComponent.setBackground(this.backgroundColor);
                            }
                            this.m_fields.add(jComponent);
                            break;
                        }
                        case 7: {
                            JSpinner jSpinner = new JSpinner();
                            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField();
                            jFormattedTextField.setText(decoder2.nextToken(""));
                            jFormattedTextField.getDocument().addDocumentListener(documentListener);
                            this.m_fields.add(jFormattedTextField);
                            jComponent = jSpinner;
                            break;
                        }
                        default: {
                            decoder2.nextToken("");
                            jComponent = null;
                            this.m_fields.add(jComponent);
                        }
                    }
                    int n2 = gridBagConstraints.gridwidth = n == 1 || n == 2 ? 2 : 1;
                    if (string != null && !string.equals("")) {
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.weightx = gridBagConstraints.gridwidth == 2 ? 1.0 : 0.0;
                        container.add((Component)new JLabel(this.getTranslation(string)), gridBagConstraints);
                        if (gridBagConstraints.gridwidth == 2) {
                            ++gridBagConstraints.gridy;
                        }
                    }
                    if (jComponent == null) continue;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = n == 1 ? 1.0 : 0.0;
                    gridBagConstraints.gridx = n == 1 ? 0 : 1;
                    container.add((Component)jComponent, gridBagConstraints);
                    ++gridBagConstraints.gridy;
                }
                if (this.backgroundColor != null) {
                    ((JComponent)container).setBackground(this.backgroundColor);
                }
                if (this.commitStyle == 1) {
                    object = new JButton("Close");
                    ((AbstractButton)object).setMnemonic(67);
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PropertySheet.this.updateStateFromFields();
                            PropertySheet.this.frame.setVisible(false);
                        }
                    });
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 14;
                    gridBagConstraints.gridwidth = 2;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    JPanel jPanel = new JPanel();
                    jPanel.add(this.applyButton);
                    jPanel.add((Component)object);
                    if (this.backgroundColor != null) {
                        this.applyButton.setBackground(this.backgroundColor);
                        ((JComponent)object).setBackground(this.backgroundColor);
                        jPanel.setBackground(this.backgroundColor);
                    }
                    container.add((Component)jPanel, gridBagConstraints);
                }
                object = GameModule.getGameModule().getFrame().getLocation();
                if (this.getMap() != null) {
                    object = this.getMap().getView().getLocationOnScreen();
                    Point point = this.getMap().componentCoordinates(this.getPosition());
                    ((Point)object).translate(point.x, point.y);
                }
                this.frame.setLocation(((Point)object).x, ((Point)object).y);
                this.frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        PropertySheet.this.updateStateFromFields();
                    }
                });
                this.frame.pack();
            }
            this.frame.setTitle(this.getLocalizedName());
            this.oldState = Decorator.getOutermost(this).getState();
            this.frame.setVisible(true);
            return null;
        }
        return null;
    }

    public Object getLocalizedProperty(Object object) {
        Object object2 = this.properties.get(object);
        return object2 == null ? super.getLocalizedProperty(object) : object2;
    }

    public Object getProperty(Object object) {
        Object object2 = this.properties.get(object);
        return object2 == null ? super.getProperty(object) : object2;
    }

    public String getDescription() {
        return "Property Sheet";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PropertySheet.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.m_definition, '~');
        while (decoder.hasMoreTokens()) {
            stringArray = decoder.nextToken();
            arrayList.add(stringArray.length() == 0 ? "" : stringArray.substring(1));
        }
        stringArray = new String[arrayList.size() + 1];
        String[] stringArray2 = new String[arrayList.size() + 1];
        stringArray[0] = this.menuName;
        stringArray2[0] = "Property Sheet command";
        int n = 1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n] = string = (String)iterator.next();
            stringArray2[n] = "Property Sheet item " + n;
            ++n;
        }
        return this.getI18nData(stringArray, stringArray2);
    }

    class TickLabel
    extends JLabel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        private int numTicks;
        private int maxTicks;
        protected int panelType;
        private List<ActionListener> actionListeners;
        protected int topMargin;
        protected int leftMargin;
        protected int numRows;
        protected int numCols;
        protected int dx;

        public int getNumTicks() {
            return this.numTicks;
        }

        public int getMaxTicks() {
            return this.maxTicks;
        }

        public void addActionListener(ActionListener actionListener) {
            this.actionListeners.add(actionListener);
        }

        public TickLabel(int n, int n2, int n3) {
            super(" ");
            this.numTicks = 0;
            this.maxTicks = 0;
            this.actionListeners = new ArrayList<ActionListener>();
            this.topMargin = 2;
            this.leftMargin = 2;
            this.dx = 1;
            this.set(n, n2);
            this.panelType = n3;
            this.addMouseListener(this);
        }

        public void paint(Graphics graphics) {
            block5: {
                int n;
                if (this.maxTicks <= 0) break block5;
                int n2 = this.getWidth() - 2;
                this.dx = Math.min(n2 / this.maxTicks, 10);
                this.numRows = this.dx < 3 ? 3 : (this.dx < 6 ? 2 : 1);
                this.dx = Math.min(n2 * this.numRows / this.maxTicks, Math.min(this.getHeight() / this.numRows, 10));
                if (this.dx < 1) {
                    this.dx = 1;
                }
                this.numCols = (this.maxTicks + this.numRows - 1) / this.numRows;
                int n3 = this.dx;
                this.topMargin = (this.getHeight() - n3 * this.numRows + 2) / 2;
                if (this.dx > 4) {
                    for (n = 0; n < this.maxTicks; ++n) {
                        int n4 = n / this.numCols;
                        int n5 = n % this.numCols;
                        graphics.setColor(Color.BLACK);
                        graphics.drawRect(this.leftMargin + n5 * this.dx, this.topMargin + n4 * n3, this.dx - 3, n3 - 3);
                        graphics.setColor(n < this.numTicks ? Color.BLACK : Color.WHITE);
                        graphics.fillRect(this.leftMargin + 1 + n5 * this.dx, this.topMargin + 1 + n4 * n3, this.dx - 4, n3 - 4);
                    }
                } else {
                    graphics.setColor(Color.GRAY);
                    graphics.fillRect(0, this.topMargin - 2, this.numCols * this.dx + this.leftMargin * 2, this.numRows * n3 + 4);
                    while (n < this.maxTicks) {
                        int n6 = n / this.numCols;
                        int n7 = n % this.numCols;
                        graphics.setColor(n < this.numTicks ? Color.BLACK : Color.WHITE);
                        graphics.fillRect(this.leftMargin + n7 * this.dx, this.topMargin + n6 * n3, this.dx - 1, n3 - 1);
                        ++n;
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.isMetaDown() || mouseEvent.isShiftDown()) && this.panelType != 6) {
                new EditTickLabelValueDialog(this);
                return;
            }
            int n = Math.min((mouseEvent.getX() - this.leftMargin + 1) / this.dx, this.numCols - 1);
            int n2 = Math.min((mouseEvent.getY() - this.topMargin + 1) / this.dx, this.numRows - 1);
            int n3 = n2 * this.numCols + n + 1;
            this.numTicks = n3 == this.numTicks ? n3 - 1 : n3;
            this.fireActionEvent();
            this.repaint();
        }

        public void fireActionEvent() {
            for (ActionListener actionListener : this.actionListeners) {
                actionListener.actionPerformed(new ActionEvent(this, 0, null));
            }
        }

        public void set(int n, int n2) {
            this.numTicks = n;
            this.maxTicks = n2;
            String string = this.numTicks + "/" + this.maxTicks;
            if (this.panelType != 6) {
                string = string + " (right-click to edit)";
            }
            this.setToolTipText(string);
            this.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public class EditTickLabelValueDialog
        extends JPanel
        implements ActionListener,
        DocumentListener,
        FocusListener {
            private static final long serialVersionUID = 1L;
            TickLabel theTickLabel;
            JLayeredPane editorParent;
            JTextField valueField;

            public EditTickLabelValueDialog(TickLabel tickLabel2) {
                Container container;
                super(new BorderLayout());
                this.theTickLabel = tickLabel2;
                for (container = this.theTickLabel.getParent(); !(container instanceof JDialog) && container != null; container = container.getParent()) {
                }
                if (container != null) {
                    this.editorParent = ((JDialog)container).getLayeredPane();
                    Rectangle rectangle = SwingUtilities.convertRectangle(this.theTickLabel.getParent(), this.theTickLabel.getBounds(), this.editorParent);
                    this.setBounds(rectangle);
                    JButton jButton = new JButton("Ok");
                    switch (TickLabel.this.panelType) {
                        case 5: {
                            this.valueField = new JTextField(Integer.toString(tickLabel2.getMaxTicks()));
                            this.valueField.setToolTipText("max value");
                            break;
                        }
                        case 4: {
                            this.valueField = new JTextField(Integer.toString(tickLabel2.getNumTicks()));
                            this.valueField.setToolTipText("current value");
                            break;
                        }
                        default: {
                            this.valueField = new JTextField(tickLabel2.numTicks + "/" + tickLabel2.maxTicks);
                            this.valueField.setToolTipText("current value / max value");
                        }
                    }
                    this.valueField.addActionListener(this);
                    this.valueField.addFocusListener(this);
                    this.valueField.getDocument().addDocumentListener(this);
                    this.add((Component)this.valueField, "Center");
                    jButton.addActionListener(this);
                    this.add((Component)jButton, "East");
                    this.editorParent.add((Component)this, JLayeredPane.MODAL_LAYER);
                    this.setVisible(true);
                    this.valueField.grabFocus();
                }
            }

            public void storeValues() {
                String string = this.valueField.getText();
                switch (TickLabel.this.panelType) {
                    case 5: {
                        this.theTickLabel.set(this.theTickLabel.getNumTicks(), PropertySheet.this.atoi(string));
                        break;
                    }
                    case 4: {
                        this.theTickLabel.set(PropertySheet.this.atoi(string), this.theTickLabel.getMaxTicks());
                        break;
                    }
                    default: {
                        this.theTickLabel.set(PropertySheet.this.atoi(string), PropertySheet.this.atoiRight(string));
                    }
                }
                this.theTickLabel.fireActionEvent();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.storeValues();
                this.editorParent.remove(this);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.theTickLabel.fireActionEvent();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.theTickLabel.fireActionEvent();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.theTickLabel.fireActionEvent();
            }

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                this.storeValues();
            }
        }
    }

    class TickPanel
    extends JPanel
    implements ActionListener,
    FocusListener,
    DocumentListener {
        private static final long serialVersionUID = 1L;
        private int numTicks;
        private int maxTicks;
        private int panelType;
        private JTextField valField;
        private JTextField maxField;
        private TickLabel ticks;
        private List<ActionListener> actionListeners;
        private List<DocumentListener> documentListeners;

        public TickPanel(String string, int n) {
            Dimension dimension;
            super(new GridBagLayout());
            this.actionListeners = new ArrayList<ActionListener>();
            this.documentListeners = new ArrayList<DocumentListener>();
            this.set(string);
            this.panelType = n;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipadx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            if (this.panelType == 5 || this.panelType == 6) {
                this.valField = new JTextField(Integer.toString(this.numTicks));
                dimension = this.valField.getMinimumSize();
                dimension.width = 24;
                this.valField.setMinimumSize(dimension);
                this.valField.setPreferredSize(dimension);
                this.valField.addActionListener(this);
                this.valField.addFocusListener(this);
                this.add((Component)this.valField, gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
            if (this.panelType == 4 || this.panelType == 6) {
                this.maxField = new JTextField(Integer.toString(this.maxTicks));
                dimension = this.maxField.getMinimumSize();
                dimension.width = 24;
                this.maxField.setMinimumSize(dimension);
                this.maxField.setPreferredSize(dimension);
                this.maxField.addActionListener(this);
                this.maxField.addFocusListener(this);
                if (this.panelType == 6) {
                    this.add((Component)new JLabel("/"), gridBagConstraints);
                    ++gridBagConstraints.gridx;
                }
                this.add((Component)this.maxField, gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
            this.ticks = new TickLabel(this.numTicks, this.maxTicks, this.panelType);
            this.ticks.addActionListener(this);
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.ticks, gridBagConstraints);
            this.doLayout();
        }

        public void updateValue(String string) {
            this.set(string);
            this.updateFields();
        }

        private void set(String string) {
            this.set(PropertySheet.this.atoi(string), PropertySheet.this.atoiRight(string));
        }

        private boolean set(int n, int n2) {
            boolean bl = false;
            if (this.numTicks == 0 && this.maxTicks == 0 && n == 0 && n2 > 0) {
                bl = true;
            }
            if (this.numTicks == 0 && this.maxTicks == 0 && n2 == 0 && n > 0) {
                n2 = n;
                bl = true;
            }
            this.numTicks = Math.min(n2, n);
            this.maxTicks = n2;
            return bl;
        }

        public String getValue() {
            this.commitTextFields();
            return Integer.toString(this.numTicks) + '/' + this.maxTicks;
        }

        private void commitTextFields() {
            if ((this.valField != null || this.maxField != null) && this.set(this.valField != null ? PropertySheet.this.atoi(this.valField.getText()) : this.numTicks, this.maxField != null ? PropertySheet.this.atoi(this.maxField.getText()) : this.maxTicks)) {
                this.updateFields();
            }
        }

        private void updateFields() {
            if (this.valField != null) {
                this.valField.setText(Integer.toString(this.numTicks));
            }
            if (this.maxField != null) {
                this.maxField.setText(Integer.toString(this.maxTicks));
            }
            this.ticks.set(this.numTicks, this.maxTicks);
        }

        private boolean areFieldValuesValid() {
            int n = this.maxField == null ? this.maxTicks : PropertySheet.this.atoi(this.maxField.getText());
            int n2 = this.valField == null ? this.numTicks : PropertySheet.this.atoi(this.valField.getText());
            return n2 < n && n2 >= 0;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.maxField || actionEvent.getSource() == this.valField) {
                this.commitTextFields();
                this.ticks.set(this.numTicks, this.maxTicks);
                this.fireActionEvent();
            } else if (actionEvent.getSource() == this.ticks) {
                this.commitTextFields();
                this.numTicks = this.ticks.getNumTicks();
                if (this.maxField == null) {
                    this.maxTicks = this.ticks.getMaxTicks();
                }
                this.updateFields();
                this.fireDocumentEvent();
            }
        }

        public void addActionListener(ActionListener actionListener) {
            this.actionListeners.add(actionListener);
        }

        public void fireActionEvent() {
            for (ActionListener actionListener : this.actionListeners) {
                actionListener.actionPerformed(new ActionEvent(this, 0, null));
            }
        }

        void addDocumentListener(DocumentListener documentListener) {
            if (this.valField != null) {
                this.valField.getDocument().addDocumentListener(this);
            }
            if (this.maxField != null) {
                this.maxField.getDocument().addDocumentListener(this);
            }
            this.documentListeners.add(documentListener);
        }

        public void fireDocumentEvent() {
            for (DocumentListener documentListener : this.documentListeners) {
                documentListener.changedUpdate(null);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.commitTextFields();
            this.ticks.set(this.numTicks, this.maxTicks);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.areFieldValuesValid()) {
                this.fireDocumentEvent();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }
    }

    private static class Ed
    implements PieceEditor {
        private PropertyPanel m_panel = new PropertyPanel();
        private JTextField menuNameCtrl;
        private HotKeyConfigurer keyStrokeConfig;
        private JButton colorCtrl;
        private JTable propertyTable;
        private JComboBox commitCtrl;
        static final String[] COLUMN_NAMES = new String[]{"Name", "Type"};
        static final String[] DEFAULT_ROW = new String[]{"*new property*", "Text"};

        public Ed(PropertySheet propertySheet) {
            this.menuNameCtrl = this.m_panel.addStringCtrl("Menu Text:", propertySheet.menuName);
            this.keyStrokeConfig = this.m_panel.addKeyStrokeConfig(propertySheet.launchKeyStroke);
            this.commitCtrl = this.m_panel.addComboBox("Commit changes on:", COMMIT_VALUES, propertySheet.commitStyle);
            this.colorCtrl = this.m_panel.addColorCtrl("Background Color:", propertySheet.backgroundColor);
            DefaultTableModel defaultTableModel = new DefaultTableModel(this.getTableData(propertySheet.m_definition), COLUMN_NAMES);
            this.AddCreateRow(defaultTableModel);
            this.propertyTable = this.m_panel.addTableCtrl("Properties:", defaultTableModel, DEFAULT_ROW);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JComboBox<String>(TYPE_VALUES));
            this.propertyTable.getColumnModel().getColumn(1).setCellEditor(defaultCellEditor);
        }

        protected void AddCreateRow(DefaultTableModel defaultTableModel) {
            defaultTableModel.addRow(DEFAULT_ROW);
        }

        protected String[][] getTableData(String string) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '~');
            int n = !string.equals("") && decoder.hasMoreTokens() ? 1 : 0;
            int n2 = -1;
            while ((n2 = string.indexOf(126, n2 + 1)) >= 0) {
                ++n;
            }
            String[][] stringArray = new String[n][2];
            for (int i = 0; decoder.hasMoreTokens() && i < n; ++i) {
                String string2 = decoder.nextToken();
                stringArray[i][0] = string2.substring(1);
                stringArray[i][1] = TYPE_VALUES[string2.charAt(0) - 48];
            }
            return stringArray;
        }

        public Component getControls() {
            return this.m_panel;
        }

        public String getType() {
            String string;
            String string2;
            String string3;
            if (this.propertyTable.isEditing()) {
                this.propertyTable.getCellEditor().stopCellEditing();
            }
            SequenceEncoder sequenceEncoder = new SequenceEncoder('~');
            block0: for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
                string3 = (String)this.propertyTable.getValueAt(i, 1);
                for (int j = 0; j < TYPE_VALUES.length; ++j) {
                    if (!string3.matches(TYPE_VALUES[j]) || DEFAULT_ROW[0].equals(this.propertyTable.getValueAt(i, 0))) continue;
                    sequenceEncoder.append(j + (String)this.propertyTable.getValueAt(i, 0));
                    continue block0;
                }
            }
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(';');
            if (this.colorCtrl.getText().equals("Default")) {
                string3 = "";
                string2 = "";
                string = "";
            } else {
                string3 = Integer.toString(this.colorCtrl.getBackground().getRed());
                string2 = Integer.toString(this.colorCtrl.getBackground().getGreen());
                string = Integer.toString(this.colorCtrl.getBackground().getBlue());
            }
            String string4 = sequenceEncoder.getValue();
            sequenceEncoder2.append(string4 == null ? "" : string4).append(this.menuNameCtrl.getText()).append("").append(Integer.toString(this.commitCtrl.getSelectedIndex())).append(string3).append(string2).append(string).append(this.keyStrokeConfig.getValueString());
            return PropertySheet.ID + sequenceEncoder2.getValue();
        }

        public String getState() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
                stringBuilder.append('~');
            }
            return stringBuilder.toString();
        }
    }

    static class PropertyPanel
    extends JPanel
    implements FocusListener {
        private static final long serialVersionUID = 1L;
        GridBagConstraints c = new GridBagConstraints();
        DefaultTableModel tableModel;
        String[] defaultValues;

        public PropertyPanel() {
            super(new GridBagLayout());
            this.c.insets = new Insets(0, 4, 0, 4);
            this.c.anchor = 17;
        }

        public HotKeyConfigurer addKeyStrokeConfig(KeyStroke keyStroke) {
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weightx = 0.0;
            this.c.fill = 0;
            this.add((Component)new JLabel("Keystroke:"), this.c);
            ++this.c.gridx;
            HotKeyConfigurer hotKeyConfigurer = new HotKeyConfigurer(null, "", keyStroke);
            Component component = hotKeyConfigurer.getControls();
            this.add(component, this.c);
            return hotKeyConfigurer;
        }

        public JTextField addStringCtrl(String string, String string2) {
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weightx = 0.0;
            this.c.fill = 2;
            this.add((Component)new JLabel(string), this.c);
            this.c.weightx = 1.0;
            JTextField jTextField = new JTextField(string2);
            ++this.c.gridx;
            this.add((Component)jTextField, this.c);
            return jTextField;
        }

        public JButton addColorCtrl(String string, Color color) {
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weightx = 0.0;
            this.c.fill = 0;
            this.add((Component)new JLabel(string), this.c);
            this.c.weightx = 0.0;
            JButton jButton = new JButton("Default");
            if (color != null) {
                jButton.setBackground(color);
                jButton.setText("sample");
            }
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    Color color = jButton.getBackground();
                    Color color2 = JColorChooser.showDialog(PropertyPanel.this, "Choose background color or CANCEL to use default color scheme", color);
                    if (color2 != null) {
                        jButton.setBackground(color2);
                        jButton.setText("sample");
                    } else {
                        jButton.setBackground(PropertyPanel.this.getBackground());
                        jButton.setText("Default");
                    }
                }
            });
            ++this.c.gridx;
            this.add((Component)jButton, this.c);
            return jButton;
        }

        public JComboBox addComboBox(String string, String[] stringArray, int n) {
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            jComboBox.setEditable(false);
            jComboBox.setSelectedIndex(n);
            this.addCtrl(string, jComboBox);
            return jComboBox;
        }

        public void addCtrl(String string, JComponent jComponent) {
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weightx = 0.0;
            this.c.fill = 0;
            this.add((Component)new JLabel(string), this.c);
            this.c.weightx = 0.0;
            ++this.c.gridx;
            this.add((Component)jComponent, this.c);
        }

        public JTable addTableCtrl(String string, DefaultTableModel defaultTableModel, String[] stringArray) {
            this.tableModel = defaultTableModel;
            this.defaultValues = stringArray;
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weighty = 0.0;
            this.c.weightx = 1.0;
            this.c.gridwidth = 2;
            this.c.fill = 2;
            this.add((Component)new JLabel(string), this.c);
            ++this.c.gridy;
            this.c.weighty = 1.0;
            this.c.fill = 1;
            final SmartTable smartTable = new SmartTable(this.tableModel);
            this.add((Component)new ScrollPane(smartTable), this.c);
            this.c.gridwidth = 1;
            ++this.c.gridy;
            this.c.fill = 0;
            this.c.anchor = 13;
            this.c.gridwidth = 2;
            this.c.weighty = 0.0;
            this.c.weightx = 1.0;
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("Insert Row");
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    ListSelectionModel listSelectionModel;
                    if (smartTable.isEditing()) {
                        smartTable.getCellEditor().stopCellEditing();
                    }
                    if ((listSelectionModel = smartTable.getSelectionModel()).isSelectionEmpty()) {
                        PropertyPanel.this.tableModel.addRow(PropertyPanel.this.defaultValues);
                        n = PropertyPanel.this.tableModel.getRowCount() - 1;
                    } else {
                        n = listSelectionModel.getMaxSelectionIndex();
                        PropertyPanel.this.tableModel.insertRow(n, PropertyPanel.this.defaultValues);
                    }
                    PropertyPanel.this.tableModel.fireTableDataChanged();
                    listSelectionModel.setSelectionInterval(n, n);
                    smartTable.grabFocus();
                    smartTable.editCellAt(n, 0);
                    Component component = smartTable.getCellEditor().getTableCellEditorComponent(smartTable, null, true, n, 0);
                    if (component instanceof JComponent) {
                        ((JComponent)component).grabFocus();
                    }
                }
            });
            final JButton jButton2 = new JButton("Delete Row");
            jButton2.setEnabled(false);
            jPanel.add(jButton2);
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (smartTable.isEditing()) {
                        smartTable.getCellEditor().stopCellEditing();
                    }
                    ListSelectionModel listSelectionModel = smartTable.getSelectionModel();
                    for (int i = listSelectionModel.getMaxSelectionIndex(); i >= listSelectionModel.getMinSelectionIndex(); --i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        PropertyPanel.this.tableModel.removeRow(i);
                    }
                    PropertyPanel.this.tableModel.fireTableDataChanged();
                }
            });
            smartTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                        jButton2.setEnabled(!listSelectionModel.isSelectionEmpty());
                    }
                }
            });
            this.add((Component)jPanel, this.c);
            this.c.anchor = 17;
            this.c.weightx = 0.0;
            return smartTable;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            JTable jTable;
            if (focusEvent.getComponent() instanceof JTable && (jTable = (JTable)focusEvent.getComponent()).isEditing()) {
                jTable.getCellEditor().stopCellEditing();
            }
        }

        public class SmartTable
        extends JTable {
            private static final long serialVersionUID = 1L;

            SmartTable(TableModel tableModel) {
                super(tableModel);
                this.setSurrendersFocusOnKeystroke(true);
            }

            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component;
                if (n == this.getRowCount() - 1) {
                    ((DefaultTableModel)this.getModel()).addRow(Ed.DEFAULT_ROW);
                }
                if ((component = super.prepareEditor(tableCellEditor, n, n2)) instanceof JTextComponent) {
                    ((JTextComponent)component).grabFocus();
                    ((JTextComponent)component).selectAll();
                }
                return component;
            }
        }
    }

    class PropertySheetDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public PropertySheetDialog(Frame frame) {
            super(frame, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertySheet.this.applyButton != null) {
                PropertySheet.this.applyButton.setEnabled(false);
            }
            PropertySheet.this.updateStateFromFields();
        }
    }
}

