/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.KeyStrokeArrayConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ReportState
extends Decorator
implements TranslatablePiece {
    public static final String ID = "report;";
    protected KeyStroke[] keys;
    protected FormattedString format = new FormattedString();
    protected String reportFormat;
    protected String[] cycleReportFormat;
    protected KeyStroke[] cycleDownKeys;
    protected int cycleIndex = -1;
    protected Map oldMap;
    protected String description;
    public static final String OLD_UNIT_NAME = "oldPieceName";
    public static final String NEW_UNIT_NAME = "newPieceName";
    public static final String MAP_NAME = "mapName";
    public static final String OLD_MAP_NAME = "oldMapName";
    public static final String LOCATION_NAME = "location";
    public static final String OLD_LOCATION_NAME = "oldLocation";
    public static final String COMMAND_NAME = "menuCommand";

    public ReportState() {
        this(ID, null);
    }

    public ReportState(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    public String myGetState() {
        return this.cycleIndex + "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(KeyStrokeArrayConfigurer.encode(this.keys)).append(this.reportFormat).append(KeyStrokeArrayConfigurer.encode(this.cycleDownKeys)).append(StringArrayConfigurer.arrayToString(this.cycleReportFormat)).append(this.description);
        return ID + sequenceEncoder.getValue();
    }

    public Command keyEvent(KeyStroke keyStroke) {
        this.oldMap = this.getMap();
        this.format.clearProperties();
        this.format.setProperty(OLD_MAP_NAME, this.getMap() == null ? null : this.getMap().getConfigureName());
        this.format.setProperty(OLD_LOCATION_NAME, this.getMap() == null ? null : this.getMap().locationName(this.getPosition()));
        Command command = this.piece.keyEvent(keyStroke);
        return command == null ? this.myKeyEvent(keyStroke) : command.append(this.myKeyEvent(keyStroke));
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        GamePiece gamePiece = ReportState.getOutermost(this);
        this.format.setProperty(MAP_NAME, this.getMap() == null ? null : this.getMap().getConfigureName());
        this.format.setProperty(LOCATION_NAME, this.getMap() == null ? null : this.getMap().locationName(this.getPosition()));
        Command command = null;
        GamePiece gamePiece2 = (GamePiece)this.getProperty("snapshot");
        boolean bl = gamePiece2 != null && !Boolean.TRUE.equals(gamePiece2.getProperty("InvisibleToOthers"));
        boolean bl2 = !Boolean.TRUE.equals(gamePiece.getProperty("InvisibleToOthers"));
        PieceAccess.GlobalAccess.hideAll();
        String string = gamePiece2 == null ? null : gamePiece2.getLocalizedName();
        this.format.setProperty(OLD_UNIT_NAME, string);
        String string2 = gamePiece.getLocalizedName();
        this.format.setProperty(NEW_UNIT_NAME, string2);
        PieceAccess.GlobalAccess.revertAll();
        if (bl2 || bl) {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.keys.length + this.cycleDownKeys.length];
            System.arraycopy(this.keys, 0, keyStrokeArray, 0, this.keys.length);
            System.arraycopy(this.cycleDownKeys, 0, keyStrokeArray, this.keys.length, this.cycleDownKeys.length);
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                Object object;
                if (!keyStroke.equals(keyStrokeArray[i])) continue;
                String string3 = "";
                KeyCommand[] keyCommandArray = ((Decorator)gamePiece).getKeyCommands();
                for (int j = 0; j < keyCommandArray.length; ++j) {
                    object = keyCommandArray[j].getKeyStroke();
                    if (!keyStroke.equals(object)) continue;
                    string3 = keyCommandArray[j].getName();
                }
                ChangeTracker changeTracker = new ChangeTracker(this);
                this.format.setProperty(COMMAND_NAME, string3);
                object = this.reportFormat;
                if (this.cycleIndex >= 0 && this.cycleReportFormat.length > 0) {
                    if (i < this.keys.length) {
                        object = this.cycleReportFormat[this.cycleIndex];
                        this.cycleIndex = (this.cycleIndex + 1) % this.cycleReportFormat.length;
                    } else {
                        this.cycleIndex = (this.cycleIndex + this.cycleReportFormat.length - 1) % this.cycleReportFormat.length;
                        object = this.cycleReportFormat[(this.cycleIndex + this.cycleReportFormat.length - 1) % this.cycleReportFormat.length];
                    }
                }
                this.format.setFormat(this.getTranslation((String)object));
                OldAndNewPieceProperties oldAndNewPieceProperties = new OldAndNewPieceProperties(gamePiece2, gamePiece);
                String string4 = this.format.getLocalizedText(oldAndNewPieceProperties);
                if (this.getMap() != null) {
                    this.format.setFormat(this.getMap().getChangeFormat());
                } else if (this.oldMap != null) {
                    this.format.setFormat(this.oldMap.getChangeFormat());
                } else if (!Map.isChangeReportingEnabled()) {
                    this.format.setFormat("");
                } else {
                    this.format.setFormat("$message$");
                }
                this.format.setProperty("message", string4);
                string4 = this.format.getLocalizedText(oldAndNewPieceProperties);
                if (string4.length() > 0) {
                    Chatter.DisplayText displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + string4);
                    displayText.execute();
                    command = displayText;
                }
                command = changeTracker.getChangeCommand().append(command);
                break;
            }
        }
        return command;
    }

    protected String getPieceName() {
        String string = "";
        PieceAccess.GlobalAccess.hideAll();
        string = ReportState.getOutermost(this).getName();
        PieceAccess.GlobalAccess.revertAll();
        return string;
    }

    public void mySetState(String string) {
        if (string.length() > 0) {
            try {
                this.cycleIndex = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.cycleIndex = -1;
                ReportState.reportDataError(this, Resources.getString("Error.non_number_error"), "Trying to init Message Index to " + string);
            }
        } else {
            this.cycleIndex = -1;
        }
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getDescription() {
        String string = "Report Action";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ReportChanges.htm");
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        String string2 = decoder.nextToken("");
        if (string2.indexOf(44) > 0) {
            this.keys = KeyStrokeArrayConfigurer.decode(string2);
        } else {
            this.keys = new KeyStroke[string2.length()];
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = KeyStroke.getKeyStroke((int)string2.charAt(i), 2);
            }
        }
        this.reportFormat = decoder.nextToken("$location$: $newPieceName$ *");
        String string3 = decoder.nextToken("");
        if (string3.indexOf(44) > 0) {
            this.cycleDownKeys = KeyStrokeArrayConfigurer.decode(string3);
        } else {
            this.cycleDownKeys = new KeyStroke[string3.length()];
            for (int i = 0; i < this.cycleDownKeys.length; ++i) {
                this.cycleDownKeys[i] = KeyStroke.getKeyStroke((int)string3.charAt(i), 2);
            }
        }
        this.cycleReportFormat = StringArrayConfigurer.stringToArray(decoder.nextToken(""));
        this.description = decoder.nextToken("");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        int n = this.cycleReportFormat == null ? 0 : this.cycleReportFormat.length;
        String[] stringArray = new String[n + 1];
        String[] stringArray2 = new String[n + 1];
        stringArray[0] = this.reportFormat;
        stringArray2[0] = this.getCommandDescription(this.description, "Report Format");
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            stringArray[n2] = this.cycleReportFormat[i];
            stringArray2[n2] = this.getCommandDescription(this.description, "Report Format " + n2);
            ++n2;
        }
        return this.getI18nData(stringArray, stringArray2);
    }

    private static class OldAndNewPieceProperties
    implements PropertySource {
        private GamePiece oldPiece;
        private GamePiece newPiece;

        public OldAndNewPieceProperties(GamePiece gamePiece, GamePiece gamePiece2) {
            this.oldPiece = gamePiece;
            this.newPiece = gamePiece2;
        }

        public Object getProperty(Object object) {
            Object object2 = null;
            if (object != null) {
                String string = object.toString();
                if (string.startsWith("old") && string.length() >= 4) {
                    string = string.substring(3);
                    object2 = this.oldPiece.getProperty(string);
                } else {
                    object2 = this.newPiece.getProperty(object);
                }
            }
            return object2;
        }

        public Object getLocalizedProperty(Object object) {
            return this.getProperty(object);
        }
    }

    public static class Ed
    implements PieceEditor {
        private KeyStrokeArrayConfigurer keys;
        private StringConfigurer format;
        private JCheckBox cycle;
        private StringArrayConfigurer cycleFormat;
        private KeyStrokeArrayConfigurer cycleDownKeys;
        protected StringConfigurer descInput;
        private JPanel box = new JPanel();

        public Ed(ReportState reportState) {
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", reportState.description);
            this.box.add(this.descInput.getControls());
            this.keys = new KeyStrokeArrayConfigurer(null, "Report on these keystrokes:  ", reportState.keys);
            this.box.add(this.keys.getControls());
            this.cycle = new JCheckBox("Cycle through different messages?");
            this.box.add(this.cycle);
            this.format = new PlayerIdFormattedStringConfigurer(null, "Report format:  ", new String[]{ReportState.COMMAND_NAME, ReportState.OLD_UNIT_NAME, ReportState.NEW_UNIT_NAME, ReportState.MAP_NAME, ReportState.OLD_MAP_NAME, ReportState.LOCATION_NAME, ReportState.OLD_LOCATION_NAME});
            this.format.setValue(reportState.reportFormat);
            this.box.add(this.format.getControls());
            this.cycleFormat = new StringArrayConfigurer(null, "Message formats", reportState.cycleReportFormat);
            this.box.add(this.cycleFormat.getControls());
            this.cycleDownKeys = new KeyStrokeArrayConfigurer(null, "Report previous message on these keystrokes:  ", reportState.cycleDownKeys);
            this.box.add(this.cycleDownKeys.getControls());
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Ed.this.format.getControls().setVisible(!Ed.this.cycle.isSelected());
                    Ed.this.cycleFormat.getControls().setVisible(Ed.this.cycle.isSelected());
                    Ed.this.cycleDownKeys.getControls().setVisible(Ed.this.cycle.isSelected());
                    Window window = SwingUtilities.getWindowAncestor(Ed.this.box);
                    if (window != null) {
                        window.pack();
                    }
                }
            };
            itemListener.itemStateChanged(null);
            this.cycle.addItemListener(itemListener);
            this.cycle.setSelected(reportState.cycleReportFormat.length > 0);
        }

        public Component getControls() {
            return this.box;
        }

        public String getState() {
            return this.cycle.isSelected() ? "0" : "-1";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            if (this.cycle.isSelected() && this.cycleFormat.getStringArray().length > 0) {
                sequenceEncoder.append(this.keys.getValueString()).append("").append(this.cycleDownKeys.getValueString()).append(this.cycleFormat.getValueString());
            } else {
                sequenceEncoder.append(this.keys.getValueString()).append(this.format.getValueString()).append("").append("");
            }
            sequenceEncoder.append(this.descInput.getValueString());
            return ReportState.ID + sequenceEncoder.getValue();
        }
    }
}

