/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.KeyCommandSubMenu;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.KeyStroke;

public class SubMenu
extends Decorator
implements TranslatablePiece {
    public static final String ID = "submenu;";
    private String subMenu;
    private KeyCommandSubMenu[] keyCommands = new KeyCommandSubMenu[1];

    public SubMenu() {
        this("submenu;Sub-Menu;", null);
    }

    public SubMenu(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public String getDescription() {
        if ("Sub-Menu".equals(this.getMenuName())) {
            return "Sub-Menu";
        }
        return "Sub-Menu:  " + this.getMenuName();
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SubMenu.htm");
    }

    public PieceEditor getEditor() {
        return new Editor(this);
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.subMenu = decoder.nextToken();
        this.keyCommands[0] = new KeyCommandSubMenu(this.subMenu, this, this);
        this.keyCommands[0].setCommands(StringArrayConfigurer.stringToArray(decoder.nextToken()));
    }

    protected KeyCommand[] myGetKeyCommands() {
        return this.keyCommands;
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getMenuName()).append(StringArrayConfigurer.arrayToString(this.getSubcommands()));
        return ID + sequenceEncoder.getValue();
    }

    public String[] getSubcommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.keyCommands[0].getCommands();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getMenuName() {
        return this.subMenu;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.getInner().draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.getInner().getName();
    }

    public Shape getShape() {
        return this.getInner().getShape();
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.getMenuName(), "Sub Menu Name");
    }

    public static class Editor
    implements PieceEditor {
        private StringConfigurer nameConfig;
        private StringArrayConfigurer commandsConfig;
        private Box box;

        public Editor(SubMenu subMenu) {
            this.nameConfig = new StringConfigurer(null, "Menu name:  ", subMenu.getMenuName());
            this.commandsConfig = new StringArrayConfigurer(null, "Sub-commands", subMenu.getSubcommands());
            this.box = Box.createVerticalBox();
            this.box.add(this.nameConfig.getControls());
            this.box.add(this.commandsConfig.getControls());
        }

        public Component getControls() {
            return this.box;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameConfig.getValueString()).append(this.commandsConfig.getValueString());
            return SubMenu.ID + sequenceEncoder.getValue();
        }
    }
}

