/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.KeyStrokeArrayConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class TriggerAction
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "macro;";
    protected String name = "";
    protected String command = "";
    protected KeyStroke key = null;
    protected PropertyExpression propertyMatch = new PropertyExpression();
    protected KeyStroke[] watchKeys = new KeyStroke[0];
    protected KeyStroke[] actionKeys = new KeyStroke[0];

    public TriggerAction() {
        this(ID, null);
    }

    public TriggerAction(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.command.length() > 0 && this.key != null) {
            KeyCommand keyCommand = new KeyCommand(this.command, this.key, Decorator.getOutermost(this), this.matchesFilter());
            if (this.getMap() == null) {
                keyCommand.setEnabled(false);
            }
            return new KeyCommand[]{keyCommand};
        }
        return new KeyCommand[0];
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.name).append(this.command).append(this.key).append(this.propertyMatch.getExpression()).append(KeyStrokeArrayConfigurer.encode(this.watchKeys)).append(KeyStrokeArrayConfigurer.encode(this.actionKeys));
        return ID + sequenceEncoder.getValue();
    }

    public Command keyEvent(KeyStroke keyStroke) {
        Command command = this.piece.keyEvent(keyStroke);
        return command == null ? this.myKeyEvent(keyStroke) : command.append(this.myKeyEvent(keyStroke));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command myKeyEvent(KeyStroke keyStroke) {
        boolean bl = false;
        if (keyStroke.equals(this.key)) {
            bl = true;
        }
        for (int i = 0; i < this.watchKeys.length && !bl; ++i) {
            if (!keyStroke.equals(this.watchKeys[i])) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        if (!this.matchesFilter()) {
            return null;
        }
        GamePiece gamePiece = Decorator.getOutermost(this);
        NullCommand nullCommand = new NullCommand();
        try {
            RecursionLimiter.startExecution(this);
            for (int i = 0; i < this.actionKeys.length && this.getMap() != null; ++i) {
                nullCommand.append(gamePiece.keyEvent(this.actionKeys[i]));
            }
        }
        catch (RecursionLimitException recursionLimitException) {
            ErrorDialog.infiniteLoop(recursionLimitException);
        }
        finally {
            RecursionLimiter.endExecution();
        }
        return nullCommand;
    }

    protected boolean matchesFilter() {
        GamePiece gamePiece = Decorator.getOutermost(this);
        return this.propertyMatch.isNull() || this.propertyMatch.accept(gamePiece);
    }

    public void mySetState(String string) {
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getDescription() {
        String string = "Trigger Action";
        if (this.name.length() > 0) {
            string = string + " - " + this.name;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TriggerAction.htm");
    }

    public void mySetType(String string) {
        int n;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.name = decoder.nextToken("");
        this.command = decoder.nextToken("Trigger");
        this.key = decoder.nextKeyStroke('T');
        this.propertyMatch.setExpression(decoder.nextToken(""));
        String string2 = decoder.nextToken("");
        if (string2.indexOf(44) > 0) {
            this.watchKeys = KeyStrokeArrayConfigurer.decode(string2);
        } else {
            this.watchKeys = new KeyStroke[string2.length()];
            for (n = 0; n < this.watchKeys.length; ++n) {
                this.watchKeys[n] = KeyStroke.getKeyStroke((int)string2.charAt(n), 2);
            }
        }
        string2 = decoder.nextToken("");
        if (string2.indexOf(44) > 0) {
            this.actionKeys = KeyStrokeArrayConfigurer.decode(string2);
        } else {
            this.actionKeys = new KeyStroke[string2.length()];
            for (n = 0; n < this.actionKeys.length; ++n) {
                this.actionKeys[n] = KeyStroke.getKeyStroke((int)string2.charAt(n), 2);
            }
        }
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, this.getCommandDescription(this.name, "Trigger command"));
    }

    public String getComponentName() {
        return Decorator.getOutermost(this).getLocalizedName();
    }

    public String getComponentTypeName() {
        return this.getDescription();
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer name;
        private StringConfigurer command;
        private HotKeyConfigurer key;
        private StringConfigurer propertyMatch;
        private KeyStrokeArrayConfigurer watchKeys;
        private KeyStrokeArrayConfigurer actionKeys;
        private JPanel box = new JPanel();

        public Ed(TriggerAction triggerAction) {
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.name = new StringConfigurer(null, "Description:  ", triggerAction.name);
            this.box.add(this.name.getControls());
            this.propertyMatch = new PropertyExpressionConfigurer(null, "Trigger when properties match:  ", triggerAction.propertyMatch);
            this.box.add(this.propertyMatch.getControls());
            Box box = Box.createHorizontalBox();
            this.command = new StringConfigurer(null, "Menu Command:  ", triggerAction.command);
            box.add(this.command.getControls());
            this.key = new HotKeyConfigurer(null, "  KeyStroke:  ", triggerAction.key);
            box.add(this.key.getControls());
            this.box.add(box);
            this.watchKeys = new KeyStrokeArrayConfigurer(null, "Watch for these Keystrokes:  ", triggerAction.watchKeys);
            this.box.add(this.watchKeys.getControls());
            this.actionKeys = new KeyStrokeArrayConfigurer(null, "Perform these Keystrokes:  ", triggerAction.actionKeys);
            this.box.add(this.actionKeys.getControls());
        }

        public Component getControls() {
            return this.box;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.name.getValueString()).append(this.command.getValueString()).append((KeyStroke)this.key.getValue()).append(this.propertyMatch.getValueString()).append(this.watchKeys.getValueString()).append(this.actionKeys.getValueString());
            return TriggerAction.ID + sequenceEncoder.getValue();
        }
    }
}

