/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.tools.logging.Logger;
import java.util.IllegalFormatException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundleHelper {
    private ResourceBundle bundle;

    public BundleHelper(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getString(String string) {
        try {
            return this.bundle.getString(string);
        }
        catch (ClassCastException classCastException) {
            Logger.log("No Translation: " + string);
        }
        catch (MissingResourceException missingResourceException) {
            Logger.log("No Translation: " + string);
        }
        return string;
    }

    public String getString(String string, Object ... objectArray) {
        try {
            return String.format(this.getString(string), objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            Logger.log("Illegal Message Format: " + string);
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }
}

